<?php

add_filter( 'vc_load_default_templates', 'liquid_reset_default_templates' ); // Hook in
function liquid_reset_default_templates( $data ) {
    return array(); // This will remove all default templates. Basically you should use native PHP functions to modify existing array and then return it.
}

function liquid_add_default_templates() {

	$templates = liquid_vc_templates();
	return array_map( 'vc_add_default_templates', $templates );
}
liquid_add_default_templates();

function liquid_vc_templates(){
	
	$uri = get_template_directory_uri() . '/liquid/assets/img/liquid_templates/';
	$templates = array();

	//Category Accordions
	//Accordion 1
	$data = array();
	$data['name'] = esc_html__( 'Accordion 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/accordions/accordion1.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1537776478307{margin-top: 50px !important;padding-top: 90px !important;padding-bottom: 40px !important;background-image: url(http://medical.liquid-themes.com/wp-content/uploads/2018/09/faq-bg-2-min.jpg?id=4055) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-7" ca_init_translate_y="60" ca_init_translate_z="-60" ca_init_rotate_x="-29" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h2"]Get expert advice[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="right_large:20%25" fs="16px" lh="1.5em"]We answer top questions from parents every month - so you can stay up-to-date on ways to get well, and stay well.[/ld_fancy_heading][ld_spacer height="40px"][vc_accordion size="medium" active_style="fill" borders="accordion-body-underlined" use_custom_fonts_title="true" heading_color="rgb(7, 38, 140)" active_bg_color="rgb(220, 233, 246)" active_heading_color="rgb(7, 38, 140)" fs="18px" ls="-0.01em"][vc_accordion_tab title="What is Ave Children Medical's philosophy towards medical care?" tab_id="1529490143263-fab829a7-33d8"][vc_column_text css=".vc_custom_1529490491925{margin-top: 10px !important;margin-left: -30px !important;border-left-width: 2px !important;padding-left: 20px !important;border-left-color: #ff8e32 !important;border-left-style: solid !important;}"]<span style="font-size: 16px; line-height: 1.5em;">Ave Medical was founded on a better model of care – one designed around patients’ needs that provides a higher level of quality and service affordably. We do this through innovative design, excellent customer service, and the efficient use of technology.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="What happens if I need to go to a hospital?" tab_id="ld-1529490494684-be0fb20a-e733"][vc_column_text css=".vc_custom_1529490491925{margin-top: 10px !important;margin-left: -30px !important;border-left-width: 2px !important;padding-left: 20px !important;border-left-color: #ff8e32 !important;border-left-style: solid !important;}"]<span style="font-size: 16px; line-height: 1.5em;">Ave Medical was founded on a better model of care – one designed around patients’ needs that provides a higher level of quality and service affordably. We do this through innovative design, excellent customer service, and the efficient use of technology.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="What kind of mental health services does Ave Children’s Medical offer?" tab_id="ld-1529490587794-c56830a7-43f4"][vc_column_text css=".vc_custom_1529490491925{margin-top: 10px !important;margin-left: -30px !important;border-left-width: 2px !important;padding-left: 20px !important;border-left-color: #ff8e32 !important;border-left-style: solid !important;}"]<span style="font-size: 16px; line-height: 1.5em;">Ave Medical was founded on a better model of care – one designed around patients’ needs that provides a higher level of quality and service affordably. We do this through innovative design, excellent customer service, and the efficient use of technology.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Does Ave Children’s Medical offer flu shots?" tab_id="ld-1529490597060-bd8f0b76-82ae"][vc_column_text css=".vc_custom_1529490491925{margin-top: 10px !important;margin-left: -30px !important;border-left-width: 2px !important;padding-left: 20px !important;border-left-color: #ff8e32 !important;border-left-style: solid !important;}"]<span style="font-size: 16px; line-height: 1.5em;">Ave Medical was founded on a better model of care – one designed around patients’ needs that provides a higher level of quality and service affordably. We do this through innovative design, excellent customer service, and the efficient use of technology.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="How long does it take to get my lab test results?" tab_id="ld-1529490605285-e7a083a0-5621"][vc_column_text css=".vc_custom_1529490491925{margin-top: 10px !important;margin-left: -30px !important;border-left-width: 2px !important;padding-left: 20px !important;border-left-color: #ff8e32 !important;border-left-style: solid !important;}"]<span style="font-size: 16px; line-height: 1.5em;">One Medical was founded on a better model of care – one designed around patients’ needs that provides a higher level of quality and service affordably. We do this through innovative design, excellent customer service, and the efficient use of technology.</span>[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 2
	$data = array();
	$data['name'] = esc_html__( 'Accordion 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/accordions/accordion2.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542877792862{padding-top: 100px !important;padding-bottom: 50px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" ca_init_translate_y="33"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="44px" color="rgb(61, 53, 110)"]Frequently asked questions[/ld_fancy_heading][ld_spacer height="15px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1540575372460{padding-top: 55px !important;padding-bottom: 40px !important;border-radius: 5px !important;}" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1200" ca_delay="150" ca_init_translate_y="35" ca_init_translate_z="-147" ca_init_rotate_x="-66"][vc_accordion borders="accordion-body-underlined" use_custom_fonts_title="true" heading_color="rgb(30, 22, 102)" active_heading_color="rgb(13, 156, 252)" fs="19px" lh="1.5em"][vc_accordion_tab title="Common PayPal and credit card issues" tab_id="1532074942188-28a08668-799f"][vc_column_text]<span style="color: #7573a1;">Bitcoin is designed around the idea of using cryptography to control the creation and transfer of money in any time.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="How to trade with Litecoin" tab_id="ld-1532075226851-84f4170a-260f"][vc_column_text]<span style="color: #7573a1;">Bitcoin is designed around the idea of using cryptography to control the creation and transfer of money in any time.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Transfer and trade digital currencies in England" tab_id="ld-1532075228316-87eff853-049d"][vc_column_text]<span style="color: #7573a1;">Bitcoin is designed around the idea of using cryptography to control the creation and transfer of money in any time.</span>[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 3
	$data = array();
	$data['name'] = esc_html__( 'Accordion 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/accordions/accordion3.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" parallax_image="1749" parallax_speed_bg="1.25" css=".vc_custom_1541318393575{padding-top: 140px !important;padding-bottom: 120px !important;background-color: #f4f5f8 !important;}" el_id="about" el_class="z-index-2"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_responsive_options="yes" offset="vc_col-lg-4" css=".vc_custom_1535961046385{margin-right: -12px !important;}" responsive_css="margin_right_mobile:0" ca_init_translate_y="52" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" init_values="translateY:50" animations_values="translateY:0" title="Easy to use" color="rgb(136, 138, 150)" fs="13px" ls="0.03em"]Easy to use[/ld_fancy_heading][vc_empty_space height="10px"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" init_values="translateY:80" animations_values="translateY:0" title="Build your entire site in minutes" fs="48px" ls="-0.025em"]Complete design <span style="color: #3ed2a7;">toolkit included</span>[/ld_fancy_heading][vc_accordion size="shortest" active_style="fill_shadow" borders="accordion-title-bordered" border_round="accordion-title-circle" show_icon="yes" i_add_icon="true" i_type="fontawesome" active_add_icon="true" active_type="fontawesome" use_custom_fonts_title="true" i_icon_fontawesome="fa fa-angle-down" active_icon_fontawesome="fa fa-angle-up" heading_color="#181b31" active_heading_color="#ffb09f" border_color="#d8dbe2" active_bg_color="rgb(255, 255, 255)" bg_color="rgba(255,255,255,0)" fs="18px"][vc_accordion_tab title="No rocket science included" tab_id="1524037146865-4ae7bf0d-d90c"][vc_column_text]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Blazing Site Performance" tab_id="1524037146878-0c65e600-2207"][vc_column_text]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Bonus Plugins Included" tab_id="1524050854877-b09aea60-5782"][vc_column_text]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsum.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column offset="vc_col-lg-offset-2 vc_col-lg-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" content_align="content-floated-mid-left" enable_image_shadow="yes" shadow_style="4" enable_browser="yes" enable_shadow="yes" enable_reveal="yes" image="1740" margin="right_all:-30vw" browser_url="digitalcreative.liquid-themes.com/"][ld_button style="btn-naked" title="See how it works" transformation="text-uppercase" link_type="lightbox" i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-xlg" enable_icon_shadowbox="yes" i_add_icon="true" i_size="23px" lightbox="yes" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||" i_icon_fontawesome="fa fa-play" i_custom_size="28px" color="rgb(79, 218, 145)" color2="rgb(52, 219, 197)" text_color="rgb(24, 27, 49)" fs="13px" icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(48%2C198%2C168%2C0.3)%22%7D%5D" h_icon_box_shadow="%5B%7B%7D%5D"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Accordion 4
	$data = array();
	$data['name'] = esc_html__( 'Accordion 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/accordions/accordion4.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1542639509824{padding-top: 75px !important;padding-bottom: 75px !important;}" el_id="services"][vc_column offset="vc_col-md-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_reveal="yes" reveal_direction="rl" image="152" reveal_color="rgb(23, 37, 49)"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" ca_init_translate_y="39" translate_from_y="-58" translate_to_y="59"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" compressor="0.5" margin="bottom_small:0px"]RESTAURANT[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="12px" ls="0.2em" color="rgb(63, 65, 71)" margin="top_small:0px"]Sip, Savir and Socialize in our restaurants[/ld_fancy_heading][ld_spacer height="28px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" title="Each boutique hotel in the Ave Hotel collection tells a unique story, inviting guests to immerse themselves in tales of adventure, romance, history, culture, nature and more for the length of a memorable stay. Discover the high points of our story here." init_values="translateY:80,opacity:0"]Ave Hotel offers several dynamic dining options, ideal for both relaxed vacationers and on-the-go business travelers.[/ld_fancy_heading][ld_spacer height="43px"][vc_accordion size="xs" borders="accordion-title-underlined" use_custom_fonts_title="true" fs="15px" ls="0.2em" fw="500"][vc_accordion_tab title="AVE RESTAURANT" tab_id="1528963630592-47c7b540-a15b"][vc_row_inner css=".vc_custom_1528964908409{padding-top: 15px !important;}"][vc_column_inner offset="vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="15px" ls="0.1em"]Hours of Operation[/ld_fancy_heading][vc_column_text]<span style="font-size: 15px;">Breakfast: <span style="color: #8e9196;">6h30am - 11:00am</span></span><br /><span style="font-size: 15px;">Lunch: <span style="color: #8e9196;">12:00pm - 2:30pm</span></span><br /><span style="font-size: 15px;">Dinner: <span style="color: #8e9196;">5h:00pm - 10:30pm</span></span>[/vc_column_text][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="15px" ls="0.1em"]Hotline[/ld_fancy_heading][vc_column_text]<span style="font-size: 16px; letter-spacing: 0.1em;">243 594 1295</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_accordion_tab][vc_accordion_tab title="LAYANA COFFEE" tab_id="ld-1528965005956-9b9fe76c-8364"][vc_row_inner css=".vc_custom_1528964908409{padding-top: 15px !important;}"][vc_column_inner offset="vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="15px" ls="0.1em"]Hours of Operation[/ld_fancy_heading][vc_column_text]<span style="font-size: 16px;">Breakfast: <span style="color: #8e9196;">6h30am - 11:00am</span></span><br /><span style="font-size: 16px;">Lunch: <span style="color: #8e9196;">12:00pm - 2:30pm</span></span><br /><span style="font-size: 16px;">Dinner: <span style="color: #8e9196;">5h:00pm - 10:30pm</span></span>[/vc_column_text][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="15px" ls="0.1em"]Hotline[/ld_fancy_heading][vc_column_text]<span style="font-size: 16px; letter-spacing: 0.1em;">243 594 1295</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 5
	$data = array();
	$data['name'] = esc_html__( 'Accordion 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/accordions/accordion5.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1532075435056{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" ca_init_translate_y="33"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="44px"]Have a question?[/ld_fancy_heading][ld_spacer height="15px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1542020466247{padding-top: 55px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;background-color: #f8faff !important;border-radius: 5px !important;}" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1200" ca_delay="150" ca_init_translate_y="35" ca_init_translate_z="-147" ca_init_rotate_x="-66" responsive_css="padding_right_medium:90px|padding_left_medium:90px"][vc_accordion size="tall" borders="accordion-body-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" i_icon_linea="icon-arrows_circle_plus" active_icon_linea="icon-arrows_circle_minus" heading_color="rgb(30, 22, 102)" active_heading_color="rgb(30, 22, 102)" exp_color="rgb(159, 159, 159)" active_exp_color="rgb(131, 0, 255)" fs="19px" lh="1.5em"][vc_accordion_tab title="Common PayPal and credit card issues" tab_id="1532074942188-28a08668-799f"][vc_column_text]<span style="color: #7573a1;">Bitcoin is designed around the idea of using cryptography to control the creation and transfer of money in any time.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="How to trade with Litecoin" tab_id="ld-1532075226851-84f4170a-260f"][vc_column_text]<span style="color: #7573a1;">Bitcoin is designed around the idea of using cryptography to control the creation and transfer of money in any time.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Transfer and trade digital currencies in England" tab_id="ld-1532075228316-87eff853-049d"][vc_column_text]<span style="color: #7573a1;">Bitcoin is designed around the idea of using cryptography to control the creation and transfer of money in any time.</span>[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Accordion 6
	$data = array();
	$data['name'] = esc_html__( 'Accordion 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/accordions/accordion6.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" parallax_image="1749" parallax_speed_bg="1.25" css=".vc_custom_1546974154743{margin-top: 40px !important;margin-bottom: 40px !important;padding-top: 90px !important;padding-bottom: 80px !important;background-color: #f9fafb !important;}" el_class="z-index-2"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_responsive_options="yes" offset="vc_col-lg-6" css=".vc_custom_1545116567023{margin-right: -12px !important;}" ca_init_translate_y="52" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22portfolio%22%7D%2C%7B%22word%22%3A%22business%22%7D%2C%7B%22word%22%3A%22creative%22%7D%2C%7B%22word%22%3A%22agency%22%7D%5D" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" init_values="translateY:80" animations_values="translateY:0" title="Build your entire site in minutes" fs="38px" lh="1.342em" margin="bottom_small:30px"]Forget about design limits! Build and customize your[/ld_fancy_heading][vc_accordion borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_position="accordion-expander-left" i_type="fontawesome" active_add_icon="true" active_type="fontawesome" use_custom_fonts_title="true" i_icon_fontawesome="fa fa-angle-down" active_icon_fontawesome="fa fa-angle-up" heading_color="rgb(0, 0, 0)" border_color="rgba(0, 0, 0, 0.1)" fs="17px" lh="1.5em" active_heading_color="rgb(70, 102, 227)"][vc_accordion_tab title="Common PayPal and credit card issues" tab_id="1524037146865-4ae7bf0d-d90cea98-fa67"][vc_column_text]<span style="font-size: 16px;">Duis consectetur feugiat auctor. Morbi nec enim luctus, feugiat arcu id, ultricies ante. Duis vel massa eleifend, porta est non, feugiat metus. Cras ante massa, tincidunt nec lobortis quis, dignissim vitae sem.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Let’s collaborate and make an impact in the business" tab_id="1524037146878-0c65e600-2207ea98-fa67"][vc_column_text]<span style="font-size: 16px;">Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsum.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="A satisfied customer is the best business strats" tab_id="1524050854877-b09aea60-5782ea98-fa67"][vc_column_text]<span style="font-size: 16px;">Duis consectetur feugiat auctor. Morbi nec enim luctus, feugiat arcu id, ultricies ante. Duis vel massa eleifend, porta est non, feugiat metus.</span>[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="6" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="http://opus.liquid-themes.com/wp-content/uploads/2018/12/opus-1-accordion.jpg" translate_from_x="60" translate_to_x="0" translate_from_z="0"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	
	//Category Banners
	//Banner 1 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner1.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="bottom" css=".vc_custom_1533040276811{padding-top: 70px !important;padding-bottom: 60px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-8" ca_duration="1200" ca_delay="150" ca_init_translate_y="40"][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="20px" lh="1.8em"]The One team consists of passionate people that constantly mix a wide range of skills: design, development, branding, statistics, user experience, etc.[/ld_fancy_heading][ld_spacer height="20px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-left" offset="vc_col-md-4" responsive_align="text-md-right" ca_duration="1200" ca_start_delay="200" ca_init_translate_y="43"][ld_button style="btn-solid" title="Join the team" transformation="text-uppercase" shape="circle" enable_row_shadowbox="yes" color="rgb(79, 218, 145)" color2="rgb(52, 219, 197)" hover_color="rgb(52, 219, 197)" fs="14px" css=".vc_custom_1532683182101{padding-right: 0.75em !important;padding-left: 0.75em !important;}" ls="0.1em" lh="1.111em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(48%2C198%2C168%2C0.32)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D"][ld_spacer height="20px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 2
	$data = array();
	$data['name'] = esc_html__( 'Banner 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner2.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1532614217271{padding-top: 50px !important;}" el_class="z-index-2"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="0" parallax_trigger="number" translate_from_y="49" translate_to_y="-130" parallax_duration="1000" parallax_trigger_number="0.3"][ld_fancy_heading transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" minfontsize="75" fs="220px" lh="1em" delay="80" color="rgb(255, 186, 131)" compressor="0.65" duration="1200" fw="700" gradient="linear-gradient(90deg, rgb(255, 186, 131) 0.3184713375796178%, #ffa5cd 100%)" margin="bottom_large:0px|bottom_small:0.25em" ca_init_translate_y="25" ca_init_rotate_z="3"]Creative[/ld_fancy_heading][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="0" parallax_trigger="number" translate_to_y="-103" parallax_duration="1000" translate_from_y="8" parallax_trigger_number="0.38"][ld_fancy_heading transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" minfontsize="75" fs="220px" lh="1em" delay="80" color="rgb(255, 186, 131)" compressor="0.65" duration="1200" fw="700" gradient="linear-gradient(90deg, rgb(255, 186, 131) 0.3184713375796178%, #ffa5cd 100%)" margin="top_large:-0.05em|bottom_small:0px" start_delay="200" ca_init_translate_y="25" ca_init_rotate_z="3"]Agency[/ld_fancy_heading][/vc_column][/vc_row][vc_row][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-md-6" translate_from_y="14" translate_to_y="-87"][ld_spacer height="80px"][vc_row_inner][vc_column_inner offset="vc_col-md-8"][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" fs="36px" lh="1.3em" duration="1200" start_delay="1100" delay="180" ca_init_translate_y="60"]We use design to help businesses launch products and brands.[/ld_fancy_heading][ld_spacer height="35px" md_height="65px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(128, 130, 145)" fs="16px" lh="1.85em" duration="1200" start_delay="600" delay="180" ca_init_translate_y="29" ca_init_rotate_z="2"]We’re a brand strategy and digital design agency, building brands that matter in culture. With more than ten years of knowledge and expertise. We work with people who are as dedicated to their craft. We do everything with our core values of honesty, hard work, and trust.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_spacer height="30px" md_height="0"][/vc_column][vc_column offset="vc_col-md-6"][ld_images_group_container][ld_images_group_element parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="681" translate_from_y="-60" translate_to_y="87" margin="top_large:-40px" shadow_delay="800"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 3
	$data = array();
	$data['name'] = esc_html__( 'Banner 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner3.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1532607152199{margin-top: 40px !important;margin-bottom: 40px !important;padding-top: 300px !important;padding-bottom: 300px !important;background-image: url(http://original.liquid-themes.com/wp-content/uploads/2018/07/bg-2-min.jpg?id=606) !important;background-position: center;background-repeat: no-repeat;background-size:cover;}"][vc_column align="text-center"][ld_button style="btn-naked"  link_type="lightbox" i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-xlg" i_ripple="btn-icon-ripple" i_add_icon="true" i_size="22px" i_color="rgb(255, 255, 255)" i_custom_size="25px" color="rgb(79, 218, 145)" color2="rgb(52, 219, 197)" hover_color="rgb(52, 219, 197)" hover_color2="rgb(52, 219, 197)" i_icon_fontawesome="fa fa-play" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DYJ5q8Wrkbdw|||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 4
	$data = array();
	$data['name'] = esc_html__( 'Banner 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner4.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1532599445971{margin-top: 55px !important;padding-top: 220px !important;padding-bottom: 220px !important;background-image: url(http://original.liquid-themes.com/wp-content/uploads/2018/07/bg-team-2-min.jpg?id=571) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1200" ca_delay="180" ca_init_translate_y="40" ca_init_translate_z="-161" ca_init_rotate_x="-80"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="36px" lh="1.111em"]Let’s work together[/ld_fancy_heading][ld_spacer height="22px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="20px" lh="25px" color="rgba(24, 27, 49, 0.502)"]<span style="font-family: Amiri, serif;">Let’s collaborate and make an impact with my cross-discipline approach to design and deveopment.</span>[/ld_fancy_heading][ld_spacer height="42px"][ld_button style="btn-default" title="My Portfolio" transformation="text-uppercase" shape="circle" color="rgb(211, 169, 133)" fs="13px" lh="1.5em" ls="0.1em" css=".vc_custom_1532599903626{padding-right: 1em !important;padding-left: 1em !important;}"][ld_spacer height="10px" hide="vc_hidden-lg" sm_hide="vc_hidden-sm" md_hide="vc_hidden-md" xs_height="12px"][ld_button style="btn-solid" title="Get in touch" transformation="text-uppercase" shape="circle" color="rgb(211, 169, 133)" fs="13px" lh="1.5em" ls="0.1em" css=".vc_custom_1532600010881{margin-left: 10px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(211, 169, 133)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 5
	$data = array();
	$data['name'] = esc_html__( 'Banner 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner5.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" equal_height="yes"][vc_column enable_content_animation="yes" ca_init_scale_x="0.5" ca_init_scale_y="0.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="2000" offset="vc_hidden-sm vc_hidden-xs"][ld_particles absolute_pos="yes" shape_type="triangle" opacity="1" enable_move="yes" move_direction="right" enable_attract_move="yes" modes_grab_opacity="1" particle_id="ld-1524905930539-9c1b067e-aab5" height="400px" position="top_large:160px"][/vc_column][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" ca_init_values="translateY:50,opacity:0,rotateX:-65" ca_animations_values="translateY:0,opacity:1,rotateX:0" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1542023140180{padding-top: 120px !important;padding-bottom: 120px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%22-10px%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%2230px%22%2C%22spread_radius%22%3A%221px%22%2C%22shadow_color%22%3A%22rgb(255%2C%20255%2C%20255)%22%7D%2C%7B%22x_offset%22%3A%2210px%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%2230px%22%2C%22spread_radius%22%3A%221px%22%2C%22shadow_color%22%3A%22rgb(255%2C%20255%2C%20255)%22%7D%5D" el_class="z-index-2" ca_an_translate_y="0" ca_init_translate_y="26" ca_duration="1200" ca_delay="150" responsive_css="padding_top_medium:185px"][ld_fancy_heading tag="h2" alignment="text-center" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" init_values="translateY:100,opacity:0" title="For the best" color="rgb(24, 27, 49)" fs="150px" ls="-0.04em" start_delay="420" compressor="0.5" minfontsize="48px" margin="bottom_small:0px"]For the best[/ld_fancy_heading][ld_fancy_heading tag="p" alignment="text-center" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" init_values="translateY:50,opacity:0,rotateX:-65" animations_values="translateY:0,opacity:1,rotateX:0" title="Ave is a creative professional multi-purpose wordpress theme pixel-perfect designed to make awesome website for any business." start_delay="630" fs="20px" lh="1.55em" padding="right_all:20%25|left_all:20%25|right_large:15%25|left_large:15%25|right_small:3%25|left_small:3%25" compressor="0.5" minfontsize="17px"]Ave is a creative professional multi-purpose wordpress theme pixel-perfect.[/ld_fancy_heading][vc_empty_space height="65px"][ld_button style="btn-default" title="Explore Features" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" size="btn-lg" enable_row_shadowbox="yes" color="rgb(255, 186, 131)" color2="rgb(255, 165, 205)" text_color="rgb(255, 176, 159)" fs="13px" fw="700" button_box_shadow="%5B%7B%7D%5D" hover_button_box_shadow="%5B%7B%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2220px%22%2C%22spread_radius%22%3A%22-5px%22%2C%22shadow_color%22%3A%22rgba(255%2C176%2C159%2C0.5)%22%7D%5D" css=".vc_custom_1542023301212{margin-bottom: 10px !important;padding-right: 1em !important;padding-left: 1em !important;}"][ld_button style="btn-solid" title="how it works" transformation="text-uppercase" link_type="lightbox" shape="circle" size="btn-lg" i_type="fontawesome" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" enable_row_shadowbox="yes" i_add_icon="true" i_size="btn-icon-sm" lightbox="yes" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||" i_icon_fontawesome="fa fa-play" color="rgb(79, 218, 144)" color2="rgb(52, 219, 197)" button_box_shadow="%5B%7B%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(48%2C198%2C168%2C0.31)%22%7D%5D" hover_button_box_shadow="%5B%7B%22y_offset%22%3A%2212px%22%2C%22blur_radius%22%3A%2235px%22%2C%22spread_radius%22%3A%22-5px%22%2C%22shadow_color%22%3A%22rgba(48%2C198%2C168%2C0.5)%22%7D%5D" fs="13px" fw="700" css=".vc_custom_1542023307843{margin-bottom: 10px !important;margin-left: 10px !important;}"][vc_empty_space height="80px"][ld_fancy_heading tag="p" transform="text-uppercase" split_type="words" use_custom_fonts_title="true" enable_split="true" title="Keep connected" color="rgb(24, 27, 49)" fs="13px" ls="0.1em" start_delay="800"]Keep connected[/ld_fancy_heading][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#b8beca" hover_color="#181b31"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 6
	$data = array();
	$data['name'] = esc_html__( 'Banner 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner49.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" content_placement="middle" enable_loading_bg="yes" css=".vc_custom_1543485088167{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(http://voguish.liquid-themes.com/wp-content/uploads/2018/11/unsplash.jpg?id=3918) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-md-8" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25"][vc_row_inner css=".vc_custom_1543609736667{padding-bottom: 20px !important;}"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1400" ca_init_translate_y="65" ca_delay="180" ca_init_rotate_z="3"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="12px" ls="0.2em" padding="bottom_small:15px"]Introducing AVE[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" minfontsize="48" fs="66px" lh="1.136" ls="-0.01em" compressor="0.75" padding="right_large:5%25" margin="bottom_small:15px"]Total design freedom <span style="text-decoration: underline;">for everyone.</span>[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner enable_content_animation="yes" content_placement="middle" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="500" ca_delay="180" ca_init_translate_x="-45" ca_init_rotate_z="1"][vc_column_inner offset="vc_col-md-1/5"][ld_button style="btn-naked" link_type="lightbox" i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_fontawesome="fa fa-play" i_size="18px" color="rgb(253, 157, 136)" i_color="rgb(255, 255, 255)" i_shape_custom_size="90px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DYJ5q8Wrkbdw%26t%3D|||" css=".vc_custom_1543609414725{margin-bottom: 22px !important;}"][/vc_column_inner][vc_column_inner offset="vc_col-md-4/5"][vc_column_text css=".vc_custom_1543482434352{margin-bottom: 0px !important;}"]<span style="font-size: 20px; color: rgba(255,255,255,0.8); line-height: 1.6;">Forget about design limits! Build and customize your site visually. It’s fun, fast and super-easy!</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 7
	$data = array();
	$data['name'] = esc_html__( 'Banner 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner6.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1538059236855{padding-top: 80px !important;padding-bottom: 80px !important;}" el_id="team"][vc_column offset="vc_col-md-6"][ld_team_members_circular inner_items="%5B%7B%22image%22%3A%224712%22%2C%22name%22%3A%22John%20Doe%22%2C%22top_pos%22%3A%22-5%25%22%2C%22right_pos%22%3A%221%25%22%7D%5D" middle_items="%5B%7B%22image%22%3A%224711%22%2C%22name%22%3A%22John%20Doe%22%2C%22top_pos%22%3A%22-5%25%22%2C%22left_pos%22%3A%2220%25%22%7D%2C%7B%22image%22%3A%224710%22%2C%22name%22%3A%22Sarah%20Doe%22%2C%22bottom_pos%22%3A%2211%25%22%2C%22left_pos%22%3A%221%25%22%7D%5D" outer_items="%5B%7B%22image%22%3A%224709%22%2C%22name%22%3A%22John%20Doe%22%2C%22top_pos%22%3A%2230%25%22%2C%22left_pos%22%3A%22-5%25%22%7D%2C%7B%22image%22%3A%224708%22%2C%22name%22%3A%22John%20Doe%22%2C%22right_pos%22%3A%225%25%22%2C%22bottom_pos%22%3A%2215%25%22%7D%5D" primary_color="rgb(255, 44, 133)"][vc_empty_space height="65px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-2 vc_col-md-4" ca_init_translate_y="48" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" init_values="translateX:-50,opacity:0" animations_values="translateX:0,opacity:1" title="Exclusive portfolio" color="rgb(167, 169, 184)" fs="13px" ls="0.1em"]Circular[/ld_fancy_heading][vc_empty_space height="20px"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" init_values="translateX:-50,opacity:0" animations_values="translateX:0,opacity:1" title="Having attractive showcase has never been easier" color="rgb(24, 27, 49)" start_delay="180" ls="-0.03em" margin="bottom_small:0px"]Adjust positions, colors and much more.[/ld_fancy_heading][vc_empty_space height="30px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" start_delay="460" fs="18px" lh="1.5em"]Use the circular shortcode to present your team, your services or even to emphasize an idea with a unique approach. It will attract your visitors.[/ld_fancy_heading][vc_empty_space height="30px"][ld_button style="btn-solid" title="Buy One Today" transformation="text-uppercase" shape="circle" enable_row_shadowbox="yes" color="#4fda91" color2="#34dbc5" hover_color="#ffba83" hover_color2="#ffa5cd" text_color="#ffffff" fs="13px" fw="700" ls="0.1em" css=".vc_custom_1539953772449{padding-right: 0.75em !important;padding-left: 0.75em !important;}" button_box_shadow="%5B%7B%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(48%2C198%2C168%2C0.32)%22%7D%5D" hover_button_box_shadow="%5B%7B%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2218px%22%2C%22shadow_color%22%3A%22rgba(255%2C186%2C131%2C0.57)%22%7D%5D"][vc_empty_space height="65px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 8
	$data = array();
	$data['name'] = esc_html__( 'Banner 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner7.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1537617801751{padding-top: 240px !important;padding-bottom: 320px !important;background-image: url(http://freelancer.liquid-themes.com/wp-content/uploads/2018/09/slider-bg-min.jpg?id=4024) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-md-8"][ld_fancy_heading tag="h4" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(139, 140, 179)" ca_init_translate_y="58" fw="700" margin="bottom_small:0.15em"]Freelance digital designer[/ld_fancy_heading][ld_fancy_heading split_type="chars, words" easing="easeOutBack" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_fit="true" enable_split="true" compressor="0.7" maxfontsize="72" minfontsize="40" delay="40" margin="right_large:5%25" duration="1000" start_delay="150" ca_init_translate_y="35" ca_init_rotate_z="5"]Hi there, I’m <span style="color: #ff546c;">Eugenia </span>glad to see you here[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 9
	$data = array();
	$data['name'] = esc_html__( 'Banner 09', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner8.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542222348011{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="h2" transform="text-uppercase" margin="bottom_large:0.2em"]About Ave[/ld_fancy_heading][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(36, 147, 224)" fs="14px" ls="0.05em"]Quality tours crafted by local experts,[/ld_fancy_heading][ld_spacer height="28px"][vc_separator color="custom" align="align_left" el_width="10" accent_color="#ff7a4b"][ld_fancy_heading tag="p"]We have a selection of over 50 tour programs that range from introductory multi-country itineraries to more regional in-depth options. &nbsp; You're about to go on the most amazing journey! Welcome to one of Europe's leading coach tour operators, Ave Tour.[/ld_fancy_heading][ld_spacer height="40px"][ld_button style="btn-naked" title="Learn More" transformation="text-uppercase" hover_color="rgb(12, 62, 114)" fs="14px" fw="700" ls="0.1em"][ld_spacer][/vc_column][vc_column align="text-center" offset="vc_col-md-offset-1 vc_col-md-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_reveal="yes" image="4066"][ld_button style="btn-naked"  link_type="lightbox" i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-xlg" i_ripple="btn-icon-ripple" i_add_icon="true" i_size="18px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||" i_icon_fontawesome="fa fa-play" i_color="rgb(255, 122, 75)" i_custom_size="22px" color="rgb(255, 255, 255)"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="14px" ls="0.05em" margin="top_large:-10px"]On your own, you see. On a tour, you do.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 10
	$data = array();
	$data['name'] = esc_html__( 'Banner 10', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner52.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" parallax="enable_parallax" css=".vc_custom_1543478429899{padding-top: 92px !important;padding-bottom: 45px !important;background-image: url(http://voguish.liquid-themes.com/wp-content/uploads/2018/11/bg-2-min.jpg?id=3891) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-7" responsive_align="text-md-left" css=".vc_custom_1531743285914{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" use_mask="true" minfontsize="35" fs="45px" lh="1.2em" ls="-0.015em" ca_init_translate_y="84" ca_init_rotate_z="10" color="rgb(255, 255, 255)" el_class="text-underline" fw="600" compressor="0.5" margin="bottom_large:0px"]Looking for a unique theme?<br /> <span style="text-decoration: underline;">Get your copy today.</span>[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-3" ca_init_translate_y="39" responsive_align="text-md-right"][ld_button style="btn-solid" title="Join to download" shape="semi-round" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" fs="16px" ls="0.01em" css=".vc_custom_1543609494516{margin-bottom: 25px !important;padding-right: 4em !important;padding-left: 4em !important;}" hover_color="rgb(0, 0, 0)" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|"][vc_row_inner][vc_column_inner align="text-center"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgba(255, 255, 255, 0.7)" link="|||" fs="16px" lh="1.56em" ls="0.02em"]Looking for a job?<br />
Apply here.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 11
	$data = array();
	$data['name'] = esc_html__( 'Banner 11', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner50.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1543480445070{padding-top: 20px !important;padding-bottom: 40px !important;}" responsive_css="padding_top_medium:40px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1800" ca_init_translate_x="-35" ca_delay="180" ca_init_rotate_z="1" css=".vc_custom_1543609791418{margin-top: -40px !important;}"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" alignment="text-left" i_shape="circle" i_size="sm" i_border="" shadow="iconbox-icon-shadow" i_icon_animated="animated-basic_webpage_img_txt" i_color="rgb(255, 255, 255)" custom_i_size="60px" animation_delay="200"][/ld_icon_box][ld_fancy_heading tag="h2" padding="bottom_small:10px"]Just add your  products and start selling online.[/ld_fancy_heading][vc_column_text css=".vc_custom_1543609670291{margin-bottom: 30px !important;padding-right: 5% !important;}"]<span style="font-size: 17px; line-height: 29px; color: #5b6674;">Import a pre-designed template and change the content. It’s that easy!</span>[/vc_column_text][/vc_column][vc_column offset="vc_col-md-7"][ld_images_group_container][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_reveal="yes" reveal_direction="rl" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="51" translate_from_y="32" translate_to_y="-33"][/ld_images_group_element][/ld_images_group_container][vc_row_inner][vc_column_inner parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_column_shadowbox="yes" responsive_css="margin_top_medium:-110%25|padding_left_medium:12%25" offset="vc_col-md-offset-6 vc_col-md-6" css=".vc_custom_1543415458262{padding-top: 35px !important;padding-right: 35px !important;padding-left: 35px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%222px%22%2C%22blur_radius%22%3A%2214px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.082)%22%7D%5D" translate_from_y="-1" translate_to_y="32"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" i_shape="circle" i_size="xs" position="iconbox-inline" i_border="" i_icon_linea="icon-ion-ios-checkmark" title="Buy Ave and get access to premium and exclusive plugins for free." custom_heading_size="16px" custom_i_size="20px"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" i_shape="circle" i_size="xs" position="iconbox-inline" i_border="" i_icon_linea="icon-ion-ios-checkmark" title="Buy Ave and get access to premium and exclusive plugins for free." custom_heading_size="16px" custom_i_size="20px"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" i_shape="circle" i_size="xs" position="iconbox-inline" i_border="" i_icon_linea="icon-ion-ios-checkmark" title="Buy Ave and get access to premium and exclusive plugins for free." custom_heading_size="16px" custom_i_size="20px"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" i_shape="circle" i_size="xs" position="iconbox-inline" i_border="" i_icon_linea="icon-ion-ios-checkmark" title="Buy Ave and get access to premium and exclusive plugins for free." custom_heading_size="16px" custom_i_size="20px"][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 12
	$data = array();
	$data['name'] = esc_html__( 'Banner 12', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner9.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542713844778{padding-top: 70px !important;}"][vc_column css=".vc_custom_1537621169691{padding-top: 115px !important;padding-right: 15px !important;padding-bottom: 115px !important;padding-left: 15px !important;background-image: url(http://mobile.liquid-themes.com/wp-content/uploads/2018/09/cta-bg-min.jpg?id=109) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 15px !important;}"][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" ca_duration="1200" ca_delay="120" ca_init_translate_y="70" ca_init_translate_z="-150" ca_init_rotate_x="-65"][vc_separator color="custom" el_width="10" accent_color="#fd623c"][ld_fancy_heading tag="h2" color="rgb(255, 255, 255)" margin="right_large:9%25|left_large:9%25"]The best solution to manage your work[/ld_fancy_heading][ld_spacer height="20px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="30px" color="rgb(255, 255, 255)"]No matter the size of your business, you will be able to benefit from signing up with Ave today. Besides, it’s free for 30 days.[/ld_fancy_heading][ld_spacer height="50px"][ld_button style="btn-solid" title="Get early access" transformation="text-uppercase" link_type="scroll_to_section" shape="round" enable_row_shadowbox="yes" color="rgb(2, 135, 237)" color2="rgb(3, 175, 224)" hover_color="rgb(3, 175, 224)" hover_color2="rgb(2, 135, 237)" fs="14px" fw="600" ls="0.1em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.1)%22%7D%5D" hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(2%2C135%2C237%2C0.14)%22%7D%5D" css=".vc_custom_1531402496618{padding-right: 0.75em !important;padding-left: 0.75em !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 13
	$data = array();
	$data['name'] = esc_html__( 'Banner 13', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner10.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1538046844598{padding-top: 40px !important;padding-bottom: 100px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1200" ca_delay="120" ca_init_translate_x="-37"][ld_icon_box i_type="linea" alignment="text-left" i_shape="circle" i_size="sm" i_border="" shadow="iconbox-icon-shadow" i_icon_linea="icon-basic_archive_full" css=".vc_custom_1537621602462{margin-bottom: 25px !important;}" i_color="rgb(70, 214, 100)" shape_color="rgb(205, 242, 214)"][/ld_icon_box][ld_fancy_heading tag="h2" enable_fit="true" compressor="0.5" margin="right_large:35%25" minfontsize="32"]Easy setup and management[/ld_fancy_heading][ld_spacer height="12px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="30px"]Ave allow you to break a large idea into actionable subtasks which are then assigned to team members individually. No more guessing who’s doing what.[/ld_fancy_heading][ld_spacer height="50px"][vc_separator color="custom" align="align_left" el_width="10" accent_color="#46d664"][ld_spacer height="10px"][ld_fancy_heading tag="h5"]Conversational Subtasks[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" lh="30px"]Turn to-do’s idea into actionable and conversational subtasks to eliminate multiple channels of feedback.[/ld_fancy_heading][ld_spacer height="40px"][ld_fancy_heading tag="h5"]Multiple Discussions[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" lh="30px"]Organize and follow your tasks from Upcoming to In Progress and then to Completed to keep track of progress.[/ld_fancy_heading][ld_spacer md_hide="vc_hidden-md" lg_hide="vc_hidden-lg"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_image_shadow="yes" shadow_style="4" enable_browser="yes" enable_shadow="yes" enable_reveal="yes" image="26" margin="right_large:-110%25" browser_url="avetheme.com"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 14
	$data = array();
	$data['name'] = esc_html__( 'Banner 14', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner11.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1542714059908{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column offset="vc_col-md-7 vc_hidden-xs"][ld_images_group_container][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="22" translate_from_y="160" translate_to_y="-50" margin="left_large:-20%25"][/ld_images_group_element][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="23" translate_from_y="185" rotate_from_y="0" translate_to_y="-110" position="left_large:0px|left_medium:20%25|top_small:0px|right_small:10%25|left_small:10%25"][/ld_images_group_element][ld_images_group_element img_size="343x121" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="8" scale_from_x="0.7" scale_from_y="0.7" scale_from_z="1" from_opacity="1" scale_to_x="1.25" scale_to_y="1.25" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="111" position="left_large:2.5%25|right_medium:0px|left_medium:22.5%25|top_small:14%25|right_small:23%25|left_small:13%25" translate_from_y="200" translate_to_y="-79" translate_from_x="60" translate_to_x="160"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1200" ca_delay="120" ca_init_translate_x="-37"][ld_icon_box i_type="linea" alignment="text-left" i_shape="circle" i_size="sm" i_border="" shadow="iconbox-icon-shadow" i_icon_linea="icon-basic_chronometer" css=".vc_custom_1537621572179{margin-bottom: 25px !important;}" i_color="rgb(253, 98, 60)" shape_color="rgb(255, 228, 223)"][/ld_icon_box][ld_fancy_heading tag="h2" enable_fit="true" compressor="0.5" margin="right_large:35%25" minfontsize="32"]Save your time by using Ave[/ld_fancy_heading][ld_spacer height="12px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="30px"]More fluid than posts, more robust than chat. The other functions of Ave integrate into discussions to keep your project and its all components cohesive.[/ld_fancy_heading][ld_spacer height="50px"][vc_separator color="custom" align="align_left" el_width="10" accent_color="#fd6043"][ld_spacer height="5px"][ld_fancy_heading tag="h5"]Feature Intergration[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" lh="30px"]Tasks, docs, and files integrate with Ave's chat to close the gaps between feedback and action.[/ld_fancy_heading][ld_spacer height="40px"][ld_fancy_heading tag="h5"]Mutilple Disscusion[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" lh="30px"]Create multiple discussions to keep all relevant conversations together, all in one place with Ave.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 15
	$data = array();
	$data['name'] = esc_html__( 'Banner 15', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner51.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1543480526794{padding-top: 15px !important;padding-bottom: 20px !important;}" responsive_css="padding_top_medium:70px|padding_bottom_medium:70px"][vc_column offset="vc_col-lg-6 vc_col-md-5"][ld_images_group_container][ld_images_group_element enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="2" enable_shadow="yes" image="58" margin="left_large:-21vw"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-lg-6 vc_col-md-7" css=".vc_custom_1543609823056{padding-top: 15px !important;padding-bottom: 15px !important;}" translate_from_y="59" translate_to_y="-73" el_class="z-index-2" responsive_css="padding_top_medium:25px|padding_bottom_medium:65px"][ld_fancy_heading tag="h2" split_type="chars, words" easing="easeOutBack" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" compressor="0.75" minfontsize="48" fs="75px" lh="1em" duration="1200" delay="60" ca_init_translate_y="25" margin="left_large:-18%25"]Ave Collection[/ld_fancy_heading][vc_row_inner responsive_css="padding_left_medium:10%25"][vc_column_inner offset="vc_col-md-7" responsive_css="padding_right_medium:5%25"][vc_column_text css=".vc_custom_1543609483095{margin-bottom: 60px !important;}"]</p> <h3><em><span style="font-size: 22px; line-height: 29px;">“Beautiful, hand-crafted  designs to get you started. in the right direction.”</span></em></h3> <p>[/vc_column_text][/vc_column_inner][vc_column_inner css=".vc_custom_1543609705491{padding-bottom: 20px !important;}"][ld_button style="btn-naked" title="See how it works" transformation="text-uppercase" link_type="lightbox" i_type="fontawesome" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" enable_icon_shadowbox="yes" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DYJ5q8Wrkbdw%26t|||" i_icon_fontawesome="fa fa-play" i_size="14px" i_shape_custom_size="75px" i_margin_right="22px" icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.1)%22%7D%5D" h_icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.07)%22%7D%5D" text_color="rgb(68, 50, 39)" fs="14px" fw="600" ls="0.2em" hover_color="rgb(68, 50, 39)" css=".vc_custom_1543609472916{margin-bottom: 60px !important;}"][/vc_column_inner][vc_column_inner][ld_counter bottom_margin="0" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" enable_blur="true" count="130m" fs="50px" lh="1em" counter_color="rgb(231, 162, 133)" el_class="mb-0"][vc_column_text]<span style="font-size: 15px; color: rgba(68,50,39,0.6);">projects completed around the world</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 16
	$data = array();
	$data['name'] = esc_html__( 'Banner 16', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner12.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" parallax="enable_parallax" enable_loading_bg="yes" enable_row_dividers="yes" css=".vc_custom_1542626083454{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(http://mobile.liquid-themes.com/wp-content/uploads/2018/09/slider-bg-min.jpg?id=114) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" row_svg_divider="bottom_shape_type:4|bottom_shape_color:%23ffffff|bottom_shape_height:181"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1200" ca_delay="150" ca_init_translate_y="60" ca_init_translate_z="-150" ca_init_rotate_x="-65" css=".vc_custom_1531730860500{padding-right: 15% !important;}"][ld_spacer height="15px"][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)"]Manage teamwork in an easy way[/ld_fancy_heading][ld_spacer height="5px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="16px" lh="30px" margin="right_large:12%25|bottom_small:0px"]With Ave, all over the place becomes all-in-one place. Every part of a project lifecycle is here.[/ld_fancy_heading][ld_spacer height="60px"][ld_button style="btn-solid" title="Get early access" transformation="text-uppercase" link_type="scroll_to_section" shape="semi-round" enable_row_shadowbox="yes" color="rgb(254, 80, 108)" color2="rgb(252, 106, 42)" hover_color="rgb(252, 106, 42)" hover_color2="rgb(254, 80, 108)" fs="14px" fw="600" ls="0.1em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.1)%22%7D%5D" hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(254%2C120%2C131%2C0.14)%22%7D%5D" css=".vc_custom_1531382505502{padding-right: 0.75em !important;padding-left: 0.75em !important;}"][ld_spacer height="70px"][ld_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(255,255,255,0.5)" hover_color="#ffffff"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6 vc_hidden-xs" ca_duration="1200" ca_delay="150" ca_init_translate_x="40" ca_init_translate_y="0" ca_start_delay="800" ca_init_rotate_y="-25" ca_an_translate_y="0"][ld_images_group_container][ld_images_group_element parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="8" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" parallax_trigger="onLeave" image="9" translate_from_x="1" translate_from_y="1" margin="top_large:0px|right_large:-40%25|left_large:60%25|top_small:60px" translate_to_x="-17" translate_to_y="-27"][/ld_images_group_element][/ld_images_group_container][ld_images_group_container][ld_images_group_element parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="8" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" parallax_trigger="onLeave" absolute_pos="yes" image="106" position="bottom_large:120px|left_large:30%25|bottom_small:150px|left_small:20%25" translate_from_x="1" translate_from_y="1" translate_to_x="-45" translate_to_y="-69"][/ld_images_group_element][/ld_images_group_container][ld_images_group_container][ld_images_group_element img_size="400x200" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="8" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" parallax_trigger="onLeave" absolute_pos="yes" image="130" position="bottom_large:280px|left_large:17%25|bottom_small:270px|left_small:36%25" translate_from_x="1" translate_from_y="32" translate_to_x="-56" translate_to_y="-181"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	
	//Banner 17
	$data = array();
	$data['name'] = esc_html__( 'Banner 17', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner13.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1542714257953{margin-top: 70px !important;padding-top: 100px !important;padding-bottom: 130px !important;background-image: url(http://medical.liquid-themes.com/wp-content/uploads/2018/09/story-3-min.jpg?id=4054) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-8 vc_col-md-4" ca_init_translate_y="50" ca_init_translate_z="-50" ca_init_rotate_x="-34"][ld_fancy_heading tag="h5" use_custom_fonts_title="true" color="rgb(255, 142, 50)" fw="700"]Spotlight Story[/ld_fancy_heading][ld_fancy_heading tag="h2"]Abbie’s Story[/ld_fancy_heading][ld_fancy_heading tag="p"]A special bond between Abbie and her doctor helped her get the life-saving treatment she needed to thrive.[/ld_fancy_heading][ld_spacer][vc_separator color="custom" align="align_left" border_width="2" el_width="10" accent_color="#ff8e32"][ld_button style="btn-naked" title="See Abbie’s Story" link_type="lightbox" i_type="fontawesome" i_add_icon="true" fs="18px" fw="700" lh="1.25em" i_icon_fontawesome="fa fa-angle-right" i_margin_left="20px" hover_color="rgb(7, 38, 140)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 18
	$data = array();
	$data['name'] = esc_html__( 'Banner 18', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner14.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" enable_loading_bg="yes" css=".vc_custom_1542271158940{padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(http://medical.liquid-themes.com/wp-content/uploads/2018/09/slider-bg-2-min.jpg?id=4050) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:120px|padding_bottom_medium:220px" el_id="top"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_delay="120" ca_init_translate_y="72" ca_init_translate_z="-59" ca_init_rotate_x="-35" ca_duration="850"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" minfontsize="50" fs="72px" lh="1.2em" ls="-0.02em" fw="900" compressor="0.65" margin="bottom_small:0.3em"]Revolutionizing Child Care[/ld_fancy_heading][ld_fancy_heading tag="h4" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" margin="right_large:16%25" color="rgba(7, 38, 140, 0.686)"]Ave Children’s Medical is consistently ranked as one of the top hospitals in the nation by USA[/ld_fancy_heading][ld_spacer height="30px"][ld_button style="btn-solid" title="Find a Doctor" size="btn-sm" fs="20px" fw="700" lh="1.25em" css=".vc_custom_1529409255703{margin-right: 25px !important;}" hover_color="rgb(7, 38, 140)"][ld_button style="btn-naked" title="Book an Appointment" i_type="fontawesome" i_add_icon="true" fs="20px" fw="700" lh="1.25em" i_icon_fontawesome="fa fa-angle-right" i_margin_left="20px" hover_color="rgb(7, 38, 140)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 19
	$data = array();
	$data['name'] = esc_html__( 'Banner 19', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner15.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="0" equal_height="yes" css=".vc_custom_1536753490086{margin-right: 0px !important;margin-left: 0px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-6" css=".vc_custom_1537777462236{padding-top: 110px !important;padding-right: 0px !important;padding-bottom: 120px !important;padding-left: 0px !important;background-image: url(http://gym.liquid-themes.com/wp-content/uploads/2018/09/cta-1-min.jpg?id=4061) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" ca_init_translate_y="50"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="24px" fw="300" ls="0.1em"]Claim your[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="40px" fs="60px" fw="600" margin="bottom_small:0.15em"]Free 7 days pass[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(255, 255, 255)"]Enjoy a workout on us! You will happy for sure.[/ld_fancy_heading][ld_spacer height="10px"][ld_button style="btn-solid" title="Get started" transformation="text-uppercase" size="btn-sm" color="rgb(245, 99, 75)" color2="rgb(254, 148, 24)" fs="16px" fw="600" ls="0.1em" hover_color="rgb(254, 148, 24)" hover_color2="rgb(245, 99, 75)"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-6" css=".vc_custom_1537777889646{padding-top: 110px !important;padding-right: 0px !important;padding-bottom: 120px !important;padding-left: 0px !important;background-image: url(http://gym.liquid-themes.com/wp-content/uploads/2018/09/call-us-min.jpg?id=4073) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" ca_init_translate_y="50"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="24px" fw="300" ls="0.1em"]CALL US[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="40px" fs="60px" fw="600" margin="bottom_small:0.15em"]979 511 5413[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(255, 255, 255)"]If we can help you on your journey! Or check out our FAQ's[/ld_fancy_heading][ld_spacer height="10px"][ld_button style="btn-solid" title="FAQ’s" transformation="text-uppercase" size="btn-sm" color="rgb(245, 99, 75)" color2="rgb(254, 148, 24)" fs="16px" fw="600" ls="0.1em" css=".vc_custom_1537543938280{padding-right: 1.5em !important;padding-left: 1.5em !important;}" hover_color="rgb(254, 148, 24)" hover_color2="rgb(245, 99, 75)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 20
	$data = array();
	$data['name'] = esc_html__( 'Banner 20', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner16.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" columns_placement="top" enable_loading_bg="yes" bg_position="custom" css=".vc_custom_1542475571783{background-image: url(http://gym.liquid-themes.com/wp-content/uploads/2018/09/slider-bg-min.jpg?id=4064) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bg_pos_h="60%" bg_pos_v="50%"][vc_column css=".vc_custom_1529318575307{padding-top: 18% !important;padding-bottom: 28% !important;}"][vc_row_inner bg_position="right bottom"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_init_translate_x="-54"][ld_fancy_heading tag="h2" transform="text-uppercase" use_inheritance="true"]Welcome to <span style="color: #fa7c31;">Avegym</span>[/ld_fancy_heading][ld_fancy_heading tag="h4" use_custom_fonts_title="true" margin="right_large:15%25|bottom_small:2.5em" lh="1.666em"]Ave Gym Centre is dedicated to enriching young lives in rural communities through fun activities and the sport of gymnastics.[/ld_fancy_heading][vc_separator color="custom" align="align_left" el_width="10" accent_color="#f5634b"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="2em" margin="right_large:15%25"]Our state of the art gyms provide you with a great place to work out in, whether you are there to burn off some calories or are training for something more specific.</p>
<p>&nbsp;</p>
<p>Why not visit your nearest Ave Gym Center and take a look? We’re here to help![/ld_fancy_heading][ld_spacer height="50px"][ld_button style="btn-solid" title="Sign up today" transformation="text-uppercase" color="rgb(245, 99, 75)" color2="rgb(254, 148, 24)" hover_color="rgb(254, 148, 24)" hover_color2="rgb(245, 99, 75)" fs="16px" fw="600" ls="0.1em"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;

	//Banner 21
	$data = array();
	$data['name'] = esc_html__( 'Banner 21', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner17.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1529390873433{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(http://gym.liquid-themes.com/wp-content/uploads/2018/06/bg@1x-min.jpg?id=38) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(250, 124, 49)" fs="16px" ls="0.1em" fw="300" ca_init_translate_y="62" duration="1000"]More Than just a gym[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" split_type="words" easing="easeInOutQuint" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" use_mask="true" fs="48px" fw="300" ls="0.5em" color="rgb(255, 255, 255)" lh="1em" delay="200" ca_init_translate_x="0" ca_init_rotate_y="0" start_delay="400" ca_init_translate_y="55" ca_init_rotate_x="0" compressor="0.65" minfontsize="36" duration="1200"]We Train with[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" split_type="chars, words" easing="easeOutExpo" ca_init_scale_x="1.5" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="128px" fw="700" ls="-0.025em" lh="1" margin="left_large:-0.15em" duration="800" start_delay="1000" delay="150" ca_init_translate_x="120" ca_init_translate_y="0" compressor="0.55" minfontsize="78"]passsion[/ld_fancy_heading][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="0.25" ca_init_scale_y="0.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_start_delay="2150" ca_init_translate_y="0"][ld_button style="btn-naked"  link_type="lightbox" i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-xlg" enable_icon_shadowbox="yes" i_add_icon="true" i_size="22px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||" i_icon_fontawesome="fa fa-play" color="rgb(245, 99, 75)" color2="rgb(254, 148, 24)" i_custom_size="30px" icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%221px%22%2C%22shadow_color%22%3A%22%23f5634b%22%7D%5D" h_icon_box_shadow="%5B%7B%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 22
	$data = array();
	$data['name'] = esc_html__( 'Banner 22', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner18.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" bg_position="center center" css=".vc_custom_1541693444650{margin-top: 75px !important;padding-top: 40px !important;background-image: url(http://construction.liquid-themes.com/wp-content/uploads/2018/09/call-to-action-min.jpg?id=4072) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-7" responsive_align="text-md-left text-xs-center" ca_init_translate_y="57"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fw="300" margin="bottom_large:0.2em" fs="30px"]Let’s work together[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="16px" lh="30px"]No matter if you are a homeowner, business owner, facility manager or property manager, Ave Construction Industries offers services that meet your needs.[/ld_fancy_heading][vc_empty_space][/vc_column][vc_column offset="vc_col-md-5" responsive_align="text-md-right text-xs-center"][ld_button style="btn-solid" title="Get Free Quote" transformation="text-uppercase" size="btn-lg" text_color="rgb(24, 27, 49)" fs="14px" fw="700" ls="0.1em" hover_color="rgb(24, 27, 49)" htext_color="rgb(255, 255, 255)"][vc_empty_space][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 23
	$data = array();
	$data['name'] = esc_html__( 'Banner 23', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner19.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542714818529{padding-top: 60px !important;padding-bottom: 70px !important;background-color: #f3f4f6 !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="45px" margin="bottom_large:0.25em" color="rgb(61, 53, 110)"]Start trading with Ave Wallet[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(133, 137, 163)" fs="20px"]Simple, Seamless, Secure.[/ld_fancy_heading][ld_spacer][ld_header_button ib_style="btn-solid" ib_title="Create free account" ib_shape="circle" ib_css=".vc_custom_1540585031641{padding-right: 1em !important;padding-left: 1em !important;}" ib_fs="15px" ib_hover_color="rgb(245, 132, 49)" ib_fw="700" ib_color="rgb(13, 156, 252)" ib_text_color="rgb(255, 255, 255)" ib_htext_color="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 24
	$data = array();
	$data['name'] = esc_html__( 'Banner 24', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner20.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" parallax="enable_parallax" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1533123683487{padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(http://original.liquid-themes.com/wp-content/uploads/2018/08/bg-patt-min.jpg?id=926) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" ca_duration="1200" ca_init_translate_y="36"][vc_column align="text-center" offset="vc_col-lg-offset-1 vc_col-lg-7 vc_col-md-8" responsive_align="text-md-left"][vc_column_text]<img class="size-full wp-image-927 alignleft" src="http://original.liquid-themes.com/wp-content/uploads/2018/08/icon.png" alt="Image" width="68" height="83" /><span style="font-size: 36px; color: #ffffff;">Want to get more details ?</span><br />
<span style="font-size: 18px; color: #ffffff;">Read our whitepaper or visit our <span style="color: #0d9cfc;"><a style="color: #0d9cfc;" href="#">blog.</a></span></span>[/vc_column_text][ld_spacer md_height="0"][/vc_column][vc_column align="text-center" offset="vc_col-md-4" responsive_align="text-md-left"][ld_button style="btn-solid" title="Read the whitepaper" transformation="text-uppercase" shape="circle" color="rgb(13, 156, 252)" fs="12px" ls="0.15em" hover_color="rgb(255, 255, 255)" htext_color="rgb(13, 156, 252)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 25
	$data = array();
	$data['name'] = esc_html__( 'Banner 25', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner21.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" enable_loading_bg="yes" css=".vc_custom_1542026557191{margin-bottom: 60px !important;padding-top: 200px !important;padding-bottom: 190px !important;background-image: url(http://blockchain.liquid-themes.com/wp-content/uploads/2018/10/bg.jpg?id=19) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" css=".vc_custom_1538134698821{margin-top: -30px !important;}"][ld_fancy_heading split_type="chars, words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" ca_init_translate_y="20" ca_init_rotate_z="9" ls="-0.02em" fw="700" delay="35" duration="1200" fs="48px"]<span style="color: #f58431;">All in One</span> Blockchain Solutions[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="chars, words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" ca_init_translate_y="20" ca_init_rotate_z="9" fw="700" delay="35" duration="1200" fs="20px"]Everyone. Anytime. Anywhere[/ld_fancy_heading][ld_spacer height="80px"][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_start_delay="800" ca_init_translate_y="40" ca_init_translate_z="101" ca_init_rotate_x="-52"][ld_button style="btn-default" title="How it works" transformation="text-uppercase" link_type="lightbox" shape="circle" size="btn-md" i_type="linea" i_position="left" i_add_icon="true" color="rgba(13, 156, 252, 0.305)" hover_color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="13px" ls="0.2em" fw="700" css=".vc_custom_1542474387234{margin-top: -30px !important;margin-right: 20px !important;margin-bottom: 10px !important;}" i_icon_linea="icon-ion-ios-play" i_color="rgb(245, 132, 49)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||"][ld_button style="btn-solid" title="Create Free Account" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" size="btn-md" color="rgb(13, 156, 252)" hover_color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="13px" ls="0.2em" fw="700" css=".vc_custom_1542026546168{margin-top: -30px !important;margin-bottom: 10px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 26
	$data = array();
	$data['name'] = esc_html__( 'Banner 26', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner22.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1540584883072{margin-top: 100px !important;margin-bottom: 100px !important;background-color: #f3f5f7 !important;}"][vc_column width="1/2"][ld_fancy_heading use_custom_fonts_title="true" fs="36px" color="rgb(61, 53, 110)"]Effortless exchange[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" color="rgb(61, 53, 110)"]Taking down the borders between Blockchain and money.[/ld_fancy_heading][vc_row_inner css=".vc_custom_1540583963066{margin-top: 20px !important;}"][vc_column_inner width="1/3"][vc_single_image image="58" img_size="full"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="59" img_size="full"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="14px" color="rgb(133, 137, 163)"]iOS 8.0+ and Android 4.4.2+ required[/ld_fancy_heading][/vc_column][vc_column width="1/2"][vc_single_image image="67" img_size="full" css=".vc_custom_1540584888763{margin-top: 50px !important;margin-bottom: 0px !important;padding-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 27
	$data = array();
	$data['name'] = esc_html__( 'Banner 27', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner23.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1539675178098{border-right-width: 3vw !important;border-left-width: 3vw !important;padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(http://architecture.liquid-themes.com/wp-content/uploads/2018/10/bg-2-min.jpg?id=4318) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;}" responsive_css="padding_top_medium:200px|padding_bottom_medium:150px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10" ca_duration="1200" ca_delay="120" ca_init_translate_y="65" ca_init_translate_z="-131" ca_init_rotate_x="-90"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="14px" ls="0.1em"]The team[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="72px" lh="1em"]Our team is an assembly of imaginative and energetic designers and artists.[/ld_fancy_heading][ld_spacer height="25px"][ld_button style="btn-default" title="Meat the team" transformation="text-uppercase" size="btn-xsm" border="border-thick" i_type="linea" i_add_icon="true" i_icon_linea="icon-arrow-right-material" i_margin_left="23px" color="rgb(245, 99, 75)" i_color="rgb(245, 99, 75)" i_hcolor="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" fs="20px" ls="0.1em" css=".vc_custom_1539675114170{padding-top: 0.1em !important;padding-right: 0.5em !important;padding-bottom: 0.1em !important;padding-left: 0.5em !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 28
	$data = array();
	$data['name'] = esc_html__( 'Banner 28', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner24.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row bg_position="center center" responsive_css="padding_top_medium:150px|padding_bottom_medium:75px" css=".vc_custom_1539610753932{padding-top: 70px !important;padding-bottom: 35px !important;background-image: url(http://architecture.liquid-themes.com/wp-content/uploads/2018/10/img-2-min.jpg?id=4322) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-lg-5 vc_col-md-6" translate_from_y="-65" translate_to_y="65"][ld_fancy_heading tag="h2" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" margin="top_small:0px" duration="1200" delay="120" ca_init_translate_y="45"]Creating bespoke spaces that enrich the human <span style="color: #f5634b;">experience</span>[/ld_fancy_heading][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="0" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3" ca_duration="1200" ca_start_delay="250" ca_init_translate_x="-30"][ld_spacer height="10px"][vc_separator color="custom" accent_color="#f5634b"][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-9" ca_duration="1200" ca_delay="120" ca_init_translate_y="45" ca_start_delay="450"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true"]Our process applies techniques from a variety of disciplines, values distinction in detail and gives careful consideration to the unique needs and qualities of each client.[/ld_fancy_heading][ld_spacer height="25px"][ld_fancy_heading tag="h5" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true"]Ave Studio operates with the philosophy that design is cross-disciplined process.[/ld_fancy_heading][ld_spacer height="40px"][ld_button style="btn-naked" title="More about us" transformation="text-uppercase" i_type="linea" i_add_icon="true" i_icon_linea="icon-arrow-right-material" fs="20px" ls="0.05em"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-offset-1 vc_col-md-5"][ld_images_group_container][ld_images_group_element enable_effects="yes" parallax="yes" enable_reveal="yes" reveal_direction="tb" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="4321" translate_from_y="66" translate_to_y="-65"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Banner 29
	$data = array();
	$data['name'] = esc_html__( 'Banner 29', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner25.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" parallax="enable_parallax" enable_loading_bg="yes" css=".vc_custom_1539607567093{border-top-width: 3vw !important;border-right-width: 3vw !important;border-bottom-width: 3vw !important;border-left-width: 3vw !important;background-image: url(http://architecture.liquid-themes.com/wp-content/uploads/2018/10/bg-min.jpg?id=4320) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;border-top-color: #ffffff !important;border-top-style: solid !important;border-bottom-color: #ffffff !important;border-bottom-style: solid !important;}"][vc_column][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="14px" ls="0.1em" margin="top_small:0px|bottom_small:-0.5em" lh="1em" duration="1200" delay="120" ca_init_translate_y="60"]Residential[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" split_type="chars, words" ca_init_scale_x="1.25" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" compressor="0.65" maxfontsize="150" minfontsize="86" fs="150px" ls="-0.01em" duration="1200" start_delay="150" delay="60" ca_init_translate_x="25" ca_init_translate_y="15" ca_init_rotate_x="0" margin="top_small:-0.1em|bottom_small:0px|left_small:-10px" lh="1em" ca_init_rotate_z="4" ca_init_translate_z="24"]Estrada House[/ld_fancy_heading][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_start_delay="850" ca_init_translate_y="60"][ld_spacer height="50px"][ld_button style="btn-default" title="Discover more" transformation="text-uppercase" link_type="scroll_to_section" size="btn-xsm" border="border-thick" i_type="linea" i_add_icon="true" i_icon_linea="icon-arrow-right-material" i_margin_left="23px" color="rgb(245, 99, 75)" i_color="rgb(245, 99, 75)" i_hcolor="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" fs="20px" ls="0.1em" css=".vc_custom_1539608606481{padding-top: 0.1em !important;padding-right: 0.5em !important;padding-bottom: 0.1em !important;padding-left: 0.5em !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 30
	$data = array();
	$data['name'] = esc_html__( 'Banner 30', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner26.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1537774434670{margin-top: 40px !important;padding-top: 110px !important;padding-bottom: 120px !important;background-image: url(http://digitalagency.liquid-themes.com/wp-content/uploads/2018/05/bg-min-2.jpg?id=2881) !important;}"][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1" ca_init_translate_y="52" ca_init_translate_x="0" ca_duration="1200" ca_delay="160" ca_init_translate_z="-142" ca_init_rotate_x="-64"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" compressor="0.6" maxfontsize="72" minfontsize="30" fs="72px" lh="1em" ls="-0.025em"]We are optimists who love to work together[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="24px" lh="1.25em" margin="right_large:5%25|left_large:5%25"]Let’s collaborate and make an impact with our cross-discipline approach to design and deveopment.[/ld_fancy_heading][vc_empty_space height="52px"][ld_button style="btn-solid" title="Free Consultation" transformation="text-uppercase" shape="circle" color="rgb(253, 115, 80)" fs="16px" fw="700" ls="0.05em" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 31
	$data = array();
	$data['name'] = esc_html__( 'Banner 31', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner27.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1537449325718{padding-top: 50px !important;padding-bottom: 65px !important;}"][vc_column offset="vc_col-lg-8 vc_col-md-6"][ld_images_group_container][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="4056" translate_from_y="89" translate_to_y="-103" margin="left_large:-54%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-4 vc_col-md-6"][ld_spacer height="" md_height="70px"][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" use_mask="true" fs="72px" ca_init_translate_y="100" ca_init_rotate_z="0" margin="left_large:-150px" compressor="0.55" maxfontsize="72" minfontsize="30" lh="1.2em" duration="1200" delay="150" ca_init_translate_x="0"]How We Work[/ld_fancy_heading][ld_spacer height="" md_height="38px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="We know that good design means good business." fs="24px" el_class="font-style-italic" color="rgb(24, 27, 49)" margin="right_large:10%25|top_small:0px|bottom_small:0px" start_delay="350" ca_init_translate_x="0" ca_init_translate_y="28" duration="1200" delay="150" lh="1.25em"]“Our mission is to produce the highest quality work for every client, on every project”[/ld_fancy_heading][ld_spacer height="35px" md_height="100px"][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_start_delay="620" ca_init_translate_y="32" ca_init_translate_z="0" ca_init_translate_x="0"][ld_button style="btn-naked" title="See how We Work" transformation="text-uppercase" link_type="lightbox" i_type="fontawesome" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-xlg" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||" i_icon_fontawesome="fa fa-play" i_custom_size="17px" color="rgb(46, 212, 124)" text_color="rgb(24, 27, 49)" fs="14px" ls="0.1em" fw="700" i_size="20px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 32
	$data = array();
	$data['name'] = esc_html__( 'Banner 32', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner28.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1537540875717{padding-top: 70px !important;padding-bottom: 75px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_init_translate_y="31" ca_init_translate_x="0" ca_duration="1200" ca_delay="150" ca_init_translate_z="-108" ca_init_rotate_x="-76"][ld_images_group_container margin="bottom_small:0px"][ld_images_group_element img_size="50%" image="4144" margin="bottom_small:0px"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" title="<b>good</b> design" init_values="translateY:50,opacity:0,rotate:15" animations_values="translateY:0,opacity:1,rotate:0" margin="top_small:0px|bottom_small:0px" fs="72px" lh="1em" ls="-0.025em" fw="400" minfontsize="48" compressor="0.65"]<strong>good</strong> design[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" title="<b>good</b> design" init_values="translateY:50,opacity:0,rotate:15" animations_values="translateY:0,opacity:1,rotate:0" margin="top_small:-3px|bottom_small:0px" fs="72px" lh="1em" ls="-0.025em" start_delay="180" fw="400" minfontsize="48" compressor="0.65"]<strong>good</strong> business[/ld_fancy_heading][vc_empty_space height="45px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="We know that good design means good business." fs="30px" el_class="font-style-italic" color="rgb(24, 27, 49)" margin="right_large:25%25|top_small:0px|bottom_small:0px" start_delay="360" lh="1.025em"]We know that good design means good business.[/ld_fancy_heading][vc_empty_space height="40px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic." fs="18px" lh="1.5em" margin="right_large:25%25" start_delay="500"]We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic.[/ld_fancy_heading][vc_empty_space height="50px"][ld_button style="btn-solid" title="More about us" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" size="btn-md" enable_border="yes" color="#2ed47c" fs="14px" fw="700" ls="0.025em" b_color="#2ed47c" css=".vc_custom_1537954741264{padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="#fc7350" h_b_color="#fc7350"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_images_group_container][ld_images_group_element img_size="470x600" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="4068" translate_from_y="78" translate_to_y="-78"][/ld_images_group_element][ld_images_group_element img_size="370x400" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="4052" position="bottom_large:-13%25|left_large:-45%25|bottom_small:-10%25|left_small:30%25" translate_from_y="107" translate_to_y="-134"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 33
	$data = array();
	$data['name'] = esc_html__( 'Banner 33', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner29.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" parallax="enable_parallax" enable_loading_bg="yes" enable_slideshow_bg="yes" slideshow_effect="scale" slideshow_images="2898,4053" slideshow_delay="3000"][vc_column width="5/6" align="text-center" offset="vc_col-sm-offset-1" css=".vc_custom_1527245307587{padding-top: 80px !important;padding-bottom: 160px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" ca_init_translate_y="39" ca_init_rotate_x="-60" ca_init_translate_z="-136" ls="0.2em" fw="400" margin="bottom_small:0.25em" duration="1200" delay="150"]We love creating[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" compressor="0.6" maxfontsize="120" minfontsize="88" fs="120px" fw="700" start_delay="220" ca_init_translate_y="50" duration="1200" delay="150" ca_init_rotate_x="-73" margin="bottom_all:0px|bottom_small:0px" ca_init_translate_z="-154" lh="1em"]digital ideas[/ld_fancy_heading][ld_spacer height="34px" xs_height="" xs_devices=""][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" fs="24px" lh="30px" margin="right_large:17%25|left_large:17%25" duration="1200" start_delay="600" delay="150" ca_init_translate_y="45" ca_init_rotate_x="-71" ca_init_translate_z="-109" compressor="0.6" minfontsize="20"]Ave is a thriving creative digital media &amp; design agency based by the valley in San Francisco.[/ld_fancy_heading][vc_empty_space height="40px"][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="5" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_start_delay="950" ca_delay="150" ca_init_translate_y="41" ca_init_rotate_x="-65" ca_init_translate_z="-118"][vc_column_inner width="1/2" responsive_align="text-md-right text-xs-center"][ld_button style="btn-solid" title="free Consultation" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" color="rgb(253, 115, 80)" fs="16px" fw="700" ls="0.05em" css=".vc_custom_1537774994397{padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)"][/vc_column_inner][vc_column_inner width="1/2" responsive_align="text-md-left text-xs-center"][ld_button style="btn-default" title="How we work" transformation="text-uppercase" link_type="lightbox" shape="circle" border="border-thick" i_type="fontawesome" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_add_icon="true" color="rgb(46, 212, 124)" fs="16px" fw="700" ls="0.05em" i_icon_fontawesome="fa fa-play" i_custom_size="11px" i_margin_right="8px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||" i_size="12px" css=".vc_custom_1537775046679{padding-right: 0.75em !important;padding-left: 0.75em !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 34
	$data = array();
	$data['name'] = esc_html__( 'Banner 34', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner30.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1527151802753{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" ca_init_translate_y="92" ca_init_rotate_x="-34" ca_duration="1200" ca_delay="150" ca_start_delay="200"][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_fit="true" enable_split="true" compressor="0.55"]Let’s create something extraordinary[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(254, 104, 139)" fs="86px" lh="1em" compressor="0.65" minfontsize="70"]together[/ld_fancy_heading][vc_empty_space height="45px"][ld_button style="btn-solid" title="Start a project" transformation="text-uppercase" shape="circle" enable_row_shadowbox="yes" color="rgb(61, 89, 232)" text_color="rgb(255, 255, 255)" fs="14px" fw="600" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2212px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22%23c5cbec%22%7D%5D" hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(254%2C104%2C139%2C0.12)%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 35
	$data = array();
	$data['name'] = esc_html__( 'Banner 35', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner31.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" css=".vc_custom_1539092154174{padding-top: 80px !important;padding-bottom: 40px !important;}" el_class="z-index-2" responsive_css="padding_top_medium:150px|padding_bottom_medium:150px" el_id="top"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" el_class="z-index-2" ca_start_delay="650" offset="vc_hidden-sm vc_hidden-xs"][ld_masked_image absolute_pos="yes" image="4038" position="top_large:-290px|right_large:-55vw|left_large:33vw|right_medium:-90vw|left_medium:42vw" bg_pos_x="-250px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_init_translate_y="51"][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="60px" lh="1.3em" ls="-0.025em"]Adventures in creative age[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" use_mask="true"]We believe that designing products and services in close partnership with our clients is the only way to have a real impact on their business.[/ld_fancy_heading][vc_empty_space height="70px"][vc_row_inner equal_height="yes" content_placement="middle" gap="5"][vc_column_inner width="1/2" css=".vc_custom_1527070643537{padding-right: 0px !important;}"][ld_button style="btn-solid" title="Start a project" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" enable_row_shadowbox="yes" color="rgb(61, 89, 232)" text_color="rgb(255, 255, 255)" fs="14px" fw="600" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2212px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22%23c5cbec%22%7D%5D" hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(254%2C104%2C139%2C0.12)%22%7D%5D"][vc_empty_space][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" margin="bottom_large:0"]<strong><span style="color: #fe688b;">Call us (0123) 456 - 789</span></strong><span style="color: #a7a9b8;">For any question or concern</span>[/ld_fancy_heading][vc_empty_space][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	
	//Banner 36
	$data = array();
	$data['name'] = esc_html__( 'Banner 36', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner32.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" parallax="enable_parallax" enable_loading_bg="yes" css=".vc_custom_1537630136123{padding-top: 70px !important;padding-bottom: 20px !important;background-image: url(http://construction.one.liquid-themes.com/wp-content/uploads/2018/09/slider-bg-min.jpg?id=4084) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="0" parallax_trigger="onLeave" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-9" ca_init_translate_x="-47" translate_from_y="0" translate_to_y="-145" ca_init_translate_y="0" ca_duration="1200" ca_delay="150"][ld_spacer height="45px" md_height="120px"][vc_row_inner][vc_column_inner offset="vc_col-md-7"][vc_separator color="custom" align="align_left" border_width="2" el_width="10" accent_color="#ffc80b" css=".vc_custom_1533798532729{margin-bottom: 25px !important;}"][/vc_column_inner][/vc_row_inner][ld_fancy_heading tag="h2" use_custom_fonts_title="true" enable_fit="true" color="rgb(255, 255, 255)" compressor="0.6" maxfontsize="100" minfontsize="40" fs="100px" lh="1em" fw="700" ls="-0.025em" margin="bottom_large:0.3em"]Expertise to build what matters.[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-7"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" lh="1.666em"]We build good experiences for our clients, our partners, our team, our subcontractors, and our community.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_empty_space height="35px"][ld_button style="btn-solid" title="Get Free Quote" transformation="text-uppercase" link_type="scroll_to_section" fs="14px" fw="700" text_color="rgb(24, 27, 49)" hover_color="rgb(24, 27, 49)" htext_color="rgb(255, 255, 255)"][ld_spacer height="45px" md_height="140px"][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="0" parallax_trigger="onLeave" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3" responsive_align="text-md-right" ca_init_translate_x="38" ca_start_delay="500" translate_to_y="-121"][ld_button style="btn-naked" title="Watch The Film" link_type="lightbox" i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-xlg" enable_icon_shadowbox="yes" i_add_icon="true" i_size="22px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3Dhy7rWRQQGeo|||" i_icon_fontawesome="fa fa-play" i_custom_size="29px" fs="14px" ls="0.02em" text_color="rgb(255, 255, 255)" icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%221px%22%2C%22shadow_color%22%3A%22%23ffffff%22%7D%5D" h_icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%221px%22%2C%22shadow_color%22%3A%22%23ffc80b%22%7D%5D"][ld_spacer height="35px" md_height="0px"][/vc_column][vc_column][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3" ca_init_translate_y="54" ca_start_delay="650"][vc_separator color="custom" align="align_left" border_width="2" el_width="20" accent_color="#ffc80b" css=".vc_custom_1527592206802{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="18px" lh="1.333em" fw="700" ls="0.02em"]Building Community Building Leaders[/ld_fancy_heading][ld_spacer md_height="0"][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-3" ca_init_translate_y="55" ca_start_delay="800"][vc_separator color="custom" align="align_left" border_width="2" el_width="20" accent_color="#ffc80b" css=".vc_custom_1527592212134{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="18px" lh="1.333em" fw="700" ls="0.02em"]Turn your vision
into a Landmark[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	
	//Banner 37
	$data = array();
	$data['name'] = esc_html__( 'Banner 37', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner33.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" parallax="enable_parallax" enable_loading_bg="yes" css=".vc_custom_1542441026426{padding-top: 155px !important;padding-bottom: 170px !important;background-image: url(http://travel.liquid-themes.com/wp-content/uploads/2018/11/travel-2.jpg?id=4273) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-2 vc_col-lg-8" ca_duration="1600" ca_delay="160" ca_init_translate_y="121" ca_init_translate_z="-142" ca_init_rotate_x="-85"][ld_fancy_heading tag="h6" transform="text-uppercase" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="14px" ls="0.2em" ca_init_translate_x="0" delay="150" ca_init_translate_y="43" ca_init_rotate_z="5"]Spring Package[/ld_fancy_heading][ld_images_group_container][ld_images_group_element img_size="60%" image="4223"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" color="rgb(255, 255, 255)"]The Perfect Summer Escape just from £99[/ld_fancy_heading][ld_spacer height="30px"][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1"][ld_button style="btn-solid" title="Book Your Holiday" transformation="text-uppercase" shape="semi-round" hover_color="rgb(255, 122, 75)" fs="14px" fw="700" ls="0.1em" css=".vc_custom_1542231498313{padding-right: 6px !important;padding-left: 6px !important;}" color="rgb(36, 147, 224)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

	$templates[] = $data;
	
	//Banner 38
	$data = array();
	$data['name'] = esc_html__( 'Banner 38', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner34.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1539092410245{padding-top: 50px !important;padding-bottom: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5 vc_hidden-sm vc_hidden-xs" ca_duration="1200" ca_delay="200" ca_init_translate_y="100" ca_init_translate_z="-76" ca_start_delay="300"][ld_images_group_container][ld_images_group_element parallax="yes" enable_roudness="yes" image_roudness="4" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="4039" margin="right_large:20px" position="top_large:-80px|left_large:-90%25" translate_from_y="47" translate_to_y="-74"][/ld_images_group_element][/ld_images_group_container][ld_images_group_container][ld_images_group_element parallax="yes" enable_roudness="yes" image_roudness="4" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="4040" position="top_large:-400px|left_large:0px|right_small:0px|bottom_small:0px" translate_from_y="83" translate_to_y="-94"][/ld_images_group_element][/ld_images_group_container][ld_images_group_container][ld_images_group_element parallax="yes" enable_roudness="yes" image_roudness="4" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="4041" position="top_large:-300px|right_large:90%25|left_large:-90%25|bottom_small:0px|left_small:-30%25" translate_from_y="167" translate_to_y="-151"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1528355075386{padding-right: 12% !important;}" ca_init_translate_y="58"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" title="About Ave Agency" color="rgb(249, 184, 81)" fs="12px" fw="600" ls="0.2em"]Our Community[/ld_fancy_heading][vc_empty_space height="15px"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" title="Ultimate experiences with story, emotion and purpose" color="rgb(24, 27, 49)" fw="700" fs="42px" lh="1.3em"]We are optimists who love to work together[/ld_fancy_heading][vc_empty_space height="10px"][ld_fancy_heading tag="p" title="We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic." margin="right_large:6%25"]Take your career to next level. Apply to our team and see what we can do together. You’re good enough, right ?[/ld_fancy_heading][vc_empty_space height="70px"][ld_button style="btn-solid" title="Join the team" transformation="text-uppercase" shape="circle" enable_row_shadowbox="yes" color="rgb(61, 89, 232)" text_color="rgb(255, 255, 255)" fs="14px" fw="600" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2212px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22%23c5cbec%22%7D%5D" hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(254%2C104%2C139%2C0.12)%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 39
	$data = array();
	$data['name'] = esc_html__( 'Banner 39', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner35.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" video_bg="yes" video_bg_source="youtube" video_bg_url="https://www.youtube.com/watch?v=BJq4d1-lHq8" y_end_time="29" enable_overlay="yes" css=".vc_custom_1538120433012{border-top-width: 2.5vw !important;border-right-width: 2.5vw !important;border-bottom-width: 2.5vw !important;border-left-width: 2.5vw !important;padding-top: 60px !important;padding-bottom: 60px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;border-top-color: #ffffff !important;border-top-style: solid !important;border-bottom-color: #ffffff !important;border-bottom-style: solid !important;}" overlay_bg="rgba(0, 0, 0, 0.242)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" ca_init_translate_y="80" ca_init_translate_z="-159" ca_init_rotate_x="-71" ca_duration="1200" ca_delay="150"][vc_row_inner][vc_column_inner][ld_fancy_heading use_theme_fonts="" text_font="font_family:Amiri%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" minfontsize="75" fs="100px" lh="1em" compressor="0.65"]Digital Experience Creation[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="16px"]<em><span style="font-family: georgia, palatino, serif;">Welcome</span></em> Ave Agency[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" ca_duration="1200" ca_init_translate_y="58" ca_start_delay="550" css=".vc_custom_1535371073897{margin-top: 8% !important;}"][ld_button style="btn-solid"  link_type="scroll_to_section" shape="circle" size="btn-custom" i_type="linea" i_add_icon="true" i_size="btn-icon-xlg" custom_size="55px" custom_height="55px" i_icon_linea="icon-arrows_down" i_color="rgb(255, 255, 255)" color="rgb(131, 11, 176)" color2="rgb(186, 0, 255)" fs="25px" hover_color="rgb(186, 0, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 40
	$data = array();
	$data['name'] = esc_html__( 'Banner 40', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner36.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1539092346072{padding-top: 70px !important;padding-bottom: 70px !important;}" responsive_css="padding_top_medium:120px|padding_bottom_medium:100px" el_id="about"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" translate_from_y="-89" ca_init_translate_y="49"][vc_empty_space][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" title="About Ave Agency" color="rgb(249, 184, 81)" fs="12px" fw="600" ls="0.2em"]How we work[/ld_fancy_heading][vc_empty_space height="15px"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" title="Ultimate experiences with story, emotion and purpose" color="rgb(24, 27, 49)" fw="700" fs="42px" lh="1.3em"]How do we create amazing products[/ld_fancy_heading][vc_empty_space height="10px"][ld_fancy_heading tag="p" title="We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic." margin="right_large:22%25"]We have a simple mission: to produce the highest quality work and services for every client, on every project.[/ld_fancy_heading][vc_empty_space height="52px"][ld_button style="btn-naked" title="See how we work" transformation="text-uppercase" link_type="lightbox" i_type="fontawesome" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-xlg" enable_icon_shadowbox="yes" i_add_icon="true" i_icon_fontawesome="fa fa-play" i_custom_size="18px" icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%225px%22%2C%22blur_radius%22%3A%2215px%22%2C%22spread_radius%22%3A%22-2px%22%2C%22shadow_color%22%3A%22rgba(254%2C104%2C139%2C0.31)%22%7D%5D" color="rgb(254, 104, 139)" fs="12px" fw="600" h_icon_box_shadow="%5B%7B%7D%5D" i_size="18px"][vc_empty_space][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-6 vc_col-md-offset-1 vc_col-md-5"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="4" enable_shadow="yes" enable_reveal="yes" reveal_direction="rl" image="4037" margin="right_large:-75%25" reveal_color="rgb(25, 38, 47)"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 41
	$data = array();
	$data['name'] = esc_html__( 'Banner 41', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner37.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" parallax="enable_parallax" css=".vc_custom_1537973047611{margin-top: 90px !important;margin-bottom: 60px !important;padding-top: 125px !important;padding-bottom: 80px !important;background-image: url(http://business.liquid-themes.com/wp-content/uploads/2018/09/video-bg.jpg?id=3974) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-7" responsive_align="text-md-right"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" compressor="0.5" minfontsize="36" fs="40px" lh="1.25em" duration="1200" delay="150" ca_init_translate_y="120" ca_init_rotate_z="-5" margin="right_large:12%25"]Great things in business are never done by one person. They're done by a team of people[/ld_fancy_heading][ld_spacer md_height="0"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-5" responsive_align="text-md-left" ca_duration="1200" ca_start_delay="400" ca_init_translate_x="-31"][ld_header_button ib_style="btn-naked" ib_title="See our presentation" ib_link_type="lightbox" ib_i_type="fontawesome" ib_i_position="left" ib_i_shape="btn-icon-circle" ib_i_shape_style="btn-icon-solid" ib_i_shape_size="btn-icon-xlg" ib_i_ripple="btn-icon-ripple" ib_i_add_icon="true" ib_i_size="22px" ib_i_icon_fontawesome="fa fa-play" ib_i_color="rgb(0, 0, 0)" ib_i_custom_size="24px" ib_color="rgb(255, 199, 10)" ib_text_color="rgb(255, 255, 255)" ib_fs="19px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 42
	$data = array();
	$data['name'] = esc_html__( 'Banner 42', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner38.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1532336243599{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #f6f6f6 !important;}"][vc_column][ld_carousel columns="lg:6|md:5|sm:3|xs:2|spacing_sm:15px|spacing_xs:5px" inactiv_opacity="1"][vc_single_image image="47" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336112678{margin-bottom: 0px !important;}"][vc_single_image image="49" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336129801{margin-bottom: 0px !important;}"][vc_single_image image="51" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336170461{margin-bottom: 0px !important;}"][vc_single_image image="49" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336129801{margin-bottom: 0px !important;}"][vc_single_image image="50" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336162782{margin-bottom: 0px !important;}"][vc_single_image image="52" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336181178{margin-bottom: 0px !important;}"][vc_single_image image="50" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336141127{margin-bottom: 0px !important;}"][vc_single_image image="49" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336129801{margin-bottom: 0px !important;}"][vc_single_image image="51" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336170461{margin-bottom: 0px !important;}"][vc_single_image image="52" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" css=".vc_custom_1532336181178{margin-bottom: 0px !important;}"][/ld_carousel][/vc_column][/vc_row][vc_row parallax="enable_parallax" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_overlay="yes" css=".vc_custom_1538125124946{margin-bottom: 40px !important;padding-top: 135px !important;padding-bottom: 135px !important;background-image: url(http://business.liquid-themes.com/wp-content/uploads/2018/09/parallax-bg.jpg?id=3970) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" ca_duration="1200" ca_init_translate_y="56" ca_init_translate_z="-179" ca_init_rotate_x="-75" overlay_bg="rgba(9, 17, 35, 0.611)"][vc_column align="text-center" css=".vc_custom_1532336583804{padding-right: 7% !important;padding-left: 7% !important;}" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="p" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" fs="40px" lh="1.25em" fw="700"]<span style="color: #ffffff;">Great things in business are never done by one person. They're done <em><span style="color: #ffc70a;">by a team of people.</span></em></span>[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 43
	$data = array();
	$data['name'] = esc_html__( 'Banner 43', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner39.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" enable_loading_bg="yes" enable_row_dividers="yes" css=".vc_custom_1538055652586{margin-bottom: 60px !important;padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(http://cryptocurrency.liquid-themes.com/wp-content/uploads/2018/09/crypto_c0c054182f3ad3802b936081f418f41c.jpg?id=4025) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" row_svg_divider="bottom_shape_type:waves-4|bottom_shape_color:%23ffffff|bottom_shape_height:70"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-7 vc_col-md-8" ca_duration="1200" ca_delay="150" ca_init_translate_y="81" ca_init_rotate_z="2" css=".vc_custom_1538048022767{margin-top: -50px !important;}"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_inheritance="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" minfontsize="35" compressor="0.5"]Bitcoin is designed around the idea of using money.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgba(255, 255, 255, 0.599)" fs="17px" lh="1.764em" margin="right_large:25%25|bottom_small:3em"]Bitcoin is designed around the idea of using cryptography to control the creation and transfer of money in any time.[/ld_fancy_heading][ld_button style="btn-naked" title="See how it works" link_type="lightbox" i_type="fontawesome" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-xlg" i_ripple="btn-icon-ripple" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||" i_icon_fontawesome="fa fa-play" i_size="22px" color="rgb(120, 11, 238)" color2="rgb(29, 225, 209)" hover_color="rgb(29, 225, 209)" hover_color2="rgb(120, 11, 238)" i_color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" fs="19px" ls="0.025em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 44
	$data = array();
	$data['name'] = esc_html__( 'Banner 44', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner40.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1531992316562{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column offset="vc_col-lg-5" el_class="z-index-2"][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_delay="150" ca_init_translate_y="40" ca_init_translate_z="-156" ca_init_rotate_x="-69"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="37px" margin="bottom_large:0.75em"]Bitcoin is divisible to eight decimal places[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="17px" lh="1.764em" margin="right_large:25%25|bottom_large:1.75em"]Bitcoin is designed around the idea of using cryptography to control the creation and transfer of money in any time.[/ld_fancy_heading][ld_header_button ib_style="btn-naked" ib_title="List ICO Sales" ib_i_type="linea" ib_i_add_icon="true" ib_i_icon_linea="icon-md-arrow-round-forward" ib_i_color="rgb(29, 62, 222)" ib_hover_color="rgb(29, 62, 222)" ib_text_color="rgb(30, 22, 102)" ib_fs="16px" ib_color="rgb(30, 22, 102)"][ld_spacer height="45px"][/vc_column_inner][/vc_row_inner][ld_images_group_container][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="41" position="right_large:25%25|bottom_large:10%25" translate_from_x="-25" translate_from_y="49" translate_to_x="-64" translate_to_y="-132"][/ld_images_group_element][/ld_images_group_container][ld_images_group_container][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="40" translate_from_x="-16" translate_from_y="74" translate_to_x="-10" translate_to_y="-123" position="right_large:3%25|bottom_large:-10%25"][/ld_images_group_element][/ld_images_group_container][ld_images_group_container][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="39" translate_from_x="-26" translate_from_y="65" translate_to_x="23" translate_to_y="-113" position="right_large:-14%25|bottom_large:10%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-7"][ld_images_group_container][ld_images_group_element img_size="597x423" enable_effects="yes" enable_reveal="yes" image="3995" margin="right_large:7%25|left_large:6%25" reveal_color="rgb(249, 249, 249)"][/ld_images_group_element][/ld_images_group_container][vc_row_inner css=".vc_custom_1536653294992{margin-top: -40% !important;}"][vc_column_inner parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-offset-6 vc_col-lg-6" css=".vc_custom_1531995234706{padding-top: 45px !important;padding-right: 45px !important;padding-bottom: 5px !important;padding-left: 40px !important;background-color: #ffffff !important;border-radius: 3px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%222px%22%2C%22blur_radius%22%3A%2214px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.079)%22%7D%5D" translate_from_y="89" translate_to_y="-135" ca_duration="1200" ca_delay="150" ca_init_translate_y="50" parallax_duration="3000"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" i_shape="circle" i_size="xs" position="iconbox-inline" i_border="" shadow="iconbox-icon-hover-shadow" i_icon_linea="icon-md-checkmark" title="Bitcoin is designed around cryptography." custom_heading_size="18px" i_color="rgb(255, 255, 255)" h_color="rgb(2, 55, 83)" shape_color="linear-gradient(115deg, rgb(146, 175, 236) 0%, rgb(155, 225, 247) 100%)" i_hcolor="" shape_hcolor="linear-gradient(90deg, rgb(87, 146, 255) 0%, #32d7ff 100%)" custom_i_size="20px"][/ld_icon_box][ld_spacer height="10px"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" i_shape="circle" i_size="xs" position="iconbox-inline" i_border="" shadow="iconbox-icon-hover-shadow" i_icon_linea="icon-md-checkmark" title="Transfer request from a digital wallet." custom_heading_size="18px" i_color="rgb(255, 255, 255)" h_color="rgb(2, 55, 83)" shape_color="linear-gradient(115deg, rgb(146, 175, 236) 0%, rgb(155, 225, 247) 100%)" i_hcolor="" shape_hcolor="linear-gradient(90deg, rgb(87, 146, 255) 0%, #32d7ff 100%)" custom_i_size="20px"][/ld_icon_box][ld_spacer height="10px"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" i_shape="circle" i_size="xs" position="iconbox-inline" i_border="" shadow="iconbox-icon-hover-shadow" i_icon_linea="icon-md-checkmark" title="The independent individuals and companies" custom_heading_size="18px" i_color="rgb(255, 255, 255)" h_color="rgb(2, 55, 83)" shape_color="linear-gradient(115deg, rgb(146, 175, 236) 0%, rgb(155, 225, 247) 100%)" i_hcolor="" shape_hcolor="linear-gradient(90deg, rgb(87, 146, 255) 0%, #32d7ff 100%)" custom_i_size="20px"][/ld_icon_box][ld_spacer height="10px"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" i_shape="circle" i_size="xs" position="iconbox-inline" i_border="" shadow="iconbox-icon-hover-shadow" i_icon_linea="icon-md-checkmark" title="Control the creation and transfer of money." custom_heading_size="18px" i_color="rgb(255, 255, 255)" h_color="rgb(2, 55, 83)" shape_color="linear-gradient(115deg, rgb(146, 175, 236) 0%, rgb(155, 225, 247) 100%)" i_hcolor="" shape_hcolor="linear-gradient(90deg, rgb(87, 146, 255) 0%, #32d7ff 100%)" custom_i_size="20px"][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][ld_spacer height="220px" xs_height="150"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 45
	$data = array();
	$data['name'] = esc_html__( 'Banner 45', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner41.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1538162648759{padding-top: 85px !important;padding-bottom: 40px !important;background-image: url(http://landing.liquid-themes.com/wp-content/uploads/2018/09/cta-1.jpg?id=159) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-7" responsive_align="text-md-left" css=".vc_custom_1531743285914{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" use_mask="true" minfontsize="35" fs="45px" lh="1.2em" ls="-0.015em" ca_init_translate_y="84" ca_init_rotate_z="10" color="rgb(255, 255, 255)" el_class="text-underline" fw="600" compressor="0.5" margin="bottom_large:0px"]Looking for a collaboration? <span style="color: #ffafa2;">Join the community.</span>[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-3" ca_init_translate_y="39" responsive_align="text-md-right"][ld_button style="btn-solid" title="Get Started" shape="semi-round" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" fs="16px" ls="0.01em" css=".vc_custom_1532341336351{padding-right: 4em !important;padding-left: 4em !important;}" hover_color="rgb(0, 0, 0)"][vc_empty_space height="25px"][vc_row_inner][vc_column_inner align="text-center"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgba(255, 255, 255, 0.7)" link="|||" fs="16px" lh="1.56em" ls="0.02em"]Looking for a job?
Apply here.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 46
	$data = array();
	$data['name'] = esc_html__( 'Banner 46', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner42.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542616092345{padding-top: 60px !important;padding-bottom: 50px !important;}" responsive_css="padding_top_medium:120px"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" margin="bottom_small:0px"]Ave Collection[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" ls="0.015em" color="rgb(167, 167, 167)" margin="top_large:5px"]Denim and shirts designs by Diana Kate[/ld_fancy_heading][ld_spacer height="50px"][/vc_column][vc_column offset="vc_col-md-6"][ld_shop_banner title="Summer Hats" link="url:%23|||" image="4395,54,57"][/vc_column][vc_column offset="vc_col-md-6"][vc_row_inner equal_height="yes"][vc_column_inner offset="vc_col-md-6"][ld_shop_banner title="Summer Denim" link="url:%23|||" image="4396"][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ld_shop_banner title="Summer Denim" link="url:%23|||" image="4398"][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ld_shop_banner title="Summer Denim" link="url:%23|||" image="4397"][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ld_shop_banner title="Summer Denim" link="url:%23|||" image="4399" color="rgb(255, 255, 255)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Banner 47
	$data = array();
	$data['name'] = esc_html__( 'Banner 47', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner43.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1538135248261{padding-top: 125px !important;padding-bottom: 135px !important;background-image: url(http://shop.liquid-themes.com/wp-content/uploads/2018/08/model_cutout.jpg?id=4239) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" responsive_css="padding_right_medium:10%25|padding_left_medium:10%25"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="13px" ls="0.2em"]SUMMER COLLECTION[/ld_fancy_heading][ld_spacer height="25px"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" fs="50px" lh="1em"]Besties by the beach under the sun.[/ld_fancy_heading][ld_button style="btn-solid" title="SHOP COLLECTION" transformation="text-uppercase" link_type="scroll_to_section" size="btn-lg" i_type="fontawesome" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" fs="13px" ls="0.2em" fw="700" i_icon_fontawesome="fa fa-angle-right"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	// Banner 48
	$data = array();
	$data['name'] = esc_html__( 'Banner 48', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner44.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1537883675681{margin-bottom: 75px !important;padding-top: 135px !important;padding-bottom: 200px !important;background-image: url(http://hotel.liquid-themes.com/wp-content/uploads/2018/06/bg-min-1.jpg?id=64) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-9" ca_init_translate_y="40" ca_init_rotate_x="-71" ca_init_translate_x="0" ca_duration="1200" ca_delay="150" ca_init_translate_z="-153"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="16px" ls="0.2em" fw="400"]<em>Special Offer</em>[/ld_fancy_heading][vc_empty_space height="48px"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" title="Extraordinary Luxury" init_values="translateY:100,opacity:0" margin="top_small:0px|bottom_small:0px" compressor="0.5" color="rgb(255, 255, 255)"]Savor Living Well[/ld_fancy_heading][vc_empty_space height="25px"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="16px" ls="0.2em" margin="right_large:20%25" lh="30px"]This limited-time offer is your opportunity to enjoy Las Vegas with every amenity at your fingertips.[/ld_fancy_heading][vc_empty_space height="55px"][ld_button style="btn-default" title="View Offer" transformation="text-uppercase" size="btn-md" i_type="fontawesome" i_add_icon="true" color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="12px" ls="0.1em" i_icon_fontawesome="fa fa-long-arrow-right" i_margin_left="15px" css=".vc_custom_1538077243135{padding-right: 0.5em !important;padding-left: 0.5em !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 49
	$data = array();
	$data['name'] = esc_html__( 'Banner 49', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner45.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1537883675681{margin-bottom: 75px !important;padding-top: 135px !important;padding-bottom: 200px !important;background-image: url(http://hotel.liquid-themes.com/wp-content/uploads/2018/06/bg-min-1.jpg?id=64) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-9" ca_init_translate_y="40" ca_init_rotate_x="-71" ca_init_translate_x="0" ca_duration="1200" ca_delay="150" ca_init_translate_z="-153"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="16px" ls="0.2em" fw="400"]<em>Special Offer</em>[/ld_fancy_heading][vc_empty_space height="48px"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" title="Extraordinary Luxury" init_values="translateY:100,opacity:0" margin="top_small:0px|bottom_small:0px" compressor="0.5" color="rgb(255, 255, 255)"]Savor Living Well[/ld_fancy_heading][vc_empty_space height="25px"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="16px" ls="0.2em" margin="right_large:20%25" lh="30px"]This limited-time offer is your opportunity to enjoy Las Vegas with every amenity at your fingertips.[/ld_fancy_heading][vc_empty_space height="55px"][ld_button style="btn-default" title="View Offer" transformation="text-uppercase" size="btn-md" i_type="fontawesome" i_add_icon="true" color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="12px" ls="0.1em" i_icon_fontawesome="fa fa-long-arrow-right" i_margin_left="15px" css=".vc_custom_1538077243135{padding-right: 0.5em !important;padding-left: 0.5em !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 50
	$data = array();
	$data['name'] = esc_html__( 'Banner 50', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner46.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1542639560703{padding-top: 75px !important;padding-bottom: 75px !important;}"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_init_translate_y="42" translate_from_y="73" translate_to_y="-80"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" compressor="0.5" margin="bottom_small:0px"]LUXURY RESORTS[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="12px" ls="0.2em" color="rgb(63, 65, 71)"]A Sanctuary of comfort and nature[/ld_fancy_heading][ld_spacer height="28px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" title="Each boutique hotel in the Ave Hotel collection tells a unique story, inviting guests to immerse themselves in tales of adventure, romance, history, culture, nature and more for the length of a memorable stay. Discover the high points of our story here." init_values="translateY:80,opacity:0"]Our exclusive experiences blend science and nature, wellness and beauty, to harmonize the body and the mind with lasting impressions of serenity, radiance and well–being.[/ld_fancy_heading][ld_spacer height="20px"][vc_row_inner][vc_column_inner offset="vc_col-md-9"][ld_spacer height="8px"][vc_column_text]</p><ul><li><span style="color: #666666;">Massage</span></li><li><span style="color: #666666;">Skin Care</span></li><li><span style="color: #666666;">Facials</span></li><li><span style="color: #666666;">Final Touches</span></li></ul><p>[/vc_column_text][ld_spacer height="45px"][ld_button style="btn-underlined" title="Learn More" transformation="text-uppercase" color="rgb(63, 65, 71)" fs="12px" ls="0.1em" hover_color="rgb(0, 0, 0)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_reveal="yes" reveal_direction="rl" image="153" reveal_color="rgb(23, 37, 49)"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 51
	$data = array();
	$data['name'] = esc_html__( 'Banner 51', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner47.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" parallax="enable_parallax" enable_slideshow_bg="yes" slideshow_images="5396,5219" css=".vc_custom_1540318952120{margin-bottom: 60px !important;}" slideshow_delay="2500"][vc_column align="text-center" css=".vc_custom_1538134698821{margin-top: -30px !important;}"][ld_fancy_heading split_type="chars, words" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22Animations%22%7D%2C%7B%22word%22%3A%22Options%22%7D%2C%7B%22word%22%3A%22Effects%22%7D%5D" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" minfontsize="50" ca_init_translate_y="20" ca_init_rotate_z="9" compressor="0.8" ls="-0.02em" fw="700" delay="35" duration="1200" fs="90px"]Unique[/ld_fancy_heading][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_start_delay="800" ca_init_translate_y="40" ca_init_translate_z="101" ca_init_rotate_x="-52"][ld_button style="btn-solid" title="DISCOVER ONE" transformation="text-uppercase" link_type="scroll_to_section" size="btn-lg" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" fs="13px" ls="0.2em" fw="700" css=".vc_custom_1540198719990{margin-top: -30px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 52
	$data = array();
	$data['name'] = esc_html__( 'Banner 52', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner48.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" enable_slideshow_bg="yes" slideshow_images="5395,5396" enable_overlay="yes" css=".vc_custom_1540320834571{margin-top: 50px !important;margin-bottom: 50px !important;padding-top: 130px !important;padding-bottom: 130px !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 0, 0, 0.262)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1530273748624{padding-right: 7% !important;}" ca_duration="1200" ca_delay="120" ca_init_translate_y="100" ca_init_translate_z="-80" ca_init_rotate_x="-71"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" fs="65px" fw="700" minfontsize="45"]Digital Experience.[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" color="rgba(255, 255, 255, 0.8)" compressor="0.5" minfontsize="14px" fs="17px" lh="28px"]We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly.[/ld_fancy_heading][ld_spacer height="45px"][ld_button style="btn-naked" title="Discover One" transformation="text-uppercase" link_type="lightbox" i_type="linea" i_position="left" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(255, 255, 255)" htext_color="rgba(255, 255, 255, 0.885)" fs="14px" ls="0.2em" i_icon_linea="icon-ion-ios-play-circle" i_size="35px" i_margin_right="15px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 53
	$data = array();
	$data['name'] = esc_html__( 'Banner 53', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner53.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" bg_position="center center" enable_overlay="yes" css=".vc_custom_1546960851784{padding-top: 80px !important;padding-bottom: 80px !important;background: #474646 url(http://opus.liquid-themes.com/wp-content/uploads/2019/01/opus-1-cta_87a4be8cf48d5b995039d1c3beea1172.jpg?id=7102);background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 0, 0, 0.15)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1600" ca_delay="160" ca_init_translate_y="50"][ld_fancy_heading tag="h2" margin="bottom_small:0.5em" color="rgb(255, 255, 255)"]Launch your amazing site today.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.68)" fs="18px" lh="32px" padding="right_large:10%25|left_large:10%25" ls="0.02em"]No more complex codes or boring designs. Creating an attractive and functional site has never been easier.[/ld_fancy_heading][ld_spacer][ld_button style="btn-solid" title="Join the community" shape="round" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" fs="16px" hover_color="rgb(58, 58, 58)"][vc_row_inner][vc_column_inner css=".vc_custom_1545130034778{padding-top: 15px !important;}"][ld_button style="btn-naked" title="or free trial" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" color="rgba(255, 255, 255, 0.7)" hover_color="rgb(255, 255, 255)" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][rev_slider alias="Opus Main Slider"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 54
	$data = array();
	$data['name'] = esc_html__( 'Banner 54', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner54.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1546275208891{padding-bottom: 120px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="45px" margin="bottom_large:0.25em"]Launch your amazing site today.[/ld_fancy_heading][ld_spacer height="25px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(134, 134, 134)" fs="17px" padding="right_small:5%25|left_small:5%25"]No more complex codes or boring designs. Buy Ave and get access to premium and exclusive plugins for free. Buy once, and it is yours forever. Perfect deal![/ld_fancy_heading][ld_spacer height="25px"][ld_button style="btn-solid" title="Join to download" shape="round" fs="17px" lh="1.5em" ls="0.02em" css=".vc_custom_1546275482231{padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(37, 37, 37)"][vc_row_inner][vc_column_inner][ld_spacer height="25px"][ld_button style="btn-naked" title="or free trial" fs="17px" lh="1.5em" ls="0.02em" css=".vc_custom_1546419285151{padding-right: 1em !important;padding-left: 1em !important;}" text_color="rgb(65, 65, 65)" htext_color="rgb(211, 82, 82)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 55
	$data = array();
	$data['name'] = esc_html__( 'Banner 55', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner55.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1546879621884{padding-top: 30px !important;padding-bottom: 90px !important;background-color: #f7f9fb !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_right_medium:7%25|padding_left_medium:12%25" ca_duration="1600" ca_delay="160" ca_init_translate_y="30"][ld_fancy_heading tag="h2" margin="bottom_small:0.75em"]Practical tools make it easier to manage.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="17px" lh="1.68em" margin="bottom_small:2em"]Being the Ave's business, that is, the person see pulled You have seen Italian organ boys holding a dancing. Lorema dolor sit amet, consectetur adipisicing elit sed.[/ld_fancy_heading][ld_button style="btn-solid" title="Discover Ave" link_type="lightbox" shape="semi-round" size="btn-sm" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4%26feature%3Dyoutu.be||target:%20_blank|" fs="15px" ls="0.02em" css=".vc_custom_1546273494651{margin-right: 8px !important;margin-bottom: 10px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="rgb(39, 39, 39)"][ld_button style="btn-default" title="Free Trial" shape="semi-round" size="btn-sm" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" color="rgb(228, 228, 228)" fs="15px" ls="0.02em" css=".vc_custom_1545115315167{margin-bottom: 10px !important;margin-left: 8px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(0, 0, 0)" text_color="rgb(26, 28, 38)" htext_color="rgb(255, 255, 255)"][ld_spacer][/vc_column][vc_column align="text-center" offset="vc_col-md-offset-0 vc_col-md-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="4" enable_shadow="yes" image="http://opus-four.liquid-themes.com/wp-content/uploads/2019/01/opus-4-video2.jpg"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 56
	$data = array();
	$data['name'] = esc_html__( 'Banner 56', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner56.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1546879614901{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f7f9fb !important;}"][vc_column align="text-center" offset="vc_col-md-offset-0 vc_col-md-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="4" enable_shadow="yes" image="http://opus-four.liquid-themes.com/wp-content/uploads/2019/01/opus-4-video.jpg"][ld_button style="btn-naked" link_type="lightbox" i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_size="18px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||" i_icon_fontawesome="fa fa-play" i_color="rgb(0, 0, 0)" i_custom_size="22px" color="rgb(255, 255, 255)" i_shape_custom_size="104px" i_margin_left="0" i_margin_right="0"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_right_medium:7%25|padding_left_medium:12%25" ca_duration="1600" ca_delay="160" ca_init_translate_y="30"][ld_fancy_heading tag="h2" margin="bottom_small:0.75em"]Beautiful, hand-crafted designs to get started.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="17px" lh="1.68em" margin="bottom_small:2em"]Being the Ave's business, that is, the person see pulled You have seen Italian organ boys holding a dancing. Lorema dolor sit amet, consectetur adipisicing elit sed.[/ld_fancy_heading][ld_button style="btn-solid" title="Discover Ave" link_type="lightbox" shape="semi-round" size="btn-sm" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4%26feature%3Dyoutu.be||target:%20_blank|" fs="15px" ls="0.02em" css=".vc_custom_1546273509540{margin-right: 8px !important;margin-bottom: 10px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="rgb(42, 42, 42)"][ld_button style="btn-default" title="Free Trial" shape="semi-round" size="btn-sm" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" color="rgb(228, 228, 228)" fs="15px" ls="0.02em" css=".vc_custom_1545115315167{margin-bottom: 10px !important;margin-left: 8px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(0, 0, 0)" text_color="rgb(26, 28, 38)" htext_color="rgb(255, 255, 255)"][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 57
	$data = array();
	$data['name'] = esc_html__( 'Banner 57', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner57.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" enable_loading_bg="yes" bg_position="center center" bg_attachment="fixed" css=".vc_custom_1546938398438{padding-top: 60px !important;padding-bottom: 60px !important;background-image: url(http://opus-four.liquid-themes.com/wp-content/uploads/2019/01/opus-4-banner-2.jpg?id=6879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1.25" ca_init_scale_y="1.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-left" offset="vc_col-md-offset-0 vc_col-md-7" ca_duration="1600" ca_delay="160"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="45px" lh="1.244em" ls="-0.014em" margin="bottom_small:0.7em"]Helping customers be their best in the moments that matter.[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-offset-0 vc_col-md-10" css=".vc_custom_1546273383363{padding-left: 1% !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="20px" lh="1.58em" margin="bottom_small:2.5em"]No more complex codes or boring designs. Creating an attractive and functional site has never been easier.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_button style="btn-solid" title="Discover Ave" link_type="lightbox" shape="semi-round" size="btn-sm" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4%26feature%3Dyoutu.be||target:%20_blank|" fs="15px" ls="0.02em" css=".vc_custom_1546610042296{margin-right: 8px !important;margin-bottom: 10px !important;margin-left: 8px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="rgb(58, 58, 58)" htext_color="rgb(255, 255, 255)"][ld_button style="btn-default" title="Free Trial" shape="semi-round" size="btn-sm" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" color="rgba(38, 39, 48, 0.09)" fs="15px" ls="0.02em" css=".vc_custom_1546610051366{margin-right: 8px !important;margin-bottom: 10px !important;margin-left: 8px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(58, 58, 58)" htext_color="rgb(255, 255, 255)" text_color="rgb(38, 39, 48)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 58
	$data = array();
	$data['name'] = esc_html__( 'Banner 58', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner58.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="0" equal_height="yes" content_placement="middle" css=".vc_custom_1545203367366{background-color: #242424 !important;}"][vc_column offset="vc_col-lg-6" css=".vc_custom_1546961669109{background-image: url(http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/opus-3-s2.jpg?id=4297) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/opus-3-s2.jpg" img_size="full" alignment="center" invisible="yes"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1.25" ca_init_scale_y="1.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vw|padding_bottom_medium:0px|padding_left_medium:10vw" css=".vc_custom_1545209818740{padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="45"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="40px" lh="1.1em" margin="bottom_small:1.2em" color="rgb(255, 255, 255)"]Great things in business are never done by one person.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(136, 136, 136)" fs="17px" lh="29px" margin="bottom_small:3em"]Complete Design Toolkit – huge collection of elements, rich customization options, flexible layouts, and instant results![/ld_fancy_heading][ld_button style="btn-solid" title="Discover Ave" link_type="lightbox" shape="semi-round" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4|||" fs="15px" css=".vc_custom_1546609712033{padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 59
	$data = array();
	$data['name'] = esc_html__( 'Banner 59', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner59.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" columns_placement="bottom" enable_loading_bg="yes" enable_slideshow_bg="yes" slideshow_effect="scale" slideshow_images="4243,4295" bg_attachment="fixed" enable_overlay="yes" css=".vc_custom_1546961602999{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 0, 0, 0.08)"][vc_column enable_content_animation="yes" ca_easing="easeOutCubic" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1200" ca_delay="120" ca_init_translate_y="55" responsive_css="margin_bottom_medium:13%25"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22solutions%22%7D%2C%7B%22word%22%3A%22innovation%22%7D%2C%7B%22word%22%3A%22quality%22%7D%5D" use_custom_fonts_title="true" use_inheritance="true" color="rgb(255, 255, 255)" margin="bottom_small:0.75em" fs="60px"]Global leader in modern business[/ld_fancy_heading][ld_button style="btn-solid" title="Discover Ave" link_type="lightbox" shape="semi-round" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4%26feature%3Dyoutu.be|||" css=".vc_custom_1546265608997{margin-right: 8px !important;margin-bottom: 10px !important;margin-left: 8px !important;padding-right: 0.2em !important;padding-left: 0.2em !important;}" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)"][ld_button style="btn-default" title="See how it works" shape="semi-round" i_type="linea" i_position="left" i_add_icon="true" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" color="rgba(255, 255, 255, 0.3)" css=".vc_custom_1546265615462{margin-right: 8px !important;margin-bottom: 10px !important;margin-left: 8px !important;padding-right: 0.2em !important;padding-left: 0.2em !important;}" hover_color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" i_icon_linea="icon-ion-ios-play" i_margin_right="10px"][/vc_column][vc_column css=".vc_custom_1545141364367{border-top-width: 1px !important;padding-top: 50px !important;padding-bottom: 30px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_start_delay="350" ca_delay="120" ca_init_translate_y="55"][vc_column_inner offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="xs" heading_weight="font-weight-normal" title="Next-generation Theme" h_color="rgb(255, 255, 255)" i_color="rgb(255, 255, 255)" i_icon_animated="animated-basic_mouse"]<span style="color: #cecece;">Install anything in a matter of seconds.</span>

[/ld_icon_box][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="xs" heading_weight="font-weight-normal" title="One Click Installation" h_color="rgb(255, 255, 255)" i_color="rgb(255, 255, 255)" i_icon_animated="animated-software_pathfinder_subtract"]<span style="color: #cecece;">Install anything in a matter of seconds.</span>[/ld_icon_box][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="xs" heading_weight="font-weight-normal" title="Top-notch Support" h_color="rgb(255, 255, 255)" i_color="rgb(255, 255, 255)" i_icon_animated="animated-weather_lightning"]<span style="color: #cecece;">Install anything in a matter of seconds.</span>[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 60
	$data = array();
	$data['name'] = esc_html__( 'Banner 60', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner60.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row enable_overlay="yes" css=".vc_custom_1546946236807{margin-top: 55px !important;padding-top: 120px !important;padding-bottom: 120px !important;background-image: url(http://opus-two.liquid-themes.com/wp-content/uploads/2019/01/opus-two-background.jpg?id=6897) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(22, 22, 22, 0.15)" hover_overlay_bg="rgba(22, 22, 22, 0.45)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1200" ca_delay="180" ca_init_translate_y="40" ca_init_translate_z="-161" ca_init_rotate_x="-80" css=".vc_custom_1545130653593{padding-top: 5% !important;padding-right: 5% !important;padding-bottom: 5% !important;padding-left: 5% !important;background-color: #ffffff !important;border-radius: 4px !important;}"][ld_spacer height="18px"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="36px" lh="1.111em"]Get in Touch[/ld_fancy_heading][ld_spacer height="12px"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="16px" lh="25px" color="rgba(24, 27, 49, 0.502)"]Top-notch support, free lifetime updates, and bonus plugins included in the package![/ld_fancy_heading][ld_spacer height="22px"][ld_button style="btn-solid" title="Join to download" shape="round" fs="15px" lh="1.5em" ls="0.02em" css=".vc_custom_1545227719465{padding-right: 7em !important;padding-left: 7em !important;}" hover_color="rgb(37, 37, 37)"][ld_spacer height="22px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 61
	$data = array();
	$data['name'] = esc_html__( 'Banner 61', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/banners/banner61.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row gap="30" full_height="yes" content_placement="middle" enable_loading_bg="yes" bg_position="center center" bg_attachment="fixed" enable_overlay="yes" css=".vc_custom_1546961442159{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(http://opus-two.liquid-themes.com/wp-content/uploads/2019/01/opus-2banner.jpg?id=6978) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-7" ca_duration="1200" ca_delay="150" ca_init_translate_y="81" ca_init_rotate_z="2" css=".vc_custom_1546528207762{margin-top: -50px !important;}" ca_init_translate_z="5"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_inheritance="true" enable_fit="true" enable_split="true" color="rgb(255, 255, 255)" minfontsize="35" compressor="0.5"]Smart and effective solutions for businesses.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgba(255, 255, 255, 0.599)" fs="20px" lh="1.764em" margin="right_large:25%25|bottom_small:3em" fw="300"]Forget about design limits! Build and customize your site visually. It’s fun, fast and super-easy![/ld_fancy_heading][ld_button style="btn-naked" title="See how it works" link_type="lightbox" i_type="fontawesome" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4|||" i_icon_fontawesome="fa fa-play" i_size="16px" color="rgb(255, 255, 255)" i_color="rgb(0, 0, 0)" text_color="rgba(255, 255, 255, 0.71)" fs="16px" ls="0.025em" i_shape_custom_size="90px" hover_color="rgb(39, 174, 96)" htext_color="rgb(255, 255, 255)" i_hcolor="rgb(255, 255, 255)"][ld_spacer height="45px" hide="vc_hidden-lg"][/vc_column][vc_column align="text-center" offset="vc_col-md-5" css=".vc_custom_1546519320706{padding-top: 10% !important;padding-right: 9% !important;padding-bottom: 0px !important;padding-left: 9% !important;background-color: #ffffff !important;border-radius: 5px !important;}" responsive_css="padding_bottom_medium:0px"][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="30px" fw="300"]Book Appointment[/ld_fancy_heading][ld_fancy_heading tag="p"]Ave offers functional contact forms that are fully customizable. Try it yourself![/ld_fancy_heading][ld_spacer height="20px"][ld_cf7 id="3986" shape="contact-form-inputs-filled" size="contact-form-inputs-md" roundness="contact-form-inputs-round" btn_size="contact-form-button-md" btn_width="contact-form-button-block" btn_roundness="contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" submit_fs="14px" h_color="rgb(111, 114, 116)" border_color="rgba(255, 255, 255, 0.147)" bg_color="rgb(247, 249, 251)" hbg_color="rgb(237, 239, 241)" color="rgb(111, 114, 116)" submit_hbg_color="rgb(44, 44, 44)" submit_hover_border_color="rgb(44, 44, 44)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Blog Category
	//Blog 1
	$data = array();
	$data['name'] = esc_html__( 'Blog 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog1.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1537449467884{padding-top: 50px !important;padding-bottom: 75px !important;}"][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1" ca_init_translate_y="79" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(46, 212, 124)" fs="13px" ls="0.1em"]News &amp; Events[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" use_mask="true" fs="60px" compressor="0.65" minfontsize="48"]Latest Articles[/ld_fancy_heading][ld_spacer][/vc_column][vc_column][ld_blog style="classic-bold" grid_columns="3" meta_type="cats" enable_parallax="no" post_type="post" posts_per_page="10" ib_style="" ib_title="" ib_border="" filter_id="1527500868084-772fdf80-9b25" unique_id="1527500868084-d39322f8-108f"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 2
	$data = array();
	$data['name'] = esc_html__( 'Blog 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog2.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1539250495649{padding-top: 110px !important;padding-bottom: 55px !important;}" el_id="news"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" margin="bottom_large:0"]Recent Articles[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6" responsive_align="text-md-right text-xs-center"][ld_button style="btn-naked" title="See Abbie’s Story" link_type="lightbox" i_type="fontawesome" i_add_icon="true" fs="18px" fw="700" lh="1.25em" i_icon_fontawesome="fa fa-angle-right" i_margin_left="20px" hover_color="rgb(7, 38, 140)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DJN-suUcRdqQ|||"][/vc_column][vc_column][ld_spacer height="50px"][ld_blog style="classic" grid_columns="3" post_type="post" posts_per_page="3" ib_style="" ib_title="" ib_border="" filter_id="1529489088198-71bde2c4-c74a" unique_id="1529489088198-37a0289e-6a46" post_excerpt_length="13"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 3
	$data = array();
	$data['name'] = esc_html__( 'Blog 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog3.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1529399797361{padding-top: 90px !important;padding-bottom: 90px !important;background-color: #f0f2f4 !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" transform="text-uppercase" margin="bottom_small:0.15em"]Blog and Social[/ld_fancy_heading][ld_fancy_heading tag="p"]See what’s happenning around AveGym[/ld_fancy_heading][ld_spacer height="60px"][/vc_column][vc_column][ld_blog style="metro" enable_parallax="no" post_type="post" posts_per_page="4" ib_style="" ib_title="" ib_border="" unique_id="ld-1525439217880-bb2be8da-7672" post_excerpt_length="10" filter_id="ld-1525439217880-e2a9a847-be5c"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 4
	$data = array();
	$data['name'] = esc_html__( 'Blog 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog12.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1543485571884{margin-bottom: 80px !important;padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column][ld_section_title title="Latest Posts" alignment="text-center" title_top_margin="0" title_bottom_margin="0" subtitle_top_margin="0" subtitle_bottom_margin="10" text_top_margin="0" text_bottom_margin="0" css=".vc_custom_1543477709255{margin-bottom: 70px !important;}"][/vc_column][vc_column][ld_blog style="minimal" post_type="post" posts_per_page="3" columns_gap="0" bottom_gap="30" ib_style="" ib_title="" ib_border="" filter_id="1543477047695-f41b3c1e-8584" unique_id="1543477047698-cb298714-fe4a" post_excerpt_length="14"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 5
	$data = array();
	$data['name'] = esc_html__( 'Blog 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog4.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1537542102894{padding-top: 65px !important;padding-bottom: 20px !important;}"][vc_column][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fw="300"]News &amp; Media[/ld_fancy_heading][vc_empty_space height="35px"][/vc_column][vc_column][ld_blog style="text-date" grid_columns="2" post_type="post" posts_per_page="4" ib_style="" ib_title="" ib_border="" unique_id="ld-1525432461818-cff235ee-aa18" taxonomies="38" post_excerpt_length="25"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 6
	$data = array();
	$data['name'] = esc_html__( 'Blog 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog5.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ld_blog style="carousel-filterable" enable_filter="yes" one_category="no" post_type="post" posts_per_page="10" filter_lbl_all="All Categories" filter_transformation="text-uppercase ltr-sp-1" ib_style="" ib_title="" ib_border="" order="ASC" unique_id="ld-1526470574311-c1f28716-a0c2" taxonomies="253" filter_title="Interesting articles updated `{`ld_span color=``#3ed2a7```}` daily `{`/ld_span`}`" filter_subtitle="Our Blog" link="url:%23|||" filter_cats="269, 271, 270, 266" filter_id="ld-1526470574310-bb6aab15-1446" filter_mb="60" link_label="See all blog" post_excerpt_length="18"][vc_empty_space height="60px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	// Blog 7
	$data = array();
	$data['name'] = esc_html__( 'Blog 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog6.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1539675238011{padding-top: 140px !important;padding-bottom: 140px !important;}"][vc_column][ld_fancy_heading tag="h2" transform="text-uppercase" margin="top_small:0px"]Latest <span style="color: #f5634b;">news</span>[/ld_fancy_heading][ld_spacer height="10px"][/vc_column][vc_column offset="vc_col-md-6"][ld_blog style="featured" post_type="post" posts_per_page="1" ib_style="" ib_title="" ib_border="" filter_id="1539675555420-57eef6ef-1eef" unique_id="1539675555420-ff402c3a-b4b8" post_excerpt_length="35"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_blog style="featured-minimal" enable_parallax="no" post_type="post" posts_per_page="4" ib_style="" ib_title="" ib_border="" filter_id="1539675595166-06d1ac63-413a" unique_id="1539675595166-32cd70ef-779e" offset="1"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 8
	$data = array();
	$data['name'] = esc_html__( 'Blog 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog7.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540648603831{padding-top: 70px !important;padding-bottom: 90px !important;}" el_id="blog"][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-sm-offset-2" ca_init_translate_y="55" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h2"]Our journal[/ld_fancy_heading][ld_fancy_heading tag="p" margin="right_desktop:25%25|left_desktop:25%25|right_mobile:2%25|left_mobile:2%25"]Explore interesting articles updated daily[/ld_fancy_heading][vc_empty_space height="50px"][/vc_column][vc_column][ld_blog style="rounded" grid_columns="3" enable_parallax="no" post_type="post" posts_per_page="3" columns_gap="15" bottom_gap="0" ib_style="" ib_title="" ib_border="" unique_id="1524836196608-9f88468d-cb4b" post_excerpt_length="0"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 9
	$data = array();
	$data['name'] = esc_html__( 'Blog 09', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog8.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1538080327093{padding-top: 85px !important;padding-bottom: 55px !important;}"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" transform="text-uppercase" margin="bottom_large:0"]From our travel blog[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6" responsive_align="text-md-right text-xs-left"][ld_button style="btn-naked" title="See all Blog" transformation="text-uppercase" hover_color="rgb(12, 62, 114)" fs="14px" fw="700" ls="0.1em"][/vc_column][vc_column][ld_spacer height="60px"][ld_blog style="classic-2" grid_columns="3" post_type="post" posts_per_page="10" ib_style="" ib_title="" ib_border="" filter_id="1529667179883-d198e7d4-d4bf" unique_id="1529667179883-ab8a2091-c2ec" post_excerpt_length="22"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 10
	$data = array();
	$data['name'] = esc_html__( 'Blog 10', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog9.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1534409531541{padding-top: 45px !important;padding-bottom: 45px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" ls="0.1em"]Recent Articles[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" enable_fit="true" compressor="0.65" minfontsize="32px" fs="50px" lh="1.15em" fw="600"]Writing is a socially acceptable form of schizophrenia[/ld_fancy_heading][ld_spacer height="12px"][/vc_column][vc_column][vc_separator color="custom" border_width="3" accent_color="#181b31"][/vc_column][/vc_row][vc_row][vc_column][ld_spacer height="12px"][ld_blog style="grid" grid_columns="3" post_type="post" posts_per_page="12" ib_style="" ib_title="" ib_border="" filter_id="1534409535228-01920208-440a" unique_id="1534409535229-04dd4219-6ee9" post_excerpt_length="13" taxonomies="54" columns_gap="45" bottom_gap="100"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 11
	$data = array();
	$data['name'] = esc_html__( 'Blog 11', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog10.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1538053746161{padding-top: 50px !important;padding-bottom: 50px !important;}" el_id="news"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(163, 172, 186)" fs="12px" ls="0.2em" margin="bottom_large:1.5em"]IDEA OF BLOCKCHAIN[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="44px"]Latest News[/ld_fancy_heading][ld_spacer height="35px"][/vc_column][vc_column][ld_blog style="square" enable_parallax="no" post_type="post" posts_per_page="5" ib_style="" ib_title="" ib_border="" filter_id="1535377760643-6483bc90-6053" unique_id="1535377760643-e25ee8df-9b57"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog 12
	$data = array();
	$data['name'] = esc_html__( 'Blog 12', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/blog/blog11.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1530096799281{padding-top: 70px !important;padding-bottom: 70px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" tag_to_inherite="h2" use_inheritance="true"]Latest in Fashion[/ld_fancy_heading][ld_spacer height="45px"][/vc_column][vc_column][ld_blog style="metro-alt" grid_columns="2" post_type="post" posts_per_page="2" ib_style="" ib_title="" ib_border="" filter_id="1530095568627-bb1a044d-e0e0" unique_id="1530095568628-602bb647-e8ed" post_excerpt_length="7"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel Category
	//Carousel 1
	$data = array();
	$data['name'] = esc_html__( 'Carousel 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/carousel/carousel1.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1530878228183{padding-bottom: 100px !important;}"][vc_column][ld_carousel columns="md:1.75|xs:2|spacing_xs:15px" inactiv_opacity="1" shadow="carousel-shadow-active" pagenationdots="yes" wraparound="yes" paddings="3%" style="" dots_bg_color="rgb(230, 230, 230)" dots_bg_hcolor="rgb(8, 8, 8)"][vc_single_image image="5180" img_size="full" alignment="center"][vc_single_image image="5178" img_size="full" alignment="center"][vc_single_image image="5177" img_size="full" alignment="center"][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 2
	$data = array();
	$data['name'] = esc_html__( 'Carousel 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/carousel/carousel2.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1530878228183{padding-bottom: 100px !important;}"][vc_column][ld_carousel columns="lg:4.5|md:3.75|sm:2|xs:1|spacing_xs:15px" inactiv_opacity="1" shadow="carousel-shadow-all" pagenationdots="yes" wraparound="yes" dots_style="carousel-dots-style4" paddings="17px" style=""][vc_single_image image="5188" img_size="full" alignment="center" onclick="link_image" enable_opacity="yes" opacity="1" css=".vc_custom_1540200995438{margin-bottom: 0px !important;}"][vc_single_image image="5357" img_size="full" alignment="center" css=".vc_custom_1540221831370{margin-bottom: 0px !important;}"][vc_single_image image="5195" img_size="full" alignment="center" css=".vc_custom_1540200802841{margin-bottom: 0px !important;}"][vc_single_image image="5187" img_size="full" alignment="center" css=".vc_custom_1540200691896{margin-bottom: 0px !important;}"][vc_single_image image="5186" img_size="full" alignment="center" css=".vc_custom_1540200726776{margin-bottom: 0px !important;}"][vc_single_image image="5195" img_size="full" alignment="center" css=".vc_custom_1540200943132{margin-bottom: 0px !important;}"][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 3
	$data = array();
	$data['name'] = esc_html__( 'Carousel 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/carousel/carousel3.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1530881046786{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h3" alignment="text-center"]Adjust column and spacing[/ld_fancy_heading][ld_spacer height="40px"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][ld_carousel columns="" inactiv_opacity="1" prevnextbuttons="yes" pagenationdots="yes" wraparound="yes" navarrow="custom" navshape="carousel-nav-rectangle" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" dots_style="carousel-dots-style4" paddings="0" prev="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1sZWZ0JTVDJTIyJTNFJTNDJTJGaSUzRQ==" next="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1yaWdodCU1QyUyMiUzRSUzQyUyRmklM0U=" shapeheight="62px" shapewidth="40px" nav_arrow_color="rgb(255, 255, 255)" nav_bg_color="rgba(0, 0, 0, 0.3)" nav_bg_hcolor="rgb(0, 0, 0)"][vc_single_image image="5177" img_size="full" alignment="center"][vc_single_image image="5178" img_size="full" alignment="center"][vc_single_image image="5179" img_size="full" alignment="center"][/ld_carousel][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" css=".vc_custom_1530878228183{padding-bottom: 100px !important;}"][vc_column][ld_carousel columns="lg:4.5|md:3.75|sm:2|xs:1|spacing_xs:15px" inactiv_opacity="1" shadow="carousel-shadow-all" pagenationdots="yes" wraparound="yes" dots_style="carousel-dots-style4" paddings="17px" style=""][vc_single_image image="5188" img_size="full" alignment="center" onclick="link_image" enable_opacity="yes" opacity="1" css=".vc_custom_1540200995438{margin-bottom: 0px !important;}"][vc_single_image image="5357" img_size="full" alignment="center" css=".vc_custom_1540221831370{margin-bottom: 0px !important;}"][vc_single_image image="5195" img_size="full" alignment="center" css=".vc_custom_1540200802841{margin-bottom: 0px !important;}"][vc_single_image image="5187" img_size="full" alignment="center" css=".vc_custom_1540200691896{margin-bottom: 0px !important;}"][vc_single_image image="5186" img_size="full" alignment="center" css=".vc_custom_1540200726776{margin-bottom: 0px !important;}"][vc_single_image image="5195" img_size="full" alignment="center" css=".vc_custom_1540200943132{margin-bottom: 0px !important;}"][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 4
	$data = array();
	$data['name'] = esc_html__( 'Carousel 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/carousel/carousel4.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1530881035795{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h3" alignment="text-center"]Adjust column and spacing[/ld_fancy_heading][ld_spacer height="40px"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][ld_carousel columns="md:4|sm:2|xs:1|spacing_md:5px|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" adaptiveheight="yes" navarrow="custom" navshape="carousel-nav-rectangle" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" paddings="3px" prev="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1sZWZ0JTVDJTIyJTNFJTNDJTJGaSUzRQ==" next="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1yaWdodCU1QyUyMiUzRSUzQyUyRmklM0U=" shapeheight="62px" shapewidth="40px" nav_arrow_color="rgb(255, 255, 255)" nav_bg_color="rgba(0, 0, 0, 0.3)" nav_bg_hcolor="rgb(0, 0, 0)" prevoffset="3px" nextoffset="3px"][vc_single_image image="5188" img_size="full" alignment="center" css=".vc_custom_1540200544830{margin-bottom: 0px !important;}"][vc_single_image image="5187" img_size="full" alignment="center" css=".vc_custom_1540200551595{margin-bottom: 0px !important;}"][vc_single_image image="5357" img_size="full" alignment="center" css=".vc_custom_1540221977635{margin-bottom: 0px !important;}"][vc_single_image image="5186" img_size="full" alignment="center" css=".vc_custom_1540200534923{margin-bottom: 0px !important;}"][vc_single_image image="5195" img_size="full" alignment="center" css=".vc_custom_1540200899492{margin-bottom: 0px !important;}"][vc_single_image image="5185" img_size="full" alignment="center" css=".vc_custom_1540200557575{margin-bottom: 0px !important;}"][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 5
	$data = array();
	$data['name'] = esc_html__( 'Carousel 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/carousel/carousel5.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="0" enable_overlay="yes" overlay_bg="linear-gradient(180deg, rgba(240, 240, 240, 0.8) 0.9554140127388535%, rgba(248, 248, 248, 0.8) 100%)" css=".vc_custom_1530883541087{margin-top: 100px !important;margin-bottom: 100px !important;padding-top: 150px !important;padding-bottom: 50px !important;}"][vc_column][ld_carousel columns="lg:3.5|spacing_xs:15px" inactiv_opacity="1" groupcells="no" wraparound="yes" autoplay="yes" randomveroffset="yes" paddings="3%"][vc_single_image image="5215" img_size="full"][vc_single_image image="5205" img_size="full"][vc_single_image image="5203" img_size="full"][vc_single_image image="5201" img_size="full"][vc_single_image image="5202" img_size="full"][vc_single_image image="5209" img_size="full"][vc_single_image image="5210" img_size="full"][vc_single_image image="5211" img_size="full"][/ld_carousel][/vc_column][/vc_row][vc_row css=".vc_custom_1530881035795{padding-top: 100px !important;padding-bottom: 100px !important;}"][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h3" alignment="text-center"]Adjust column and spacing[/ld_fancy_heading][ld_spacer height="40px"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][ld_carousel columns="md:4|sm:2|xs:1|spacing_md:5px|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" adaptiveheight="yes" navarrow="custom" navshape="carousel-nav-rectangle" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" paddings="3px" prev="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1sZWZ0JTVDJTIyJTNFJTNDJTJGaSUzRQ==" next="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1yaWdodCU1QyUyMiUzRSUzQyUyRmklM0U=" shapeheight="62px" shapewidth="40px" nav_arrow_color="rgb(255, 255, 255)" nav_bg_color="rgba(0, 0, 0, 0.3)" nav_bg_hcolor="rgb(0, 0, 0)" prevoffset="3px" nextoffset="3px"][vc_single_image image="5188" img_size="full" alignment="center" css=".vc_custom_1540200544830{margin-bottom: 0px !important;}"][vc_single_image image="5187" img_size="full" alignment="center" css=".vc_custom_1540200551595{margin-bottom: 0px !important;}"][vc_single_image image="5357" img_size="full" alignment="center" css=".vc_custom_1540221977635{margin-bottom: 0px !important;}"][vc_single_image image="5186" img_size="full" alignment="center" css=".vc_custom_1540200534923{margin-bottom: 0px !important;}"][vc_single_image image="5195" img_size="full" alignment="center" css=".vc_custom_1540200899492{margin-bottom: 0px !important;}"][vc_single_image image="5185" img_size="full" alignment="center" css=".vc_custom_1540200557575{margin-bottom: 0px !important;}"][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact Category
	//Contact 1
	$data = array();
	$data['name'] = esc_html__( 'Contact 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/contacts/contact1.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540307511038{margin-top: 60px !important;margin-bottom: 60px !important;}"][vc_column enable_column_shadowbox="yes" css=".vc_custom_1539966394663{padding-top: 45px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.025)%22%7D%5D"][vc_row_inner content_placement="middle"][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-6"][ld_section_title title="Drop us a line" title_top_margin="10" title_bottom_margin="0" subtitle_top_margin="0" subtitle_bottom_margin="10" text_top_margin="0" text_bottom_margin="0" use_custom_fonts_title="true" subtitle="We are here to answer any question you may have" fs="38px"][/vc_column_inner][vc_column_inner align="text-left" offset="vc_col-md-4 vc_hidden-sm vc_hidden-xs" responsive_align="text-md-right"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" alignment="text-right" i_size="xl" i_icon_animated="animated-basic_paperplane" i_color="rgb(216, 219, 226)" h_i_color="rgb(0, 0, 0)" css=".vc_custom_1536751299280{margin-bottom: 0px !important;}"][/ld_icon_box][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-10"][ld_cf7 id="3984" shape="contact-form-inputs-underlined" btn_roundness="contact-form-button-circle" use_custom_fonts_submit="true" submit_fs="13px" submit_fw="700" submit_ls="0.1em" color="rgb(167, 169, 184)" h_color="rgb(24, 27, 49)" submit_bg_color="linear-gradient(90deg, rgb(79, 218, 145) 0%, #34dbc5 100%)" submit_hbg_color="linear-gradient(90deg, #34dbc5 0.6369426751592356%, rgb(52, 219, 197) 100%)" submit_border_color="rgba(255, 255, 255, 0)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 2
	$data = array();
	$data['name'] = esc_html__( 'Contact 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/contacts/contact2.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" columns_placement="stretch" content_placement="middle" css=".vc_custom_1540477221747{background-color: #181b31 !important;}"][vc_column offset="vc_col-lg-4 vc_col-md-6" css=".vc_custom_1536744633956{padding-top: 90px !important;padding-bottom: 140px !important;}"][ld_section_title title="Contact Us" title_top_margin="10" title_bottom_margin="1" subtitle_top_margin="0" subtitle_bottom_margin="10" sub_tag="p" text_top_margin="0" text_bottom_margin="0" use_custom_fonts_title="true" use_custom_fonts_subtitle="true" subtitle="We’re here to answer any questions" fs="42px" fw="700" color="rgb(255, 255, 255)" sub_color="rgba(255, 255, 255, 0.398)"][ld_spacer height="45px"][ld_cf7 id="3967" shape="contact-form-inputs-filled" roundness="contact-form-inputs-circle" btn_width="contact-form-button-block" btn_roundness="contact-form-button-circle" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" submit_fs="14px" submit_fw="700" submit_ls="0.1em" bg_color="rgb(34, 37, 61)" hbg_color="rgb(52, 56, 89)" color="rgba(179, 181, 194, 0.738)" h_color="rgb(255, 255, 255)" submit_bg_color="linear-gradient(90deg, rgb(79, 218, 145) 0%, #34dbc5 100%)" submit_hbg_color="linear-gradient(90deg, #34dbc5 3.5031847133757963%, rgb(52, 219, 197) 100%)" submit_color="rgb(255, 255, 255)" submit_border_color="rgba(255, 255, 255, 0)"][vc_column_text]<span style="font-size: 12px; color: #808291; text-transform: uppercase; letter-spacing: 0.1em;">Call us directly</span><br /><strong><span style="font-size: 24px; color: #ffffff;">(123) 567 8901</span></strong>[/vc_column_text][/vc_column][vc_column offset="vc_col-lg-offset-2 vc_col-lg-6 vc_col-md-6" css=".vc_custom_1536752464947{margin-right: -21vw !important;}"][ld_google_map style="assassinsCreedIV" map_marker="html_marker" si_style="" si_size="" si_shape="" si_scheme="" si_orientation="" zoom="14" map_controls="fullscreenControl" si_visibility="" si_text_transform="" si_css_animation="" address="8 Dapp Ct Elmwood Park, NJ 07407 USA" color_marker="#4fda91" map_height="1000px" si_letter_spacing="" si_font_size="" si_hover_color="" si_bg_color="" si_hbg_color="" si_border_color="" si_identities=""][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 3
	$data = array();
	$data['name'] = esc_html__( 'Contact 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/contacts/contact3.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542907122049{padding-top: 100px !important;padding-bottom: 60px !important;background-color: #e7f0f9 !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3" ca_init_translate_x="-60" ca_duration="1200"][ld_fancy_heading tag="h2"]Request an Appointment[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]Your information will be forwarded to a scheduling specialist who will contact you by the end of the next business day.[/ld_fancy_heading][ld_spacer height="20px"][vc_separator color="custom" align="align_left" el_width="20" accent_color="#ff8e32"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]For urgent matters, please call the scheduling center at:[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" color="rgb(255, 142, 50)" fw="700" fs="16px"](733) 255 - 488[/ld_fancy_heading][ld_spacer][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-8"][ld_spacer height="35px"][ld_cf7 id="2307" shape="contact-form-inputs-filled" size="contact-form-inputs-lg" btn_size="contact-form-button-lg" btn_width="contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="16px" submit_fs="20px" submit_fw="700" bg_color="rgb(255, 255, 255)" color="rgb(158, 167, 197)" h_color="rgb(0, 0, 0)" submit_bg_color="rgb(60, 211, 209)" submit_color="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 4
	$data = array();
	$data['name'] = esc_html__( 'Contact 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/contacts/contact4.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row bg_position="right bottom" css=".vc_custom_1537546898773{padding-bottom: 180px !important;background-image: url(http://gym.liquid-themes.com/wp-content/uploads/2018/06/bg-2-min.jpg?id=30) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_small:0px"][vc_column enable_column_shadowbox="yes" css=".vc_custom_1537547493659{margin-top: -150px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2255px%22%2C%22blur_radius%22%3A%2270px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.075)%22%7D%5D"][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner offset="vc_col-lg-4 vc_col-md-5" css=".vc_custom_1537777311021{background-image: url(http://gym.liquid-themes.com/wp-content/uploads/2018/09/try-min.jpg?id=4068) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_left_small:0px"][vc_single_image image="4068" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-8" css=".vc_custom_1537969561545{padding-top: 40px !important;padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}" responsive_css="padding_right_medium:45px|padding_left_medium:15px"][ld_fancy_heading tag="h3" transform="text-uppercase" margin="right_large:35%25"]Claim your 7 Days Free Full Access Pass for Fitness[/ld_fancy_heading][ld_spacer height="40px"][ld_cf7 id="2672" shape="contact-form-inputs-underlined" size="contact-form-inputs-sm" btn_size="contact-form-button-md" btn_width="contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" submit_fs="16px" submit_fw="600" submit_ls="0.1em" h_color="rgb(24, 26, 35)" submit_bg_color="linear-gradient(90deg, rgb(245, 99, 75) 0%, #fe9418 100%)" submit_hbg_color="linear-gradient(90deg, rgb(254, 148, 24) 0%, rgb(254, 148, 24) 100%)"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="14px" lh="1.428em"]<span style="line-height: 23px;">We respect your privacy and do not tolerate spam and will never sell, rent, lease or give away your information to any third party.</span>[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][vc_row_inner bg_position="right bottom"][vc_column_inner][ld_spacer height="140px"][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_init_translate_x="-54"][ld_fancy_heading tag="h2" transform="text-uppercase" use_inheritance="true"]Welcome to <span style="color: #fa7c31;">Avegym</span>[/ld_fancy_heading][ld_fancy_heading tag="h4" use_custom_fonts_title="true" margin="right_large:15%25|bottom_small:2.5em" lh="1.666em"]Ave Gym Centre is dedicated to enriching young lives in rural communities through fun activities and the sport of gymnastics.[/ld_fancy_heading][vc_separator color="custom" align="align_left" el_width="10" accent_color="#f5634b"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="2em" margin="right_large:15%25"]Our state of the art gyms provide you with a great place to work out in, whether you are there to burn off some calories or are training for something more specific.</p><p>&nbsp;</p><p>Why not visit your nearest Ave Gym Center and take a look? We’re here to help![/ld_fancy_heading][ld_spacer height="50px"][ld_button style="btn-solid" title="Sign up today" transformation="text-uppercase" color="rgb(245, 99, 75)" color2="rgb(254, 148, 24)" hover_color="rgb(254, 148, 24)" hover_color2="rgb(245, 99, 75)" fs="16px" fw="600" ls="0.1em"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 5
	$data = array();
	$data['name'] = esc_html__( 'Contact 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/contacts/contact5.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1538125177509{padding-bottom: 90px !important;}" ca_duration="1200" ca_init_translate_y="44"][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ld_section_title title="Contact Us" alignment="text-center" title_bottom_margin="-10px" add_line="underline-section-title" use_custom_fonts_title="true" title_font_container="tag:h2" title_use_theme_fonts="yes"][ld_spacer][/vc_column][vc_column offset="vc_col-md-8" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1537021088122{margin-bottom: 30px !important;}"][ld_google_map style="unsaturatedBrowns" map_marker="html_marker" si_style="" si_size="" zoom="16" map_controls="fullscreenControl" map_height="532px" address="7420 Shore Rd, Brooklyn, NY 11209, USA"][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1537973408357{padding-top: 40px !important;padding-right: 12% !important;padding-left: 12% !important;background-image: url(http://business.liquid-themes.com/wp-content/uploads/2018/09/contact.jpg?id=3975) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 199, 10)" fs="11px" ls="0.15em"]CONTACT US[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="30px"]Send a message[/ld_fancy_heading][ld_spacer height="20px"][ld_cf7 id="61" shape="contact-form-inputs-underlined" size="contact-form-inputs-sm" btn_size="contact-form-button-md" btn_width="contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="15px" fw="500" submit_fs="13px" submit_fw="700" submit_ls="0.185em" submit_color="rgb(22, 27, 48)" h_color="rgb(255, 255, 255)" hover_border_color="rgb(255, 255, 255)" border_color="rgba(255, 255, 255, 0.147)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 6
	$data = array();
	$data['name'] = esc_html__( 'Contact 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/contacts/contact6.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1540307555447{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #181b2f !important;}" ca_duration="1200" ca_init_translate_y="44"][vc_column width="1/3" align="text-center" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1539965357165{margin-bottom: 30px !important;}"][/vc_column][vc_column width="1/3"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 199, 10)" fs="11px" ls="0.15em"]CONTACT US[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="30px"]Send a message[/ld_fancy_heading][ld_cf7 id="3967" shape="contact-form-inputs-underlined" size="contact-form-inputs-sm" btn_size="contact-form-button-md" btn_width="contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="15px" fw="500" submit_fs="13px" submit_fw="700" submit_ls="0.185em" submit_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" hover_border_color="rgb(255, 255, 255)" border_color="rgba(255, 255, 255, 0.147)"][ld_spacer height="20px"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 7
	$data = array();
	$data['name'] = esc_html__( 'Contact 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/contacts/contact7.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1546254183777{padding-top: 130px !important;padding-bottom: 130px !important;}" ca_duration="1200" ca_init_translate_y="44"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px|padding_left_medium:7%25" css=".vc_custom_1545125147802{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" color="rgb(26, 28, 38)" fw="300"]Contact us[/ld_fancy_heading][vc_separator color="custom" accent_color="#f7f9fb"][vc_row_inner][vc_column_inner width="1/2"][vc_column_text css=".vc_custom_1545129300745{margin-bottom: 40px !important;}"]<span style="font-size: 16px; color: #4666e3;">Address</span></p>
<p><span style="font-size: 15px; color: #666666;">290 Maryam Springs 260,</span><br />
<span style="font-size: 15px; color: #666666;">Courbevoie, Paris, France</span>[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text css=".vc_custom_1545649068363{margin-bottom: 40px !important;}"]<span style="font-size: 16px; color: #4666e3;">Call Us</span></p>
<p><span style="font-size: 15px; color: #666666;">+47 213 5941 295</span><br />
<span style="font-size: 15px; color: #666666;">hello@ave.com</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][ld_google_map style="unsaturatedBrowns" map_marker="html_marker" si_style="" si_size="" zoom="16" map_height="280px" address="7420 Shore Rd, Brooklyn, NY 11209, USA"][/vc_column][vc_column align="text-center" offset="vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1545128189389{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 12% !important;padding-left: 12% !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-left-color: #e7e7e7 !important;border-left-style: solid !important;border-right-color: #e7e7e7 !important;border-right-style: solid !important;border-top-color: #e7e7e7 !important;border-top-style: solid !important;border-bottom-color: #e7e7e7 !important;border-bottom-style: solid !important;}"][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" color="rgb(26, 28, 38)" margin="bottom_small:10px" fw="300"]Send a message[/ld_fancy_heading][ld_spacer height="10px"][vc_column_text]<span style="color: #73747f; font-size: 15px; line-height: 26px;">Feel free to reach us if you need any assistance.</span>[/vc_column_text][ld_spacer height="35px"][ld_cf7 id="5" shape="contact-form-inputs-filled" size="contact-form-inputs-sm" roundness="contact-form-inputs-round" btn_size="contact-form-button-sm" btn_width="contact-form-button-block" btn_roundness="contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" submit_fs="15px" submit_color="rgb(255, 255, 255)" h_color="rgb(94, 96, 98)" bg_color="rgb(247, 249, 251)" hbg_color="rgb(238, 243, 248)" color="rgb(111, 114, 116)" fw="400" submit_hbg_color="rgb(58, 58, 58)" submit_hover_border_color="rgb(58, 58, 58)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 8
	$data = array();
	$data['name'] = esc_html__( 'Contact 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/contacts/contact8.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1545200136753{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 6px !important;border-bottom-color: #efefef !important;border-bottom-style: solid !important;}"][vc_column][ld_cf7 id="5" roundness="contact-form-inputs-round" btn_width="contact-form-button-block" btn_roundness="contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" submit_fs="14px" bg_color="rgb(243, 245, 246)" hbg_color="rgb(252, 252, 252)" color="rgb(111, 114, 116)" h_color="rgb(0, 0, 0)" submit_hbg_color="rgb(58, 58, 58)" submit_hover_border_color="rgb(58, 58, 58)" css=".vc_custom_1546613512493{background-color: #ffffff !important;}" border_color="rgb(247, 249, 251)" hover_border_color="rgb(247, 249, 251)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters Category
	//Counter 1
	$data = array();
	$data['name'] = esc_html__( 'Counter 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/counter/counter1.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1537973108352{background-color: #0a0b4e !important;}"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" parallax_trigger="onCenter" enable_column_shadowbox="yes" enable_transform="" css=".vc_custom_1537973176572{margin-top: -12% !important;padding-top: 70px !important;padding-bottom: 90px !important;background-image: url(http://freelancer.liquid-themes.com/wp-content/uploads/2018/09/column-bg-min.jpg?id=4021) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 4px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2250px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" translate_from_y="0" rotate_from_y="0" translate_to_y="-122" rotate_from_x="0" translate_to_x="0" rotate_to_x="-35" translate_to_z="0"][vc_row_inner content_placement="middle" el_id="about"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-4 vc_col-md-offset-1 vc_col-md-5" ca_init_translate_y="18" ca_init_rotate_z="-1" ca_start_delay="1000" ca_delay="30" ca_duration="1200" ca_init_translate_z="-125" ca_init_rotate_x="-68" css=".vc_custom_1536239916828{padding-left: 15px !important;}"][ld_fancy_heading tag="h3"]About me[/ld_fancy_heading][ld_fancy_heading tag="p" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="20px" lh="1.35em" color="rgb(255, 255, 255)"]My name is Eugenia, I’m a freelance Branding &amp; Digital Designer based by the valley in New York. I also have major skills in motion graphics.[/ld_fancy_heading][vc_empty_space height="50px"][ld_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-medium%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-pinterest%22%2C%22url%22%3A%22%23%22%7D%5D" hover_color="#ffd200"][/vc_column_inner][vc_column_inner offset="vc_col-lg-offset-3 vc_col-lg-3 vc_col-md-offset-2 vc_col-md-4" css=".vc_custom_1536238166940{padding-left: 15px !important;}"][ld_counter style="huge" size="xl" bottom_margin="0" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" enable_blur="true" label="More than" bottom_label="Years of experience" count="7" counter_color="rgb(255, 210, 0)" text_color="rgb(255, 255, 255)" start_delay="600" ls="0.05em"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counter 2
	$data = array();
	$data['name'] = esc_html__( 'Counter 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/counter/counter2.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540478540805{padding-top: 20px !important;padding-bottom: 20px !important;}"][vc_column width="1/2" align="text-center" offset="vc_col-md-3"][ld_counter style="bordered" size="lg" bottom_margin="0" enable_gradient="yes" enable_hover_gradient="" enable_blur="true" bottom_label="Successful Projects" count="150" start_color="rgb(255, 186, 131)" end_color="rgb(255, 165, 205)"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3"][ld_counter style="bordered" size="lg" bottom_margin="0" enable_gradient="yes" enable_hover_gradient="" enable_blur="true" bottom_label="Happy clients" count="349" start_color="rgb(255, 186, 131)" end_color="rgb(255, 165, 205)" start_delay="250"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3"][ld_counter style="bordered" size="lg" bottom_margin="0" enable_gradient="yes" enable_hover_gradient="" enable_blur="true" bottom_label="positive feedback" count="218" start_color="rgb(255, 186, 131)" end_color="rgb(255, 165, 205)" start_delay="500"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3"][ld_counter style="bordered" size="lg" bottom_margin="0" enable_gradient="yes" enable_hover_gradient="" enable_blur="true" bottom_label="cups of coffee" count="650" start_color="rgb(255, 186, 131)" end_color="rgb(255, 165, 205)" start_delay="750"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counter 3
	$data = array();
	$data['name'] = esc_html__( 'Counter 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/counter/counter3.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540583460260{padding-top: 100px !important;padding-bottom: 50px !important;}"][vc_column width="1/3" align="text-center"][ld_counter size="xl" bottom_margin="0" use_theme_fonts="" text_font="font_family:Ubuntu%3A300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic|font_style:300%20light%20regular%3A300%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" enable_blur="true" bottom_label="Transactions" count="7m" fs="90px" text_color="rgb(119, 121, 129)" counter_color="rgb(13, 156, 252)" text_fs="24px" text_fw="300" ls="0.05em" text_lh="2em"][/vc_column][vc_column width="1/3" align="text-center"][ld_counter size="xl" bottom_margin="0" use_theme_fonts="" text_font="font_family:Ubuntu%3A300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic|font_style:300%20light%20regular%3A300%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" enable_blur="true" bottom_label="Wallets" count="3m+" fs="90px" text_color="rgb(119, 121, 129)" counter_color="rgb(13, 156, 252)" text_fs="24px" text_fw="300" ls="0.05em" text_lh="2em" start_delay="300"][/vc_column][vc_column width="1/3" align="text-center"][ld_counter size="xl" bottom_margin="0" use_theme_fonts="" text_font="font_family:Ubuntu%3A300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic|font_style:300%20light%20regular%3A300%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" enable_blur="true" bottom_label="Countries" count="24" fs="90px" text_color="rgb(119, 121, 129)" counter_color="rgb(13, 156, 252)" text_fs="24px" text_fw="300" ls="0.05em" text_lh="2em" start_delay="600"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counter 4
	$data = array();
	$data['name'] = esc_html__( 'Counter 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/counter/counter4.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row bg_position="right top" css=".vc_custom_1539674876269{padding-top: 50px !important;padding-bottom: 50px !important;background-image: url(http://architecture.liquid-themes.com/wp-content/uploads/2018/10/img-3-min.jpg?id=4323) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_bottom_medium:110px"][vc_column width="1/3"][ld_fancy_heading tag="h2" transform="text-uppercase" split_type="words" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22different%22%7D%2C%7B%22word%22%3A%22unique%22%7D%5D" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" margin="top_small:0px" duration="1800" delay="180" ca_init_translate_y="45" word_colors="rgb(245, 99, 75)"]be[/ld_fancy_heading][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1600" ca_delay="160" ca_init_translate_y="45"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" margin="bottom_small:1.75em"]Ave began as a collaborative architectural and landscape workshop, and has remained true to its trans-disciplinary way of thinking since its inception.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true"]Our work strives to enhance our sense of place, identity and relationship to others and the physical spaces we inhabit, whether feral or human-made. Museums, markets, reindeer observatories, landscapes and dollhouses get the same care and attention to purpose.[/ld_fancy_heading][ld_spacer height="45px"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_counter align="left" bottom_margin="0" use_theme_fonts="" text_font="font_family:Teko%3A300%2Cregular|font_style:400%20regular%3A400%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" bottom_label="SQUARE FREE BUILT" count="3.5M" fs="48px" lh="1em" text_fs="12px" text_lh="1em" text_ls="0.1em" text_color="rgb(119, 121, 129)" counter_color="rgb(245, 99, 75)"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_counter align="left" bottom_margin="0" use_theme_fonts="" text_font="font_family:Teko%3A300%2Cregular|font_style:400%20regular%3A400%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" bottom_label="AWARDS RECEIVED" count="98" fs="48px" lh="1em" text_fs="12px" text_lh="1em" text_ls="0.1em" text_color="rgb(119, 121, 129)" counter_color="rgb(245, 99, 75)"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_counter align="left" bottom_margin="0" use_theme_fonts="" text_font="font_family:Teko%3A300%2Cregular|font_style:400%20regular%3A400%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" bottom_label="HAPPY CLIENTS" count="104" fs="48px" lh="1em" text_fs="12px" text_lh="1em" text_ls="0.1em" text_color="rgb(119, 121, 129)" counter_color="rgb(245, 99, 75)"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_counter align="left" bottom_margin="0" use_theme_fonts="" text_font="font_family:Teko%3A300%2Cregular|font_style:400%20regular%3A400%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" bottom_label="CUPS OF COFFEE" count="267" fs="48px" lh="1em" text_fs="12px" text_lh="1em" text_ls="0.1em" text_color="rgb(119, 121, 129)" counter_color="rgb(245, 99, 75)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counter 5
	$data = array();
	$data['name'] = esc_html__( 'Counter 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/counter/counter5.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" enable_overlay="yes" css=".vc_custom_1540311646539{margin-top: 50px !important;margin-bottom: 50px !important;padding-top: 115px !important;padding-bottom: 85px !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="linear-gradient(137deg, #242428 0%, #2D3544 100%)"][vc_column width="1/3" align="text-center"][ld_icon_box i_type="linea" i_size="xl" i_icon_linea="icon-ion-ios-happy" icon_mb="1" css=".vc_custom_1538126516047{margin-bottom: 25px !important;}" i_color="rgb(255, 255, 255)"][/ld_icon_box][ld_counter bottom_margin="15" use_theme_fonts="" text_font="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" enable_blur="true" count="700+" fs="55px" text_color="rgba(255, 255, 255, 0.599)" counter_color="rgb(255, 255, 255)" bottom_label="PEOPLE AND GROUPS" ls="1.5px"][/vc_column][vc_column width="1/3" align="text-center"][ld_icon_box i_type="linea" i_size="xl" i_icon_linea="icon-ion-ios-pin" icon_mb="1" css=".vc_custom_1538126523813{margin-bottom: 25px !important;}" i_color="rgb(255, 255, 255)"][/ld_icon_box][ld_counter bottom_margin="15" use_theme_fonts="" text_font="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" enable_blur="true" count="125+" fs="55px" text_color="rgba(255, 255, 255, 0.599)" counter_color="rgb(255, 255, 255)" bottom_label="STORES" ls="1.5px" start_delay="150"][/vc_column][vc_column width="1/3" align="text-center"][ld_icon_box i_type="linea" i_size="xl" i_icon_linea="icon-ion-ios-card" icon_mb="1" css=".vc_custom_1538126530642{margin-bottom: 25px !important;}" i_color="rgb(255, 255, 255)"][/ld_icon_box][ld_counter bottom_margin="15" use_theme_fonts="" text_font="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" enable_blur="true" count="682+" fs="55px" text_color="rgba(255, 255, 255, 0.599)" counter_color="rgb(255, 255, 255)" bottom_label="TRANSACTIONS" ls="1.5px" start_delay="300"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counter 6
	$data = array();
	$data['name'] = esc_html__( 'Counter 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/counter/counter6.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1539082071439{padding-top: 100px !important;padding-bottom: 50px !important;}"][vc_column align="text-center" offset="vc_col-md-4"][ld_counter size="xl" bottom_margin="0" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" enable_blur="true" bottom_label="Cups of Coffee" count="560" fs="90px" text_color="rgb(119, 121, 129)" text_fs="24px" text_fw="300" ls="0.05em" text_lh="2em" counter_color="rgb(216, 65, 148)"][/vc_column][vc_column align="text-center" offset="vc_col-md-4"][ld_counter size="xl" bottom_margin="0" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" enable_blur="true" bottom_label="Users" count="30k+" fs="90px" text_color="rgb(119, 121, 129)" counter_color="rgb(216, 65, 148)" text_fs="24px" text_fw="300" ls="0.05em" text_lh="2em"][/vc_column][vc_column align="text-center" offset="vc_col-md-4"][ld_counter size="xl" bottom_margin="0" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" use_custom_fonts_text="true" enable_blur="true" bottom_label="Countries" count="24" fs="90px" text_color="rgb(119, 121, 129)" counter_color="rgb(216, 65, 148)" text_fs="24px" text_fw="300" ls="0.05em" text_lh="2em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counter 7
	$data = array();
	$data['name'] = esc_html__( 'Counter 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/counter/counter7.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1536672541963{margin-top: -90px !important;padding-bottom: 60px !important;}" ca_duration="1200" ca_init_translate_y="50" ca_init_rotate_x="-85" ca_init_translate_z="-151"][vc_column enable_column_shadowbox="yes" css=".vc_custom_1531999849007{padding-top: 60px !important;padding-bottom: 50px !important;background-image: url(http://cryptocurrency.liquid-themes.com/wp-content/uploads/2018/07/bg-5-min.jpg?id=49) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2240px%22%2C%22blur_radius%22%3A%2290px%22%2C%22shadow_color%22%3A%22rgba(131%2C%200%2C%20255%2C%200.204)%22%7D%5D"][vc_row_inner content_placement="middle"][vc_column_inner width="5/6" align="text-center" offset="vc_col-md-5 vc_col-sm-offset-1" responsive_align="text-md-left"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="21px" lh="1.666em" ls="-0.025em"]Blocks in shorter chains (or invalid chains) are not used for anything. The bitcoin client switches to another, longer chain.[/ld_fancy_heading][/vc_column_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-2 vc_col-md-4"][ld_counter enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" enable_blur="true" count="£34m" fs="70px" lh="1.25em" fw="600" counter_color="rgb(255, 255, 255)" start_delay="500"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.695)" fs="18px" lh="1.5em" fw="600" ls="0.3em"]1 ETH = $0.280[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counter 8
	$data = array();
	$data['name'] = esc_html__( 'Counter 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/counter/counter8.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1546879604451{padding-top: 120px !important;padding-bottom: 90px !important;background-color: #f7f9fb !important;}"][vc_column offset="vc_col-md-5"][ld_images_group_container][ld_images_group_element enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="6834"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-md-offset-1 vc_col-md-6" translate_from_y="92" translate_to_y="-111"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="45px" lh="1.244em" margin="bottom_small:0.7em"]Huge collection of pre-built<br />
section templates.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="17px" lh="1.58em" margin="bottom_small:2.5em"]Being the savage's business, that is, the person see pulled<br />
You have seen Italian organ boys holding a dancing. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod.[/ld_fancy_heading][ld_spacer height="25px"][vc_row_inner][vc_column_inner width="1/3"][ld_counter bottom_margin="0" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" count="1k" fs="67px" text_color="rgba(0, 0, 0, 0.55)" bottom_label="Downloads" counter_color="rgb(0, 0, 0)" fw="300"][/vc_column_inner][vc_column_inner width="1/3"][ld_counter style="`{`object Object`}`" bottom_margin="0" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" count="2m" fs="67px" text_color="rgba(0, 0, 0, 0.55)" bottom_label="Downloads" counter_color="rgb(0, 0, 0)" fw="300"][/vc_column_inner][vc_column_inner width="1/3"][ld_counter style="`{`object Object`}`" bottom_margin="0" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" count="4k" fs="67px" text_color="rgba(0, 0, 0, 0.55)" bottom_label="Downloads" counter_color="rgb(0, 0, 0)" fw="300"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box Category
	//Fancy Box 1
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox1.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1537540875717{padding-top: 70px !important;padding-bottom: 75px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" ca_init_translate_y="31" ca_init_translate_x="0" ca_duration="1200" ca_delay="150" ca_init_translate_z="-108" ca_init_rotate_x="-76"][vc_single_image image="29" img_size="80x32" css=".vc_custom_1537954661070{margin-bottom: 10px !important;}"][vc_empty_space height="45px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="We know that good design means good business." fs="30px" el_class="font-style-italic" color="rgb(24, 27, 49)" margin="right_large:25%25|top_small:0px|bottom_small:0px" start_delay="360" lh="1.025em"]We know that good design means good business.[/ld_fancy_heading][vc_empty_space height="40px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic." fs="18px" lh="1.5em" margin="right_large:25%25" start_delay="500"]We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic.[/ld_fancy_heading][vc_empty_space height="50px"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_images_group_container][ld_images_group_element img_size="470x600" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" enable_reveal="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="3336" translate_from_y="78" translate_to_y="-78"][/ld_images_group_element][ld_images_group_element img_size="370x450" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="5346" position="bottom_large:-13%25|left_large:-45%25|bottom_small:-10%25|left_small:30%25" translate_from_y="107" translate_to_y="-134"][ld_button style="btn-naked"  i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-lg" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_fontawesome="fa fa-play" hover_color="rgb(255, 101, 101)" i_size="25px"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Fancy Box 2
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox2.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1539264455735{padding-top: 75px !important;padding-bottom: 75px !important;}" el_id="about"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_init_translate_y="42"][ld_fancy_heading tag="h5" use_theme_fonts="" text_font="font_family:Crimson%20Text%3Aregular%2Citalic%2C600%2C600italic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="About Ave" init_values="translateY:100,opacity:0" color="rgb(187, 160, 122)" fs="20px" margin="top_small:0px|bottom_small:0px"]<em>About Ave</em>[/ld_fancy_heading][vc_empty_space height="10px"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_fit="true" enable_split="true" title="Extraordinary Luxury" init_values="translateY:100,opacity:0" margin="top_small:0px|bottom_small:0px" minfontsize="45" compressor="0.5"]EXTRAORDINARY LUXURY[/ld_fancy_heading][vc_empty_space height="48px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="Each boutique hotel in the Ave Hotel collection tells a unique story, inviting guests to immerse themselves in tales of adventure, romance, history, culture, nature and more for the length of a memorable stay. Discover the high points of our story here." init_values="translateY:80,opacity:0" start_delay="180" margin="right_large:8%25"]Each boutique hotel in the Ave Hotel collection tells a unique story, inviting guests to immerse themselves in tales of adventure, romance, history, culture, nature and more for the length of a memorable stay. Discover the high points of our story here.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-5"][ld_fancy_heading tag="p" alignment="text-right" use_theme_fonts="" text_font="font_family:Scheherazade%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_title="true" title="Since" color="rgb(187, 160, 122)" fs="30px" margin="bottom_small:-1.75em"]Since[/ld_fancy_heading][ld_counter style="`{`object Object`}`" use_theme_fonts="" text_font="font_family:Scheherazade%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal" enable_gradient="" enable_hover_gradient="" use_custom_fonts_title="true" enable_blur="true" count="1987" fs="200px" fw="400" counter_color="rgb(187, 160, 122)" el_class="pull-right"][ld_images_group_container][ld_images_group_element enable_effects="yes" parallax="yes" enable_reveal="yes" reveal_direction="tb" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="150" reveal_color="rgb(41, 45, 53)" margin="left_large:-30px" translate_from_y="-42" translate_to_y="33" position="top_large:-120px"][/ld_images_group_element][/ld_images_group_container][ld_images_group_container][ld_images_group_element enable_effects="yes" parallax="yes" enable_reveal="yes" reveal_direction="rl" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="151" position="left_large:-80%25" translate_from_y="46" translate_to_y="-81" margin="top_large:-70%25|left_large:-68%25" reveal_color="rgb(41, 45, 53)"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column][vc_empty_space height="60px"][/vc_column][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-sm-offset-1" ca_init_translate_y="40" ca_init_rotate_x="-35"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="25px" lh="1.3em" color="rgb(0, 0, 0)"]Ave Hotel is taking contemporary sophistication to new heights. This elegant hotel reflects the capital city’s compelling culture, history, and geography.[/ld_fancy_heading][vc_empty_space height="10px"][ld_button style="btn-underlined" title="Find out more" transformation="text-uppercase" color="rgb(63, 65, 71)" fs="12px" ls="0.1em" hover_color="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 3
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox3.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1529662719090{margin-top: 45px !important;margin-bottom: 45px !important;padding-top: 85px !important;padding-bottom: 90px !important;background-color: #f7f7f7 !important;}"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" transform="text-uppercase" margin="bottom_large:0"]Ultimate Experiences[/ld_fancy_heading][ld_fancy_heading tag="p"]Check these awesome adventures off your bucket list![/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6" responsive_align="text-md-right text-xs-left"][ld_button style="btn-naked" title="See all Tours" transformation="text-uppercase" hover_color="rgb(12, 62, 114)" fs="14px" fw="700" ls="0.1em"][/vc_column][vc_column][ld_spacer height="40px"][ld_carousel columns="md:4|sm:2|xs:1|spacing_xs:7px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" navarrow="1" navfill="carousel-nav-solid" navshape="carousel-nav-rectangle" navshadow="carousel-nav-shadowed" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" paddings="7px" navoffset="top:25%" prevoffset="-13px" nextoffset="-13px" nav_arrow_color="rgb(24, 27, 49)" nav_arrow_color_hover="rgb(255, 255, 255)" nav_bg_color="rgb(255, 255, 255)" nav_bg_hcolor="rgb(36, 147, 224)"][ld_content_box style="s04" heading_weight="font-weight-semibold" heading_size="content-box-heading-sm" rating="5" title="Embrace The Wonders Of Japan 2017 Tour" image="4061" info="From <strong>$2849</strong>" rating_text="15 Reviews"]Japan endless discovery[/ld_content_box][ld_content_box style="s04" heading_weight="font-weight-semibold" heading_size="content-box-heading-sm" rating="5" title="Costa Rica Pacific Beach All Inclusive Fly &amp; Drive" image="4062" info="From <strong>$1729</strong>" rating_text="15 Reviews"]Evolved greatly from its origins[/ld_content_box][ld_content_box style="s04" heading_weight="font-weight-semibold" heading_size="content-box-heading-sm" rating="5" title="Country Roads of Puglia &amp; the Neapolitan Riviera" image="4063" info="From <strong>$1419</strong>" rating_text="15 Reviews"]Fall head over heels for Puglia[/ld_content_box][ld_content_box style="s04" heading_weight="font-weight-semibold" heading_size="content-box-heading-sm" rating="5" title="Britain &amp; Ireland Delight Winter Season" image="4064" info="From <strong>$4199</strong>" rating_text="15 Reviews"]Explore the cultural diversity[/ld_content_box][ld_content_box style="s04" heading_weight="font-weight-semibold" heading_size="content-box-heading-sm" rating="5" title="Embrace The Wonders Of Japan 2017 Tour" image="4061" info="From <strong>$2849</strong>" rating_text="15 Reviews"]Japan endless discovery[/ld_content_box][ld_content_box style="s04" heading_weight="font-weight-semibold" heading_size="content-box-heading-sm" rating="5" title="Costa Rica Pacific Beach All Inclusive Fly &amp; Drive" image="4062" info="From <strong>$1729</strong>" rating_text="15 Reviews"]Evolved greatly from its origins[/ld_content_box][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 4
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox15.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1543609564362{padding-top: 70px !important;padding-bottom: 60px !important;}" responsive_css="padding_top_medium:140px|padding_bottom_medium:90px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_init_rotate_z="1"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="12px" ls="0.2em" margin="bottom_small:20px"]Fancy Images[/ld_fancy_heading][ld_fancy_heading tag="h2" enable_fit="true" minfontsize="38" compressor="0.75" margin="bottom_large:10px" padding="bottom_large:20px"]Build and customize stunning pages in minutes -visually.[/ld_fancy_heading][vc_column_text css=".vc_custom_1543609645226{padding-right: 5% !important;padding-bottom: 30px !important;}"]<span style="font-size: 17px; line-height: 29px; color: #5b6674;">Import a pre-designed template and change the content. It’s that easy!</span>[/vc_column_text][ld_button style="btn-solid" title="Fancy Button" transformation="text-uppercase" link_type="scroll_to_section" shape="semi-round" size="btn-lg" i_type="fontawesome" i_add_icon="true" i_icon_fontawesome="fa fa-angle-right" fs="12px" fw="600" ls="0.2em" css=".vc_custom_1543483703815{padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="rgb(68, 50, 39)"][/vc_column][vc_column offset="vc_col-md-7 vc_hidden-sm vc_hidden-xs"][ld_images_group_container][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="42" position="left_large:15px" translate_from_y="-17" translate_to_y="55"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="41" shadow_delay="250" position="top_large:55px|right_large:0px" translate_from_y="18" translate_to_y="-71"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Fancy Box 5
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox4.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1542223211331{margin-bottom: 45px !important;padding-top: 75px !important;padding-bottom: 75px !important;}" ca_duration="600" ca_init_translate_y="40"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1529661415778{padding-right: 5% !important;padding-left: 5% !important;}"][ld_fancy_heading tag="h2" transform="text-uppercase"]Top Destinations[/ld_fancy_heading][ld_spacer height="5px"][ld_fancy_heading tag="p"]For over 40 years, we’ve been helping travelers plan and enjoy effortless, fun vacations and authentic experiences around the world.[/ld_fancy_heading][ld_spacer height="50px"][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-8 vc_col-sm-offset-1"][ld_content_box style="s03" cb_size="content-box-big" show_button="yes" ib_style="btn-naked" ib_title="Learn More" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Britain &amp; Iceland" image="4053" info="15 tours" ib_link="url:%23|||" ib_fs="14px" ib_fw="700" ib_ls="0.1em" ib_text_color="#ff7a4b" ib_i_icon_fontawesome="fa fa-long-arrow-right" alt_color="rgb(36, 147, 224)" img_link="url:%23|||"]Explore South America holidays and discover the best time and places to visit.[/ld_content_box][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_content_box style="s03" cb_size="fancy-box-tall" show_button="yes" ib_style="btn-naked" ib_title="Learn More" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Asia" image="4054" info="07 tours" ib_link="url:%23|||" ib_fs="14px" ib_fw="700" ib_ls="0.1em" ib_text_color="#ff7a4b" ib_i_icon_fontawesome="fa fa-long-arrow-right" alt_color="rgb(36, 147, 224)" img_link="url:%23|||"]Explore South America holidays and discover the best time and places to visit.[/ld_content_box][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_content_box style="s03" show_button="yes" ib_style="btn-naked" ib_title="Learn More" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Italy &amp; Sicily" image="4055" info="12 tours" ib_link="url:%23|||" ib_fs="14px" ib_fw="700" ib_ls="0.1em" ib_text_color="#ff7a4b" ib_i_icon_fontawesome="fa fa-long-arrow-right" alt_color="rgb(36, 147, 224)" img_link="url:%23|||"]<span style="font-size: 14px;">Explore South America holidays and discover the best time and places to visit.</span>[/ld_content_box][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_content_box style="s03" show_button="yes" ib_style="btn-naked" ib_title="Learn More" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="South America" image="4056" info="10 tours" ib_link="url:%23|||" ib_fs="14px" ib_fw="700" ib_ls="0.1em" ib_text_color="#ff7a4b" ib_i_icon_fontawesome="fa fa-long-arrow-right" alt_color="rgb(36, 147, 224)" img_link="url:%23|||"]<span style="font-size: 14px;">Explore South America holidays and discover the best time and places to visit.</span>[/ld_content_box][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_content_box style="s03" show_button="yes" ib_style="btn-naked" ib_title="Learn More" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Spain &amp; Portugal" image="4057" info="05 tours" ib_link="url:%23|||" ib_fs="14px" ib_fw="700" ib_ls="0.1em" ib_text_color="#ff7a4b" ib_i_icon_fontawesome="fa fa-long-arrow-right" alt_color="rgb(36, 147, 224)" img_link="url:%23|||"]<span style="font-size: 14px;">Explore South America holidays and discover the best time and places to visit.</span>[/ld_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 6
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox5.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1529390145878{padding-top: 90px !important;padding-bottom: 50px !important;background-color: #f0f2f4 !important;}"][vc_column offset="vc_col-md-8"][ld_fancy_heading tag="h2" transform="text-uppercase" margin="bottom_small:0px"]Unlimited Classes[/ld_fancy_heading][ld_fancy_heading tag="p"]We offer more than 35 group exercis, aerobic classes each week.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-4" el_id="class-nav-container" responsive_align="text-md-right text-xs-center"][/vc_column][vc_column][ld_spacer height="35px"][ld_carousel columns="lg:4|md:3|xs:2|spacing_xs:15px" inactiv_opacity="1" enable_item_animation="yes" cellalign="left" prevnextbuttons="yes" navappend="custom_id" groupcells="no" wraparound="yes" navarrow="custom" navsize="carousel-nav-sm" navfill="carousel-nav-bordered" navshape="carousel-nav-square" navhalign="carousel-nav-right" pf_init_scale_x="0.5" pf_init_scale_y="0.5" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" navappend_id="#class-nav-container" nav_arrow_color="rgb(24, 26, 35)" nav_border_color="rgb(213, 214, 222)" nav_bg_hcolor="rgba(0, 0, 0, 0)" nav_arrow_color_hover="rgb(248, 118, 56)" nav_border_hcolor="rgb(248, 118, 56)" prev="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1sZWZ0JTVDJTIyJTNFJTNDJTJGaSUzRQ==" next="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1yaWdodCU1QyUyMiUzRSUzQyUyRmklM0U=" pf_duration="1200" pf_delay="150"][ld_content_box style="s02" heading_size="content-box-heading-sm" add_icon="yes" i_type="fontawesome" title="BootCamp Circuits" image="4057" info="Adrian Holmes" i_icon_fontawesome="fa fa-user-o"][/ld_content_box][ld_content_box style="s02" heading_size="content-box-heading-sm" add_icon="yes" i_type="fontawesome" title="Krunch and Kore" image="4058" info="Katharine Barnes" i_icon_fontawesome="fa fa-user-o"][/ld_content_box][ld_content_box style="s02" heading_size="content-box-heading-sm" add_icon="yes" i_type="fontawesome" title="Total Body" image="4059" info="David Richards" i_icon_fontawesome="fa fa-user-o" label="Premium"][/ld_content_box][ld_content_box style="s02" heading_size="content-box-heading-sm" add_icon="yes" i_type="fontawesome" title="Energy Blast" image="4060" info="Marion Miller" i_icon_fontawesome="fa fa-user-o"][/ld_content_box][ld_content_box style="s02" heading_size="content-box-heading-sm" add_icon="yes" i_type="fontawesome" title="Krunch and Kore" image="4058" info="Katharine Barnes" i_icon_fontawesome="fa fa-user-o"][/ld_content_box][ld_content_box style="s02" heading_size="content-box-heading-sm" add_icon="yes" i_type="fontawesome" title="Total Body" image="4059" info="David Richards" i_icon_fontawesome="fa fa-user-o"][/ld_content_box][ld_content_box style="s02" heading_size="content-box-heading-sm" add_icon="yes" i_type="fontawesome" title="Energy Blast" image="4060" info="Marion Miller" i_icon_fontawesome="fa fa-user-o"][/ld_content_box][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 7
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox6.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1538080460664{padding-top: 80px !important;padding-bottom: 40px !important;}"][vc_column][ld_content_box_table enable_header="yes"][ld_content_box_cell][vc_column_text]</p><h3>Top Offers</h3>
<p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]Duration[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]Departure[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]Price[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]Save Now[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]availability[/vc_column_text][/ld_content_box_cell][/ld_content_box_table][ld_content_box_table][ld_content_box_cell][vc_column_text]<img class="wp-image-4082 size-full alignleft" src="http://travel.liquid-themes.com/wp-content/uploads/2018/09/lin-mei.jpg" alt="Image" width="120" height="80" /></p><p><span style="color: #0c3e72; margin-top: 15px;"><strong>Essential Japan</strong></span></p><p><small>Endless discovery</small>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5>07 days <small>06 nights</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5>20 Nov, 2018<small>05:00pm</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5><span style="color: #ff7a4b;">$1399</span><small>Was $1699</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5><span style="color: #2493e0;">$300</span><small>Save 15%</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][ld_button style="btn-default" title="Check" transformation="text-uppercase" css=".vc_custom_1530025225869{padding-right: 0.5em !important;padding-left: 0.5em !important;}" lh="1em" fw="700"][/ld_content_box_cell][/ld_content_box_table][ld_content_box_table][ld_content_box_cell][vc_column_text]<img class="alignleft wp-image-4084 size-full" src="http://travel.liquid-themes.com/wp-content/uploads/2018/09/willian-west.jpg" alt="Image" width="120" height="80" /></p><p><span style="color: #0c3e72; margin-top: 15px;"><strong>Flavors of Italy</strong></span></p><p><small>Food breathing</small>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5>05 days <small>04 nights</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5>20 Nov, 2018<small>05:00pm</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5><span style="color: #ff7a4b;">$1099</span><small>Was $1299</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5><span style="color: #2493e0;">$200</span><small>Save 15%</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][ld_button style="btn-default" title="Check" transformation="text-uppercase" css=".vc_custom_1530025225869{padding-right: 0.5em !important;padding-left: 0.5em !important;}" lh="1em" fw="700"][/ld_content_box_cell][/ld_content_box_table][ld_content_box_table][ld_content_box_cell][vc_column_text]<img class="wp-image-4083 size-full alignleft" src="http://travel.liquid-themes.com/wp-content/uploads/2018/09/lina-loos.jpg" alt="Image" width="120" height="80" /></p><p><span style="color: #0c3e72; margin-top: 15px;"><strong>Sri Lanka is Style</strong></span></p><p><small>Wild meets modern</small>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5>08 days <small>07 nights</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5>20 Nov, 2018<small>05:00pm</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5><span style="color: #ff7a4b;">$1599</span><small>Was $2199</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][vc_column_text]</p><h5><span style="color: #2493e0;">$600</span><small>Save 45%</small></h5><p>[/vc_column_text][/ld_content_box_cell][ld_content_box_cell][ld_button style="btn-default" title="Check" transformation="text-uppercase" css=".vc_custom_1530025225869{padding-right: 0.5em !important;padding-left: 0.5em !important;}" lh="1em" fw="700"][/ld_content_box_cell][/ld_content_box_table][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 8
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox7.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1537542061291{padding-top: 45px !important;padding-bottom: 45px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_x="-45" ca_init_translate_z="-31" ca_init_rotate_y="10"][vc_column width="1/2" bg_position="right center" offset="vc_col-lg-4 vc_col-md-6" css=".vc_custom_1541693388160{margin-bottom: 30px !important;padding-right: 15px !important;padding-left: 15px !important;background-image: url(http://construction.liquid-themes.com/wp-content/uploads/2018/09/career-bg-min.jpg?id=4073) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_empty_space height="48px"][vc_row_inner css=".vc_custom_1527752022094{padding-left: 15px !important;}"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-7" ca_init_translate_y="22" ca_init_rotate_x="-71" ca_init_rotate_z="0" ca_duration="1200" ca_delay="150" ca_init_translate_z="-118"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 200, 11)" fs="12px" ls="0.1em" fw="400" margin="bottom_large:0.2em"]We’re hiring[/ld_fancy_heading][ld_fancy_heading tag="h5" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="36px" lh="1.11em" fw="300"]Take your career to next level[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.5)" fs="16px" lh="1.5em" margin="right_large:23%25"]Apply to our team and see what can we do together[/ld_fancy_heading][vc_empty_space height="38px"][ld_button style="btn-solid" title="Apply Now" transformation="text-uppercase" size="btn-sm" text_color="rgb(24, 27, 49)" fs="12px" fw="700" ls="0.1em" css=".vc_custom_1533799087063{padding-right: 1em !important;padding-left: 1em !important;}"][/vc_column_inner][/vc_row_inner][vc_empty_space height="70px"][/vc_column][vc_column width="1/2" offset="vc_col-lg-4 vc_col-md-6" css=".vc_custom_1527842141825{margin-bottom: 30px !important;}"][ld_google_map style="shadesOfGrey" map_marker="html_marker" si_style="" si_size="" zoom="14" map_controls="fullscreenControl" address="7420 Shore Rd, Brooklyn, NY 11209, USA" map_height="530px"][/vc_column][vc_column offset="vc_col-lg-4 vc_col-md-12" css=".vc_custom_1527842152031{margin-bottom: 30px !important;padding-top: 40px !important;padding-right: 25px !important;padding-bottom: 40px !important;padding-left: 25px !important;background-color: #181b31 !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 200, 11)" fs="12px" ls="0.1em" fw="400" margin="bottom_large:0.2em"]Subscribe to newsletter[/ld_fancy_heading][ld_fancy_heading tag="h5" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="36px" lh="1.11em" fw="300"]Latest News[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.5)" fs="16px" lh="1.5em"]Enter your email address to receive all news and promotions from Ave.[/ld_fancy_heading][vc_empty_space height="25px"][ld_cf7 id="2968" shape="contact-form-inputs-underlined" btn_width="contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" submit_fs="12px" submit_fw="700" submit_ls="0.1em" color="rgba(255, 255, 255, 0.312)" h_color="rgb(255, 255, 255)" border_color="rgba(255, 255, 255, 0.211)" hover_border_color="rgb(255, 255, 255)" submit_bg_color="rgb(255, 200, 11)" submit_color="rgb(24, 27, 49)" fs="12px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 9
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 09', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox8.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1537957399778{margin-bottom: 60px !important;padding-top: 40px !important;padding-bottom: 50px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_y="44"][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ld_section_title title="Initial Concepts" alignment="text-center" title_top_margin="10" title_bottom_margin="-10px" add_line="underline-section-title" subtitle_top_margin="0" subtitle_bottom_margin="10" text_top_margin="0" text_bottom_margin="0" use_custom_fonts_title="true" title_font_container="tag:h2" title_use_theme_fonts="yes"][ld_spacer][/vc_column][vc_column offset="vc_col-md-4"][ld_flipbox direction="ld-flipbox-tb" bg_image="3968" back_bg_color="rgb(14, 48, 93)"][ld_flipbox_section title="Front"][ld_header_button ib_style="btn-solid" ib_title="Analytics" ib_shape="semi-round" ib_size="btn-sm" ib_color="rgb(255, 255, 255)" ib_text_color="rgb(5, 35, 75)" ib_fs="15px" ib_ls="0.025em" ib_fw="600"][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_header_button ib_style="btn-underlined" ib_title="Case Studies" ib_transformation="text-uppercase" ib_color="rgb(255, 255, 255)" ib_fs="13px" ib_ls="0.2em" ib_hover_color="rgb(255, 255, 255)" ib_fw="700"][/ld_flipbox_section][/ld_flipbox][/vc_column][vc_column offset="vc_col-md-4"][ld_flipbox direction="ld-flipbox-tb" bg_image="3966" back_bg_color="rgb(14, 48, 93)"][ld_flipbox_section title="Front"][ld_header_button ib_style="btn-solid" ib_title="Logistics" ib_shape="semi-round" ib_size="btn-sm" ib_color="rgb(255, 255, 255)" ib_text_color="rgb(5, 35, 75)" ib_fs="15px" ib_ls="0.025em" ib_fw="600"][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_header_button ib_style="btn-underlined" ib_title="Case Studies" ib_transformation="text-uppercase" ib_color="rgb(255, 255, 255)" ib_fs="13px" ib_ls="0.2em" ib_hover_color="rgb(255, 255, 255)" ib_fw="700"][/ld_flipbox_section][/ld_flipbox][/vc_column][vc_column offset="vc_col-md-4"][ld_flipbox direction="ld-flipbox-tb" bg_image="3967" back_bg_color="rgb(14, 48, 93)"][ld_flipbox_section title="Front"][ld_header_button ib_style="btn-solid" ib_title="Consultation" ib_shape="semi-round" ib_size="btn-sm" ib_color="rgb(255, 255, 255)" ib_text_color="rgb(5, 35, 75)" ib_fs="15px" ib_ls="0.025em" ib_fw="600"][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_header_button ib_style="btn-underlined" ib_title="Case Studies" ib_transformation="text-uppercase" ib_color="rgb(255, 255, 255)" ib_fs="13px" ib_ls="0.2em" ib_hover_color="rgb(255, 255, 255)" ib_fw="700"][/ld_flipbox_section][/ld_flipbox][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 10
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 10', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox9.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1532513359069{margin-top: 30px !important;margin-bottom: 50px !important;padding-top: 100px !important;padding-bottom: 80px !important;background-color: #f6f6f7 !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1532512924420{padding-right: 7% !important;padding-left: 7% !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_y="57"][ld_fancy_heading tag="h2"]Case Studies[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="1.611em"]Great things in business are never done by one person. They're done by a team of people.[/ld_fancy_heading][ld_spacer height="50px"][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_delay="150" ca_init_translate_x="-34"][vc_column_inner offset="vc_col-md-3"][ld_content_box style="s07" show_button="yes" ib_style="btn-naked" ib_title="Read more" ib_i_type="fontawesome" ib_i_add_icon="true" title="Apple Phase" image="173" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="14px"]Praesent pharetra risus pharetra orci ultrices, vel pharetra dolor.[/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-3"][ld_content_box style="s07" show_button="yes" ib_style="btn-naked" ib_title="Read more" ib_i_type="fontawesome" ib_i_add_icon="true" title="White Chair" image="174" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="14px"]Praesent pharetra risus pharetra orci ultrices, vel pharetra dolor.[/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-3"][ld_content_box style="s07" show_button="yes" ib_style="btn-naked" ib_title="Read more" ib_i_type="fontawesome" ib_i_add_icon="true" title="Modern Essentials" image="176" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="14px"]Praesent pharetra risus pharetra orci ultrices, vel pharetra dolor.[/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-3"][ld_content_box style="s07" show_button="yes" ib_style="btn-naked" ib_title="Read more" ib_i_type="fontawesome" ib_i_add_icon="true" title="Berries on White" image="177" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="14px"]Praesent pharetra risus pharetra orci ultrices, vel pharetra dolor.[/ld_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 11
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 11', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox16.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row enable_overlay="yes" css=".vc_custom_1543480429760{margin-bottom: 20px !important;padding-top: 60px !important;padding-bottom: 60px !important;}" overlay_bg="linear-gradient(180deg, rgb(255,248,245) 0.6369426751592356%, rgb(255,255,255) 49.681528662420384%)" responsive_css="margin_top_medium:65px|margin_right_medium:30px|margin_bottom_medium:40px|margin_left_medium:30px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" ca_duration="1800" ca_delay="180" ca_init_translate_y="45"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" color="rgb(68, 50, 39)" fs="12px" lh="1em" fw="600" ls="0.2em" padding="top_small:17px|right_small:30px|bottom_small:17px|left_small:30px" fh_bg="rgb(255, 255, 255)" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.08)%22%7D%5D" margin="bottom_small:35px"]Save Money $[/ld_fancy_heading][vc_row_inner css=".vc_custom_1543609441378{margin-bottom: 45px !important;}"][vc_column_inner width="5/6" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true"]Buy Ave and get access to premium and exclusive plugins for free.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][vc_row_inner][vc_column_inner offset="vc_col-md-4"][ld_content_box style="s06" is_tall="tall" heading_weight="font-weight-semibold" title="Automatic Updates" image="46" info="Subtitle" overlay_color="rgba(0, 0, 0, 0.05)" blur_radius="15"]<span style="font-size: 16px; color: rgba(255,255,255,0.6);">Import a pre-designed template and change the content.</span>[/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ld_content_box style="s06" is_tall="tall" heading_weight="font-weight-semibold" title="Flexible Options" image="47" info="Subtitle" overlay_color="rgba(0, 0, 0, 0.05)" blur_radius="15"]<span style="font-size: 16px; color: rgba(255,255,255,0.6);">Import a pre-designed template and change the content.</span>[/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ld_content_box style="s06" is_tall="tall" heading_weight="font-weight-semibold" title="Lifetime Use" image="48" info="Subtitle" overlay_color="rgba(0, 0, 0, 0.05)" blur_radius="15"]<span style="font-size: 16px; color: rgba(255,255,255,0.6);">Import a pre-designed template and change the content.</span>[/ld_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 12
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 12', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox10.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542909819347{margin-top: 70px !important;margin-bottom: 70px !important;padding-top: 120px !important;padding-bottom: 75px !important;background-image: url(http://hotel.liquid-themes.com/wp-content/uploads/2018/09/testimonials-bg-min-2.jpg?id=4089) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column][ld_fancy_heading tag="h2" use_custom_fonts_title="true" enable_fit="true" compressor="0.5" margin="bottom_small:0px" el_class="booking-heading"]EXPERIENCE AVE HOTEL[/ld_fancy_heading][vc_empty_space height="60px"][/vc_column][vc_column][ld_carousel columns="md:2|sm:1.5|xs:1|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" navappend="custom_id" fullwidthside="yes" navarrow="6" navsize="carousel-nav-lg" navfill="carousel-nav-bordered" navshape="carousel-nav-rectangle" navhalign="carousel-nav-right" navappend_id=".booking-heading" nav_arrow_color="rgb(159, 162, 169)" nav_arrow_color_hover="rgb(187, 160, 122)" nav_border_color="rgb(159, 162, 169)" nav_border_hcolor="rgb(187, 160, 122)" nav_bg_hcolor="rgba(255, 255, 255, 0)"][ld_content_box style="s01" heading_size="content-box-heading-lg" show_button="yes" ib_style="btn-solid" ib_title="Book Now" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Superior Guest Rooms" cb_atts="%5B%7B%22cb_label%22%3A%22Bed%20options%22%7D%2C%7B%22cb_label%22%3A%2202%20Sleeps%22%7D%5D" image="156" ib_fs="12px" ib_ls="0.1em" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(187, 160, 122)" ib_text_color="rgb(187, 160, 122)"]Unwind in our Superior Rooms featuring dramatic Manhattan views created by elevated stays on the 21st floor or higher.[/ld_content_box][ld_content_box style="s01" heading_size="content-box-heading-lg" show_button="yes" ib_style="btn-solid" ib_title="Book Now" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Superior Guest Rooms" cb_atts="%5B%7B%22cb_label%22%3A%22Bed%20options%22%7D%2C%7B%22cb_label%22%3A%2202%20Sleeps%22%7D%5D" image="157" ib_fs="12px" ib_ls="0.1em" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(187, 160, 122)" ib_text_color="rgb(187, 160, 122)"]Unwind in our Superior Rooms featuring dramatic Manhattan views created by elevated stays on the 21st floor or higher.[/ld_content_box][ld_content_box style="s01" heading_size="content-box-heading-lg" show_button="yes" ib_style="btn-solid" ib_title="Book Now" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Superior Guest Rooms" cb_atts="%5B%7B%22cb_label%22%3A%22Bed%20options%22%7D%2C%7B%22cb_label%22%3A%2202%20Sleeps%22%7D%5D" image="158" ib_fs="12px" ib_ls="0.1em" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(187, 160, 122)" ib_text_color="rgb(187, 160, 122)"]Unwind in our Superior Rooms featuring dramatic Manhattan views created by elevated stays on the 21st floor or higher.[/ld_content_box][ld_content_box style="s01" heading_size="content-box-heading-lg" show_button="yes" ib_style="btn-solid" ib_title="Book Now" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Superior Guest Rooms" cb_atts="%5B%7B%22cb_label%22%3A%22Bed%20options%22%7D%2C%7B%22cb_label%22%3A%2202%20Sleeps%22%7D%5D" image="157" ib_fs="12px" ib_ls="0.1em" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(187, 160, 122)" ib_text_color="rgb(187, 160, 122)"]Unwind in our Superior Rooms featuring dramatic Manhattan views created by elevated stays on the 21st floor or higher.[/ld_content_box][ld_content_box style="s01" heading_size="content-box-heading-lg" show_button="yes" ib_style="btn-solid" ib_title="Book Now" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" title="Superior Guest Rooms" cb_atts="%5B%7B%22cb_label%22%3A%22Bed%20options%22%7D%2C%7B%22cb_label%22%3A%2202%20Sleeps%22%7D%5D" image="156" ib_fs="12px" ib_ls="0.1em" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(187, 160, 122)" ib_text_color="rgb(187, 160, 122)"]Unwind in our Superior Rooms featuring dramatic Manhattan views created by elevated stays on the 21st floor or higher.[/ld_content_box][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 13
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 13', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox11.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540322467971{padding-top: 50px !important;padding-bottom: 100px !important;}"][vc_column width="1/4"][ld_content_box style="s05" add_icon="yes" i_type="linea" title="Graphic Design" image="5365" info="Creative" i_icon_linea="icon-ion-ios-watch" img_link="url:%23|||"][/ld_content_box][/vc_column][vc_column width="1/4" offset="vc_col-md-3"][ld_content_box style="s05" add_icon="yes" i_type="linea" title="Graphic Design" image="5369" info="Creative" i_icon_linea="icon-ion-ios-watch" img_link="url:%23|||"][/ld_content_box][/vc_column][vc_column width="1/4" offset="vc_col-md-3"][ld_content_box style="s05" add_icon="yes" i_type="linea" title="Development" image="104" info="Technology" i_icon_linea="icon-ion-ios-laptop" img_link="url:%23|||"][/ld_content_box][/vc_column][vc_column width="1/4"][ld_content_box style="s05" add_icon="yes" i_type="linea" title="Development" image="5370" info="Technology" i_icon_linea="icon-ion-ios-laptop" img_link="url:%23|||"][/ld_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 14
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 14', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox12.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1530869560687{padding-top: 150px !important;padding-bottom: 50px !important;}"][vc_column offset="vc_col-md-6"][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="UI Design" image="5392" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(0, 251, 248)" ib_hover_color2="rgb(223, 0, 255)" ib_fs="12px" ib_ls="0.2em" ib_b_color="rgb(0, 251, 248)" ib_b_color2="rgb(223, 0, 255)" ib_color2="rgb(255, 255, 255)" overlay_color="rgba(0, 0, 0, 0.5)" blur_radius="10"]<span style="color: #ffffff; font-size: 16px;">We have a selection of over 50 tour programs that range from introductory multi-country itineraries to more regional in-depth options.</span>[/ld_content_box][/vc_column][vc_column offset="vc_col-md-6"][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="UI Design" image="5373" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(0, 251, 248)" ib_hover_color2="rgb(223, 0, 255)" ib_fs="12px" ib_ls="0.2em" ib_b_color="rgb(0, 251, 248)" ib_b_color2="rgb(223, 0, 255)" ib_color2="rgb(255, 255, 255)" overlay_color="linear-gradient(90deg, rgba(255, 42, 42, 0.758) 1.592356687898089%, rgba(33, 29, 225, 0.658) 100%)" blur_radius="50"]<span style="color: #ffffff; font-size: 16px;">We have a selection of over 50 tour programs that range from introductory multi-country itineraries to more regional in-depth options.</span>[/ld_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 15
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 15', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox13.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1530876924248{margin-top: 50px !important;margin-bottom: 50px !important;}"][vc_column offset="vc_col-md-6"][ld_content_box style="s10" title="Virtual Reality" image="5373" info="We have a selection of over 50 tour programs" blur_radius="100"][/ld_content_box][/vc_column][vc_column offset="vc_col-md-6"][ld_content_box style="s10" title="Virtual Reality" image="5373" info="We have a selection of over 50 tour programs" blur_radius="100"][/ld_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 16
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 16', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox14.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_init_translate_y="44" css=".vc_custom_1540311846471{margin-top: 160px !important;margin-bottom: 200px !important;padding-top: 35px !important;padding-bottom: 45px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1540159685667{margin-bottom: 150px !important;}"][ld_spacer height="90px"][ld_fancy_heading tag="h2" margin="bottom_large:0px"]3D Carousel with Content Boxes[/ld_fancy_heading][ld_spacer height="20px"][/vc_column][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ld_carousel_3d][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" title="UI Design" image="5381" ib_color="rgb(255, 255, 255)" ib_hover_color="rgba(255, 255, 255, 0.778)" overlay_color="linear-gradient(137deg, #242428 0%, rgba(36, 36, 41, 0.842) 2.229299363057325%, rgba(45, 53, 68, 0.91) 100%)"][/ld_content_box][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" title="UI Design" image="5373" ib_color="rgb(255, 255, 255)" ib_hover_color="rgba(255, 255, 255, 0.778)" overlay_color="rgba(0, 0, 0, 0.319)"]Take your career to next level. Apply to our team and see what we can do together. You’re good enough, right ?[/ld_content_box][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" title="UI Design" image="5389" ib_color="rgb(255, 255, 255)" ib_hover_color="rgba(255, 255, 255, 0.778)" overlay_color="linear-gradient(128deg, rgba(128, 106, 255, 0.86) 1.5923566878980893%, rgba(255, 101, 101, 0.789) 100%)"][/ld_content_box][/ld_carousel_3d][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 17
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 17', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox17.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1547137423651{padding-top: 120px !important;padding-bottom: 50px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-0 vc_col-md-6"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="4" enable_shadow="yes" image="7104"][ld_button style="btn-naked" link_type="lightbox" i_type="fontawesome" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_size="18px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4|||" i_icon_fontawesome="fa fa-play" i_color="rgb(0, 0, 0)" i_custom_size="22px" color="rgb(255, 255, 255)" i_shape_custom_size="104px" i_margin_left="0" i_margin_right="0" hover_color="rgb(240, 243, 255)"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_right_medium:7%25|padding_left_medium:12%25" ca_duration="1600" ca_delay="160" ca_init_translate_y="30"][ld_fancy_heading tag="h2" margin="bottom_small:0.75em"]Set up Ave in under a minute.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.78em" margin="bottom_small:2em" ls="0.01em"]Being the Ave's business, that is, the person see pulled You have seen Italian organ boys holding a dancing. Lorema dolor sit amet, consectetur adipisicing elit sed.[/ld_fancy_heading][ld_button style="btn-solid" title="Discover Ave" link_type="lightbox" shape="semi-round" size="btn-sm" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4%26feature%3Dyoutu.be||target:%20_blank|" fs="15px" ls="0.02em" css=".vc_custom_1545656221784{margin-right: 8px !important;margin-bottom: 10px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="rgb(58, 58, 58)"][ld_button style="btn-default" title="Free Trial" shape="semi-round" size="btn-sm" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" color="rgb(228, 228, 228)" fs="15px" ls="0.02em" css=".vc_custom_1545656232739{margin-bottom: 10px !important;margin-left: 8px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(58, 58, 58)" text_color="rgb(58, 58, 58)" htext_color="rgb(255, 255, 255)"][ld_spacer][/vc_column][/vc_row][vc_row][vc_column][rev_slider alias="Opus Main Slider"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 18
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 18', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox18.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" responsive_css="padding_top_medium:110px|padding_bottom_medium:140px" css=".vc_custom_1547138785509{padding-top: 70px !important;padding-bottom: 70px !important;}" ca_duration="1200" ca_delay="120" ca_init_translate_y="45"][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8"][ld_section_title title="Innovation. Quality. Invention." alignment="text-center" title_top_margin="0" title_bottom_margin="10" subtitle_top_margin="0" subtitle_bottom_margin="0" text_top_margin="0" text_bottom_margin="0" use_custom_fonts_subtitle="true" sub_fs="17px" sub_color="rgb(136, 136, 136)" sub_lh="1.705em" sub_fw="400"][ld_spacer height="20px"][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_flipbox border_radius="round" bg_image="4296" back_bg_color="rgb(39, 174, 96)" bg_color="rgba(0, 0, 0, 0.3)"][ld_flipbox_section title="Front"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="custom" heading_weight="font-weight-normal" i_size="md" title="Automatic Updates" custom_heading_size="23px" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" icon_mb="18" css=".vc_custom_1546877245081{padding-top: 30px !important;padding-bottom: 30px !important;}" i_icon_animated="animated-basic_folder_multiple" custom_size="70px"][/ld_icon_box][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_fancy_heading tag="p" margin="top_small:-0.5em|bottom_small:1em" color="rgba(255, 255, 255, 0.69)"]Install any demo, plugin or template in a matter of seconds.[/ld_fancy_heading][ld_button style="btn-underlined" title="Discover Ave" link_type="lightbox" i_type="fontawesome" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4%26feature%3Dyoutu.be||target:%20_blank|" i_icon_fontawesome="fa fa-angle-right" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" b_color="rgba(255, 255, 255, 0.5)" h_b_color="rgb(255, 255, 255)" fs="16px"][/ld_flipbox_section][/ld_flipbox][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_flipbox border_radius="round" bg_image="4223" back_bg_color="rgb(39, 174, 96)"][ld_flipbox_section title="Front"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="custom" heading_weight="font-weight-normal" title="Automatic Updates" custom_heading_size="23px" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" icon_mb="18" css=".vc_custom_1546879156778{padding-top: 30px !important;padding-bottom: 30px !important;}" i_icon_animated="animated-basic_flag1" custom_size="70px"][/ld_icon_box][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_fancy_heading tag="p" margin="top_small:-0.5em|bottom_small:1em" color="rgba(255, 255, 255, 0.69)"]Install any demo, plugin or template in a matter of seconds.[/ld_fancy_heading][ld_button style="btn-underlined" title="Discover Ave" link_type="lightbox" i_type="fontawesome" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4%26feature%3Dyoutu.be||target:%20_blank|" i_icon_fontawesome="fa fa-angle-right" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" b_color="rgba(255, 255, 255, 0.5)" h_b_color="rgb(255, 255, 255)" fs="16px"][/ld_flipbox_section][/ld_flipbox][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_flipbox border_radius="round" bg_image="4299" back_bg_color="rgb(39, 174, 96)" bg_color="rgba(0, 0, 0, 0.04)"][ld_flipbox_section title="Front"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="custom" heading_weight="font-weight-normal" title="Automatic Updates" custom_heading_size="23px" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" icon_mb="18" css=".vc_custom_1546877259570{padding-top: 30px !important;padding-bottom: 30px !important;}" i_icon_animated="animated-basic_elaboration_browser_plus" custom_size="70px"][/ld_icon_box][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_fancy_heading tag="p" margin="top_small:-0.5em|bottom_small:1em" color="rgba(255, 255, 255, 0.69)"]Install any demo, plugin or template in a matter of seconds.[/ld_fancy_heading][ld_button style="btn-underlined" title="Discover Ave" link_type="lightbox" i_type="fontawesome" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQWGjLq1P3q4%26feature%3Dyoutu.be||target:%20_blank|" i_icon_fontawesome="fa fa-angle-right" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" b_color="rgba(255, 255, 255, 0.5)" h_b_color="rgb(255, 255, 255)" fs="16px"][/ld_flipbox_section][/ld_flipbox][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 19
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 19', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox19.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1545661118919{padding-top: 120px !important;padding-bottom: 90px !important;background-color: rgba(29,30,31,0.98) !important;*background-color: rgb(29,30,31) !important;}"][vc_column offset="vc_col-md-5"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_roudness="yes" image_roudness="6" enable_reveal="yes" reveal_direction="tb" image="6851" label="Next-generation theme." reveal_color="rgb(70, 70, 70)"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22business%22%7D%2C%7B%22word%22%3A%22agency%22%7D%2C%7B%22word%22%3A%22portfolio%22%7D%5D" color="rgb(255, 255, 255)"]Building products for[/ld_fancy_heading][ld_spacer height="25px"][vc_row_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Brand Experience[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Trends and Insights[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Dashboard Tools[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Content Management[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]System Guide[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Mobile App Design[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Dashboard and Tools[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Logo and Identity[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Content Management[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]System guides[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Communications[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.8)" link="|||" fs="16px" lh="1.25em" ls="0.025em" margin="bottom_large:16px" fw="500"]Pre-Built Templates[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 20
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 20', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancybox/fancybox20.jpg' );
	$data['sort_name'] = 'FancyBox';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1545670444234{margin-bottom: 20px !important;padding-top: 100px !important;padding-bottom: 80px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1545670816022{padding-right: 7% !important;padding-left: 7% !important;}"][ld_fancy_heading tag="h2"]Set up Ave in under a minute[/ld_fancy_heading][ld_spacer height="40px"][/vc_column][vc_column offset="vc_col-md-4"][ld_content_box style="s07" heading_weight="font-weight-medium" heading_size="fancy-box-heading-custom" show_button="yes" button_placement="on_image" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="No coding or design skills required" image="6848" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="15px" ib_link="url:%23|||" custom_heading_size="19px" ib_htext_color="rgb(54, 54, 54)" img_link="url:%23|||"]Forget about design limits! Build and customize your site visually. It’s fun, fast and super-easy![/ld_content_box][/vc_column][vc_column offset="vc_col-md-4"][ld_content_box style="s07" heading_weight="font-weight-medium" heading_size="fancy-box-heading-custom" show_button="yes" button_placement="on_image" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="Intuitive Visual Editor" image="6849" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="15px" ib_link="url:%23|||" custom_heading_size="19px" ib_htext_color="rgb(54, 54, 54)" img_link="url:%23|||"]Forget about design limits! Build and customize your site visually. It’s fun, fast and super-easy![/ld_content_box][/vc_column][vc_column offset="vc_col-md-4"][ld_content_box style="s07" heading_weight="font-weight-medium" heading_size="fancy-box-heading-custom" show_button="yes" button_placement="on_image" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="One Click Installation" image="6893" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="15px" ib_link="url:%23|||" custom_heading_size="19px" ib_htext_color="rgb(54, 54, 54)" img_link="url:%23|||"]Forget about design limits! Build and customize your site visually. It’s fun, fast and super-easy![/ld_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text Category
	//Fancy Text 1
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancytext/fancytext1.jpg' );
	$data['sort_name'] = 'fancytext';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1536843316088{padding-top: 80px !important;padding-bottom: 50px !important;}"][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-3" ca_init_translate_y="40" ca_init_translate_x="0" ca_init_translate_z="-121" ca_init_rotate_x="-60" ca_duration="1200" ca_delay="150" css=".vc_custom_1536843291050{margin-bottom: 30px !important;}" responsive_css="padding_right_medium:4%25"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="36px" lh="1.11em" fw="700"]Branded eCommerce[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p"]Our eCommerce design starts and ends with a best-in-class experience strategy that builds brands and drives transactions.[/ld_fancy_heading][/vc_column][vc_column width="2/3" align="text-center" offset="vc_col-md-offset-1 vc_col-md-4" responsive_css="padding_right_medium:4%25|padding_left_medium:4%25" css=".vc_custom_1536843298512{margin-bottom: 30px !important;}"][vc_row_inner][vc_column_inner width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-left" offset="vc_col-md-offset-1" ca_start_delay="150" ca_init_translate_y="41" ca_init_translate_z="-119" ca_init_rotate_x="-65" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="36px" lh="1.11em" fw="700" margin="right_large:4%25"]Digital Experience[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p"]Through a deep understanding of our audience’s makeup and motivations, we design digital experiences that connect with people.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-3" ca_start_delay="300" ca_init_translate_y="40" ca_init_translate_x="0" ca_init_translate_z="-119" ca_init_rotate_x="-62" ca_duration="1200" ca_delay="150" css=".vc_custom_1536843306248{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="36px" lh="1.11em" fw="700"]Branding Strategy[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p"]We build and activate brands through cultural insight, strategic vision, and the power of emotion across every element of its expression.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 2
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancytext/fancytext2.jpg' );
	$data['sort_name'] = 'fancytext';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1542970459327{padding-top: 55px !important;padding-bottom: 55px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_x="-26"][vc_column offset="vc_col-md-4"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_large:0" fs="36px" lh="1.111em"]Services[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(211, 169, 133)" fs="14px" ls="0.1em" fw="400"]Brand Identity, print &amp; Web[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-7"][ld_fancy_heading tag="h5" use_theme_fonts="" text_font="font_family:Amiri%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_title="true" fs="20px" lh="28px" color="rgb(115, 115, 115)"]It's time to bring it all together. Nothing is more rewarding for me than making great work for clients with meaningful missions.[/ld_fancy_heading][ld_spacer height="40px"][vc_row_inner][vc_column_inner offset="vc_col-md-3"][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" fs="11px" lh="30px" fw="700" ls="0.1em" duration="1200" start_delay="400" delay="150" ca_init_translate_y="30"]Logo Design<br />Brand Guide<br />Package Design<br />Poster design[/ld_fancy_heading][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-3"][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" fs="11px" lh="30px" fw="700" ls="0.1em" duration="1200" start_delay="500" delay="150" ca_init_translate_y="30"]Flayer design<br />Advertising<br />Web design<br />web advertising[/ld_fancy_heading][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-3"][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" fs="11px" lh="30px" fw="700" ls="0.1em" duration="1200" start_delay="600" delay="150" ca_init_translate_y="30"]Icon design<br />Illustration<br />Photography<br />Seo[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 3
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancytext/fancytext3.jpg' );
	$data['sort_name'] = 'fancytext';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1527251816196{padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column parallax="yes" width="2/3" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-3" ca_init_translate_y="35" translate_from_y="100" translate_to_y="-169" ca_init_translate_x="0" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(46, 212, 124)" fs="12px" fw="700" ls="0.2em"]01[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="36px" lh="1.11em"]Branded eCommerce[/ld_fancy_heading][vc_empty_space height="18px"][ld_fancy_heading tag="p"]Our eCommerce design starts and ends with a best-in-class experience strategy that builds brands and drives transactions.[/ld_fancy_heading][vc_empty_space height="25px"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Brand experience[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Platform &amp; Positioning[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Trends &amp; Insights[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Marketing Strategy[/ld_fancy_heading][/vc_column][vc_column width="2/3" align="text-center" offset="vc_col-md-offset-1 vc_col-md-4"][vc_row_inner][vc_column_inner parallax="yes" width="5/6" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-left" offset="vc_col-md-offset-1" ca_start_delay="250" ca_init_translate_y="38" translate_from_y="100" translate_to_y="-100" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(46, 212, 124)" fs="12px" fw="700" ls="0.2em"]02[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="36px" lh="1.11em" margin="right_large:8%25"]Digital Experience[/ld_fancy_heading][vc_empty_space height="18px"][ld_fancy_heading tag="p"]Through a deep understanding of our audience’s makeup and motivations, we design digital experiences that connect with people.[/ld_fancy_heading][vc_empty_space height="25px"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Web design[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]mobile app design[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]ux / ui design[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]dashboard &amp; tool[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column parallax="yes" width="2/3" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-3" ca_start_delay="500" ca_init_translate_y="40" translate_from_y="100" translate_to_y="-29" ca_init_translate_x="0" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(46, 212, 124)" fs="12px" fw="700" ls="0.2em"]03[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="36px" lh="1.11em"]Branding Strategy[/ld_fancy_heading][vc_empty_space height="18px"][ld_fancy_heading tag="p"]We build and activate brands through cultural insight, strategic vision, and the power of emotion across every element of its expression.[/ld_fancy_heading][vc_empty_space height="25px"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Communications[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Logo &amp; Identity[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]Content Management[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" fw="700" ls="0.1em" color="rgb(24, 27, 49)"]System &amp; guides[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 4
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancytext/fancytext4.jpg' );
	$data['sort_name'] = 'fancytext';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1540482661663{padding-top: 40px !important;padding-bottom: 40px !important;}"][vc_column offset="vc_col-md-5"][ld_freakin_image image="6047" color="linear-gradient(139deg, rgb(91, 104, 255) 20.38216560509554%, rgb(255, 120, 112) 97.77070063694268%)"][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" offset="vc_col-md-offset-1 vc_col-md-6" translate_from_y="92" translate_to_y="-111"][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" duration="1200" delay="140" ca_init_translate_y="23" ca_init_translate_x="0" ca_init_rotate_z="7"]About me[/ld_fancy_heading][ld_spacer height="10px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(61, 61, 61)" fs="16px" lh="2em" ls="0.01em" margin="right_large:20%25" duration="1200" start_delay="200" delay="180" ca_init_translate_y="50" el_class="text-underline"]Hey, I am Daniel. It’s always good to receive positive and constructive feedback for your work – from clients and moreover, from designers![/ld_fancy_heading][ld_spacer height="30px"][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" duration="1200" delay="140" ca_init_translate_y="23" ca_init_translate_x="0" ca_init_rotate_z="7" start_delay="400"]I’m good at:[/ld_fancy_heading][ld_spacer height="25px"][vc_row_inner][vc_column_inner width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_start_delay="600" ca_delay="150" ca_init_translate_y="70" ca_init_rotate_z="7"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Brand Experience[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Trends and Insights[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Dashboard Tools[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Content Management[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]System Guide[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Mobile App Design[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_start_delay="800" ca_delay="150" ca_init_translate_y="70" ca_init_rotate_z="7"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Mobile App Design[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Content Management[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]System Guide[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Brand Experience[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Trends and Insights[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" link="|||" fs="15px" lh="1.25em" ls="0.025em" margin="bottom_large:16px"]Dashboard Tools[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 5
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancytext/fancytext5.jpg' );
	$data['sort_name'] = 'fancytext';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1542970253710{padding-top: 75px !important;padding-bottom: 75px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_x="-27"][vc_column offset="vc_col-md-4"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_large:0" fs="36px" lh="1.111em"]I'm Leona Dawson[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(211, 169, 133)" fs="14px" ls="0.1em" fw="400"]A few words about me[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-3"][ld_fancy_heading tag="h5" use_theme_fonts="" text_font="font_family:Amiri%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_title="true" fs="20px" lh="28px" color="rgb(115, 115, 115)"]My job is to build your website so that it is functional and user friendly but at the same time attractive. My aim is to bring across your message and identity in the most creative way.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-3"][ld_fancy_heading tag="h5" use_theme_fonts="" text_font="font_family:Amiri%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_title="true" fs="20px" lh="28px" color="rgb(115, 115, 115)"]I enjoy turning complex problems into simple, beautiful and intuitive interface designs. When I'm not coding or pushing pixels, you'll find me in the pool or on the court shooting hoops.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 6
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancytext/fancytext6.jpg' );
	$data['sort_name'] = 'fancytext';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1527857420004{padding-top: 130px !important;padding-bottom: 110px !important;background-color: #0a0b4e !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-3" ca_init_translate_y="30"][vc_empty_space height="12px"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 84, 108)" fs="14px" lh="1.5em" ls="0.2em" fw="700"]Awards[/ld_fancy_heading][vc_empty_space height="30px"][/vc_column][vc_column offset="vc_col-md-7"][vc_row_inner][vc_column_inner width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_init_translate_y="30" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h4"]Opentech[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.4)"]UI / UX contest winner with CloudPay[/ld_fancy_heading][ld_fancy_heading tag="h4"]Warephase[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.4)"]Best of Animation with Zara[/ld_fancy_heading][ld_fancy_heading tag="h4"]Sumace[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.4)"]Top week Featured design[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_init_translate_y="30" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h4"]Blackzim[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.4)"]Design of the day with Biosock[/ld_fancy_heading][ld_fancy_heading tag="h4"]Ontomedia[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.4)"]Top Level Certification with Fusion[/ld_fancy_heading][ld_fancy_heading tag="h4"]Doncon[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.4)"]Top 10 best designers in the world[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][vc_empty_space height="70px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-3" ca_init_translate_y="29"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 84, 108)" fs="14px" lh="1.5em" ls="0.2em" fw="700"]Press[/ld_fancy_heading][vc_empty_space height="30px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-7" ca_init_translate_y="20" ca_duration="1200" ca_delay="150"][ld_custom_menu inline="inline-nav" menu_slug="press" color="rgb(139, 140, 179)" hcolor="rgb(255, 210, 0)"][vc_empty_space height="30px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 7
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancytext/fancytext7.jpg' );
	$data['sort_name'] = 'fancytext';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" bg_position="center bottom" css=".vc_custom_1536229559397{padding-top: 95px !important;padding-bottom: 100px !important;background-image: url(http://construction.liquid-themes.com/wp-content/uploads/2018/05/img-min.jpg?id=34) !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_init_translate_y="40"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" ls="0.2em"]About One[/ld_fancy_heading][vc_empty_space height="10px"][vc_separator color="custom" align="align_left" border_width="2" el_width="10" accent_color="#ffc80b" css=".vc_custom_1527594180869{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(24, 27, 49)" fs="30px" lh="1.6em" fw="300" ls="0"]One Construction builds with a quality and precision that honors architectural vision, delivers exceptional execution and outstanding client services.[/ld_fancy_heading][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-6" css=".vc_custom_1536228549170{margin-top: -9% !important;padding-top: 30px !important;padding-right: 50px !important;padding-left: 50px !important;background-image: url(http://construction.liquid-themes.com/wp-content/uploads/2018/05/Vector-Smart-Object-min.jpg?id=36) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="z-index-2" ca_init_translate_y="35" translate_from_y="-135" translate_to_y="111" ca_duration="1600"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="24px"]Get Free Quote[/ld_fancy_heading][vc_empty_space height="18px"][ld_cf7 id="2963" shape="contact-form-inputs-filled" btn_width="contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" submit_fs="14px" bg_color="rgb(255, 255, 255)" color="rgba(24, 27, 49, 0.498)" h_color="rgb(24, 27, 49)" submit_bg_color="rgb(24, 27, 49)" submit_color="rgb(255, 255, 255)" submit_fw="700" submit_ls="0.1em"][/vc_column][vc_column][vc_empty_space height="40px"][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_init_translate_x="0" ca_init_translate_y="35" ca_duration="1200" ca_delay="150" css=".vc_custom_1536229546130{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3"]What We Do[/ld_fancy_heading][vc_empty_space height="18px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" lh="30px"]Through a unique combination of engineering, construction and design disciplines and expertise, Concor delivers world class infrastructure solutions to customers and stakeholders across a broad range of industry sectors.[/ld_fancy_heading][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-6" ca_init_translate_x="0" ca_init_translate_y="35" ca_duration="1200" ca_delay="150" css=".vc_custom_1536229551450{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3"]Our People[/ld_fancy_heading][vc_empty_space height="18px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" lh="30px"]One Construction employs over 3 000 employees, the majority of whom are based on project sites. We embrace holistic development and support for employees with the aim of being a first-choice employer within our sectors.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 8
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/fancytext/fancytext8.jpg' );
	$data['sort_name'] = 'fancytext';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
[vc_row gap="0" css=".vc_custom_1546528974114{border-bottom-width: 1px !important;padding-top: 25px !important;padding-bottom: 15px !important;border-bottom-color: #f4f4f4 !important;border-bottom-style: solid !important;}"][vc_column width="1/3"][ld_button style="btn-naked" title="Recommended by Envato" i_type="fontawesome" i_position="left" i_add_icon="true" i_icon_fontawesome="fa fa-star-o" i_margin_right="20px" text_color="rgb(141, 147, 151)"][/vc_column][vc_column width="1/3" align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" link="|||"]Quite simply the best theme we've ever purchased.[/ld_fancy_heading][/vc_column][vc_column width="1/3" align="text-right"][ld_button style="btn-naked" title="Read Testimonials" i_type="fontawesome" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_add_icon="true" i_icon_fontawesome="fa fa-angle-right" htext_color="rgb(66, 66, 66)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Footers Category
	//Footer 1
	$data = array();
	$data['name'] = esc_html__( 'Footer 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer1.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" enable_overlay="yes" overlay_bg="linear-gradient(270deg, #fc8484 0%, #ac1de1 100%)" css=".vc_custom_1531483704557{padding-top: 80px !important;padding-bottom: 30px !important;}"][vc_column css=".vc_custom_1531483350721{padding-bottom: 50px !important;}"][ld_fancy_heading tag="h3" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true" duration="1200" delay="100" ca_init_translate_y="18" ca_init_rotate_z="6" color="rgb(255, 255, 255)"]Let’s collaborate and make an impact.[/ld_fancy_heading][ld_fancy_heading tag="p" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.738)" fs="18px" lh="1.15em" duration="1200" start_delay="450" ca_init_translate_y="60" ls="0.01em" fw="500"]97C Golf Street. Round Lake,  + 1800 123 567 89,  <a style="text-decoration: underline;" href="#">hireme@ave.com</a>[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1531483314011{border-top-width: 1px !important;padding-top: 50px !important;border-top-color: rgba(255,255,255,0.2) !important;border-top-style: solid !important;}"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_start_delay="1000" ca_delay="250" ca_init_translate_y="47"][vc_column_inner width="1/2"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.85)" fs="11px" lh="1.333em" fw="500" ls="0.2em"]2018 - AVE. ALL RIGHTS RESERVED.[/ld_fancy_heading][ld_spacer][/vc_column_inner][vc_column_inner width="1/2" align="text-left" responsive_align="text-md-right"][ld_social_icons style="text-only" text_transform="text-uppercase" letter_spacing="0.2em" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22pinterest%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="11px" primary_color="#ffffff" hover_color="rgba(255,255,255,0.6)"][ld_spacer][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 2
	$data = array();
	$data['name'] = esc_html__( 'Footer 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer2.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle"][vc_column offset="vc_col-md-6"][vc_single_image image="4287" img_size="full" css=".vc_custom_1542033497413{margin-bottom: 0px !important;}"][ld_spacer height="30px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg" xs_height="30px"][/vc_column][vc_column align="text-left" responsive_align="text-md-right" offset="vc_col-md-6"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 3
	$data = array();
	$data['name'] = esc_html__( 'Footer 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer18.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1543479797861{margin-bottom: 30px !important;}"][vc_column offset="vc_col-md-4" responsive_align="text-md-left text-xs-center"][vc_single_image image="16" img_size="full"][ld_spacer height="30px" md_height="0px"][/vc_column][vc_column offset="vc_col-md-8" responsive_align="text-md-right text-xs-center"][ld_list inline="inline-nav" use_custom_fonts_list="true" items_spacing="30" fs="16px" lh="1.5em" primary_color="rgb(255, 175, 162)"]Lifetime License,Top Notch Support,Bonus Plugins[/ld_list][/vc_column][vc_column][ld_spacer height="15px"][vc_separator color="custom" accent_color="rgba(255,255,255,0.1)"][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-md-4" css=".vc_custom_1543480229906{margin-bottom: 30px !important;}"][vc_column_text]hello@liquid-themes.com

290 Maryam Springs 260,
Courbevoie, Paris, France

+47 213 5941 295[/vc_column_text][/vc_column][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1543480234889{margin-bottom: 30px !important;}"][ld_custom_menu source="custom" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Ave%20Guide%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22%20Support%20%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Intergrations%20%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Community%22%2C%22url%22%3A%22%23%22%7D%5D" fs="16px" spacing="11"][/vc_column][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1543480242590{margin-bottom: 30px !important;}"][ld_custom_menu source="custom" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Instagram%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Pinterest%22%2C%22url%22%3A%22%23%22%7D%5D" fs="16px" spacing="11"][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1543480249751{margin-bottom: 30px !important;}"][ld_newsletter style="solid" inputs_radius="ld-sf--circle" btn_style="solid" btn_display="icon" btn_position="ld-sf--button-inline" i_type="fontawesome" use_custom_fonts_input="true" i_add_icon="true" placeholder_text="Enter your email address" fs="14px" lh="1.5em" i_icon_fontawesome="fa fa-angle-right" i_size="23px" txt_color="rgba(255, 255, 255, 0.602)" bg_color="rgba(255, 255, 255, 0.047)" txt_f_color="rgb(255, 255, 255)" bg_f_color="rgba(255, 255, 255, 0.097)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Footer 4
	$data = array();
	$data['name'] = esc_html__( 'Footer 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer3.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column offset="vc_col-md-4" css=".vc_custom_1536057325640{margin-bottom: 35px !important;}"][vc_single_image image="4302" img_size="full" css=".vc_custom_1542034030644{margin-bottom: 30px !important;}" image_max_width="62px"][ld_spacer md_height="0"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%5D"][ld_spacer height="25px"][vc_column_text]<span style="font-size: 16px;">Copyright 2018 <span style="color: #fff;">Ave</span>. All Rights Reserved.</span>[/vc_column_text][/vc_column][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1536057330389{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Main Navigation[/ld_fancy_heading][ld_spacer height="18px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="16px" lh="2em"][/vc_column][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1536057341977{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Abous Us[/ld_fancy_heading][ld_spacer height="18px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="16px" lh="2em"][/vc_column][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1536057353339{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Workflows[/ld_fancy_heading][ld_spacer height="18px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-3" fs="16px" lh="2em"][/vc_column][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1536057358278{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Resources[/ld_fancy_heading][ld_spacer height="18px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-4" fs="16px" lh="2em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 5
	$data = array();
	$data['name'] = esc_html__( 'Footer 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer4.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row bg_position="left top" css=".vc_custom_1538049965101{padding-bottom: 60px !important;background: #0a0b4e url(http://freelancer.liquid-themes.com/wp-content/uploads/2018/08/decor-min.png?id=2909) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" el_id="contact"][vc_column offset="vc_col-md-3"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 84, 108)" fs="14px" fw="600" ls="0.15em"]Let’s make it happen[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="48px" lh="52px" ls="-0.025em"]Let's create the future[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p" color="rgb(139, 140, 179)"]We’re available for commissions and collaborations, and I’m excited to hear from you about new projects.[/ld_fancy_heading][ld_spacer height="60px"][ld_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff" hover_color="#ffd200"][ld_spacer][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-8"][ld_cf7 id="2920" shape="contact-form-inputs-underlined" size="contact-form-inputs-sm" btn_shape="contact-form-button-bordered" btn_thickness="contact-form-button-border-thick" btn_size="contact-form-button-md" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="18px" submit_fs="14px" submit_ls="0.2em" color="rgb(255, 255, 255)" border_color="rgba(255, 255, 255, 0.204)" hover_border_color="rgb(255, 255, 255)" submit_hbg_color="rgb(255, 210, 0)" submit_color="rgb(255, 210, 0)" submit_h_color="rgb(0, 0, 0)" submit_border_color="rgb(255, 210, 0)"][/vc_column][/vc_row][vc_row css=".vc_custom_1533801677507{padding-top: 34px !important;padding-bottom: 2px !important;background-color: #060742 !important;}"][vc_column offset="vc_col-md-4"][ld_custom_menu inline="inline-nav" separator="" use_custom_fonts_menu="true" menu_slug="main-nav" fs="14px" spacing="13"][ld_spacer][/vc_column][vc_column align="text-left" offset="vc_col-md-4" responsive_align="text-md-center"][vc_single_image image="4058" img_size="full" image_max_width="80px"][ld_spacer][/vc_column][vc_column align="text-left" offset="vc_col-md-4" responsive_align="text-md-right"][vc_column_text]<span style="font-size: 14px;">© 2018 Ave.</span>[/vc_column_text][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 6
	$data = array();
	$data['name'] = esc_html__( 'Footer 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer5.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/3" offset="vc_col-md-2"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" fs="14px" fw="700" ls="0.1em"]Ave Travel[/ld_fancy_heading][ld_spacer height="7px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="13px" lh="2em"][/vc_column][vc_column width="1/3" offset="vc_col-md-2"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" fs="14px" fw="700" ls="0.1em"]Quick Links[/ld_fancy_heading][ld_spacer height="7px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="13px" lh="2em"][/vc_column][vc_column width="1/3" offset="vc_col-md-2"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" fs="14px" fw="700" ls="0.1em"]Help Center[/ld_fancy_heading][ld_spacer height="7px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-3" fs="13px" lh="2em"][/vc_column][vc_column align="text-right" offset="vc_col-md-offset-2 vc_col-md-4"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" fs="14px" fw="700" ls="0.1em"]Payments accepted[/ld_fancy_heading][ld_spacer height="7px"][vc_single_image image="4074" img_size=""][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1533819232683{padding-top: 80px !important;}"][vc_column offset="vc_col-md-9"][ld_spacer height="15px"][ld_custom_menu inline="inline-nav" separator="" use_custom_fonts_menu="true" menu_slug="footer-nav-4" spacing="16" fs="13px" color="rgb(24, 27, 49)" hcolor="rgb(255, 122, 75)"][ld_spacer height="10px"][vc_column_text]<span style="font-size: 12px;">Copyright 2018 Ave Travel. All Rights Reserved.</span>[/vc_column_text][/vc_column][vc_column align="text-left" offset="vc_col-md-3" responsive_align="text-md-right"][ld_social_icons style="branded-text" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-pinterest%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff" hover_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 7
	$data = array();
	$data['name'] = esc_html__( 'Footer 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer6.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column offset="vc_col-md-5" css=".vc_custom_1536755994849{margin-bottom: 30px !important;padding-right: 7% !important;}"][vc_column_text]
<h3 class="my-0"><span style="font-size: 30px;">Ave Children’s Medical</span></h3>
<h6 class="my-0"><span style="font-size: 20px; color: #9ea7c5;">Until every child is well</span></h6>
[/vc_column_text][ld_spacer height="12px"][vc_column_text]<span style="font-size: 16px; line-height: 24px;">At One Medical, we take a holistic view on health care. Our board-certified internal medicine doctors can help with everything from allergies and annual physicals to chronic pain managment and severe illnesses.</span>[/vc_column_text][ld_spacer height="40px"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(7,38,140,0.31)"][ld_spacer height="30px"][ld_custom_menu source="custom" inline="inline-nav" separator="" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Terms%20of%20Use%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Site%20Map%22%2C%22url%22%3A%22%23%22%7D%5D" spacing="14" fs="16px"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-3" css=".vc_custom_1536756002562{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 142, 50)" fs="24px" fw="700"]Our Locations[/ld_fancy_heading][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="16px" lh="2em"][/vc_column][vc_column offset="vc_col-md-3" css=".vc_custom_1536756010032{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 142, 50)" fs="24px" fw="700"]Get In Touch[/ld_fancy_heading][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="16px" lh="2em"][/vc_column][vc_column align="text-center" offset="vc_col-md-offset-1 vc_col-md-10"][ld_spacer height="20px"][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22English%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Espa%C3%B1ol%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Espa%C3%B1ol%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22%ED%95%9C%EA%B5%AD%EC%96%B4%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22%E7%B9%81%E9%AB%94%E4%B8%AD%E6%96%87%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Deutsch%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Fran%C3%A7ais%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Vietnamese%22%2C%22url%22%3A%22%23%22%7D%5D" spacing="20" fs="14px"][ld_spacer height="20px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="14px"]Copyright ©2018 One Children’s Medical. All rights reserved.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 8
	$data = array();
	$data['name'] = esc_html__( 'Footer 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer7.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column offset="vc_col-md-5" css=".vc_custom_1536230727400{margin-bottom: 30px !important;}"][vc_single_image image="4175" img_size="full" image_max_width="100px"][/vc_column][vc_column offset="vc_col-md-7"][vc_row_inner equal_height="yes"][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1536230697092{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" fw="700"]Company[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="14px" lh="2.25em" fw="300" ls="0.025em"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1536230704303{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" fw="700"]information[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="14px" lh="2.25em" fw="300" ls="0.025em"][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1536230709388{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" fw="700"]information[/ld_fancy_heading][ld_spacer height="15px"][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-light" i_size="xs" position="iconbox-inline" i_icon_fontawesome="fa fa-phone" title="(213) 5941 295" i_color="rgb(251, 187, 27)" custom_heading_size="14px" h_color="rgb(181, 183, 196)" css=".vc_custom_1533797583093{margin-bottom: 22px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-light" i_size="xs" position="iconbox-inline" i_icon_fontawesome="fa fa-envelope-open-o" title="hello@aveconstruction.com" i_color="rgb(251, 187, 27)" custom_heading_size="14px" h_color="rgb(181, 183, 196)" css=".vc_custom_1533797591325{margin-bottom: 22px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-light" i_size="xs" position="iconbox-inline" i_icon_fontawesome="fa fa-location-arrow" title="66 McKenzie Turnpike Apt. 745, San Francisco, CA." i_color="rgb(251, 187, 27)" custom_heading_size="14px" h_color="rgb(181, 183, 196)" css=".vc_custom_1533797508472{margin-bottom: 0px !important;}"][/ld_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner content_placement="middle"][vc_column_inner offset="vc_col-md-4" css=".vc_custom_1536230789072{margin-bottom: 30px !important;}"][ld_social_icons style="" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22skype%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff" hover_color="#ffc80b"][/vc_column_inner][vc_column_inner align="text-left" offset="vc_col-md-8" responsive_align="text-md-right" css=".vc_custom_1536230793525{margin-bottom: 30px !important;}"][vc_column_text]<span style="font-size: 14px;">Copyright 2018 <span style="color: #ffffff;"><strong>Ave Construction</strong></span>. All Rights Reserved.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 9
	$data = array();
	$data['name'] = esc_html__( 'Footer 09', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer8.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1536218723447{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(24, 27, 49)" fs="20px" fw="700"]Main Navigation[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="14px" lh="2em"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1536218728374{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(24, 27, 49)" fs="20px" fw="700"]Branded eCommerce[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="14px" lh="2em"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1536218732480{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(24, 27, 49)" fs="20px" fw="700"]Digital Experience[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-3" fs="14px" lh="2em"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1536218737046{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(24, 27, 49)" fs="20px" fw="700"]Branding Strategy[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-4" fs="14px" lh="2em"][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1536218744784{padding-top: 40px !important;}"][vc_column offset="vc_col-md-4"][vc_single_image image="4144" img_size="full"][ld_spacer][/vc_column][vc_column align="text-left" offset="vc_col-md-4" responsive_align="text-md-center"][vc_column_text]<span style="font-size: 14px;">Copyright 2018 <span style="color: #2ed47c;"><strong>Ave</strong></span>. All Rights Reserved.</span>[/vc_column_text][ld_spacer][/vc_column][vc_column align="text-left" offset="vc_col-md-4" responsive_align="text-md-right"][ld_social_icons style="branded-text" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%5D"][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 10
	$data = array();
	$data['name'] = esc_html__( 'Footer 10', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer9.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1532083453510{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_inheritance="true" color="rgb(61, 53, 110)"]Ave wallet[/ld_fancy_heading][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" lh="36px" fs="15px"][/vc_column][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1532083457620{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_inheritance="true" color="rgb(61, 53, 110)"]For clients[/ld_fancy_heading][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" lh="36px" fs="15px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1532083461885{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_inheritance="true" color="rgb(61, 53, 110)"]Get in touch[/ld_fancy_heading][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-3" lh="36px" fs="15px"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-4" css=".vc_custom_1532083465951{margin-bottom: 30px !important;}"][vc_row_inner gap="3"][vc_column_inner offset="vc_col-md-6"][vc_single_image image="58" img_size="" onclick="custom_link" img_link_target="_blank" link="#" css=".vc_custom_1540577960924{margin-bottom: 25px !important;}"][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][vc_single_image image="59" img_size="" onclick="custom_link" img_link_target="_blank" link="#" css=".vc_custom_1540577966747{margin-bottom: 25px !important;}"][/vc_column_inner][/vc_row_inner][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_inheritance="true" margin="bottom_large:0.25em" color="rgb(61, 53, 110)"]Newsletter[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" margin="bottom_large:1.5em"]Get our latest news right in your mailbox[/ld_fancy_heading][ld_newsletter style="bordered" inputs_size="ld-sf--size-sm" inputs_radius="ld-sf--circle" btn_style="solid" btn_display="icon" btn_position="ld-sf--button-inside" i_type="linea" use_custom_fonts_label="true" i_add_icon="true" placeholder_text="Email" i_icon_linea="icon-ion-ios-arrow-round-forward" txt_color="rgb(167, 169, 184)" brd_color="rgb(216, 219, 226)" txt_f_color="rgb(0, 0, 0)" brd_f_color="rgb(170, 179, 201)" btn_txt_color="rgb(255, 255, 255)" label_fs="28px" label_lh="1em" btn_bg_color="rgb(13, 156, 252)" hover_btn_txt_color="rgb(29, 225, 209)" hover_btn_bg_color="rgb(255, 255, 255)"][/vc_column][vc_column][ld_spacer height="55px"][/vc_column][/vc_row][vc_row content_placement="middle"][vc_column align="text-center" offset="vc_col-md-6" responsive_align="text-md-left" css=".vc_custom_1532083433491{margin-bottom: 30px !important;}"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22skype%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22github%22%7D%5D"][/vc_column][vc_column align="text-center" offset="vc_col-md-6" responsive_align="text-md-right" css=".vc_custom_1532083439702{margin-bottom: 30px !important;}"][vc_column_text]© 2018 Ave · <a href="#">Privacy Policy</a> · <a href="#">Terms of Use</a>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 11
	$data = array();
	$data['name'] = esc_html__( 'Footer 11', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer10.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1533806917881{margin-bottom: 65px !important;}"][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" fw="700" margin="bottom_large:1em"]Quick Links[/ld_fancy_heading][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="13px"][/vc_column][vc_column width="1/2" offset="vc_col-md-5"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" fw="700" margin="bottom_large:1em"]Get Social[/ld_fancy_heading][ld_tweet tweet="https://twitter.com/Google/status/1027254108623912960"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-3"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px" fw="700" margin="bottom_large:1em"]Subscribe newsletter[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="14px" margin="bottom_large:1.5em"]Never miss a special offer.[/ld_fancy_heading][ld_newsletter style="solid" inputs_size="ld-sf--size-sm" btn_style="solid" btn_label="Keep updated" btn_position="ld-sf--button-block" placeholder_text="Email Address" txt_color="rgb(89, 91, 101)" bg_color="rgb(39, 41, 52)" txt_f_color="rgb(255, 255, 255)" bg_f_color="rgba(39, 41, 52, 0.75)" btn_txt_color="rgb(255, 255, 255)" btn_bg_color="linear-gradient(90deg, rgb(245, 99, 75) 0.9554140127388535%, #fe9418 100%)" hover_btn_bg_color="linear-gradient(90deg, #fe9418 0.3184713375796178%, rgb(254, 148, 24) 100%)"][/vc_column][/vc_row][vc_row css=".vc_custom_1537543583363{padding-top: 25px !important;padding-bottom: 25px !important;background-color: #000000 !important;}"][vc_column offset="vc_col-md-4"][vc_single_image image="4141" img_size="full" image_max_width="64px"][ld_spacer hide="vc_hidden-lg" md_hide="vc_hidden-md"][/vc_column][vc_column align="text-left" offset="vc_col-md-8" responsive_align="text-md-right"][vc_row_inner][vc_column_inner align="text-left" offset="vc_col-md-9" responsive_align="text-md-right"][ld_spacer hide="vc_hidden-lg" md_hide="vc_hidden-md"][/vc_column_inner][vc_column_inner offset="vc_col-md-3"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#595b65" hover_color="#fa7c31"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 12
	$data = array();
	$data['name'] = esc_html__( 'Footer 12', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer11.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle"][vc_column offset="vc_col-md-8"][ld_fancy_heading tag="h2" transform="text-uppercase" color="rgb(255, 255, 255)"]Let’s build something great. Together.[/ld_fancy_heading][/vc_column][vc_column align="text-left" offset="vc_col-md-4" responsive_align="text-md-right"][ld_button style="btn-solid" title="Start your project" transformation="text-uppercase" size="btn-xsm" i_type="linea" i_add_icon="true" i_icon_linea="icon-arrow-right-material" i_margin_left="20px" fs="20px" ls="0.05em" css=".vc_custom_1539676235579{padding-top: 0.1em !important;padding-right: 1.5em !important;padding-bottom: 0.1em !important;padding-left: 1.5em !important;}"][ld_spacer height="15px"][/vc_column][/vc_row][vc_row css=".vc_custom_1539676495189{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column offset="vc_col-md-4"][vc_row_inner][vc_column_inner offset="vc_col-md-8"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="36px"]London[/ld_fancy_heading][ld_fancy_heading tag="p"]82 Bernie Greens Apt. 210, Hendon Way, London, UK[/ld_fancy_heading][vc_separator color="custom" align="align_left" el_width="30" accent_color="#f5634b" css=".vc_custom_1539676590558{margin-top: 10px !important;margin-bottom: 25px !important;}"][ld_fancy_heading tag="p"]+53 213 5941 295
contact.london@example.com[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-md-4"][vc_row_inner][vc_column_inner offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="36px"]Paris[/ld_fancy_heading][ld_fancy_heading tag="p"]290 Maryam Springs Suite 260, Courbevoie, Paris, France[/ld_fancy_heading][vc_separator color="custom" align="align_left" el_width="30" accent_color="#f5634b" css=".vc_custom_1539676590558{margin-top: 10px !important;margin-bottom: 25px !important;}"][ld_fancy_heading tag="p"]+36 213 5941 295
contact.paris@example.com[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-md-4"][vc_row_inner][vc_column_inner offset="vc_col-md-offset-4 vc_col-md-8"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="36px"]New York[/ld_fancy_heading][ld_fancy_heading tag="p"]21 Valenti Apt. 335, Paterson New Jersey, New York, USA[/ld_fancy_heading][vc_separator color="custom" align="align_left" el_width="30" accent_color="#f5634b" css=".vc_custom_1539676590558{margin-top: 10px !important;margin-bottom: 25px !important;}"][ld_fancy_heading tag="p"]+47 213 5941 295
contact.newyork@example.com[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1539676614192{margin-top: 20px !important;}"][vc_column][vc_separator color="custom" accent_color="rgba(255,255,255,0.15)" css=".vc_custom_1539676997089{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1539677308266{padding-top: 50px !important;padding-bottom: 45px !important;}"][vc_column offset="vc_col-md-8"][vc_row_inner][vc_column_inner offset="vc_col-md-1/5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1542023622483{margin-bottom: 15px !important;}"][vc_single_image image="4424" img_size="full"][/vc_column_inner][vc_column_inner offset="vc_col-md-9" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1542023630079{margin-bottom: 15px !important;}"][ld_custom_menu inline="inline-nav" separator="" transform="uppercase" use_theme_fonts="" menu_font="font_family:Teko%3A300%2Cregular|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_menu="true" menu_slug="footer-nav-1" spacing="20" fs="20px" ls="0.1em"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-left" offset="vc_col-md-4" responsive_align="text-md-right"][ld_social_icons style="" shape="square" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff" bg_color="rgba(255,255,255,0.15)" hbg_color="#f5634b" font_size="16px" hover_color="#ffffff"][/vc_column][/vc_row][vc_row css=".vc_custom_1539677324028{padding-top: 10px !important;padding-bottom: 3px !important;background-color: #070811 !important;}"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="12px" ls="0.1em"]© 2018 Ave. All Rights Reserved.[/ld_fancy_heading][/vc_column][vc_column align="text-left" offset="vc_col-md-6" responsive_align="text-md-right"][ld_custom_menu source="custom" inline="inline-nav" separator="" transform="uppercase" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Privacy%20Policy%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22terms%20of%20use%22%2C%22url%22%3A%22%23%22%7D%5D" spacing="12" fs="12px" ls="0.1em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 13
	$data = array();
	$data['name'] = esc_html__( 'Footer 13', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer12.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1537539351402{border-right-width: 2.5vw !important;border-left-width: 2.5vw !important;padding-top: 90px !important;padding-bottom: 60px !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;}"][vc_column offset="vc_col-md-3"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(186, 0, 255)" fs="14px" fw="600" ls="0.15em"]Let’s make it happen[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="48px" lh="52px" ls="-0.025em"]Let's create the future[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(204, 204, 204)" fs="14px" lh="24px"]We’re available for commissions and collaborations, and I’m excited to hear from you about new projects.[/ld_fancy_heading][ld_spacer height="60px"][ld_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff" hover_color="#ba00ff"][ld_spacer][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-8"][ld_cf7 id="6" shape="contact-form-inputs-underlined" btn_shape="contact-form-button-bordered" btn_thickness="contact-form-button-border-thick" use_custom_fonts_input="true" use_custom_fonts_submit="true" color="rgba(255, 255, 255, 0.849)" h_color="rgb(255, 255, 255)" border_color="rgba(255, 255, 255, 0.328)" hover_border_color="rgb(255, 255, 255)" fs="12px" submit_color="rgb(255, 255, 255)" submit_border_color="rgb(255, 255, 255)" submit_fs="14px" submit_h_color="rgb(0, 0, 0)" submit_hbg_color="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row css=".vc_custom_1533722977061{border-right-width: 2.5vw !important;border-bottom-width: 2.5vw !important;border-left-width: 2.5vw !important;padding-top: 34px !important;padding-bottom: 2px !important;background-color: #73179e !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;border-bottom-color: #ffffff !important;border-bottom-style: solid !important;}"][vc_column offset="vc_col-md-6"][vc_column_text]<span style="font-size: 14px;">© 2018 Ave.</span>[/vc_column_text][ld_spacer][/vc_column][vc_column align="text-left" offset="vc_col-md-6" responsive_align="text-md-right"][ld_custom_menu inline="inline-nav" separator="" use_custom_fonts_menu="true" menu_slug="main-nav" fs="14px" spacing="13"][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 14
	$data = array();
	$data['name'] = esc_html__( 'Footer 14', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer13.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2" align="text-left" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-md-center" css=".vc_custom_1536586277269{margin-bottom: 30px !important;}"][vc_row_inner][vc_column_inner align="text-left" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(24, 27, 49)" fs="16px" fw="700"]Navigation[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="14px" lh="2em"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" align="text-left" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-md-center" css=".vc_custom_1536586282319{margin-bottom: 30px !important;}"][vc_row_inner][vc_column_inner align="text-left" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(24, 27, 49)" fs="16px" fw="700"]Abous Us[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="14px" lh="2em"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" align="text-left" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-md-center" css=".vc_custom_1536586287729{margin-bottom: 30px !important;}"][vc_row_inner][vc_column_inner align="text-left" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(24, 27, 49)" fs="16px" fw="700"]Workflows[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-3" fs="14px" lh="2em"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" align="text-left" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-md-center" css=".vc_custom_1536586292904{margin-bottom: 30px !important;}"][vc_row_inner][vc_column_inner align="text-left" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(24, 27, 49)" fs="16px" fw="700"]Resources[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-4" fs="14px" lh="2em"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1537991304369{padding-top: 70px !important;}"][vc_column align="text-center"][vc_single_image image="4104" img_size="full" alignment="center" css=".vc_custom_1542026331641{margin-bottom: 7px !important;}"][ld_spacer height="35px"][vc_column_text]<span style="font-size: 14px;">© 2018 Ave. All Rights Reserved.</span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 15
	$data = array();
	$data['name'] = esc_html__( 'Footer 15', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer14.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Company[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="16px" lh="2em"][ld_spacer height="66px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Products[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="16px" lh="2em"][ld_spacer height="66px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Products[/ld_fancy_heading][ld_spacer height="15px"][vc_column_text]<span style="font-size: 16px;">hello@ave.com</span>

<span style="font-size: 16px;">290 Maryam Springs 260,</span>
<span style="font-size: 16px;">Courbevoie, Paris, France</span>

<span style="font-size: 16px;">+47 213 5941 295</span>[/vc_column_text][ld_spacer height="66px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Follow us[/ld_fancy_heading][ld_spacer height="15px"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%5D"][ld_spacer height="35px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Subscribe[/ld_fancy_heading][ld_spacer height="15px"][ld_newsletter style="solid" inputs_size="ld-sf--size-xs" inputs_radius="ld-sf--circle" btn_style="solid" btn_display="icon" btn_position="ld-sf--button-inline" i_type="fontawesome" i_add_icon="true" placeholder_text="Your email" i_icon_fontawesome="fa fa-angle-right" txt_color="rgb(115, 122, 128)" bg_color="rgb(255, 255, 255)" txt_f_color="rgb(0, 0, 0)" btn_txt_color="rgb(0, 0, 0)" btn_bg_color="rgb(255, 199, 10)" hover_btn_txt_color="rgb(61, 89, 232)" hover_btn_bg_color="rgb(255, 255, 255)"][ld_spacer height="66px"][/vc_column][/vc_row][vc_row css=".vc_custom_1534864747094{border-top-width: 1px !important;padding-top: 35px !important;padding-bottom: 35px !important;border-top-color: rgba(255,255,255,0.17) !important;border-top-style: solid !important;}"][vc_column offset="vc_col-md-6"][ld_custom_menu inline="inline-nav" separator="" use_custom_fonts_menu="true" menu_slug="footer-nav-7" spacing="16" fs="14px"][ld_spacer hide="vc_hidden-lg" md_hide="vc_hidden-md"][/vc_column][vc_column align="text-left" offset="vc_col-md-6" responsive_align="text-md-right"][vc_column_text]© 2018 Ave theme. Made with love.[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 16
	$data = array();
	$data['name'] = esc_html__( 'Footer 16', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer15.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Company[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="16px" lh="2em"][ld_spacer height="65px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Products[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="16px" lh="2em"][ld_spacer height="65px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Products[/ld_fancy_heading][ld_spacer height="15px"][vc_column_text]<span style="font-size: 16px;">hello@one.com</span>

<span style="font-size: 16px;">290 Maryam Springs 260,</span>
<span style="font-size: 16px;">Courbevoie, Paris, France</span>

<span style="font-size: 16px;">+47 213 5941 295</span>[/vc_column_text][ld_spacer height="65px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Follow us[/ld_fancy_heading][ld_spacer height="15px"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%5D"][ld_spacer height="35px"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]Subscribe[/ld_fancy_heading][ld_spacer height="15px"][ld_newsletter style="solid" inputs_size="ld-sf--size-xs" inputs_radius="ld-sf--circle" btn_style="solid" btn_display="icon" btn_position="ld-sf--button-inline" i_type="fontawesome" i_add_icon="true" placeholder_text="Your email" i_icon_fontawesome="fa fa-angle-right" txt_color="rgb(115, 122, 128)" bg_color="rgb(255, 255, 255)" txt_f_color="rgb(0, 0, 0)" btn_txt_color="rgb(255, 255, 255)" btn_bg_color="rgb(61, 89, 232)" hover_btn_txt_color="rgb(61, 89, 232)" hover_btn_bg_color="rgb(255, 255, 255)"][ld_spacer height="65px"][/vc_column][/vc_row][vc_row css=".vc_custom_1534864747094{border-top-width: 1px !important;padding-top: 35px !important;padding-bottom: 35px !important;border-top-color: rgba(255,255,255,0.17) !important;border-top-style: solid !important;}"][vc_column offset="vc_col-md-6"][ld_custom_menu inline="inline-nav" separator="" use_custom_fonts_menu="true" menu_slug="footer-nav-7" spacing="16" fs="14px"][ld_spacer hide="vc_hidden-lg" md_hide="vc_hidden-md"][/vc_column][vc_column align="text-left" offset="vc_col-md-6" responsive_align="text-md-right"][vc_column_text]© 2018 One theme. Made with love.[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 17 
	$data = array();
	$data['name'] = esc_html__( 'Footer 17', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer16.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1541929276847{margin-top: 0px !important;margin-bottom: 0px !important;padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/2" offset="vc_col-md-4"][ld_images_group_container][ld_images_group_element img_size="83x33" content_align="content-floated-mid-left" image="4517"][/ld_images_group_element][/ld_images_group_container][vc_column_text]Spanish fast-fashion retailer based in store pick up points, the company founded in 1997. Enjoy quality, fashionable from Ave.[/vc_column_text][ld_spacer height="25px"][ld_header_social_icons style="" size="social-icon-lg" scheme="scheme-dark" identities="%5B%7B%22network%22%3A%22fa-pinterest%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="25px"][ld_spacer height="15px"][ld_newsletter style="underlined" inputs_size="ld-sf--size-sm" btn_style="naked" btn_display="icon" btn_position="ld-sf--button-inside" i_type="fontawesome" use_custom_fonts_input="true" i_add_icon="true" placeholder_text="Enter your email address" i_icon_fontawesome="fa fa-angle-right" txt_color="rgb(0, 0, 0)" brd_color="rgb(0, 0, 0)" btn_txt_color="rgb(0, 0, 0)" fs="15px" brd_f_color="rgb(215, 215, 215)" i_size="17px"][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-3"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="14px" ls="0.15em"]BEST SELLERS[/ld_fancy_heading][ld_spacer height="20px"][ld_woo_products taxonomies="men"][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="13px" ls="0.15em"]STORE[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-1" fs="15px" fw="500" ls="0.025em" lh="2.5em"][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][ld_fancy_heading tag="h3" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="14px" ls="0.15em"]CUSTOMER SERVICE[/ld_fancy_heading][ld_spacer height="15px"][ld_custom_menu use_custom_fonts_menu="true" menu_slug="footer-nav-2" fs="15px" fw="500" ls="0.025em" lh="2.5em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footer 18
	$data = array();
	$data['name'] = esc_html__( 'Footer 18', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/footers/footer17.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column align="text-center" offset="vc_col-md-offset-1 vc_col-md-10"][ld_custom_menu inline="inline-nav" separator="" transform="uppercase" use_custom_fonts_menu="true" menu_slug="footer-nav-1" spacing="30" fs="12px" ls="0.1em"][ld_spacer height="85px"][/vc_column][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6"][vc_single_image image="4117" img_size="full"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.746)" fs="14px" fw="500" ls="0.2em"]66 McKenzie Turnpike Apt. 745, Las Vegas, NV[/ld_fancy_heading][ld_spacer height="30px"][ld_fancy_heading tag="h4" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="14px" fw="500" ls="0.2em"]243 594 1295 - hello@avehotel.com[/ld_fancy_heading][ld_spacer height="70px"][ld_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22pinterest%22%2C%22url%22%3A%22%23%22%7D%5D" hover_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Header Category
	//Header 1
	$data = array();
	$data['name'] = esc_html__( 'Header 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header1.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1527937470496{margin-top: 50px !important;padding-right: 85px !important;padding-left: 85px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="40" padding_bottom="40"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed visible="navbar-visible-ontoggle"][ld_header_menu align_items="end" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="16px" fw="700" link_color="rgb(255, 255, 255)" link_hcolor="rgb(255, 255, 255)"][/ld_header_collapsed][ld_header_trigger fill="fill-solid" scheme="scheme-light"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 2
	$data = array();
	$data['name'] = esc_html__( 'Header 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header2.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1542472371857{padding-top: 50px !important;padding-right: 100px !important;padding-left: 100px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes" usestickylogo="yes" padding_top="30" padding_right="0" padding_bottom="30" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu hover_style="linethrough" align_items="end" transform="uppercase" use_theme_fonts="" menu_font="font_family:Teko%3A300%2Cregular|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_menu="true" menu_slug="primary" fs="20px" ls="0.1em" link_color="rgb(255, 255, 255)" link_hcolor="rgb(245, 99, 75)"][/ld_header_collapsed][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 3
	$data = array();
	$data['name'] = esc_html__( 'Header 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header3.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1534316954764{padding-right: 35px !important;padding-left: 35px !important;}"][vc_column header_col_width="col-auto" width="1/3"][ld_header_image uselogo="yes" padding_top="30" padding_right="0" padding_bottom="30" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right"][ld_header_collapsed visible="navbar-visible-ontoggle"][ld_header_menu hover_style="underline-1" align_items="start" use_custom_fonts_menu="true" visible="navbar-visible-ontoggle" menu_slug="primary" fs="33px" lh="1.5em"][/ld_header_collapsed][ld_header_trigger][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 4
	$data = array();
	$data['name'] = esc_html__( 'Header 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header4.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar" css=".vc_custom_1537025817170{padding-top: 6px !important;padding-bottom: 6px !important;background-color: #ffffff !important;}"][vc_column header_col_width="col-auto" width="1/3"][ld_header_iconbox i_type="fontawesome" heading_size="custom" i_size="xs" i_icon_fontawesome="fa fa-phone" title="Phone: + 124 569 89 09" custom_heading_size="14px" i_color="rgb(255, 199, 10)" h_color="rgb(14, 48, 93)"][ld_header_iconbox i_type="fontawesome" heading_size="custom" i_size="xs" i_icon_fontawesome="fa fa-envelope-o" title="Mail: support@ave.com" custom_heading_size="14px" i_color="rgb(255, 199, 10)" h_color="rgb(14, 48, 93)"][ld_header_iconbox i_type="fontawesome" heading_size="custom" i_size="xs" i_icon_fontawesome="fa fa-clock-o" title="Hours: Mon-Fri 8am - 7pm" custom_heading_size="14px" i_color="rgb(255, 199, 10)" h_color="rgb(14, 48, 93)"][ld_header_dropdown source="custom" use_custom_fonts_trigger="true" trigger_label="Italian" items="%5B%7B%22label%22%3A%22French%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22English%22%2C%22url%22%3A%22%23%22%7D%5D" trigger_color="rgb(14, 48, 93)" trigger_fw="600" trigger_fs="14px"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right"][ld_header_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(14, 48, 93, 0.525)" hover_color="rgb(255, 199, 10)"][ld_header_separator left_margin="0" right_margin="0" sep_color="rgba(14, 48, 93, 0.12)"][ld_header_button ib_style="btn-naked" ib_title="Join to Download" ib_i_type="fontawesome" ib_i_add_icon="true" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(14, 48, 93)" ib_fw="600" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075|||"][ld_header_separator left_margin="0" right_margin="0" sep_color="rgba(14, 48, 93, 0.12)"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="35" padding_right="0" padding_bottom="35" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu align_items="end" use_custom_fonts_menu="true" menu_slug="main-nav" fs="16px" link_color="rgba(255, 255, 255, 0.771)" link_hcolor="rgb(255, 255, 255)" fw="500" ls="0.025em"][/ld_header_collapsed][ld_header_search primary_color="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 5
	$data = array();
	$data['name'] = esc_html__( 'Header 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header5.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar" css=".vc_custom_1532507967782{border-bottom-width: 1px !important;border-bottom-color: #edecec !important;border-bottom-style: solid !important;}"][vc_column width="1/3"][ld_header_dropdown source="custom" trigger_label="English" items="%5B%7B%22label%22%3A%22France%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Italian%22%2C%22url%22%3A%22%23%22%7D%5D"][ld_header_iconbox i_type="linea" heading_size="custom" i_size="xs" i_icon_linea="icon-ion-ios-call" title="Phone: +124 569 89 09" custom_heading_size="14px" h_color="rgb(40, 40, 40)"][ld_header_iconbox i_type="linea" heading_size="custom" i_size="xs" i_icon_linea="icon-md-mail" title="Mail: info@one.com" custom_heading_size="14px" h_color="rgb(40, 40, 40)"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right"][ld_header_button ib_style="btn-default" ib_title="Get Early Access" ib_shape="semi-round" ib_size="btn-xsm" ib_color="rgb(239, 239, 239)" ib_hover_color="rgb(216, 65, 148)" ib_text_color="rgb(0, 0, 0)" ib_fs="13px" ib_lh="1.25em"][ld_header_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(157, 157, 157)" hover_color="rgb(0, 0, 0)"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ld_header_image uselogo="yes"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu align_items="end" use_custom_fonts_menu="true" menu_slug="main-nav" link_color="rgb(37, 37, 37)" link_hcolor="rgb(221, 106, 157)" fw="500"][/ld_header_collapsed][ld_header_cart][ld_header_search][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 6
	$data = array();
	$data['name'] = esc_html__( 'Header 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header6.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1527936804713{border-bottom-width: 1px !important;padding-right: 35px !important;padding-left: 35px !important;border-bottom-color: rgba(255,255,255,0.2) !important;border-bottom-style: solid !important;}"][vc_column header_col_width="col-auto" width="1/3" css=".vc_custom_1527936961431{padding-right: 50px !important;}"][ld_header_image uselogo="yes" padding_top="25" padding_bottom="25"][/vc_column][vc_column width="1/3" css=".vc_custom_1542473339438{padding-right: 3% !important;padding-left: 10% !important;}"][ld_header_collapsed][ld_header_menu align_items="start" use_custom_fonts_menu="true" menu_slug="main-nav" fs="16px" fw="700" ls="0.02em" link_color="rgb(255, 255, 255)" link_hcolor="rgb(255, 200, 11)"][/ld_header_collapsed][ld_header_social_icons style="" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-google%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(255, 255, 255)" hover_color="rgb(255, 200, 11)"][/vc_column][vc_column header_col_width="col-auto" width="1/3" align="text-right" responsive_align="text-lg-right" css=".vc_custom_1527936387055{border-left-width: 1px !important;padding-left: 50px !important;border-left-color: rgba(255,255,255,0.2) !important;border-left-style: solid !important;}"][ld_header_text]</p>
<p style="text-align: right; line-height: 1.5em;"><span style="font-size: 14px; color: rgba(255,255,255,0.5); letter-spacing: -0.01em;">Call us for any question </span><br />
<span style="font-size: 24px; color: #ffc80b;"><strong>(213) 5941 295</strong></span></p>
<p>[/ld_header_text][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 7
	$data = array();
	$data['name'] = esc_html__( 'Header 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header7.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1527937892503{padding-right: 35px !important;padding-left: 35px !important;}"][vc_column header_col_width="col-auto" width="1/3"][ld_header_image uselogo="yes" usestickylogo="yes" padding_top="31" padding_right="0" padding_bottom="45" padding_left="0"][/vc_column][vc_column width="1/3" align="text-left" css=".vc_custom_1537773701856{padding-left: 3% !important;}"][ld_header_collapsed][ld_header_menu align_items="start" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="16px" ls="0.05em" link_color="rgb(133, 134, 148)" link_hcolor="rgb(254, 104, 139)" fw="400"][/ld_header_collapsed][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_button ib_style="btn-default" ib_title="Join to Download" ib_transformation="text-uppercase" ib_shape="circle" ib_border="border-thick" ib_fs="12px" ib_fw="600" ib_ls="0.1em" ib_color="rgb(255, 255, 255)" ib_htext_color="rgb(0, 0, 0)" sticky_color="rgb(61, 89, 232)" sticky_text_color="rgb(61, 89, 232)" sticky_htext_color="rgb(255, 255, 255)" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 8
	$data = array();
	$data['name'] = esc_html__( 'Header 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header8.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1531402160111{padding-right: 35px !important;padding-left: 35px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="37" padding_right="0" padding_bottom="37" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu hover_style="underline-1" align_items="end" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="15px" ls="0.025em" link_color="rgba(255, 255, 255, 0.837)" link_hcolor="rgb(255, 255, 255)" color="rgb(255, 255, 255)"][/ld_header_collapsed][ld_header_button ib_style="btn-solid" ib_title="Get early access" ib_shape="circle" ib_size="btn-sm" ib_border="border-thick" ib_enable_row_shadowbox="yes" ib_fs="14px" ib_color="rgb(131, 0, 255)" ib_color2="rgb(29, 225, 209)" ib_hover_color="rgb(29, 225, 209)" ib_hover_color2="rgb(131, 0, 255)" ib_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(0%2C75%2C196%2C0.16)%22%7D%5D" ib_hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2225px%22%2C%22shadow_color%22%3A%22rgba(0%2C173%2C252%2C0.16)%22%7D%5D" ib_css=".vc_custom_1537522871157{padding-right: 0.75em !important;padding-left: 0.75em !important;}" ib_ls="0.025em"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 9
	$data = array();
	$data['name'] = esc_html__( 'Header 09', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header9.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row][vc_column header_col_width="col-auto" width="1/3"][ld_header_image uselogo="yes" usestickylogo="yes" padding_top="31" padding_right="0" padding_bottom="45" padding_left="0"][/vc_column][vc_column width="1/3"][ld_header_collapsed][ld_header_menu align_items="start" transform="uppercase" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="13px" ls="0.05em" link_color="rgba(255, 255, 255, 0.814)" link_hcolor="rgb(255, 255, 255)" fw="700"][/ld_header_collapsed][/vc_column][vc_column width="1/3" align="text-right"][ld_header_text]<span style="color: #ffffff; font-weight: 600; font-size: 13px;">1 BTC = <span style="color: #f58431;">4452.65</span> USD</span>[/ld_header_text][ld_header_button ib_style="btn-default" ib_title="Get a Free Wallet" ib_transformation="text-uppercase" ib_shape="circle" ib_size="btn-sm" ib_fs="13px" ib_fw="700" ib_htext_color="rgb(0, 0, 0)" ib_color="rgb(13, 156, 252)" ib_hover_color="rgb(255, 255, 255)" ib_text_color="rgb(13, 156, 252)" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 10
	$data = array();
	$data['name'] = esc_html__( 'Header 10', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header10.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_full_width="yes" css=".vc_custom_1527934297999{padding-right: 50px !important;padding-left: 50px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes"][/vc_column][vc_column width="1/3"][ld_header_collapsed][ld_header_menu hover_style="underline-1" transform="uppercase" use_custom_fonts_menu="true" menu_slug="main-nav" fs="14px" fw="700" ls="0.1em" link_color="rgba(255, 255, 255, 0.769)" link_hcolor="rgb(255, 255, 255)" color="rgb(255, 255, 255)"][/ld_header_collapsed][/vc_column][vc_column width="1/3" align="text-right"][ld_header_social_icons style="" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-dribbble%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" font_size="17px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 11
	$data = array();
	$data['name'] = esc_html__( 'Header 11', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header11.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row][vc_column header_col_width="col-auto" width="1/3"][ld_header_image uselogo="yes" usestickylogo="yes" padding_top="33" padding_right="0" padding_bottom="40" padding_left="0"][/vc_column][vc_column width="1/3"][ld_header_collapsed][ld_header_menu hover_style="underline-2" align_items="start" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="16px" ls="0.05em" color="rgb(255, 84, 108)" link_color="rgb(255, 255, 255)" link_hcolor="rgb(255, 255, 255)"][/ld_header_collapsed][/vc_column][vc_column width="1/3" align="text-right"][ld_header_button ib_style="btn-default" ib_title="Buy Now" ib_transformation="text-uppercase" ib_size="btn-sm" ib_border="border-thick" ib_fs="13px" ib_fw="700" ib_ls="0.2em" ib_css=".vc_custom_1542537553147{padding-right: 1em !important;padding-left: 1em !important;}" ib_htext_color="rgb(0, 0, 0)" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 12
	$data = array();
	$data['name'] = esc_html__( 'Header 12', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header12.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1536308153116{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column header_col_width="col-auto" width="1/3"][ld_header_image uselogo="yes" usestickylogo="yes" padding_top="31" padding_right="30" padding_bottom="45" padding_left="0"][ld_header_collapsed][ld_header_menu align_items="start" transform="uppercase" use_custom_fonts_menu="true" menu_slug="main-nav" fs="13px" fw="600" ls="0.1em" link_color="rgb(255, 255, 255)" link_hcolor="rgb(250, 124, 49)"][/ld_header_collapsed][/vc_column][vc_column header_col_width="col-auto" width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_menu align_items="end" transform="uppercase" use_custom_fonts_menu="true" menu_slug="main-nav-right" fs="13px" fw="600" ls="0.1em" link_color="rgb(255, 255, 255)" link_hcolor="rgb(250, 124, 49)"][ld_header_button ib_style="btn-default" ib_title="Join to Download" ib_transformation="text-uppercase" ib_border="border-thick" ib_fs="13px" ib_fw="600" ib_ls="0.1em" ib_color="rgb(245, 99, 75)" ib_color2="rgb(254, 148, 24)" ib_css=".vc_custom_1542537236984{margin-left: 30px !important;}" ib_text_color="rgb(245, 99, 75)" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
 
	//Header 13
	$data = array();
	$data['name'] = esc_html__( 'Header 13', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header13.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1542188780955{padding-top: 20px !important;padding-right: 35px !important;padding-left: 35px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes" usestickylogo="yes" padding_top="30" padding_right="0" padding_bottom="30" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu align_items="end" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="16px" fw="700" link_color="rgba(255, 255, 255, 0.746)" link_hcolor="rgb(255, 255, 255)" ls="0.025em"][/ld_header_collapsed][ld_header_spacing height="7"][ld_header_button ib_style="btn-default" ib_title="Early Access" ib_shape="round" ib_size="btn-xsm" ib_color="rgba(255, 255, 255, 0.258)" ib_hover_color="rgb(255, 255, 255)" ib_text_color="rgb(255, 255, 255)" ib_fs="15px" ib_ls="0.01em" ib_htext_color="rgb(0, 0, 0)" ib_css=".vc_custom_1540794267914{padding-right: 0.75em !important;padding-left: 0.75em !important;}" ib_fw="700" sticky_color="rgba(0, 0, 0, 0.238)" sticky_text_color="rgb(0, 0, 0)" sticky_hover_color="rgb(0, 0, 0)" sticky_htext_color="rgb(255, 255, 255)"][ld_header_button ib_style="btn-solid" ib_title="Purchase" ib_shape="round" ib_size="btn-xsm" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(0, 0, 0)" ib_text_color="rgb(0, 0, 0)" ib_fs="15px" ib_ls="0.01em" ib_htext_color="rgb(255, 255, 255)" ib_css=".vc_custom_1540794354528{padding-right: 0.75em !important;padding-left: 0.75em !important;}" ib_fw="700" sticky_color="rgb(0, 0, 0)" sticky_text_color="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 14
	$data = array();
	$data['name'] = esc_html__( 'Header 14', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header14.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1537879783176{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column width="1/3"][ld_header_dropdown source="custom" use_custom_fonts_trigger="true" trigger_label="ENGLISH" items="%5B%7B%22label%22%3A%22French%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Spanish%22%2C%22url%22%3A%22%23%22%7D%5D" trigger_color="rgb(255, 255, 255)" trigger_fs="13px" trigger_ls="0.2em" trigger_fw="500"][/vc_column][vc_column header_col_width="col-auto" width="1/3"][ld_header_collapsed][ld_header_menu hover_style="underline-1" transform="uppercase" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav-left" link_color="rgb(255, 255, 255)" link_hcolor="rgb(255, 255, 255)" fs="13px" ls="0.2em" color="rgb(255, 255, 255)" fw="500"][/ld_header_collapsed][ld_header_image uselogo="yes" alignment="justify-content-lg-center" padding_top="30" padding_right="100" padding_bottom="30" padding_left="100"][ld_header_collapsed][ld_header_menu hover_style="underline-1" transform="uppercase" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav-right" link_color="rgb(255, 255, 255)" link_hcolor="rgb(255, 255, 255)" fs="13px" ls="0.2em" color="rgb(255, 255, 255)" fw="500"][/ld_header_collapsed][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_button ib_style="btn-default" ib_title="Book Now" ib_transformation="text-uppercase" ib_fs="13px" ib_ls="0.2em" ib_color="rgba(255, 255, 255, 0.3)" ib_color2="rgba(255, 255, 255, 0.5)" ib_hover_color="rgb(255, 255, 255)" ib_text_color="rgb(255, 255, 255)" ib_htext_color="rgb(0, 0, 0)" ib_fw="500"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 15
	$data = array();
	$data['name'] = esc_html__( 'Header 15', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header15.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="30" padding_right="0" padding_bottom="30" padding_left="0"][ld_header_text]
<h5><span style="font-size: 16px;">Navigation</span></h5>
[/ld_header_text][ld_header_collapsed][ld_header_menu hover_style="underline-2" use_custom_fonts_menu="true" menu_slug="main-nav-side" link_color="rgb(167, 169, 184)" link_hcolor="rgb(24, 27, 49)" lh="1.8"][/ld_header_collapsed][ld_header_text]
<h5><span style="font-size: 16px;">Get Social</span></h5>
[/ld_header_text][ld_header_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-dribbble%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][ld_header_text]<span style="text-transform: uppercase; font-size: 10px;">© 2018 ONE</span>[/ld_header_text][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 16
	$data = array();
	$data['name'] = esc_html__( 'Header 16', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header16.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar" css=".vc_custom_1529417597259{background-color: #eef0f4 !important;}"][vc_column width="1/3" align="text-left"][ld_header_text]<span style="color: #9ba5c3; font-size: 16px;"><strong><span style="color: #ff8e32;">(733) 255 - 488 </span></strong></span><span style="font-size: 16px; color: #7d849c;">Call us for any question or concern</span>[/ld_header_text][/vc_column][vc_column header_col_width="col-auto" width="1/3"][/vc_column][vc_column width="1/3" align="text-right"][ld_custom_menu inline="inline-nav" separator="" use_custom_fonts_menu="true" menu_slug="menu-top" spacing="20" fs="16px" color="rgb(125, 132, 156)" hcolor="rgb(34, 37, 44)"][/vc_column][/vc_row][vc_row header_type="secondarybar" css=".vc_custom_1529417842507{padding-top: 25px !important;padding-bottom: 25px !important;background-color: #ffffff !important;}"][vc_column width="1/3" align="text-left"][ld_header_image uselogo="yes" padding_top="30" padding_right="0" padding_bottom="30" padding_left="0"][/vc_column][vc_column width="1/3" align="text-right"][ld_header_iconbox i_type="linea" heading_size="custom" i_size="sm" i_icon_linea="icon-ion-ios-call" title="1 (733) 211 - 488" custom_heading_size="17px"][ld_header_separator left_margin="7" right_margin="0" sep_width="1px" sep_color="rgba(0, 0, 0, 0.1)"][/vc_column][vc_column width="1/3" align="text-right"][ld_header_iconbox i_type="linea" heading_size="custom" i_size="xs" i_icon_linea="icon-md-mail-open" title="medical@one.com" custom_heading_size="17px"][ld_header_separator left_margin="7" right_margin="0" sep_width="1px" sep_color="rgba(0, 0, 0, 0.1)"][ld_header_iconbox i_type="linea" heading_size="custom" i_size="xs" i_icon_linea="icon-ion-ios-time" title="6am - 7pm" custom_heading_size="17px"][/vc_column][/vc_row][vc_row css=".vc_custom_1529480829430{background-color: #07268c !important;}"][vc_column width="1/3"][ld_header_collapsed][ld_header_menu align_items="start" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="18px" fw="700" link_color="rgb(255, 255, 255)" link_hcolor="rgb(60, 211, 209)"][/ld_header_collapsed][/vc_column][vc_column header_col_width="col-auto" width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_social_icons style="" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(255, 255, 255, 0.5)" hover_color="rgb(255, 255, 255)" font_size="20px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 17
	$data = array();
	$data['name'] = esc_html__( 'Header 17', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header17.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1531402160111{padding-right: 35px !important;padding-left: 35px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="37" padding_right="0" padding_bottom="37" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu hover_style="underline-1" align_items="end" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="14px" ls="0.025em" link_color="rgba(255, 255, 255, 0.83)" link_hcolor="rgb(255, 255, 255)" color="rgb(255, 255, 255)"][/ld_header_collapsed][ld_header_spacing height="15"][ld_header_button ib_style="btn-solid" ib_title="Join to Download" ib_shape="round" ib_size="btn-sm" ib_border="border-thick" ib_enable_row_shadowbox="yes" ib_fs="14px" ib_color="rgb(2, 135, 237)" ib_color2="rgb(3, 175, 224)" ib_hover_color="rgb(3, 175, 224)" ib_hover_color2="rgb(2, 135, 237)" ib_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(0%2C75%2C196%2C0.3)%22%7D%5D" ib_hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2225px%22%2C%22shadow_color%22%3A%22rgba(0%2C173%2C252%2C0.3)%22%7D%5D" ib_css=".vc_custom_1542537289603{padding-right: 0.75em !important;padding-left: 0.75em !important;}" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 18
	$data = array();
	$data['name'] = esc_html__( 'Header 18', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header18.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row css=".vc_custom_1531467820204{padding-top: 20px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="30" padding_right="0" padding_bottom="30" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu hover_style="linethrough" align_items="end" transform="uppercase" use_custom_fonts_menu="true" menu_slug="main-nav" fs="13px" fw="700" ls="0.15em" link_color="rgb(0, 0, 0)" link_hcolor="rgba(0, 0, 0, 0.75)"][/ld_header_collapsed][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 19
	$data = array();
	$data['name'] = esc_html__( 'Header 19', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header19.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1531402160111{padding-right: 35px !important;padding-left: 35px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="37" padding_right="0" padding_bottom="37" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu hover_style="underline-1" align_items="end" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav" fs="14px" ls="0.025em" link_color="rgba(255, 255, 255, 0.83)" link_hcolor="rgb(255, 255, 255)" color="rgb(255, 255, 255)"][/ld_header_collapsed][ld_header_spacing height="15"][ld_header_button ib_style="btn-solid" ib_title="Join to Download" ib_shape="round" ib_size="btn-sm" ib_border="border-thick" ib_enable_row_shadowbox="yes" ib_fs="14px" ib_color="rgb(2, 135, 237)" ib_color2="rgb(3, 175, 224)" ib_hover_color="rgb(3, 175, 224)" ib_hover_color2="rgb(2, 135, 237)" ib_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%228px%22%2C%22blur_radius%22%3A%2215px%22%2C%22shadow_color%22%3A%22rgba(0%2C75%2C196%2C0.3)%22%7D%5D" ib_hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2225px%22%2C%22shadow_color%22%3A%22rgba(0%2C173%2C252%2C0.3)%22%7D%5D" ib_css=".vc_custom_1542537289603{padding-right: 0.75em !important;padding-left: 0.75em !important;}" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 20
	$data = array();
	$data['name'] = esc_html__( 'Header 20', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header20.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar" header_full_width="yes" css=".vc_custom_1533621156087{margin-right: 30px !important;margin-left: 30px !important;border-bottom-width: 1px !important;padding-top: 2px !important;padding-bottom: 2px !important;border-bottom-color: #ededed !important;border-bottom-style: solid !important;}"][vc_column width="1/3"][ld_header_button ib_style="btn-naked" ib_title="Polo collection is out!" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_add_icon="true" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(0, 0, 0)" ib_hover_color="rgb(189, 158, 107)" ib_fw="500" ib_fs="12px" ib_ls="0.175em"][ld_header_separator][ld_header_button ib_style="btn-naked" ib_title="+0 333 556 789" ib_transformation="text-uppercase" ib_i_type="fontawesome" ib_i_position="left" ib_i_add_icon="true" ib_i_size="15px" ib_color="rgb(0, 0, 0)" ib_hover_color="rgb(189, 158, 107)" ib_fw="500" ib_fs="14px" ib_ls="0.024em" ib_i_icon_fontawesome="fa fa-phone" ib_i_color="rgb(189, 158, 107)" ib_i_margin_right="12px"][ld_header_separator][ld_header_text]<span style="font-weight: 500; color: #434343;">Summer  - Up to 50% Off</span>[/ld_header_text][/vc_column][vc_column width="1/3"][/vc_column][vc_column header_col_width="col-auto" width="1/3" align="text-right"][ld_header_dropdown source="custom" hover_style="ld-dropdown-menu-underlined" use_custom_fonts_trigger="true" trigger_label="ACCOUNT" trigger_fs="12px" trigger_ls="0.185em" items="%5B%7B%22label%22%3A%22Register%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22Login%22%2C%22url%22%3A%22%23%22%7D%5D" trigger_fw="500" trigger_color="rgb(0, 0, 0)" color="rgb(121, 121, 121)" hcolor="rgb(0, 0, 0)"][ld_header_separator][ld_header_button ib_style="btn-naked" ib_title="Find a store" ib_transformation="text-uppercase" ib_color="rgb(0, 0, 0)" ib_hover_color="rgb(189, 158, 107)" ib_fw="500" ib_fs="12px" ib_ls="0.175em"][ld_header_separator][ld_header_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22fa-pinterest%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(0, 0, 0)" hover_color="rgb(189, 158, 107)"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1537976496038{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="18" padding_right="0" padding_bottom="18" padding_left="0"][/vc_column][vc_column width="1/3"][ld_header_collapsed][ld_header_menu use_custom_fonts_menu="true" menu_slug="main-nav" fs="16PX" fw="600" ls="0.02em" link_color="rgb(0, 0, 0)" link_hcolor="rgb(189, 158, 107)"][/ld_header_collapsed][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_dropdown source="custom" hover_style="ld-dropdown-menu-underlined" use_custom_fonts_trigger="true" trigger_label="US" trigger_fs="12px" trigger_ls="0.185em" items="%5B%7B%22label%22%3A%22FR%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22label%22%3A%22IT%22%2C%22url%22%3A%22%23%22%7D%5D" trigger_fw="700" trigger_color="rgb(0, 0, 0)" color="rgb(133, 133, 133)" hcolor="rgb(0, 0, 0)"][ld_header_cart cart_text="Free Delivery on orders over"][ld_header_search][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 21
	$data = array();
	$data['name'] = esc_html__( 'Header 21', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header21.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar" header_full_width="yes" css=".vc_custom_1538081993404{padding-right: 2% !important;padding-left: 2% !important;background-color: rgba(12,62,114,0.08) !important;*background-color: rgb(12,62,114) !important;}"][vc_column width="1/3" align="text-left"][ld_header_dropdown use_custom_fonts_trigger="true" trigger_label="English" menu_slug="languages" trigger_fs="13px" trigger_color="rgb(12, 62, 114)" color="rgb(12, 62, 114)" trigger_ls="0.05em" trigger_fw="500"][ld_header_separator left_margin="0" right_margin="0" sep_width="1px" sep_color="rgb(229, 229, 229)"][ld_header_text]
<p style="text-align: left;"><a href="#"><span style="font-size: 13px; letter-spacing: 0.05em; font-weight: 500;"><span style="color: #0c3e72; line-height: 1em;">Compare and Get Cheap Prices &gt;</span></span></a></p>
[/ld_header_text][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right"][ld_header_text]
<p style="text-align: right;"><span style="font-size: 13px; letter-spacing: 0.05em; font-weight: 500;"><span style="color: #ff7a4b; line-height: 1em;">Popular Destinations &gt;</span></span></p>
[/ld_header_text][ld_header_separator left_margin="5" right_margin="0" sep_width="0"][ld_header_custom_menu cm_inline="inline-nav" cm_use_custom_fonts_menu="true" cm_menu_slug="footer-nav-3" cm_spacing="20" cm_fs="13px" cm_color="rgb(12, 62, 114)" cm_hcolor="rgb(255, 122, 75)" cm_fw="500" cm_ls="0.1px"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1529495395366{margin-right: 2% !important;margin-left: 2% !important;}"][vc_column header_col_width="col-auto" width="1/3" align="text-left"][ld_header_image uselogo="yes" padding_top="26" padding_right="0" padding_bottom="26" padding_left="0"][/vc_column][vc_column width="1/3" css=".vc_custom_1542217501218{padding-right: 5% !important;padding-left: 5% !important;}"][ld_header_collapsed][ld_header_menu hover_style="underline-3" align_items="start" use_custom_fonts_menu="true" menu_slug="main-nav" link_color="rgb(11, 42, 74)" link_hcolor="rgb(255, 122, 75)" color="rgb(255, 122, 75)" fs="14px" ls="0.05em" fw="500"][/ld_header_collapsed][/vc_column][vc_column header_col_width="col-auto" width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_social_icons style="branded-text" size="social-icon-md" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-pinterest%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" font_size="20px"][ld_header_spacing height="7"][ld_header_iconbox i_type="linea" heading_size="xs" i_size="sm" i_icon_linea="icon-ion-ios-call" title="0113 567 8901"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 22
	$data = array();
	$data['name'] = esc_html__( 'Header 22', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header22.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_full_width="yes" css=".vc_custom_1534230932594{padding-right: 35px !important;padding-left: 35px !important;}"][vc_column header_col_width="col-auto" width="1/2"][ld_header_image uselogo="yes" padding_top="30" padding_right="0" padding_bottom="30" padding_left="0"][/vc_column][vc_column width="1/2"][ld_header_collapsed visible="navbar-visible-ontoggle"][ld_header_menu hover_style="underline-1" align_items="end" use_custom_fonts_menu="true" visible="navbar-visible-ontoggle" menu_slug="main-nav" fs="16px"][/ld_header_collapsed][ld_header_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-pinterest%22%2C%22url%22%3A%22%23%22%7D%5D"][ld_header_trigger][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 23
	$data = array();
	$data['name'] = esc_html__( 'Header 23', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header23.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar" css=".vc_custom_1545052912330{border-bottom-width: 1px !important;border-bottom-color: rgba(237,236,236,0.1) !important;border-bottom-style: solid !important;}"][vc_column width="1/3"][ld_header_iconbox i_type="linea" heading_size="custom" i_size="custom" i_icon_linea="icon-ion-ios-call" title="Call: 1 800 459 82" i_color="rgba(255, 250, 250, 0.82)" h_color="rgba(255, 255, 255, 0.74)" custom_heading_size="14px" custom_i_size="15px"][ld_header_button ib_style="btn-naked" ib_title="liquid-themes.com" ib_i_type="linea" ib_i_add_icon="true" ib_link="url:http%3A%2F%2Fave.liquid-themes.com%2F|||" ib_color="rgba(255, 255, 255, 0.7)" ib_hover_color="rgb(255, 255, 255)" ib_fs="14px" ib_i_icon_linea="icon-ion-ios-arrow-dropright-circle" ib_i_margin_left="10px"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right"][ld_header_button ib_style="btn-naked" ib_title="Documentation" ib_link="url:http%3A%2F%2Fave.liquid-themes.com%2F|||" ib_color="rgba(255, 255, 255, 0.7)" ib_hover_color="rgb(255, 255, 255)" ib_fs="14px"][ld_header_button ib_style="btn-naked" ib_title="Help Center" ib_link="url:http%3A%2F%2Fave.liquid-themes.com%2F|||" ib_color="rgba(255, 255, 255, 0.7)" ib_hover_color="rgb(255, 255, 255)" ib_fs="14px"][ld_header_search primary_color="rgba(255, 255, 255, 0.75)" fs="16px"][ld_header_custom_menu cm_menu_slug="language"][ld_header_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-facebook-square%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="17px" primary_color="rgba(255, 255, 255, 0.74)" hover_color="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="27" padding_right="0" padding_bottom="27" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu hover_style="fade-inactive" align_items="end" use_custom_fonts_menu="true" local_scroll="true" menu_slug="primary" fs="15px" link_color="rgb(255, 255, 255)" link_hcolor="rgba(255, 255, 255, 0.85)" ls="0.02em"][/ld_header_collapsed][ld_header_button ib_style="btn-solid" ib_title="Join Us" ib_transformation="text-uppercase" ib_shape="round" ib_size="btn-sm" ib_fs="12px" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" ib_color="rgb(255, 255, 255)" ib_text_color="rgb(49, 49, 49)" ib_css=".vc_custom_1545651266960{border-top-width: 0px !important;border-right-width: 0px !important;border-bottom-width: 0px !important;border-left-width: 0px !important;padding-right: 1em !important;padding-left: 1em !important;}" ib_hover_color="rgb(81, 116, 253)" ib_htext_color="rgb(255, 255, 255)" ib_ls="0.15em" sticky_color="rgb(81, 116, 253)" sticky_hover_color="rgb(58, 58, 58)" sticky_text_color="rgb(255, 255, 255)" sticky_htext_color="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 24
	$data = array();
	$data['name'] = esc_html__( 'Header 24', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header24.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1545660286281{padding-top: 1% !important;padding-right: 2% !important;padding-left: 2% !important;}"][vc_column header_col_width="col-auto" width="1/3"][ld_header_image uselogo="yes" padding_top="31" padding_right="30" padding_bottom="31" padding_left="0"][ld_header_collapsed][ld_header_menu align_items="start" use_custom_fonts_menu="true" menu_slug="primary" fs="15px" fw="500" ls="0.02em" link_color="rgba(255, 255, 255, 0.88)" link_hcolor="rgb(255, 255, 255)"][/ld_header_collapsed][/vc_column][vc_column header_col_width="col-auto" width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_button ib_style="btn-underlined" ib_title="Discover Ave" ib_fs="15px" ib_fw="500" ib_ls="0.03em" ib_color="rgba(255, 255, 255, 0.68)" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" ib_b_color="rgba(255, 255, 255, 0)" ib_b_color2="rgba(255, 255, 255, 0.03)" ib_h_b_color="rgb(255, 255, 255)" ib_hover_color="rgb(255, 255, 255)" sticky_color="rgb(61, 61, 61)" sticky_htext_color="rgb(39, 174, 96)"][ld_header_button ib_style="btn-default" ib_title="Join the community" ib_shape="round" ib_size="btn-sm" ib_fs="15px" ib_fw="500" ib_ls="0.03em" ib_color="rgba(255, 255, 255, 0.29)" ib_text_color="rgb(255, 255, 255)" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" ib_hover_color="rgb(39, 174, 96)" ib_htext_color="rgb(255, 255, 255)" ib_css=".vc_custom_1546433960360{margin-left: 15px !important;}" sticky_color="rgb(39, 174, 96)" sticky_hover_color="rgb(51, 51, 51)" sticky_text_color="rgb(39, 174, 96)" sticky_htext_color="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 25
	$data = array();
	$data['name'] = esc_html__( 'Header 25', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header25.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row][vc_row header_full_width="yes" css=".vc_custom_1545140770955{border-bottom-width: 1px !important;padding-right: 30px !important;padding-left: 30px !important;border-bottom-color: rgba(255,255,255,0.2) !important;border-bottom-style: solid !important;}"][vc_column width="1/3"][ld_header_iconbox i_type="linea" heading_size="custom" i_size="xs" title="Find us: New York, 18C" custom_heading_size="15px" i_color="rgb(255, 255, 255)" h_color="rgba(255, 255, 255, 0.79)" custom_heading_weight="400" i_icon_linea="icon-basic_geolocalize-01"][/vc_column][vc_column header_col_width="col-auto" width="1/3"][ld_header_collapsed][ld_header_menu hover_style="fade-inactive" use_theme_fonts="" menu_font="font_family:Source%20Sans%20Pro%3A200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav-left" link_color="rgba(255, 255, 255, 0.79)" link_hcolor="rgb(255, 255, 255)" fs="16px"][/ld_header_collapsed][ld_header_image uselogo="yes" alignment="justify-content-lg-center" padding_top="30" padding_right="100" padding_bottom="30" padding_left="100"][ld_header_collapsed][ld_header_menu hover_style="fade-inactive" use_theme_fonts="" menu_font="font_family:Source%20Sans%20Pro%3A200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_menu="true" local_scroll="true" menu_slug="main-nav-right" link_color="rgba(255, 255, 255, 0.8)" link_hcolor="rgb(255, 255, 255)" fs="16px"][/ld_header_collapsed][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_social_icons style="" identities="%5B%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="17px" primary_color="rgba(255, 255, 255, 0.61)" hover_color="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header 26
	$data = array();
	$data['name'] = esc_html__( 'Header 26', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/headers/header26.jpg' );
	$data['sort_name'] = 'header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_row header_type="secondarybar" css=".vc_custom_1545139018528{border-bottom-width: 1px !important;border-bottom-color: rgba(38,39,48,0.08) !important;border-bottom-style: solid !important;}"][vc_column width="1/3"][ld_header_text]<span style="font-size: 14px; color: #73747f);">Call: 1 800 459 82</span>[/ld_header_text][ld_header_button ib_style="btn-naked" ib_title="liquid-themes.com" ib_i_type="linea" ib_i_add_icon="true" ib_link="url:http%3A%2F%2Fave.liquid-themes.com%2F|||" ib_color="rgb(115, 116, 127)" ib_fs="14px" ib_i_icon_linea="icon-arrows_right"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right"][ld_header_button ib_style="btn-naked" ib_title="Documentation" ib_link="url:http%3A%2F%2Fave.liquid-themes.com%2F|||" ib_color="rgb(115, 116, 127)" ib_fs="14px"][ld_header_button ib_style="btn-naked" ib_title="Help Center" ib_link="url:http%3A%2F%2Fave.liquid-themes.com%2F|||" ib_color="rgb(115, 116, 127)" ib_fs="14px"][ld_header_custom_menu cm_menu_slug="language"][ld_header_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-facebook-square%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="17px" primary_color="rgb(115, 116, 127)" hover_color="rgb(115, 116, 127)"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ld_header_image uselogo="yes" padding_top="27" padding_right="0" padding_bottom="27" padding_left="0"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3" align="text-right" responsive_align="text-lg-right"][ld_header_collapsed][ld_header_menu hover_style="fade-inactive" align_items="end" use_custom_fonts_menu="true" local_scroll="true" fs="15px" link_color="rgb(77, 77, 85)" link_hcolor="rgb(52, 52, 58)" menu_slug="primary"][/ld_header_collapsed][ld_header_search primary_color="rgb(115, 116, 127)"][ld_header_button ib_style="btn-solid" ib_title="Join Us" ib_shape="round" ib_size="btn-xsm" ib_fs="14px" ib_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fave-responsive-multipurpose-wordpress-theme%2F22854075%3F%26license%3Dregular%26open_purchase_for_item_id%3D22854075||target:%20_blank|" ib_text_color="rgb(255, 255, 255)" ib_css=".vc_custom_1546610002481{border-top-width: 0px !important;border-right-width: 0px !important;border-bottom-width: 0px !important;border-left-width: 0px !important;padding-right: 1em !important;padding-left: 1em !important;}" ib_hover_color="rgb(41, 41, 41)" ib_htext_color="rgb(255, 255, 255)"][/vc_column][/vc_row][vc_row header_type="secondarybar"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][vc_column width="1/3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon Category
	//Icon 1
	$data = array();
	$data['name'] = esc_html__( 'Icon 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon1.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1536752040227{padding-top: 90px !important;padding-bottom: 60px !important;}"][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][vc_row_inner][vc_column_inner width="2/3" offset="vc_col-md-3" css=".vc_custom_1536751938404{padding-left: 15px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="24px" fw="700" margin="bottom_small:0.65em"]<small>[ld_icon icon="icon-liquid_map_pin mr-2 fa-1x"]</small> London[/ld_fancy_heading][vc_column_text]<span style="color: #808291; font-size: 14px;">82 Bernie Greens Apt. 210, Hendon Way, London, UK</span>[/vc_column_text][vc_separator color="custom" align="align_left" el_width="30" accent_color="#f5634b" css=".vc_custom_1536749745674{margin-top: 13px !important;margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #808291; font-size: 14px;">+53 213 5941 295<br />
contact.london@example.com</span>[/vc_column_text][ld_spacer][/vc_column_inner][vc_column_inner width="2/3" offset="vc_col-md-offset-1 vc_col-md-3" css=".vc_custom_1536751987454{padding-left: 15px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="24px" fw="700" margin="bottom_small:0.65em"]<small>[ld_icon icon="icon-liquid_map_pin mr-2 fa-1x"]</small> Paris[/ld_fancy_heading][vc_column_text]<span style="color: #808291; font-size: 14px;">290 Maryam Springs Suite 260, Courbevoie, Paris, France</span>[/vc_column_text][vc_separator color="custom" align="align_left" el_width="30" accent_color="#f5634b" css=".vc_custom_1536749745674{margin-top: 13px !important;margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #808291; font-size: 14px;">+36 213 5941 295<br />
contact.paris@example.com</span>[/vc_column_text][ld_spacer][/vc_column_inner][vc_column_inner width="2/3" offset="vc_col-md-offset-1 vc_col-md-3" css=".vc_custom_1536751993889{padding-left: 15px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="24px" fw="700" margin="bottom_small:0.65em"]<small>[ld_icon icon="icon-liquid_map_pin mr-2 fa-1x"]</small> New York[/ld_fancy_heading][vc_column_text]<span style="color: #808291; font-size: 14px;">21 Valentin Rapids Apt. 335 New Jersey, New York, USA</span>[/vc_column_text][vc_separator color="custom" align="align_left" el_width="30" accent_color="#f5634b" css=".vc_custom_1536749745674{margin-top: 13px !important;margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #808291; font-size: 14px;">+47 213 5941 295<br />
contact.newyork@example.com</span>[/vc_column_text][ld_spacer][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 2
	$data = array();
	$data['name'] = esc_html__( 'Icon 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon2.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="0.5" ca_init_scale_y="0.5" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1529672350265{padding-top: 55px !important;padding-bottom: 40px !important;}" ca_duration="1200"][vc_column width="1/2"][ld_icon_box i_type="image" heading_weight="font-weight-bold" position="iconbox-inline" i_icon_image="57" title="TRANSPORTATION" i_color="rgb(36, 147, 224)"]<span style="font-size: 14px;">Spectacular train rides, breathtaking cable car ascents, overnight cruise ships, scenic day ferries, private first-class motorcoaches.</span>[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2"][ld_icon_box i_type="image" heading_weight="font-weight-bold" position="iconbox-inline" i_icon_image="59" title="SIGHTSEEING" i_color="rgb(36, 147, 224)"]<span style="font-size: 14px;">Our packages include very good guided sightseeing and scenic highlights that reveal the best of your destination.</span>[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2"][ld_icon_box i_type="image" heading_weight="font-weight-bold" position="iconbox-inline" i_icon_image="60" title="PERSONALIZATION" i_color="rgb(36, 147, 224)"]<span style="font-size: 14px;">Whether you’re into art, music, food, wine, history, or whatever, we give you the freedom to truly personalize your trip with optional excursions.</span>[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2"][ld_icon_box i_type="image" heading_weight="font-weight-bold" position="iconbox-inline" i_icon_image="58" title="MEALS" i_color="rgb(36, 147, 224)"]<span style="font-size: 14px;">We include some meals to save you time and money, yet we also leave enough free time so you can sample gastronomic delights on your own.</span>[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2"][ld_icon_box i_type="image" heading_weight="font-weight-bold" position="iconbox-inline" i_icon_image="61" title="ACCOMMODATIONS" i_color="rgb(36, 147, 224)"]<span style="font-size: 14px;">We select hotels with the best guestrooms (always with a private bathroom), service, and food for the money.</span>[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2"][ld_icon_box i_type="image" heading_weight="font-weight-bold" position="iconbox-inline" i_icon_image="62" title="GUIDANCE" i_color="rgb(36, 147, 224)"]<span style="font-size: 14px;">At the heart of every great tour are the friendly, knowledgeable folks who show you around and help you maximize your free time.</span>[/ld_icon_box][ld_spacer height="30px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 3
	$data = array();
	$data['name'] = esc_html__( 'Icon 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon3.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1542966346115{padding-top: 150px !important;padding-bottom: 75px !important;}" ca_duration="1200" ca_delay="180" ca_init_translate_y="60"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2"]Specializing in small things, big things and everything in-between[/ld_fancy_heading][ld_spacer height="80px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="sm" i_icon_image="42" title="Baby Care" i_color="rgb(60, 211, 209)" title_mb="1"]<span style="font-size: 16px;">Treats 1,000+ Infants Each Year</span>[/ld_icon_box][vc_empty_space][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="sm" i_icon_image="47" title="Respiratory Issues" i_color="rgb(197, 115, 236)" title_mb="1"]<span style="font-size: 16px;">100+ Breathing Experts</span>[/ld_icon_box][vc_empty_space][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="sm" i_icon_image="44" title="Cancer Treatment" i_color="rgb(164, 222, 101)" title_mb="1"]<span style="font-size: 16px;">85% Cure Rate for Kids' Cancer</span>[/ld_icon_box][vc_empty_space][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="sm" i_icon_image="49" title="Dental Care" i_color="rgb(241, 166, 126)" title_mb="1"]<span style="font-size: 16px;">100+ Breathing Experts</span>[/ld_icon_box][vc_empty_space][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="sm" i_icon_image="48" title="Fetal Care" i_color="rgb(143, 164, 244)" title_mb="1"]<span style="font-size: 16px;">All types of fetal surgery performed</span>[/ld_icon_box][vc_empty_space][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="sm" i_icon_image="43" title="Brain &amp; Behavior" i_color="rgb(240, 215, 96)" title_mb="1"]<span style="font-size: 16px;">78+ Conditions Treated</span>[/ld_icon_box][vc_empty_space][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="sm" i_icon_image="45" title="Heart Health" i_color="rgb(244, 130, 133)" title_mb="1"]<span style="font-size: 16px;">400+ Successful Heart Transplants</span>[/ld_icon_box][vc_empty_space][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="image" heading_size="sm" i_icon_image="46" title="Endocrinology" i_color="rgb(81, 212, 158)" title_mb="1"]<span style="font-size: 16px;">#8 in the Nation for Endocrinology</span>[/ld_icon_box][vc_empty_space][/vc_column][vc_column align="text-center"][vc_empty_space height="15px"][ld_button style="btn-naked" title="See All Departments" i_type="fontawesome" i_add_icon="true" fs="18px" fw="700" lh="1.25em" i_icon_fontawesome="fa fa-angle-right" i_margin_left="20px" hover_color="rgb(7, 38, 140)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 4
	$data = array();
	$data['name'] = esc_html__( 'Icon 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon4.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="0.5" ca_init_scale_y="0.5" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1539250322145{padding-top: 90px !important;}" responsive_css="margin_top_medium:-90px|padding_top_medium:0px"][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_icon_box i_type="linea" heading_size="md" show_button="yes" fill="yes" ib_style="btn-naked" ib_title="Learn More" ib_i_type="fontawesome" ib_i_add_icon="true" i_icon_linea="icon-basic_webpage_multiple" title="Programs &amp; Services" i_color="rgb(76, 147, 220)" h_color="rgb(76, 147, 220)" fill_color="rgb(220, 233, 246)" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(76, 147, 220)" ib_fs="16px" ib_fw="700" title_mb="8" icon_mb="8" css=".vc_custom_1536756108728{padding-right: 8% !important;padding-left: 8% !important;}"]<span style="font-size: 16px;">State-of-the-art care for children's unique healthcare needs.</span>[/ld_icon_box][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_icon_box i_type="linea" heading_size="md" show_button="yes" fill="yes" ib_style="btn-naked" ib_title="Learn More" ib_i_type="fontawesome" ib_i_add_icon="true" i_icon_linea="icon-basic_pin1" title="Maps &amp; Locations" i_color="rgb(60, 211, 209)" h_color="rgb(60, 211, 209)" fill_color="rgb(219, 241, 241)" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(60, 211, 209)" ib_fs="16px" ib_fw="700" title_mb="8" icon_mb="8" css=".vc_custom_1536756116043{padding-right: 8% !important;padding-left: 8% !important;}"]<span style="font-size: 16px;">Programs &amp; services conveniently located throughout the region.</span>[/ld_icon_box][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_icon_box i_type="linea" heading_size="md" show_button="yes" fill="yes" ib_style="btn-naked" ib_title="Donate Today" ib_i_type="fontawesome" ib_i_add_icon="true" i_icon_linea="icon-ecommerce_gift" title="Make a Gift" i_color="rgb(255, 142, 50)" h_color="rgb(255, 142, 50)" fill_color="rgb(249, 236, 226)" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(255, 142, 50)" ib_fs="16px" ib_fw="700" title_mb="8" icon_mb="8" css=".vc_custom_1536756123313{padding-right: 8% !important;padding-left: 8% !important;}"]<span style="font-size: 16px;">Give us a hand, we can change and save lives, together.</span>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 5
	$data = array();
	$data['name'] = esc_html__( 'Icon 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon24.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1543412417864{padding-top: 90px !important;padding-bottom: 65px !important;}"][vc_column offset="vc_col-md-4" responsive_css="padding_right_medium:15%25|padding_left_medium:15%25"][ld_icon_box i_type="image" heading_size="sm" heading_weight="font-weight-semibold" i_size="lg" i_icon_image="3927" title="Intuitive Visual Editor" icon_mb="35" title_mb="22"]Manage theme settings and take full control over your site.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4" responsive_css="padding_right_medium:15%25|padding_left_medium:15%25"][ld_icon_box i_type="image" heading_size="sm" heading_weight="font-weight-semibold" i_size="lg" i_icon_image="3928" title="Huge Design Collection" title_mb="22" icon_mb="35"]Manage theme settings and take full control over your site.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4" responsive_css="padding_right_medium:15%25|padding_left_medium:15%25"][ld_icon_box i_type="image" heading_size="sm" heading_weight="font-weight-semibold" i_size="lg" i_icon_image="3929" title="One Click Installation" title_mb="22" icon_mb="35"]Manage theme settings and take full control over your site.[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Icon 6
	$data = array();
	$data['name'] = esc_html__( 'Icon 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon5.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1533809548330{padding-top: 90px !important;padding-bottom: 30px !important;background-color: #f0f2f4 !important;}" ca_delay="150" ca_init_translate_y="43" ca_duration="1200"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" transform="text-uppercase" margin="bottom_large:0.15em"]Why Choose AveGym[/ld_fancy_heading][ld_fancy_heading tag="p"]We encourage family involvement, fun, physical fitness and literacy.[/ld_fancy_heading][ld_spacer height="60px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="40" title="PLENTY OF EQUIPMENT" css=".vc_custom_1529397484090{padding-right: 10% !important;padding-left: 10% !important;}" i_color="rgb(245, 99, 75)" i_color2="rgb(254, 148, 24)"]<span style="color: #828593; font-size: 14px;">Each club has a huge range of all types of equipment, from cardio-vascular to weights to functional machines.</span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="42" title="CHANGING ROOMS" css=".vc_custom_1529397506722{padding-right: 10% !important;padding-left: 10% !important;}" i_color="rgb(245, 99, 75)" i_color2="rgb(254, 148, 24)"]<span style="color: #828593; font-size: 14px;">You'll find showers, lockers, hair driers and sockets available.</span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="41" title="PERSONAL TRAINERS" css=".vc_custom_1529397570713{padding-right: 10% !important;padding-left: 10% !important;}" i_color="rgb(245, 99, 75)" i_color2="rgb(254, 148, 24)"]<span style="color: #828593; font-size: 14px;">Our Personal Trainers are on hand to assist you with your training and provide complimentary inductions.</span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="46" title="LADIES ONLY AREAS" css=".vc_custom_1529398746640{padding-right: 10% !important;padding-left: 10% !important;}" i_color="rgb(245, 99, 75)" i_color2="rgb(254, 148, 24)"]<span style="color: #828593;"><span style="font-size: 14px;">For the ladies who prefer training in a ladies only environment these areas are in addition to the main gym.</span> </span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="44" title="WEIGHTS ROOMS" css=".vc_custom_1529398759059{padding-right: 10% !important;padding-left: 10% !important;}" i_color="rgb(245, 99, 75)" i_color2="rgb(254, 148, 24)"]<span style="color: #828593;"><span style="font-size: 14px;">Each club has a wide range of both fixed machines and free weights.</span> </span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="45" title="DAILY CLASSES" css=".vc_custom_1529398771118{padding-right: 10% !important;padding-left: 10% !important;}" i_color="rgb(245, 99, 75)" i_color2="rgb(254, 148, 24)"]<span style="color: #828593;"><span style="font-size: 14px;">All classes are included in membership. Check out your local timetable on the club webpages.</span> </span>[/ld_icon_box][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 7
	$data = array();
	$data['name'] = esc_html__( 'Icon 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon6.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_delay="150" ca_init_translate_y="51" css=".vc_custom_1540583881795{margin-top: 80px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_spacer height="30px"][ld_fancy_heading tag="h2" color="rgb(61, 53, 110)"]Discover the benefits[/ld_fancy_heading][ld_fancy_heading tag="h5" color="rgb(61, 53, 110)"]The Ave Wallet is our solution for an easy to use, fast and effective way to hold your Bitcoin, Ethereum and digital assets.[/ld_fancy_heading][ld_spacer height="75px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 8
	$data = array();
	$data['name'] = esc_html__( 'Icon 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon7.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1539092165387{padding-top: 105px !important;padding-bottom: 105px !important;}"][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-7 vc_col-md-6" ca_init_translate_y="0" ca_init_translate_x="-32" translate_from_y="-50" translate_to_y="166"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" title="About Ave Agency" color="rgb(249, 184, 81)" fs="12px" fw="600" ls="0.2em"]About Ave Agency[/ld_fancy_heading][vc_empty_space height="15px"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" title="Ultimate experiences with story, emotion and purpose" color="rgb(24, 27, 49)" fw="700" fs="42px" lh="1.3em" margin="right_all:22%25"]Ultimate experiences with story, emotion and purpose[/ld_fancy_heading][vc_empty_space height="5px"][vc_row_inner][vc_column_inner width="1/6" offset="vc_hidden-sm vc_hidden-xs"][vc_separator color="custom" accent_color="#fe688b" css=".vc_custom_1527071379204{margin-top: 15px !important;}"][/vc_column_inner][vc_column_inner width="5/6"][ld_fancy_heading tag="p" title="We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic." margin="right_large:10%25"]We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="0.25" ca_init_scale_y="0.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_start_delay="800" ca_delay="100" ca_duration="1200"][vc_row_inner][vc_column_inner align="text-center" css=".vc_custom_1536585637942{margin-top: 12vw !important;}"][ld_icon_box i_type="animated" heading_size="xs" heading_weight="font-weight-semibold" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" i_icon_animated="animated-ecommerce_basket_check" css=".vc_custom_1538065692578{padding-top: 20px !important;padding-right: 30px !important;padding-bottom: 30px !important;padding-left: 30px !important;}" i_color="rgb(254, 104, 139)" h_color="rgb(254, 104, 139)" fill_color="rgb(252, 215, 224)" icon_mb="5" el_class="d-inline-flex"]<strong><span style="font-size: 14px; color: #fe688b;">ECOMMERCE</span></strong>[/ld_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner css=".vc_custom_1536586055471{margin-top: -16vw !important;margin-left: 10% !important;}"][ld_icon_box i_type="animated" heading_size="xs" heading_weight="font-weight-semibold" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" i_icon_animated="animated-basic_display" css=".vc_custom_1536650406493{padding-top: 20px !important;padding-right: 50px !important;padding-bottom: 30px !important;padding-left: 50px !important;}" i_color="rgb(61, 89, 232)" h_color="rgb(61, 89, 232)" fill_color="rgb(221, 225, 248)" el_class="d-inline-flex" icon_mb="5"]<span style="color: #3d59e8;"><strong><span style="font-size: 14px;">UI / UX</span></strong></span>[/ld_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner css=".vc_custom_1536586002740{margin-top: -16.5vw !important;margin-left: 60% !important;}"][ld_icon_box i_type="animated" heading_size="xs" heading_weight="font-weight-semibold" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" i_icon_animated="animated-basic_elaboration_browser_check" css=".vc_custom_1538065730082{padding-top: 20px !important;padding-right: 40px !important;padding-bottom: 30px !important;padding-left: 40px !important;}" i_color="rgb(40, 213, 167)" h_color="rgb(40, 213, 167)" fill_color="rgb(199, 247, 234)" icon_mb="5" el_class="d-inline-flex"]<span style="color: #28d5a7;"><strong><span style="font-size: 14px;">BRANDING</span></strong></span>[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 9
	$data = array();
	$data['name'] = esc_html__( 'Icon 09', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon8.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1542048708553{padding-top: 50px !important;padding-bottom: 20px !important;}" ca_duration="1200" ca_delay="180" ca_init_translate_y="47"][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1542008463891{padding-right: 5% !important;padding-left: 5% !important;}"][ld_icon_box i_type="linea" heading_size="sm" i_size="xl" i_icon_linea="icon-ion-ios-color-filter" title="No rocket science" i_color="rgb(255, 186, 131)" i_color2="rgb(255, 165, 205)" icon_mb="15"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1542008532111{padding-right: 5% !important;padding-left: 5% !important;}"][ld_icon_box i_type="linea" heading_size="sm" i_size="xl" i_icon_linea="icon-ion-ios-tv" title="Blazing Performance" i_color="rgb(255, 186, 131)" i_color2="rgb(255, 165, 205)" icon_mb="15" css=".vc_custom_1542008470979{padding-right: 5% !important;padding-left: 5% !important;}"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1542008477872{padding-right: 5% !important;padding-left: 5% !important;}"][ld_icon_box i_type="linea" heading_size="sm" i_size="xl" i_icon_linea="icon-ion-ios-rocket" title="Unlimited Layouts" i_color="rgb(255, 186, 131)" i_color2="rgb(255, 165, 205)" icon_mb="15"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1542008499150{padding-right: 5% !important;padding-left: 5% !important;}"][ld_icon_box i_type="linea" heading_size="sm" i_size="xl" i_icon_linea="icon-ion-ios-gift" title="Simple Pricing" i_color="rgb(255, 186, 131)" i_color2="rgb(255, 165, 205)" icon_mb="15"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1542008513106{padding-right: 5% !important;padding-left: 5% !important;}"][ld_icon_box i_type="linea" heading_size="sm" i_size="xl" i_icon_linea="icon-ion-ios-contacts" title="Ready to rock?" i_color="rgb(255, 186, 131)" i_color2="rgb(255, 165, 205)" icon_mb="15"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1542008521611{padding-right: 5% !important;padding-left: 5% !important;}"][ld_icon_box i_type="linea" heading_size="sm" i_size="xl" i_icon_linea="icon-ion-ios-help-buoy" title="Free updates" i_color="rgb(255, 186, 131)" i_color2="rgb(255, 165, 205)" icon_mb="15"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][ld_spacer height="30px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 10
	$data = array();
	$data['name'] = esc_html__( 'Icon 10', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon9.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1542966980235{padding-top: 75px !important;padding-bottom: 75px !important;}"][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-sm-offset-2" ca_init_translate_y="50"][ld_fancy_heading tag="h2"]Inspired design for the digital age[/ld_fancy_heading][ld_fancy_heading tag="p" margin="right_desktop:25%25|left_desktop:25%25|right_mobile:2%25|left_mobile:2%25"]We’re passionate about solving problems through creative communications.[/ld_fancy_heading][vc_empty_space height="60px"][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_init_translate_y="35" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_translate_z="0" ca_init_rotate_z="0" ca_duration="1200" ca_delay="150"][vc_column_inner width="5/6" offset="vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-1"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="sm" heading_weight="font-weight-semibold" position="iconbox-side" fill="yes" border_radius="iconbox-round" hover_fill="yes" shadow="iconbox-shadow" i_icon_animated="animated-arrows_glide" title="Newest technology" hover_fill_color="linear-gradient(60deg, rgb(131,11,176) 0%, #ba00ff 100%)" i_color="#830bb0" i_color2="#ba00ff" h_i_color="#ffffff" fill_color="rgb(255, 255, 255)"]Produce the highest quality work and services for every client, on every project[/ld_icon_box][/vc_column_inner][vc_column_inner width="5/6" offset="vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-1"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="sm" heading_weight="font-weight-semibold" position="iconbox-side" fill="yes" border_radius="iconbox-round" hover_fill="yes" shadow="iconbox-shadow" i_icon_animated="animated-basic_pencil_ruler" title="Attention to details" hover_fill_color="linear-gradient(60deg, rgb(131, 11, 176) 0%, #ba00ff 100%)" i_color="#830bb0" i_color2="#ba00ff" h_i_color="#ffffff" fill_color="#ffffff" animation_delay="300"]Produce the highest quality work and services for every client, on every project[/ld_icon_box][/vc_column_inner][vc_column_inner width="5/6" offset="vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-1"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="sm" heading_weight="font-weight-semibold" position="iconbox-side" fill="yes" border_radius="iconbox-round" hover_fill="yes" shadow="iconbox-shadow" i_icon_animated="animated-basic_world" title="Proven worldwide" hover_fill_color="linear-gradient(60deg, rgb(131, 11, 176) 0.6369426751592356%, #ba00ff 100%)" i_color="#830bb0" i_color2="#ba00ff" h_i_color="#ffffff" fill_color="#ffffff"]Produce the highest quality work and services for every client, on every project[/ld_icon_box][/vc_column_inner][vc_column_inner width="5/6" offset="vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-1"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="sm" heading_weight="font-weight-semibold" position="iconbox-side" fill="yes" border_radius="iconbox-round" hover_fill="yes" shadow="iconbox-shadow" i_icon_animated="animated-ecommerce_creditcard" title="Honest pricing" hover_fill_color="linear-gradient(60deg, rgb(131, 11, 176) 0.3184713375796178%, #ba00ff 100%)" i_color="#830bb0" i_color2="#ba00ff" h_i_color="#ffffff" fill_color="#ffffff" animation_delay="300"]Produce the highest quality work and services for every client, on every project[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 11
	$data = array();
	$data['name'] = esc_html__( 'Icon 11', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon10.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1542967123204{margin-top: 50px !important;margin-bottom: 80px !important;padding-top: 90px !important;padding-bottom: 30px !important;background-color: #f3f5f6 !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" color="rgb(61, 53, 110)"]Wallet without intermediaries[/ld_fancy_heading][vc_column_text]<span style="font-size: 16px; color: #3d356e;">With the Av wallet you are up and running as soon as it’s installed, no more syncing! And, with 8 second block times you can actually see your transactions occur in real time! No more checking in every 30 minutes to see if your transactions were confirmed. </span>[/vc_column_text][ld_spacer height="50px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1533044057740{padding-right: 20% !important;padding-left: 20% !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_size="xl" i_icon_linea="icon-ecommerce_graph3" title="0% commission" i_color="rgb(245, 132, 49)" h_color="rgb(61, 53, 110)" title_mb="1"]<span style="color: #8589a3;">Zero broker commission</span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1533044063208{padding-right: 20% !important;padding-left: 20% !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_size="xl" i_icon_linea="icon-ecommerce_graph1" title="Low spreads" i_color="rgb(245, 132, 49)" h_color="rgb(61, 53, 110)" title_mb="1"]<span style="color: #8589a3;">Matching engine with spread priority</span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1533044069936{padding-right: 20% !important;padding-left: 20% !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_size="xl" i_icon_linea="icon-basic_signs" title="Guaranteed execution" i_color="rgb(245, 132, 49)" h_color="rgb(61, 53, 110)" title_mb="1"]<span style="color: #8589a3;">Trading at human speed. Best execution guaranteed!</span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1533044084269{padding-right: 20% !important;padding-left: 20% !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_size="xl" i_icon_linea="icon-basic_sheet_pencil" title="Immediate settlement" i_color="rgb(245, 132, 49)" h_color="rgb(61, 53, 110)" title_mb="1"]<span style="color: #8589a3;">Your trade is settled in minutes</span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1533044091761{padding-right: 20% !important;padding-left: 20% !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_size="xl" i_icon_linea="icon-ecommerce_wallet" title="Direct ownership" i_color="rgb(245, 132, 49)" h_color="rgb(61, 53, 110)" title_mb="1"]<span style="color: #8589a3;">Guaranteed by the blockchain</span>[/ld_icon_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4" css=".vc_custom_1533044097340{padding-right: 20% !important;padding-left: 20% !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_size="xl" i_icon_linea="icon-basic_key" title="100% security" i_color="rgb(245, 132, 49)" h_color="rgb(61, 53, 110)" title_mb="1"]<span style="color: #8589a3;">Orders are approved by fingerprint</span>[/ld_icon_box][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 12
	$data = array();
	$data['name'] = esc_html__( 'Icon 12', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon11.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_init_translate_x="0" ca_init_translate_z="0" ca_init_translate_y="43" ca_init_rotate_x="0" ca_duration="1200" ca_delay="150"][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-3 vc_col-md-6 vc_col-sm-offset-1" ca_init_translate_y="55" ca_start_delay="100"][ld_fancy_heading tag="h2" alignment="text-center" init_values="translateY:80,opacity:0" margin="bottom_small:0px"]<span style="color: #3ed2a7;">Amazing</span> features[/ld_fancy_heading][vc_empty_space height="20px"][ld_fancy_heading tag="p" alignment="text-center" use_custom_fonts_title="true" fs="18px" lh="1.5em"]Ave provides a collection of pre-designed pages, carefully crafted elements and easily customizable templates.[/ld_fancy_heading][vc_empty_space height="80px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" i_shape="wavebg" i_icon_animated="animated-software_layout_4boxes" title="No rocket science" i_color="#ffb09f" css=".vc_custom_1532459293806{padding-right: 10% !important;padding-left: 10% !important;}"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][vc_empty_space height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" i_shape="wavebg" i_icon_animated="animated-basic_accelerator" title="Blazing Performance" i_color="#ad78ef" css=".vc_custom_1532459325084{padding-right: 10% !important;padding-left: 10% !important;}" animation_delay="600"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][vc_empty_space height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" i_shape="wavebg" i_icon_animated="animated-basic_webpage_img_txt" title="Unlimited Layouts" i_color="#3ed2a7" css=".vc_custom_1532459312257{padding-right: 10% !important;padding-left: 10% !important;}" animation_delay="300"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][vc_empty_space height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" i_shape="wavebg" i_icon_animated="animated-basic_book_pen" title="Simple Pricing" i_color="#edba57" css=".vc_custom_1532459345906{padding-right: 10% !important;padding-left: 10% !important;}" animation_delay="300"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][vc_empty_space height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" i_shape="wavebg" i_icon_animated="animated-ecommerce_diamond" title="Ready to rock?" i_color="#577eed" css=".vc_custom_1532459364684{padding-right: 10% !important;padding-left: 10% !important;}"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][vc_empty_space height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="animated" animation="yes" i_shape="wavebg" i_icon_animated="animated-basic_life_buoy" title="Free Updates" i_color="#28b5f0" css=".vc_custom_1532459376766{padding-right: 10% !important;padding-left: 10% !important;}" animation_delay="300"]Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue.[/ld_icon_box][vc_empty_space height="30px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 13
	$data = array();
	$data['name'] = esc_html__( 'Icon 13', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon12.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1529672307213{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #0a345f !important;}" ca_duration="1200" ca_init_translate_y="37" ca_init_translate_z="-34" ca_init_rotate_x="-31"][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="2341" title="CALL US FOR MORE INFORMATION" i_color="rgb(36, 147, 224)" h_color="rgb(255, 255, 255)" title_mb="5" icon_mb="5"]<span style="color: #a7a9b8;">0123 567 8901</span>[/ld_icon_box][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="2342" title="REQUEST A FREE BROCHURE" i_color="rgb(36, 147, 224)" h_color="rgb(255, 255, 255)" title_mb="5" icon_mb="5"]<span style="color: #a7a9b8;">It’s Free</span>[/ld_icon_box][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="image" heading_size="xs" heading_weight="font-weight-bold" i_icon_image="2340" title="CREATE YOUR OWN ADVENTURE" i_color="rgb(36, 147, 224)" h_color="rgb(255, 255, 255)" title_mb="5" icon_mb="5"]<span style="color: #a7a9b8;">Book a Tour Today</span>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 14
	$data = array();
	$data['name'] = esc_html__( 'Icon 14', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon13.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1537957389446{margin-top: 60px !important;padding-top: 55px !important;padding-bottom: 50px !important;}" ca_duration="1200" ca_delay="160" ca_init_translate_x="-37"][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" i_shape="circle" i_size="sm" position="iconbox-side" i_border="" i_icon_linea="icon-ion-ios-paper" title="Insight and Analytics" i_color="rgb(255, 255, 255)" shape_color="rgb(14, 48, 93)" shape_hcolor="rgb(255, 199, 10)"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, vel pharetra.</span></p>
<p>[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" i_shape="circle" i_size="sm" position="iconbox-side" i_border="" i_icon_linea="icon-ion-ios-calculator" title="Exceptional Execution" i_color="rgb(255, 255, 255)" shape_color="rgb(14, 48, 93)" shape_hcolor="rgb(255, 199, 10)"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, vel pharetra.</span></p>
<p>[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" i_shape="circle" i_size="sm" position="iconbox-side" i_border="" i_icon_linea="icon-ion-ios-happy" title="Initial Concept Phase" i_color="rgb(255, 255, 255)" shape_color="rgb(14, 48, 93)" shape_hcolor="rgb(255, 199, 10)"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, vel pharetra.</span></p>
<p>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 15
	$data = array();
	$data['name'] = esc_html__( 'Icon 15', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon14.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_direction="backward" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1541318247468{padding-top: 100px !important;padding-bottom: 60px !important;}" ca_duration="1200" ca_delay="200" ca_init_translate_x="35" ca_init_translate_y="35" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0"][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" i_size="sm" position="iconbox-side" i_icon_linea="icon-ion-ios-trending-up" title="Attract Your Visitors" i_color="rgb(221, 106, 157)"]</p>
<p class="p1"><span class="s1">Layouts of One enables you to present the most professional look with stunning and unique designs.</span></p>
<p>[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" i_size="sm" position="iconbox-side" i_icon_linea="icon-software_layers2" title="Latest Modern Technologies" i_color="rgb(221, 106, 157)"]</p>
<p class="p1"><span class="s1">In One, we have used the latest in-browser technologies to bring you the best product. The most up-to-date.</span></p>
<p>[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" i_size="sm" position="iconbox-side" i_icon_linea="icon-basic_paperplane" title="Obsessed with Performance" i_color="rgb(221, 106, 157)"]</p>
<p class="p1"><span class="s1">We have paid extreme attention to coding details as we're obsessed with blazing fast performance. </span></p>
<p>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 16
	$data = array();
	$data['name'] = esc_html__( 'Icon 16', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon15.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1532513514736{padding-top: 90px !important;padding-bottom: 70px !important;}" ca_duration="1200" ca_delay="160" ca_init_translate_y="40"][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="sm" i_size="xl" title="Global Features" i_color="rgb(215, 91, 146)" i_icon_animated="animated-basic_geolocalize-05"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, asaesa vel pharetra.</span></p>
<p>[/ld_icon_box][ld_spacer height="50px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="sm" i_size="xl" title="Events Plugin" i_color="rgb(215, 91, 146)" i_icon_animated="animated-basic_elaboration_calendar_plus"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, asaesa vel pharetra.</span></p>
<p>[/ld_icon_box][ld_spacer height="50px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="sm" i_size="xl" title="In-Browser Technologies" i_color="rgb(215, 91, 146)" i_icon_animated="animated-ecommerce_creditcard"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, asaesa vel pharetra.</span></p>
<p>[/ld_icon_box][ld_spacer height="50px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="sm" i_size="xl" title="Outstanding E-Commerce" i_color="rgb(215, 91, 146)" i_icon_animated="animated-ecommerce_basket_check"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, asaesa vel pharetra.</span></p>
<p>[/ld_icon_box][ld_spacer height="50px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="sm" i_size="xl" title="Super Customizable" i_color="rgb(215, 91, 146)" i_icon_animated="animated-music_record"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, asaesa vel pharetra.</span></p>
<p>[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" heading_size="sm" i_size="xl" title="Smart Support" i_color="rgb(215, 91, 146)" i_icon_animated="animated-basic_elaboration_message_happy"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, asaesa vel pharetra.</span></p>
<p>[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" heading_size="sm" i_size="xl" title="Insight Analytics" i_color="rgb(215, 91, 146)" i_icon_animated="animated-basic_webpage"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, asaesa vel pharetra.</span></p>
<p>[/ld_icon_box][ld_spacer height="30px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" heading_size="sm" i_size="xl" title="Performance-Driven" i_color="rgb(215, 91, 146)" i_icon_animated="animated-basic_cup"]</p>
<p class="p1"><span class="s1">Praesent pharetra risus pharetra orci ultrices, asaesa vel pharetra.</span></p>
<p>[/ld_icon_box][ld_spacer height="30px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 17
	$data = array();
	$data['name'] = esc_html__( 'Icon 17', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon16.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1542967693409{padding-top: 60px !important;padding-bottom: 60px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_y="60"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="40px"]Secure Cryptography[/ld_fancy_heading][ld_spacer height="50px"][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1531990587404{padding-right: 20% !important;padding-left: 15% !important;}"][ld_icon_box i_type="linea" heading_size="sm" alignment="text-left" i_size="xl" i_icon_linea="icon-basic_chronometer" title="Bitcoin improvement proposals" title_mb="0" i_color="rgb(120, 11, 238)" i_color2="rgb(29, 225, 209)" h_color="rgb(29, 25, 82)"]Having a BIP here does not make it a formally accepted standard until its status become.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1531990580962{padding-right: 20% !important;padding-left: 15% !important;}"][ld_icon_box i_type="linea" heading_size="sm" alignment="text-left" i_size="xl" i_icon_linea="icon-basic_elaboration_message_check" title="Transfer request from a digital wallet" title_mb="0" i_color="rgb(120, 11, 238)" i_color2="rgb(29, 225, 209)" h_color="rgb(29, 25, 82)"]Having a BIP here does not make it a formally accepted standard until its status become.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1531990633769{padding-right: 20% !important;padding-left: 15% !important;}"][ld_icon_box i_type="linea" heading_size="sm" alignment="text-left" i_size="xl" i_icon_linea="icon-ecommerce_bag_check" title="The independent individuals and companies" title_mb="0" i_color="rgb(120, 11, 238)" i_color2="rgb(29, 225, 209)" h_color="rgb(29, 25, 82)"]Having a BIP here does not make it a formally accepted standard until its status become.[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 18
	$data = array();
	$data['name'] = esc_html__( 'Icon 18', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon17.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1531997144153{padding-top: 60px !important;padding-bottom: 285px !important;background-image: url(http://cryptocurrency.liquid-themes.com/wp-content/uploads/2018/07/bg-2-min.jpg?id=45) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.498)" fs="12px" ls="0.2em" margin="bottom_large:1.5em"]IDEA OF BLOCKCHAIN[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="40px"]Digital Blockchain[/ld_fancy_heading][/vc_column][/vc_row][vc_row enable_content_animation="yes" ca_init_scale_x="0.5" ca_init_scale_y="0.5" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1532083700759{margin-top: -230px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_y="20" ca_init_rotate_x="0"][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" i_size="xl" fill="yes" border_radius="iconbox-semiround" hover_fill="yes" shadow="iconbox-shadow" i_icon_linea="icon-ecommerce_bag_plus" title="Bitcoin Trade" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" fill_color="rgb(37, 44, 66)" hover_fill_color="rgb(255, 255, 255)" h_i_color="rgb(120, 11, 238)" css=".vc_custom_1538053958748{padding-top: 65px !important;padding-right: 12% !important;padding-bottom: 65px !important;padding-left: 12% !important;}" custom_heading_size="21px" title_mb="20" icon_mb="26" h_hcolor="rgb(30, 22, 102)" hover_text_color="rgba(30, 22, 102, 0.548)" h_i_color2="rgb(29, 225, 209)"]<span style="color: #8482a9;">Bitcoin is designed around the idea cryptography.</span>[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" i_size="xl" fill="yes" border_radius="iconbox-semiround" hover_fill="yes" shadow="iconbox-shadow" i_icon_linea="icon-basic_archive_full" title="Money Transfer" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" fill_color="rgb(37, 44, 66)" hover_fill_color="rgb(255, 255, 255)" h_i_color="rgb(120, 11, 238)" css=".vc_custom_1538057673774{padding-top: 65px !important;padding-right: 12% !important;padding-bottom: 65px !important;padding-left: 12% !important;}" custom_heading_size="21px" title_mb="20" icon_mb="26" h_hcolor="rgb(30, 22, 102)" hover_text_color="rgba(30, 22, 102, 0.548)" h_i_color2="rgb(29, 225, 209)"]<span style="color: #8482a9;">Bitcoin is designed around the idea cryptography.</span>[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" i_size="xl" fill="yes" border_radius="iconbox-semiround" hover_fill="yes" shadow="iconbox-shadow" i_icon_linea="icon-basic_mail_open_text" title="Litecoin Miners" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" fill_color="rgb(37, 44, 66)" hover_fill_color="rgb(255, 255, 255)" h_i_color="rgb(120, 11, 238)" css=".vc_custom_1538057693730{padding-top: 65px !important;padding-right: 12% !important;padding-bottom: 65px !important;padding-left: 12% !important;}" custom_heading_size="21px" title_mb="20" icon_mb="26" h_hcolor="rgb(30, 22, 102)" hover_text_color="rgba(30, 22, 102, 0.548)" h_i_color2="rgb(29, 225, 209)"]<span style="color: #8482a9;">Bitcoin is designed around the idea cryptography.</span>[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" i_size="xl" fill="yes" border_radius="iconbox-semiround" hover_fill="yes" shadow="iconbox-shadow" i_icon_linea="icon-ecommerce_creditcard" title="Decimal Places" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" fill_color="rgb(37, 44, 66)" hover_fill_color="rgb(255, 255, 255)" h_i_color="rgb(120, 11, 238)" css=".vc_custom_1538057706471{padding-top: 65px !important;padding-right: 12% !important;padding-bottom: 65px !important;padding-left: 12% !important;}" custom_heading_size="21px" title_mb="20" icon_mb="26" h_hcolor="rgb(30, 22, 102)" hover_text_color="rgba(30, 22, 102, 0.548)" h_i_color2="rgb(29, 225, 209)"]<span style="color: #8482a9;">Bitcoin is designed around the idea cryptography.</span>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 19
	$data = array();
	$data['name'] = esc_html__( 'Icon 19', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon18.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1532000811417{padding-top: 70px !important;padding-bottom: 70px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(163, 172, 186)" fs="12px" ls="0.2em" margin="bottom_large:1.5em"]IDEA OF USE CREDIT CARDS[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="40px"]Investing in Bitcoins[/ld_fancy_heading][ld_spacer height="90px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" css=".vc_custom_1532000908423{padding-right: 15% !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_x="-35"][ld_icon_box i_type="linea" heading_size="sm" i_size="lg" position="iconbox-side" title="Digital Blockchain" i_color="rgb(106, 44, 229)" i_color2="rgb(99, 195, 210)" h_color="rgb(29, 25, 82)" i_icon_linea="icon-basic_todo_txt"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using crypto.</span>[/ld_icon_box][ld_spacer height="40px"][ld_icon_box i_type="linea" heading_size="sm" i_size="lg" position="iconbox-side" title="Digital Blockchain" i_color="rgb(106, 44, 229)" i_color2="rgb(99, 195, 210)" h_color="rgb(29, 25, 82)" i_icon_linea="icon-ecommerce_creditcard"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using crypto.</span>[/ld_icon_box][ld_spacer height="40px"][ld_icon_box i_type="linea" heading_size="sm" i_size="lg" position="iconbox-side" title="Digital Blockchain" i_color="rgb(106, 44, 229)" i_color2="rgb(99, 195, 210)" h_color="rgb(29, 25, 82)" i_icon_linea="icon-basic_bolt"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using crypto.</span>[/ld_icon_box][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1200" ca_start_delay="400"][vc_single_image image="4001" img_size="full" alignment="center"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1200" ca_delay="150" ca_init_translate_x="35" css=".vc_custom_1532001150337{padding-left: 15% !important;}"][ld_icon_box i_type="linea" heading_size="sm" alignment="text-right" i_size="lg" position="iconbox-side" title="Digital Blockchain" i_color="rgb(106, 44, 229)" i_color2="rgb(99, 195, 210)" h_color="rgb(29, 25, 82)" i_icon_linea="icon-basic_clock"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using crypto.</span>[/ld_icon_box][ld_spacer height="40px"][ld_icon_box i_type="linea" heading_size="sm" alignment="text-right" i_size="lg" position="iconbox-side" title="Digital Blockchain" i_color="rgb(106, 44, 229)" i_color2="rgb(99, 195, 210)" h_color="rgb(29, 25, 82)" i_icon_linea="icon-basic_watch"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using crypto.</span>[/ld_icon_box][ld_spacer height="40px"][ld_icon_box i_type="linea" heading_size="sm" alignment="text-right" i_size="lg" position="iconbox-side" title="Digital Blockchain" i_color="rgb(106, 44, 229)" i_color2="rgb(99, 195, 210)" h_color="rgb(29, 25, 82)" i_icon_linea="icon-ecommerce_wallet"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using crypto.</span>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 20
	$data = array();
	$data['name'] = esc_html__( 'Icon 20', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon19.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542968200152{padding-top: 120px !important;padding-bottom: 30px !important;}"][vc_column][ld_tabs style="s8" use_custom_fonts_nav="true" primary_color="rgb(0, 54, 61)" active_color="rgb(0, 54, 61)" secondary_color="linear-gradient(90deg, rgb(222, 82, 124) 0%, #830bee 100%)" fs="16px"][ld_tab_section title="Design and Development" tab_id="1531726285128-6b3f78d7-fde6"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1531727235394{margin-top: 65px !important;}" ca_duration="1000" ca_delay="180" ca_init_translate_y="31"][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" i_size="xl" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)" i_icon_linea="icon-basic_chronometer"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" heading_size="custom" i_size="xl" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)" i_icon_animated="animated-ecommerce_bag_check"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_webpage_multiple" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_watch" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Mobile Apps" tab_id="ld-1532340773143-1caf41dc-7460"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1531727235394{margin-top: 65px !important;}" ca_duration="1000" ca_delay="180" ca_init_translate_y="31"][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_message_txt" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_message_txt" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_message_txt" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_message_txt" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Digital Consultation" tab_id="ld-1532340772011-31f19673-3ed5"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1531727235394{margin-top: 65px !important;}" ca_duration="1000" ca_delay="180" ca_init_translate_y="31"][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_message_txt" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]<span style="font-size: 15px;">Online chat platform to develop ideas and collaborate easily.</span>[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_message_txt" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_message_txt" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="animated" animation="yes" heading_size="custom" i_size="xl" i_icon_animated="animated-basic_message_txt" title="Chat Integration" custom_heading_size="19px" i_color="rgba(62, 18, 238, 0.645)" i_color2="rgb(231, 142, 142)" icon_mb="20" h_color="rgb(0, 0, 0)"]Online chat platform to develop ideas and collaborate easily.[/ld_icon_box][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 21
	$data = array();
	$data['name'] = esc_html__( 'Icon 21', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon20.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540906196372{padding-top: 30px !important;padding-bottom: 70px !important;}"][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1541184702271{padding-top: 50px !important;padding-right: 5% !important;padding-left: 5% !important;}" ca_duration="1200" ca_start_delay="300" ca_delay="150" ca_init_translate_y="51"][vc_column_inner width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" show_button="yes" i_size="xl" fill="yes" border_radius="iconbox-semiround" hover_fill="yes" scale_bg="iconbox-scale-bg" shadow="iconbox-shadow" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="Payment Options" custom_heading_size="22px" hover_fill_color="rgb(88, 78, 255)" ib_color="rgb(0, 0, 0)" ib_fs="12px" ib_fw="500" ib_ls="0.2em" ib_b_color="rgb(120, 11, 238)" ib_b_color2="rgb(29, 225, 209)" ib_h_b_color="rgb(255, 255, 255)" i_icon_linea="icon-ion-ios-paper"]</p>
<p class="p1">Having a BIP here does not make it a formally accepted standard until its status become.</p>
<p>[/ld_icon_box][/vc_column_inner][vc_column_inner width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" show_button="yes" i_size="xl" fill="yes" border_radius="iconbox-semiround" hover_fill="yes" scale_bg="iconbox-scale-bg" shadow="iconbox-shadow" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="Payment Options" custom_heading_size="22px" hover_fill_color="rgb(88, 78, 255)" ib_color="rgb(0, 0, 0)" ib_fs="12px" ib_fw="500" ib_ls="0.2em" ib_b_color="rgb(120, 11, 238)" ib_b_color2="rgb(29, 225, 209)" ib_h_b_color="rgb(255, 255, 255)" i_icon_linea="icon-md-eye"]</p>
<p class="p1">Having a BIP here does not make it a formally accepted standard until its status become.</p>
<p>[/ld_icon_box][/vc_column_inner][vc_column_inner width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" show_button="yes" i_size="xl" fill="yes" border_radius="iconbox-semiround" hover_fill="yes" scale_bg="iconbox-scale-bg" shadow="iconbox-shadow" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="Payment Options" custom_heading_size="22px" hover_fill_color="rgb(88, 78, 255)" ib_color="rgb(0, 0, 0)" ib_fs="12px" ib_fw="500" ib_ls="0.2em" ib_b_color="rgb(120, 11, 238)" ib_b_color2="rgb(29, 225, 209)" ib_h_b_color="rgb(255, 255, 255)" i_icon_linea="icon-ion-ios-folder-open"]</p>
<p class="p1">Having a BIP here does not make it a formally accepted standard until its status become.</p>
<p>[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 22
	$data = array();
	$data['name'] = esc_html__( 'Icon 22', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon21.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540323183126{padding-top: 90px !important;padding-bottom: 50px !important;}"][vc_column width="1/2" offset="vc_col-md-6"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Brain Storming" shape_hcolor="linear-gradient(295deg, #1de1d1 0.3184713375796178%, rgb(120, 11, 238) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1540322767176{padding-bottom: 30px !important;}" i_icon_animated="animated-basic_elaboration_browser_star"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][ld_icon_box i_type="animated" animation="yes" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Brain Storming" shape_hcolor="linear-gradient(295deg, #1de1d1 0.3184713375796178%, rgb(120, 11, 238) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1540322777762{padding-bottom: 30px !important;}" i_icon_animated="animated-arrows_circle_check"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][ld_icon_box i_type="animated" animation="yes" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Brain Storming" shape_hcolor="linear-gradient(295deg, #1de1d1 0.3184713375796178%, rgb(120, 11, 238) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1540322791024{padding-bottom: 30px !important;}" i_icon_animated="animated-ecommerce_basket_check"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][/vc_column][vc_column width="1/2"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Brain Storming" shape_hcolor="linear-gradient(295deg, #1de1d1 0.3184713375796178%, rgb(120, 11, 238) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1540322767176{padding-bottom: 30px !important;}" i_icon_animated="animated-basic_elaboration_browser_star"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][ld_icon_box i_type="animated" animation="yes" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Brain Storming" shape_hcolor="linear-gradient(295deg, #1de1d1 0.3184713375796178%, rgb(120, 11, 238) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1540322777762{padding-bottom: 30px !important;}" i_icon_animated="animated-arrows_circle_check"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][ld_icon_box i_type="animated" animation="yes" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Brain Storming" shape_hcolor="linear-gradient(295deg, #1de1d1 0.3184713375796178%, rgb(120, 11, 238) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1540322791024{padding-bottom: 30px !important;}" i_icon_animated="animated-ecommerce_basket_check"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 23
	$data = array();
	$data['name'] = esc_html__( 'Icon 23', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon22.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1542058723774{margin-top: 40px !important;margin-bottom: 40px !important;padding-top: 110px !important;padding-bottom: 60px !important;background-color: #f7f8fb !important;}"][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" show_button="yes" i_size="xl" position="iconbox-side" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="No Coding Skills Required" custom_heading_size="19px" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(85, 111, 255)" ib_hover_color="rgb(0, 0, 0)" ib_fs="16px" title_mb="22" i_icon_linea="icon-basic_webpage_multiple" icon_size="50px" i_color="rgb(16, 15, 38)"]<span style="color: #7d7d7d; font-size: 16px; line-height: 24px;">Starting from headers through the footers, every bit of Ave has been engineered for you.</span>[/ld_icon_box][ld_spacer height="" md_height="40px"][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" show_button="yes" i_size="xl" position="iconbox-side" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="Intuitive Visual Editor" custom_heading_size="19px" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(85, 111, 255)" ib_hover_color="rgb(0, 0, 0)" ib_fs="16px" title_mb="22" i_icon_linea="icon-basic_laptop" icon_size="50px" i_color="rgb(16, 15, 38)"]<span style="color: #7d7d7d; font-size: 16px; line-height: 24px;">Forget about limits! Core plugin is the perfect match for Ave. Build and customize your site visually.</span>[/ld_icon_box][ld_spacer height="" md_height="40px"][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" show_button="yes" i_size="xl" position="iconbox-side" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="Online Documentation" custom_heading_size="19px" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(85, 111, 255)" ib_hover_color="rgb(0, 0, 0)" ib_fs="16px" title_mb="22" i_icon_linea="icon-basic_spread_text_bookmark" icon_size="50px" i_color="rgb(16, 15, 38)"]<span style="color: #7d7d7d; font-size: 16px; line-height: 24px;">Documentation is not only a guide for Ave, it is a comprehensive kit fully integrated with the community.</span>[/ld_icon_box][ld_spacer height="" md_height="40px"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" show_button="yes" i_size="xl" position="iconbox-side" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="Attractive Animations" custom_heading_size="19px" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(85, 111, 255)" ib_hover_color="rgb(0, 0, 0)" ib_fs="16px" title_mb="22" i_icon_linea="icon-basic_target" icon_size="50px" i_color="rgb(16, 15, 38)"]<span style="color: #7d7d7d; font-size: 16px; line-height: 24px;">Manage theme settings and take full control over your site. Attraction guaranteed.</span>[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" show_button="yes" i_size="xl" position="iconbox-side" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="SEO Optimized" custom_heading_size="19px" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(85, 111, 255)" ib_hover_color="rgb(0, 0, 0)" ib_fs="16px" title_mb="22" i_icon_linea="icon-ecommerce_bag_search" icon_size="50px" i_color="rgb(16, 15, 38)"]<span style="color: #7d7d7d; font-size: 16px; line-height: 24px;">Help our clients succeed by creating brand identities, digital experiences, and print materials.</span>[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" show_button="yes" i_size="xl" position="iconbox-side" ib_style="btn-naked" ib_title="Learn more" ib_i_type="fontawesome" ib_i_add_icon="true" title="Automatic Updates" custom_heading_size="19px" ib_i_icon_fontawesome="fa fa-angle-right" ib_color="rgb(85, 111, 255)" ib_hover_color="rgb(0, 0, 0)" ib_fs="16px" title_mb="22" i_icon_linea="icon-basic_settings" icon_size="50px" i_color="rgb(16, 15, 38)"]<span style="color: #7d7d7d; font-size: 16px; line-height: 24px;">Smart Dashboard keeps your site up-to-date and fresh. Free for lifetime for Ave users.</span>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 24
	$data = array();
	$data['name'] = esc_html__( 'Icon 24', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon23.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542058644975{padding-top: 130px !important;padding-bottom: 50px !important;}"][vc_column width="1/4" offset="vc_col-md-offset-0 vc_col-md-3 vc_col-sm-offset-2" css=".vc_custom_1541580334139{padding-right: 7% !important;padding-left: 7% !important;}"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="xl" i_border="" shadow="iconbox-icon-shadow" title="Huge Collection" i_color="rgb(41, 54, 92)" shape_color="rgba(255, 255, 255, 0)" i_icon_animated="animated-basic_webpage_multiple" h_i_color="rgb(255, 255, 255)" shape_hcolor="linear-gradient(115deg, rgb(85, 111, 255) 0.6369426751592356%, #ff798e 100%)" title_mb="20"]<span style="font-size: 16px; color: #808080; line-height: 27px;">The latest design trends meet hand-crafted templates in Ave Collection.</span>[/ld_icon_box][/vc_column][vc_column width="1/4" offset="vc_col-md-offset-0 vc_col-md-3 vc_col-sm-offset-2" css=".vc_custom_1541580338775{padding-right: 7% !important;padding-left: 7% !important;}"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="xs" heading_weight="font-weight-semibold" i_shape="circle" i_size="xl" i_border="" shadow="iconbox-icon-shadow" title="Next-Gen Online Store" i_color="rgb(41, 54, 92)" shape_color="rgba(255, 255, 255, 0)" i_icon_animated="animated-ecommerce_bag_plus" h_i_color="rgb(255, 255, 255)" shape_hcolor="linear-gradient(115deg, rgb(85, 111, 255) 0.6369426751592356%, #ff798e 100%)" title_mb="20"]<span style="font-size: 16px; color: #808080; line-height: 27px;">Open a beautiful store, increase your conversion rates and boost your sales.</span>[/ld_icon_box][/vc_column][vc_column width="1/4" offset="vc_col-md-offset-0 vc_col-md-3 vc_col-sm-offset-2" css=".vc_custom_1541580343989{padding-right: 7% !important;padding-left: 7% !important;}"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="xs" heading_weight="font-weight-semibold" i_shape="circle" i_size="xl" i_border="" shadow="iconbox-icon-shadow" title="AI-Powered Support" i_color="rgb(41, 54, 92)" shape_color="rgba(255, 255, 255, 0)" i_icon_animated="animated-basic_elaboration_message_check" h_i_color="rgb(255, 255, 255)" shape_hcolor="linear-gradient(115deg, rgb(85, 111, 255) 0.6369426751592356%, #ff798e 100%)" title_mb="20"]<span style="font-size: 16px; color: #808080; line-height: 27px;">Support, makes your experience faster and more accurate than ever.</span>[/ld_icon_box][/vc_column][vc_column width="1/4"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="xl" i_border="" shadow="iconbox-icon-shadow" title="Smart Installation Tools" i_color="rgb(41, 54, 92)" shape_color="rgba(255, 255, 255, 0)" i_icon_animated="animated-basic_settings" h_i_color="rgb(255, 255, 255)" shape_hcolor="linear-gradient(115deg, rgb(85, 111, 255) 0.6369426751592356%, #ff798e 100%)" title_mb="20"]<span style="font-size: 16px; color: #808080; line-height: 27px;">Tools are beyond the one-click install, async tech merges with ultimate flexibility.</span>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 25
	$data = array();
	$data['name'] = esc_html__( 'Icon 25', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon25.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" enable_overlay="yes" css=".vc_custom_1546439058345{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(http://opus-four.liquid-themes.com/wp-content/uploads/2019/01/img-2-min.jpg?id=6886) !important;}" overlay_bg="rgba(255, 255, 255, 0.68)"][vc_column width="1/2" offset="vc_col-md-6"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Install Ave in 1 minute" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1546273312086{padding-bottom: 30px !important;}" i_icon_linea="icon-num-1" icon_size="24px" shape_hcolor="rgb(248, 96, 116)"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Customize the pages as you like" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1546273356859{padding-bottom: 30px !important;}" i_icon_linea="icon-num-2" icon_size="24px" shape_hcolor="rgb(248, 96, 116)"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" title="Launch your site in minutes" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1546273351639{padding-bottom: 30px !important;}" i_icon_linea="icon-num-3" icon_size="24px" shape_hcolor="rgb(248, 96, 116)"]All transactions that occur on Envato Market be in U.S. dollars. If your Paypal account or funding.[/ld_icon_box][/vc_column][vc_column width="1/2" align="text-center" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25"][ld_images_group_container][ld_images_group_element img_size="50%" enable_roudness="yes" image_roudness="4" image="http://opus-four.liquid-themes.com/wp-content/uploads/2019/01/iphone.jpg"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 26
	$data = array();
	$data['name'] = esc_html__( 'Icon 26', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon26.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" content_placement="top" responsive_css="padding_right_medium:7%25|padding_left_medium:7%25" css=".vc_custom_1546272026497{margin-top: 100px !important;}"][vc_column width="1/2"][ld_images_group_container][ld_images_group_element enable_image_shadow="yes" shadow_style="1" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="http://opus-three.liquid-themes.com/wp-content/uploads/2018/12/opus-2-tabs-4.jpg"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column width="1/2" responsive_css="padding_left_medium:15%25" css=".vc_custom_1546272055953{padding-top: 7% !important;}"][ld_carousel columns="xs:1|spacing_xs:15px" inactiv_opacity="1" pagenationdots="yes" wraparound="yes" autoplay="yes" align_dots="carousel-dots-left" size_dots="carousel-dots-sm" dots_bottom_offset="-50px" dots_left_offset="23px" dots_style="carousel-dots-style4" dots_bg_color="rgba(134, 147, 158, 0.2)" controllingcarousels="#img-carousel-1, #img-carousel-2" dots_bg_hcolor="rgb(39, 174, 96)"][vc_row_inner gap="0"][vc_column_inner][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:0.9em"]Great things in business are never done by one person.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(136, 136, 136)" fs="17px" lh="29px" margin="bottom_small:1.75em"]Complete Design Toolkit – huge collection of elements, rich customization options, flexible layouts, and instant results![/ld_fancy_heading][ld_button style="btn-naked" title="Learn more" fs="16px"][/vc_column_inner][/vc_row_inner][vc_row_inner gap="0"][vc_column_inner][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:0.9em"]Forget about design limits! Build and customize your site visually.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(136, 136, 136)" fs="17px" lh="29px" margin="bottom_small:1.75em"]Being the savage's business, that is, the person see pulled You have seen Italian organ boys holding a dancing.[/ld_fancy_heading][ld_button style="btn-naked" title="Learn more" fs="16px"][/vc_column_inner][/vc_row_inner][vc_row_inner gap="0"][vc_column_inner][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:0.9em"]Forget about design limits! Build and customize your site visually.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(136, 136, 136)" fs="17px" lh="29px" margin="bottom_small:1.75em"]Being the savage's business, that is, the person see pulled You have seen Italian organ boys holding a dancing.[/ld_fancy_heading][ld_button style="btn-naked" title="Learn more" fs="16px"][/vc_column_inner][/vc_row_inner][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 27
	$data = array();
	$data['name'] = esc_html__( 'Icon 27', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon27.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="0" equal_height="yes" content_placement="middle" css=".vc_custom_1546265126458{background-color: #f7f9fb !important;}" el_id="services"][vc_column enable_content_animation="yes" ca_init_scale_x="1.25" ca_init_scale_y="1.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vw|padding_bottom_medium:0px|padding_left_medium:10vw" css=".vc_custom_1545209792415{padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="46"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="40px" lh="1.2em" margin="bottom_small:1.5em"]Exploration Driven. Delivery focused.[/ld_fancy_heading][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="custom" heading_weight="font-weight-normal" alignment="text-left" i_size="lg" position="iconbox-side" title="Automatic Updates" custom_heading_size="20px" css=".vc_custom_1546877287903{margin-bottom: 2.5em !important;}" i_icon_animated="animated-ecommerce_basket_plus" i_color="rgb(39, 174, 96)"]Smart Dashboard keeps your site up-to-date. Free for lifetime. Try it yourself![/ld_icon_box][vc_separator color="custom" accent_color="#ebebeb"][ld_icon_box i_type="animated" animation="yes" hover_animation="yes" heading_size="custom" heading_weight="font-weight-normal" alignment="text-left" i_size="lg" position="iconbox-side" title="SEO Friendly" custom_heading_size="20px" css=".vc_custom_1546609821742{margin-bottom: 2.5em !important;}" i_icon_animated="animated-basic_laptop" i_color="rgb(39, 174, 96)"]The best SEO practices to achieve higher rankings on Google. Be better![/ld_icon_box][/vc_column][vc_column offset="vc_col-lg-6" css=".vc_custom_1546961711816{background-image: url(http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/opus-3-service1_0474b5bbcfd5da85ae57400435edb37f.jpg?id=4298) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/opus-3-service1_0474b5bbcfd5da85ae57400435edb37f.jpg" img_size="full" alignment="center" invisible="yes"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 28
	$data = array();
	$data['name'] = esc_html__( 'Icon 28', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon28.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1547035393833{padding-top: 50px !important;padding-bottom: 90px !important;}"][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" alignment="text-left" i_size="xl" hover_fill="yes" shadow="iconbox-shadow-hover" title="Automatic Updates" title_mb="0" h_color="rgb(26, 28, 38)" css=".vc_custom_1547205022959{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 35px !important;padding-right: 40px !important;padding-bottom: 35px !important;padding-left: 40px !important;border-left-color: #e8e9f1 !important;border-left-style: solid !important;border-right-color: #e8e9f1 !important;border-right-style: solid !important;border-top-color: #e8e9f1 !important;border-top-style: solid !important;border-bottom-color: #e8e9f1 !important;border-bottom-style: solid !important;border-radius: 3px !important;}" hover_bg_image="http://opus.liquid-themes.com/wp-content/uploads/2019/01/opus-3-overlay.jpg" hover_text_color="rgba(255, 255, 255, 0.87)" hover_fill_color="rgba(0, 0, 0, 0.67)" i_icon_linea="icon-basic_laptop"]<span style="font-size: 15px;">Huge collection of elements, rich customization options, flexible layouts, and instant results!</span>[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" alignment="text-left" i_size="xl" hover_fill="yes" shadow="iconbox-shadow-hover" title="Multi-lingual" title_mb="0" h_color="rgb(26, 28, 38)" css=".vc_custom_1547205033971{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 35px !important;padding-right: 32px !important;padding-bottom: 35px !important;padding-left: 32px !important;border-left-color: #e8e9f1 !important;border-left-style: solid !important;border-right-color: #e8e9f1 !important;border-right-style: solid !important;border-top-color: #e8e9f1 !important;border-top-style: solid !important;border-bottom-color: #e8e9f1 !important;border-bottom-style: solid !important;border-radius: 3px !important;}" label="Exclusive" hover_bg_image="http://opus.liquid-themes.com/wp-content/uploads/2019/01/opus-1-overlay.jpg" i_icon_linea="icon-basic_globe"]<span style="font-size: 15px;">Huge collection of elements, rich customization options, flexible layouts, and instant results!</span>[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" alignment="text-left" i_size="xl" hover_fill="yes" shadow="iconbox-shadow-hover" title="Online Shopping" title_mb="0" h_color="rgb(26, 28, 38)" css=".vc_custom_1547205063140{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 35px !important;padding-right: 32px !important;padding-bottom: 35px !important;padding-left: 32px !important;border-left-color: #e8e9f1 !important;border-left-style: solid !important;border-right-color: #e8e9f1 !important;border-right-style: solid !important;border-top-color: #e8e9f1 !important;border-top-style: solid !important;border-bottom-color: #e8e9f1 !important;border-bottom-style: solid !important;border-radius: 3px !important;}" hover_bg_image="http://opus.liquid-themes.com/wp-content/uploads/2019/01/opus-2-overlay.jpg" hover_text_color="rgba(255, 255, 255, 0.93)" i_icon_linea="icon-ecommerce_bag_plus"]<span style="font-size: 15px;">Huge collection of elements, rich customization options, flexible layouts, and instant results!</span>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 29
	$data = array();
	$data['name'] = esc_html__( 'Icon 29', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon29.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1545672237042{padding-top: 110px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1545659321487{padding-right: 7% !important;padding-left: 7% !important;}"][ld_fancy_heading tag="h2"]Premium Plugins Included[/ld_fancy_heading][ld_fancy_heading tag="h6" alignment="text-center" use_custom_fonts_title="true" fs="16px" lh="25px" color="rgba(24, 27, 49, 0.502)"]Free lifetime updates, and bonus plugins included in the package![/ld_fancy_heading][ld_spacer height="60px"][/vc_column][/vc_row][vc_row css=".vc_custom_1545672242060{margin-bottom: 120px !important;}"][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" alignment="text-left" show_button="yes" i_size="xl" shadow="iconbox-shadow-hover" ib_style="btn-underlined" ib_title="Learn more" title="Automatic Updates" custom_heading_size="21px" icon_mb="20" ib_b_color="rgba(0, 0, 0, 0.08)" css=".vc_custom_1546979413183{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 12% !important;padding-right: 10% !important;padding-bottom: 12% !important;padding-left: 10% !important;border-left-color: #e8e9f1 !important;border-left-style: solid !important;border-right-color: #e8e9f1 !important;border-right-style: solid !important;border-top-color: #e8e9f1 !important;border-top-style: solid !important;border-bottom-color: #e8e9f1 !important;border-bottom-style: solid !important;}" i_icon_linea="icon-basic_laptop"]Complete Design Toolkit – huge collection of elements, flexible layouts, and instant results![/ld_icon_box][/vc_column][vc_column width="5/6" css=".vc_custom_1546521059761{border-radius: 3px !important;}" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" alignment="text-left" show_button="yes" i_size="xl" shadow="iconbox-shadow-hover" ib_style="btn-underlined" ib_title="Learn more" title="Multi-lingual" custom_heading_size="21px" icon_mb="20" ib_b_color="rgba(0, 0, 0, 0.08)" css=".vc_custom_1546979403150{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 12% !important;padding-right: 10% !important;padding-bottom: 12% !important;padding-left: 10% !important;border-left-color: #e8e9f1 !important;border-left-style: solid !important;border-right-color: #e8e9f1 !important;border-right-style: solid !important;border-top-color: #e8e9f1 !important;border-top-style: solid !important;border-bottom-color: #e8e9f1 !important;border-bottom-style: solid !important;}" i_icon_linea="icon-weather_lightning" label="Exclusive"]Complete Design Toolkit – huge collection of elements, flexible layouts, and instant results![/ld_icon_box][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" alignment="text-left" show_button="yes" i_size="xl" shadow="iconbox-shadow-hover" ib_style="btn-underlined" ib_title="Learn more" title="SEO Friendly" custom_heading_size="21px" icon_mb="20" ib_b_color="rgba(0, 0, 0, 0.08)" css=".vc_custom_1546979421975{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 12% !important;padding-right: 10% !important;padding-bottom: 12% !important;padding-left: 10% !important;border-left-color: #e8e9f1 !important;border-left-style: solid !important;border-right-color: #e8e9f1 !important;border-right-style: solid !important;border-top-color: #e8e9f1 !important;border-top-style: solid !important;border-bottom-color: #e8e9f1 !important;border-bottom-style: solid !important;}" i_icon_linea="icon-basic_globe"]Complete Design Toolkit – huge collection of elements, flexible layouts, and instant results![/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Icon 30
	$data = array();
	$data['name'] = esc_html__( 'Icon 30', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/icons/icon30.jpg' );
	$data['sort_name'] = 'icon';
	$data['custom_class'] = 'general icon';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" bg_position="center center" enable_overlay="yes" css=".vc_custom_1546960875013{padding-top: 100px !important;padding-bottom: 90px !important;background: #1d1e1f url(http://opus.liquid-themes.com/wp-content/uploads/2019/01/opus-1-icons_fffcdbe8ecd84575539decc0bf173d88.jpg?id=7103) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="45" overlay_bg="rgba(0, 0, 0, 0.33)"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h2" color="rgb(255, 255, 255)"]Unlimited layouts, pages, styles, headers, and footers.[/ld_fancy_heading][ld_spacer height="50px"][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1546535939737{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-right: 10% !important;padding-left: 10% !important;border-left-color: rgba(255,255,255,0.15) !important;border-right-color: rgba(255,255,255,0.15) !important;border-top-color: rgba(255,255,255,0.15) !important;border-bottom-color: rgba(255,255,255,0.15) !important;border-radius: 5px !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" i_size="xl" shadow="iconbox-icon-shadow" title="Install Ave" i_color="rgb(255, 255, 255)" h_i_color="rgb(255, 255, 255)" title_mb="20" h_color="rgb(255, 255, 255)" icon_mb="34" css=".vc_custom_1547205078200{padding-top: 15% !important;}" i_icon_linea="icon-basic_settings"]<span style="font-size: 16px; color: #cfcfcf; line-height: 27px;">Forget about design limits! Build and customize your site visually.</span>[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1546536191320{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 12% !important;padding-right: 7% !important;padding-left: 7% !important;border-left-color: rgba(255,255,255,0.17) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.17) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.17) !important;border-top-style: solid !important;border-bottom-color: rgba(255,255,255,0.17) !important;border-bottom-style: solid !important;border-radius: 5px !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" i_size="xl" shadow="iconbox-icon-shadow" title="Customize as you like" i_color="rgb(255, 255, 255)" h_i_color="rgb(255, 255, 255)" title_mb="20" h_color="rgb(255, 255, 255)" icon_mb="34" i_icon_linea="icon-basic_webpage_multiple"]<span style="font-size: 16px; color: #cfcfcf; line-height: 27px;">Forget about design limits! Build and customize your site visually.</span>[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1545122099721{padding-right: 7% !important;padding-left: 7% !important;}"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-normal" i_size="xl" shadow="iconbox-icon-shadow" title="Launch your site" i_color="rgb(255, 255, 255)" h_i_color="rgb(255, 255, 255)" title_mb="20" h_color="rgb(255, 255, 255)" icon_mb="34" css=".vc_custom_1547205115618{padding-top: 15% !important;}" i_icon_linea="icon-basic_flag2"]<span style="font-size: 16px; color: #cfcfcf; line-height: 27px;">Forget about design limits! Build and customize your site visually.</span>[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Category Media
	//Media 1
	$data = array();
	$data['name'] = esc_html__( 'Media 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/medias/media1.jpg' );
	$data['sort_name'] = 'media';
	$data['custom_class'] = 'general media';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ld_spacer height="100px"][ld_fancy_heading tag="h3" alignment="text-center"]Show or hide shadow/icons[/ld_fancy_heading][ld_spacer height="20px"][ld_media columns_gap="0" bottom_gap="0" enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="1" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" media_id="ld-1540215739413-70a5b095-0eb0" color="rgb(255, 255, 255)" overlay_bg="rgba(0, 0, 0, 0.634)"][ld_media_element link_type="iframe" add_icon="yes" icon_type="audio" width="1/6" visible_content="yes" shadow_content="yes" image="5318" link="url:https%3A%2F%2Fw.soundcloud.com%2Fplayer%2F%3Furl%3Dhttps%253A%2F%2Fapi.soundcloud.com%2Ftracks%2F340395695%26color%3D%2523ff5500%26auto_play%3Dfalse%26hide_related%3Dfalse%26show_comments%3Dtrue%26show_user%3Dtrue%26show_reposts%3Dfalse%26show_teaser%3Dtrue%26visual%3Dtrue|||"][ld_media_element link_type="iframe" add_icon="yes" icon_type="audio" width="1/6" shadow_content="yes" image="5317" link="url:https%3A%2F%2Fw.soundcloud.com%2Fplayer%2F%3Furl%3Dhttps%253A%2F%2Fapi.soundcloud.com%2Ftracks%2F340395695%26color%3D%2523ff5500%26auto_play%3Dfalse%26hide_related%3Dfalse%26show_comments%3Dtrue%26show_user%3Dtrue%26show_reposts%3Dfalse%26show_teaser%3Dtrue%26visual%3Dtrue|||"][ld_media_element link_type="iframe" add_icon="yes" icon_type="audio" width="1/6" shadow_content="yes" image="5322" link="url:https%3A%2F%2Fw.soundcloud.com%2Fplayer%2F%3Furl%3Dhttps%253A%2F%2Fapi.soundcloud.com%2Ftracks%2F340395695%26color%3D%2523ff5500%26auto_play%3Dfalse%26hide_related%3Dfalse%26show_comments%3Dtrue%26show_user%3Dtrue%26show_reposts%3Dfalse%26show_teaser%3Dtrue%26visual%3Dtrue|||"][ld_media_element link_type="iframe" add_icon="yes" icon_type="audio" width="1/6" visible_content="yes" shadow_content="yes" image="5321" link="url:https%3A%2F%2Fw.soundcloud.com%2Fplayer%2F%3Furl%3Dhttps%253A%2F%2Fapi.soundcloud.com%2Ftracks%2F340395695%26color%3D%2523ff5500%26auto_play%3Dfalse%26hide_related%3Dfalse%26show_comments%3Dtrue%26show_user%3Dtrue%26show_reposts%3Dfalse%26show_teaser%3Dtrue%26visual%3Dtrue|||"][ld_media_element link_type="iframe" add_icon="yes" icon_type="audio" width="1/6" shadow_content="yes" image="5320" link="url:https%3A%2F%2Fw.soundcloud.com%2Fplayer%2F%3Furl%3Dhttps%253A%2F%2Fapi.soundcloud.com%2Ftracks%2F340395695%26color%3D%2523ff5500%26auto_play%3Dfalse%26hide_related%3Dfalse%26show_comments%3Dtrue%26show_user%3Dtrue%26show_reposts%3Dfalse%26show_teaser%3Dtrue%26visual%3Dtrue|||"][ld_media_element link_type="iframe" add_icon="yes" icon_type="audio" width="1/6" shadow_content="yes" image="5319" link="url:https%3A%2F%2Fw.soundcloud.com%2Fplayer%2F%3Furl%3Dhttps%253A%2F%2Fapi.soundcloud.com%2Ftracks%2F340395695%26color%3D%2523ff5500%26auto_play%3Dfalse%26hide_related%3Dfalse%26show_comments%3Dtrue%26show_user%3Dtrue%26show_reposts%3Dfalse%26show_teaser%3Dtrue%26visual%3Dtrue|||"][/ld_media][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Media 2 
	$data = array();
	$data['name'] = esc_html__( 'Media 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/medias/media2.jpg' );
	$data['sort_name'] = 'media';
	$data['custom_class'] = 'general media';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ld_spacer height="80px"][ld_fancy_heading tag="h3" alignment="text-center"]Adjust columns and spacing[/ld_fancy_heading][ld_spacer height="20px"][ld_media columns_gap="5" bottom_gap="15" enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="1" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" media_id="ld-1540214730720-a3bb03b4-673a" color="rgb(255, 255, 255)" overlay_bg="rgba(0, 0, 0, 0.401)"][ld_media_element add_icon="yes" width="1/4" image="5266" title="Add Title" subtitle="or subtitle"][ld_media_element add_icon="yes" width="1/4" image="5267"][ld_media_element add_icon="yes" width="1/4" image="5268"][ld_media_element add_icon="yes" width="1/4" image="5269"][ld_media_element add_icon="yes" width="1/4" image="5270"][ld_media_element add_icon="yes" width="1/4" image="5271"][ld_media_element add_icon="yes" width="1/4" image="5273"][ld_media_element add_icon="yes" width="1/4" image="5272"][/ld_media][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Media 3
	$data = array();
	$data['name'] = esc_html__( 'Media 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/medias/media3.jpg' );
	$data['sort_name'] = 'media';
	$data['custom_class'] = 'general media';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ld_spacer height="80px"][ld_fancy_heading tag="h3" alignment="text-center"]Unlimited responsive layouts[/ld_fancy_heading][ld_spacer height="20px"][ld_media columns_gap="10" bottom_gap="20" enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="1" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" media_id="ld-1540215447107-9aa42dcf-213f" color="rgb(255, 255, 255)" overlay_bg="linear-gradient(124deg, rgba(255, 101, 48, 0.821) 0.3184713375796178%, rgba(206, 74, 255, 0.832) 99.68152866242038%)"][ld_media_element add_icon="yes" icon_type="plus" image="5300" title="Custom Title" subtitle="or Subtitle"][ld_media_element add_icon="yes" icon_type="plus" image="5301"][ld_media_element add_icon="yes" icon_type="plus" image="5302"][ld_media_element add_icon="yes" icon_type="plus" image="5303"][ld_media_element add_icon="yes" icon_type="plus" image="5305"][ld_media_element add_icon="yes" icon_type="plus" image="5306"][ld_media_element add_icon="yes" icon_type="plus" image="5304"][/ld_media][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Media 4
	$data = array();
	$data['name'] = esc_html__( 'Media 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/medias/media4.jpg' );
	$data['sort_name'] = 'media';
	$data['custom_class'] = 'general media';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ld_spacer height="80px"][ld_fancy_heading tag="h3" alignment="text-center"]Add custom media elements[/ld_fancy_heading][ld_spacer height="20px"][ld_media columns_gap="10" bottom_gap="20" enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="1" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" media_id="ld-1540207915500-298c08e6-2b13"][ld_media_element link_type="video" add_icon="yes" icon_type="video" width="1/2" visible_content="yes" image="5288" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DYleYIoIMj1I|||"][ld_media_element link_type="iframe" add_icon="yes" icon_type="audio" width="1/4" image="5269" link="url:http%3A%2F%2Foriginal.liquid-themes.com%2Fwp-content%2Fuploads%2F2018%2F10%2FDS_BeatF145-01.mp3|||"][ld_media_element add_icon="yes" icon_type="plus" width="1/4" image="5268"][ld_media_element add_icon="yes" icon_type="plus" width="1/4" image="5273"][ld_media_element add_icon="yes" icon_type="plus" width="1/4" image="5267"][/ld_media][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Media 5
	$data = array();
	$data['name'] = esc_html__( 'Media 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/medias/media5.jpg' );
	$data['sort_name'] = 'media';
	$data['custom_class'] = 'general media';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ld_spacer height="100px"][ld_fancy_heading tag="h3" alignment="text-center"]iFrame and Lightbox support[/ld_fancy_heading][ld_spacer height="20px"][ld_media columns_gap="10" bottom_gap="20" enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="1" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" media_id="ld-1539866554963-b5f22642-dcd4" color="rgb(255, 255, 255)" overlay_bg="rgba(0, 0, 0, 0.634)"][ld_media_element link_type="video" add_icon="yes" icon_type="video2" width="1/2" visible_content="yes" shadow_content="yes" image="5325" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DYleYIoIMj1I|||"][ld_media_element link_type="video" add_icon="yes" icon_type="video" width="1/2" visible_content="yes" shadow_content="yes" image="5180" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DYleYIoIMj1I|||"][ld_media_element link_type="video" add_icon="yes" icon_type="video" width="1/2" visible_content="yes" shadow_content="yes" image="5179" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DYleYIoIMj1I|||"][ld_media_element link_type="video" add_icon="yes" icon_type="video2" width="1/2" visible_content="yes" shadow_content="yes" image="5177" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DYleYIoIMj1I|||"][/ld_media][ld_spacer height="100px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Misc
	//Misc 1
	$data = array();
	$data['name'] = esc_html__( 'Misc 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc1.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1532598197563{padding-top: 55px !important;padding-bottom: 55px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_x="-26"][vc_column offset="vc_col-md-4"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_large:0" fs="36px" lh="1.111em"]Awards &amp; Press[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(211, 169, 133)" fs="14px" ls="0.1em" fw="400"]My precious collection[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-7"][vc_column_text]<span style="font-size: 20px; line-height: 25px; font-family: Amiri, serif;">It's always good to receive positive and constructive feedback for your work - from clients and moreover, from designers!</span>[/vc_column_text][ld_spacer height="40px"][vc_row_inner][vc_column_inner offset="vc_col-md-6"][vc_column_text]<span style="color: #a7a9b8;">2017</span>               <img class="alignnone size-full wp-image-569" src="http://original.liquid-themes.com/wp-content/uploads/2018/07/logo-3.png" alt="Image" width="123" height="14" />[/vc_column_text][ld_spacer height="30px"][vc_column_text]<span style="color: #a7a9b8;">2016</span>               <img class="alignnone wp-image-568 size-full" src="http://original.liquid-themes.com/wp-content/uploads/2018/07/logo-2.png" alt="Image" width="116" height="16" />[/vc_column_text][ld_spacer height="30px"][vc_column_text]<span style="color: #a7a9b8;">2015</span>               <img class="alignnone wp-image-567 size-full" src="http://original.liquid-themes.com/wp-content/uploads/2018/07/logo-1.png" alt="Image" width="90" height="15" />[/vc_column_text][ld_spacer height="30px"][vc_column_text]<span style="color: #a7a9b8;">2015</span>               <img class="alignnone wp-image-570 size-full" src="http://original.liquid-themes.com/wp-content/uploads/2018/07/logo.png" alt="Image" width="102" height="24" />[/vc_column_text][ld_spacer height="" hide="vc_hidden-lg" md_hide="vc_hidden-md" sm_height="32px" xs_height="32px"][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(0, 0, 0)" fs="16px" lh="3.5em" margin="top_large:-1em"]Featured Portfolio Websites<br />
Top 10 Design<br />
Website Inspiration<br />
Creative Things[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 2
	$data = array();
	$data['name'] = esc_html__( 'Misc 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc2.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" content_placement="middle" css=".vc_custom_1537951669312{margin-bottom: -1px !important;padding-top: 50px !important;padding-bottom: 50px !important;background: #001028 url(http://original.liquid-themes.com/wp-content/uploads/2018/09/coming-soon-bg.jpg?id=4103) !important;}"][vc_column][vc_row_inner equal_height="yes"][vc_column_inner align="text-center"][vc_single_image image="6532" img_size="full" alignment="center"][ld_spacer height="60px" md_height="30px"][ld_fancy_heading transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="68" fs="100px" lh="1em" fw="700" ls="-0.025em" margin="bottom_small:0.15em"]Coming Soon[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="18" fs="20px" lh="1.5em" ls="0.025em"]We will be back with new and exciting feature![/ld_fancy_heading][/vc_column_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_spacer height="30px" md_height="70px"][ld_countdown month="12" day="31" year="2019" use_custom_typography="true" fs="100px" primary_color="rgb(255, 255, 255)" digits_color="rgb(236, 46, 95)" fw="400"][ld_spacer height="30px" md_height="80px"][/vc_column_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="14px" fw="700" ls="0.1em" margin="bottom_small:1.5em"]Stay tuned for updates[/ld_fancy_heading][ld_newsletter style="solid" inputs_size="ld-sf--size-lg" inputs_radius="ld-sf--round" btn_style="solid" btn_position="ld-sf--button-inside" use_custom_fonts_input="true" use_custom_fonts_label="true" placeholder_text="Email Address" fs="15px" label_fs="16px" label_fw="700" label_ls="0.015em" txt_color="rgb(167, 169, 184)" bg_color="rgb(255, 255, 255)" txt_f_color="rgb(0, 0, 0)" btn_txt_color="rgb(255, 255, 255)" btn_bg_color="rgb(100, 46, 236)" hover_btn_txt_color="rgb(255, 255, 255)" hover_btn_bg_color="rgb(132, 94, 228)"][/vc_column_inner][vc_column_inner align="text-center"][ld_spacer height="30px" md_height="80px"][ld_social_icons style="branded" shape="circle" identities="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-linkedin%22%2C%22url%22%3A%22%23%22%7D%5D"][ld_spacer height="8px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(128, 130, 145)" fs="12px" ls="0.05em"]Copyright 2018 <span style="color: #ffffff;">One</span>. All Rights Reserved.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0"][vc_column][ld_particles absolute_pos="yes" opacity="0.5" enable_random_opacity="yes" enable_anim_opacity="yes" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" enable_attract_move="yes" modes_grab_opacity="0" retina_detect="yes" particle_id="ld-1537513018864-b0e3600c-8634" height="50vh" position="top_small:-75vh|right_small:0px" color="#ffffff" anim_size_min="35" number="150" size="2" move_speed="6" anim_opacity_min="0.25" anim_opacity_speed="0.5" modes_bubble_distance="1" modes_bubble_size="1" modes_bubble_duration="1" modes_grab_distance="0"][ld_particles absolute_pos="yes" opacity="0.65" enable_random_opacity="yes" enable_anim_opacity="yes" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" enable_attract_move="yes" modes_grab_opacity="0" retina_detect="yes" particle_id="ld-1537951722839-27b06d9c-7314" height="50vh" position="top_small:-75vh|right_small:0px" color="#ffffff" anim_size_min="44" number="100" size="2.25" move_speed="4" anim_opacity_min="0.2" anim_opacity_speed="1" modes_bubble_distance="1" modes_bubble_size="1" modes_bubble_duration="1" modes_grab_distance="0"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 3
	$data = array();
	$data['name'] = esc_html__( 'Misc 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc3.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1537546926967{padding-top: 110px !important;padding-bottom: 130px !important;}"][vc_column][le_schedule_table color="#fa7c31" gr_color="#f5634b" gr_color2="#fe9418" title="CLASS SCHEDULE" description="All classes are suitable for both men and women and all levels of fitness welcome."][le_schedule_table_cell day="Monday" title="BootCamp" info="Adrian Holmes" category="Bootcamp" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Monday" from_time="10:00" to_time="12:00" title="Crossfit" info="Logan Park" category="Crossfit" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Monday" from_time="14:00" to_time="16:00" title="Total Body" info="David Richards" category="Total Body" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Monday" from_time="18:00" to_time="20:00" title="Boxercise" info="Jesse Willis" category="Boxercise" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Tuesday" title="Krunch &amp; Kore" info="Katharine Barnes" category="Krunch &amp; Kore" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Tuesday" from_time="14:00" to_time="16:00" title="Spinning" info="Lela Rhodes" category="Spinning" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Tuesday" from_time="16:00" to_time="18:00" title="Krunch &amp; Kore" info="Katharine Barnes" category="Krunch &amp; Kore" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Wednesday" from_time="10:00" to_time="12:00" title="Boxercise" info="Jesse Willis" category="Boxercise" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Wednesday" from_time="14:00" to_time="16:00" title="Energy Blast" info="Marion Miller" category="Energy Blast" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Wednesday" from_time="18:00" to_time="20:00" title="Crossfit" info="Logan Park" category="Crossfit" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Thursday" title="Total Body" info="David Richards" category="Total Body" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Thursday" from_time="14:00" to_time="16:00" title="Krunch &amp; Kore" info="Katharine Barnes" category="Krunch &amp; Kore" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Thursday" from_time="16:00" to_time="18:00" title="Bootcamp" info="Adrian Holmes" category="Bootcamp" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Friday" from_time="10:00" to_time="12:00" title="Spinning" info="Lela Rhodes" category="Spinning" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Friday" from_time="14:00" to_time="16:00" title="Total Body" info="David Richards" category="Total Body" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Friday" from_time="18:00" to_time="20:00" title="Energy Blast" info="Adrian Holmes" category="Energy Blast" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Saturday" from_time="14:00" to_time="16:00" title="Crossfit" info="Logan Park" category="Crossfit" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Saturday" from_time="18:00" to_time="20:00" title="Spinning" info="Lela Rhodes" category="Spinning" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Saturday" from_time="10:00" to_time="12:00" title="BootCamp" info="Adrian Holmes" category="Bootcamp" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell from_time="16:00" to_time="18:00" title="Krunch &amp; Kore" info="Katharine Barnes" category="Krunch &amp; Kore" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell title="Energy Blast" info="Marion Miller" category="Energy Blast" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell from_time="10:00" to_time="12:00" title="BootCamp" info="Adrian Holmes" category="Bootcamp" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][le_schedule_table_cell day="Saturday" from_time="16:00" to_time="18:00" title="Total Body" info="David Richards" category="Total Body" btn_label="Join now" link="url:%23|||"]Boxercise is a fun and energetic routine using boxing moves for all levels of ability.[/le_schedule_table_cell][/le_schedule_table][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 4
	$data = array();
	$data['name'] = esc_html__( 'Misc 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc4.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1537957783867{margin-bottom: 95px !important;padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1532333001793{padding-right: 12% !important;}" ca_init_translate_x="-47" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h2" margin="bottom_small:0.5em"]Ave is better[/ld_fancy_heading][ld_spacer height="25px"][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" i_size="xs" position="iconbox-inline" i_icon_fontawesome="fa fa-check" title="Exceptional Execution for Business" custom_heading_size="18px" i_color="rgb(255, 199, 10)" css=".vc_custom_1538125194770{margin-bottom: 12px !important;}"][/ld_icon_box][ld_spacer height="10px"][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" i_size="xs" position="iconbox-inline" i_icon_fontawesome="fa fa-check" title="Immigration Minister Pledges to Labour" custom_heading_size="18px" i_color="rgb(255, 199, 10)" css=".vc_custom_1538125273164{margin-bottom: 12px !important;}"][/ld_icon_box][ld_spacer height="10px"][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" i_size="xs" position="iconbox-inline" i_icon_fontawesome="fa fa-check" title="Business Insight and Analytics" custom_heading_size="18px" i_color="rgb(255, 199, 10)" css=".vc_custom_1538125267728{margin-bottom: 12px !important;}"][/ld_icon_box][ld_spacer height="10px"][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" i_size="xs" position="iconbox-inline" i_icon_fontawesome="fa fa-check" title="Initial Concept and Design Phase" custom_heading_size="18px" i_color="rgb(255, 199, 10)" css=".vc_custom_1538125279973{margin-bottom: 12px !important;}"][/ld_icon_box][ld_spacer height="25px"][ld_header_button ib_style="btn-default" ib_title="Get a quote" ib_link_type="scroll_to_section" ib_shape="semi-round" ib_size="btn-sm" ib_border="border-thick" ib_i_type="fontawesome" ib_i_add_icon="true" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="15px" ib_css=".vc_custom_1538124054963{padding-right: 1em !important;padding-left: 1em !important;}" ib_color="rgb(14, 48, 93)" ib_lh="1.85em" ib_fw="600"][ld_spacer md_height="0"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1.25" ca_init_scale_y="1.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1532332993199{padding-right: 15px !important;padding-left: 15px !important;}"][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner enable_column_shadowbox="yes" align="text-center" css=".vc_custom_1532327141090{padding-top: 25px !important;padding-right: 55px !important;padding-bottom: 25px !important;padding-left: 55px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%2221px%22%2C%22shadow_color%22%3A%22rgba(128%2C%20152%2C%20213%2C%200.19)%22%7D%5D"][vc_line_chart values="%5B%7B%22title%22%3A%22One%22%2C%22y_values%22%3A%2210%3B%2015%3B%2020%3B%2025%3B%2027%3B%2025%3B%2023%3B%2025%22%2C%22color%22%3A%22blue%22%7D%2C%7B%22title%22%3A%22Two%22%2C%22y_values%22%3A%2225%3B%2018%3B%2016%3B%2017%3B%2020%3B%2025%3B%2030%3B%2035%22%2C%22color%22%3A%22pink%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 5
	$data = array();
	$data['name'] = esc_html__( 'Misc 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc5.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1542965612330{padding-top: 55px !important;padding-bottom: 70px !important;}"][vc_column][ld_instagram limit="10" images_per_row="5" columns_gap="" stretch="yes"][/vc_column][/vc_row][vc_row full_height="yes" parallax="enable_parallax" enable_loading_bg="yes" css=".vc_custom_1542441026426{padding-top: 155px !important;padding-bottom: 170px !important;background-image: url(http://travel.liquid-themes.com/wp-content/uploads/2018/11/travel-2.jpg?id=4273) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-2 vc_col-lg-8" ca_duration="1600" ca_delay="160" ca_init_translate_y="121" ca_init_translate_z="-142" ca_init_rotate_x="-85"][ld_fancy_heading tag="h6" transform="text-uppercase" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="14px" ls="0.2em" ca_init_translate_x="0" delay="150" ca_init_translate_y="43" ca_init_rotate_z="5"]Spring Package[/ld_fancy_heading][ld_images_group_container][ld_images_group_element img_size="60%" image="4223"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" color="rgb(255, 255, 255)"]The Perfect Summer Escape just from £99[/ld_fancy_heading][ld_spacer height="30px"][vc_row_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1"][ld_button style="btn-solid" title="Book Your Holiday" transformation="text-uppercase" shape="semi-round" hover_color="rgb(255, 122, 75)" fs="14px" fw="700" ls="0.1em" css=".vc_custom_1542231498313{padding-right: 6px !important;padding-left: 6px !important;}" color="rgb(36, 147, 224)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 6
	$data = array();
	$data['name'] = esc_html__( 'Misc 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc6.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1532608358275{padding-top: 50px !important;padding-bottom: 50px !important;}" ca_duration="1200" ca_delay="180" ca_init_translate_y="38"][vc_column][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" fs="36px" lh="1.222em" duration="1200" delay="150" ca_init_translate_y="61"]Our Milestone[/ld_fancy_heading][ld_spacer height="60px"][/vc_column][vc_column offset="vc_col-md-5"][ld_milestone title="Established" date="2010" primary_color="rgb(255, 176, 159)"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt.[/ld_milestone][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_milestone title="Relocates" date="2012" primary_color="rgb(255, 176, 159)"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt.[/ld_milestone][/vc_column][vc_column offset="vc_col-md-5"][ld_milestone title="Touches revenues" date="2014" primary_color="rgb(255, 176, 159)"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt.[/ld_milestone][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_milestone title="Employee grows to over 10,000" date="2017" primary_color="rgb(255, 176, 159)"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt.[/ld_milestone][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 7
	$data = array();
	$data['name'] = esc_html__( 'Misc 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc7.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row content_placement="top" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1540305967853{padding-top: 45px !important;padding-bottom: 55px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_x="-26"][vc_column offset="vc_col-md-4"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_large:0px" fs="36px" lh="1.111em"]Progress Bars[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-7"][ld_progressbar label_position="liquid-progressbar-values-inside" size="liquid-progressbar-xl" roundness="liquid-progressbar-circle" label="Web Design" count="60" label_color="rgb(255, 255, 255)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.03)" bar="linear-gradient(90deg, #8987e2 0%, rgb(29, 225, 209) 100%)"][ld_progressbar label_position="liquid-progressbar-values-inside" size="liquid-progressbar-xl" roundness="liquid-progressbar-circle" label="Web Development" count="90" label_color="rgb(255, 255, 255)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.03)" bar="linear-gradient(90deg, #8987e2 0%, rgb(29, 225, 209) 100%)"][ld_progressbar label_position="liquid-progressbar-values-inside" size="liquid-progressbar-xl" roundness="liquid-progressbar-circle" label="Graphic Design" count="75" label_color="rgb(255, 255, 255)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.03)" bar="linear-gradient(90deg, #8987e2 0%, rgb(29, 225, 209) 100%)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 8
	$data = array();
	$data['name'] = esc_html__( 'Misc 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc8.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row content_placement="top" css=".vc_custom_1540305999987{padding-top: 60px !important;padding-bottom: 100px !important;}"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_large:0px" fs="36px" lh="1.111em"]Progress Bars[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3"][ld_spacer height="25px"][ld_progressbar size="liquid-progressbar-thick" percentage_shape="round" label="Graphic Design" count="90" label_color="rgb(51, 51, 51)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.1)" bar="rgb(53, 204, 98)" suffix="%"][ld_spacer height="1px"][ld_progressbar size="liquid-progressbar-thick" percentage_shape="round" label="Graphic Design" count="65" label_color="rgb(51, 51, 51)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.1)" bar="rgb(53, 204, 98)" suffix="%"][ld_spacer height="1px"][ld_progressbar size="liquid-progressbar-thick" percentage_shape="round" label="Graphic Design" count="80" label_color="rgb(51, 51, 51)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.1)" bar="rgb(53, 204, 98)" suffix="%"][/vc_column][vc_column offset="vc_col-md-3"][ld_spacer height="25px"][ld_progressbar size="liquid-progressbar-thick" percentage_shape="round" label="Graphic Design" count="80" label_color="rgb(51, 51, 51)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.1)" bar="rgb(53, 204, 98)" suffix="%"][ld_spacer height="1px"][ld_progressbar size="liquid-progressbar-thick" percentage_shape="round" label="Graphic Design" count="90" label_color="rgb(51, 51, 51)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.1)" bar="rgb(53, 204, 98)" suffix="%"][ld_spacer height="1px"][ld_progressbar size="liquid-progressbar-thick" percentage_shape="round" label="Graphic Design" count="65" label_color="rgb(51, 51, 51)" count_color="rgb(255, 255, 255)" background="rgba(0, 0, 0, 0.1)" bar="rgb(53, 204, 98)" suffix="%"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 9
	$data = array();
	$data['name'] = esc_html__( 'Misc 09', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc9.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row content_placement="top" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1540305972182{padding-top: 95px !important;padding-bottom: 35px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_x="-26"][vc_column offset="vc_col-md-4"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_large:0px" fs="36px" lh="1.111em"]Progress Bars[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-7"][ld_progressbar size="liquid-progressbar-lg" roundness="liquid-progressbar-circle" label="Web Design" count="90" suffix="%" bar="rgb(211, 169, 133)"][ld_progressbar size="liquid-progressbar-lg" roundness="liquid-progressbar-circle" label="Graphic Design" count="80" suffix="%" bar="rgb(211, 169, 133)"][ld_progressbar size="liquid-progressbar-lg" roundness="liquid-progressbar-circle" label="Typography" count="85" suffix="%" bar="rgb(211, 169, 133)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc 10
	$data = array();
	$data['name'] = esc_html__( 'Misc 10', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/misc/misc10.jpg' );
	$data['sort_name'] = 'misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1542965033383{margin-top: 100px !important;margin-bottom: 100px !important;padding-top: 90px !important;padding-bottom: 90px !important;background-image: url(http://cryptocurrency.liquid-themes.com/wp-content/uploads/2018/07/bg-5-min-1.jpg?id=53) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1532002022218{padding-right: 10% !important;padding-left: 10% !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="44px" color="rgb(255, 255, 255)"]Roadmap[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="17px" lh="1.764em" color="rgb(176, 185, 213)"]Blocks in shorter chains (or invalid chains) are not used for anything.  The bitcoin client switches to another.[/ld_fancy_heading][ld_spacer height="60px"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][ld_roadmap enable_animation="yes" color="rgb(255, 255, 255)"][ld_roadmap_item checked_item="yes" title="Oct, 21 - H1"]Cryptocurrency concept is born[/ld_roadmap_item][ld_roadmap_item title="Oct, 21 - H1"]Project Pipeline Secured[/ld_roadmap_item][ld_roadmap_item title="Mon, 24 Oct"]Balancing and Frequency Regulation[/ld_roadmap_item][ld_roadmap_item title="Mon, 24 Oct"]Public Token Sale[/ld_roadmap_item][ld_roadmap_item title="Mon, 24 Oct"]Distrubution of donated energy to token holders[/ld_roadmap_item][/ld_roadmap][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Newsletter
	//Newsletter 1
	$data = array();
	$data['name'] = esc_html__( 'Newsletter 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/newsletters/newsletter1.jpg' );
	$data['sort_name'] = 'newsletter';
	$data['custom_class'] = 'general newsletter';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_init_translate_y="44" css=".vc_custom_1540080761599{margin-top: 100px !important;padding-top: 35px !important;padding-bottom: 45px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h2" margin="bottom_large:0px"]Subscribe Newsletter[/ld_fancy_heading][ld_fancy_heading tag="p"]You can customize buttons, positions along with the icons.[/ld_fancy_heading][/vc_column][vc_column align="text-center" offset="vc_col-md-offset-4 vc_col-md-4"][ld_spacer][ld_newsletter style="solid" inputs_size="ld-sf--size-lg" inputs_radius="ld-sf--circle" inputs_shadow="ld-sf--input-shadow" btn_style="solid" btn_display="label_icon" i_type="linea" i_add_icon="true" placeholder_text="Please enter your email address here" i_icon_linea="icon-md-paper-plane" txt_color="rgb(167, 169, 184)" txt_f_color="rgb(0, 0, 0)" btn_txt_color="rgb(255, 255, 255)" btn_bg_color="linear-gradient(90deg, rgb(79, 218, 145) 0%, #34dbc5 100%)" hover_btn_bg_color="linear-gradient(90deg, #34dbc5 0%, rgb(52, 219, 197) 100%)" i_size="26px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Newsletter 2
	$data = array();
	$data['name'] = esc_html__( 'Newsletter 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/newsletters/newsletter2.jpg' );
	$data['sort_name'] = 'newsletter';
	$data['custom_class'] = 'general newsletter';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_init_translate_y="44" css=".vc_custom_1540080761599{margin-top: 100px !important;padding-top: 35px !important;padding-bottom: 45px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" margin="bottom_large:0px"]Subscribe Newsletter[/ld_fancy_heading][ld_fancy_heading tag="p"]Increase engagement with your website visitors.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ld_spacer][ld_newsletter style="solid" btn_style="solid" btn_position="ld-sf--button-inside" placeholder_text="Please enter you email address here" txt_color="rgb(167, 169, 184)" bg_color="rgb(244, 245, 247)" btn_bg_color="rgb(255, 122, 75)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Newsletter 3
	$data = array();
	$data['name'] = esc_html__( 'Newsletter 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/newsletters/newsletter3.jpg' );
	$data['sort_name'] = 'newsletter';
	$data['custom_class'] = 'general newsletter';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1529413332185{padding-top: 30px !important;padding-bottom: 10px !important;background-color: #f7f7f7 !important;}"][vc_column offset="vc_col-md-7"][ld_spacer height="10px"][ld_fancy_heading tag="h3" transform="text-uppercase" split_type="chars, words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_fit="true" enable_split="true" use_mask="true" minfontsize="45" ca_init_translate_y="0" ca_init_translate_x="79" margin="bottom_small:0px" compressor="0.55"]Subscribe[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" title="Each boutique hotel in the Ave Hotel collection tells a unique story, inviting guests to immerse themselves in tales of adventure, romance, history, culture, nature and more for the length of a memorable stay. Discover the high points of our story here." init_values="translateY:80,opacity:0" fs="16px" ls="0.025em" lh="1.2em" start_delay="600" ca_init_translate_y="64"]We’ve got plenty of news and promotion, be the first to read all about it.[/ld_fancy_heading][ld_spacer height="30px"][/vc_column][vc_column offset="vc_col-md-5"][ld_newsletter style="bordered" btn_style="naked" btn_position="ld-sf--button-inside" txt_color="rgb(142, 145, 150)" bg_color="rgb(255, 255, 255)" brd_color="rgb(218, 221, 225)" btn_txt_color="rgb(63, 65, 71)" hover_btn_txt_color="rgb(0, 0, 0)" placeholder_text="Email Address"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Newsletter 4
	$data = array();
	$data['name'] = esc_html__( 'Newsletter 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/newsletters/newsletter4.jpg' );
	$data['sort_name'] = 'newsletter';
	$data['custom_class'] = 'general newsletter';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1537971845928{margin-bottom: 40px !important;padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(http://shop.liquid-themes.com/wp-content/uploads/2018/08/newsletter.jpg?id=4410) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" tag_to_inherite="h2" use_inheritance="true" color="rgb(255, 255, 255)"]Subscribe to the exclusive deals![/ld_fancy_heading][ld_spacer height="5px"][vc_row_inner][vc_column_inner offset="vc_col-md-offset-3 vc_col-md-6"][ld_newsletter style="underlined" inputs_size="ld-sf--size-lg" inputs_border="ld-sf--border-thick" btn_style="naked" btn_display="icon" btn_position="ld-sf--button-inside" i_type="fontawesome" use_custom_fonts_input="true" i_add_icon="true" placeholder_text="enter your email address" i_icon_fontawesome="fa fa-angle-right" txt_color="rgba(255, 255, 255, 0.735)" brd_color="rgba(255, 255, 255, 0.771)" btn_txt_color="rgb(255, 255, 255)" hover_btn_txt_color="rgba(255, 255, 255, 0.907)" txt_f_color="rgb(255, 255, 255)" brd_f_color="rgb(255, 255, 255)" fs="18px" lh="1" i_size="20px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Portfolio
	//Portfolio 1
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/portfolios/portfolio1.jpg' );
	$data['sort_name'] = 'portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540469355100{padding-top: 80px !important;padding-bottom: 70px !important;}"][vc_column][ld_portfolio_listing style="carousel" post_type="liquid-portfolio" posts_per_page="9" enable_item_animation="yes" show_filter="yes" enable_parallax="no" filter_lbl_all="Selected Project" filter_size="size-sm" filter_transformation="text-uppercase ltr-sp-1" filter_mb="60" filter_weight="font-weight-bold" tag_to_inherite="h1 mt-0" filter_title_size="size-xl" filter_title_weight="font-weight-bold" color_type="ld-pf-light" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" filter_id="ra1524914102171-d22fa729-eee1" filter_title="Our works" filter_cats="ecommerce, digital-experiences, branding-strategy" color_primary="linear-gradient(0deg, rgba(0, 0, 0, 0.7) 0.3184713375796178%, rgba(0,0,0,0) 100%)" pf_init_translate_x="36" pf_duration="1000" taxonomies="carousel"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio 2
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/portfolios/portfolio2.jpg' );
	$data['sort_name'] = 'portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row bg_position="right top" css=".vc_custom_1539674876269{padding-top: 50px !important;padding-bottom: 50px !important;background-image: url(http://architecture.liquid-themes.com/wp-content/uploads/2018/10/img-3-min.jpg?id=4323) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_bottom_medium:110px"][vc_column][ld_portfolio_listing style="grid" columns_gap="15" bottom_gap="30" post_type="liquid-portfolio" posts_per_page="10" enable_item_animation="yes" show_filter="yes" enable_gallery="listing-lightbox-gallery" filter_lbl_all="All work" filter_size="size-sm" filter_decoration="filters-line-through" filter_transformation="text-uppercase ltr-sp-1" filter_mb="40" tag_to_inherite="h3 mt-0" filter_title_size="size-xl" filter_title_transformation="text-uppercase" pf_init_scale_x="0.75" pf_init_scale_y="0.75" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" filter_id="1539611431482-8a54e91e-9884" filter_cats="architecture, interior-design, urban-design" filter_title="Selected work" filter_normal_color="rgb(0, 0, 0)" filter_hover_color="rgb(245, 99, 75)" filter_dec_color="rgb(245, 99, 75)" color_primary="rgba(245, 99, 75, 0.903)" pf_duration="1600" pf_delay="160"][vc_row_inner][vc_column_inner align="text-center"][ld_spacer height="35px"][ld_button style="btn-naked" title="More Work" transformation="text-uppercase" i_type="linea" i_add_icon="true" i_icon_linea="icon-arrow-right-material" fs="20px" ls="0.05em"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio 3
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/portfolios/portfolio3.jpg' );
	$data['sort_name'] = 'portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1542964011453{padding-top: 150px !important;padding-bottom: 150px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_responsive_options="yes" offset="vc_col-lg-5" css=".vc_custom_1535961195869{margin-right: -12px !important;}" responsive_css="margin_right_mobile:0"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" init_values="translateX:-50,opacity:0" animations_values="translateX:0,opacity:1" title="Exclusive portfolio" color="rgb(167, 169, 184)" fs="13px" ls="0.1em" ca_init_translate_y="40" duration="1200" delay="150"]Exclusive portfolio[/ld_fancy_heading][vc_empty_space height="15px"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" init_values="translateX:-50,opacity:0" animations_values="translateX:0,opacity:1" title="Having attractive showcase has never been easier" color="rgb(24, 27, 49)" start_delay="180" ls="-0.03em" ca_init_translate_y="50"]Having attractive showcase
has never been <span style="color: #3ed2a7;">easier</span>[/ld_fancy_heading][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-lg-4"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="We’re a brand strategy and digital design agency, building brands that matter in culture. With more than ten years of knowledge and expertise." start_delay="260" fs="18px" lh="1.5em" margin="right_large:12%25" ca_init_translate_y="50" duration="1200" delay="150"]We’re a brand strategy and digital design agency, building brands that matter in culture. With more than ten years of knowledge and expertise.[/ld_fancy_heading][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" title="We work with people who are as dedicated to their craft. We do everything with our core values of honesty, hard work, and trust.
" start_delay="360" fs="18px" lh="1.5em" ca_init_translate_y="48" duration="1200" delay="150"]We work with people who are as dedicated to their craft. We do everything with our core values of honesty, hard work, and trust.[/ld_fancy_heading][ld_spacer][/vc_column][vc_column][vc_empty_space height="40px"][ld_portfolio_listing style="masonry-classic" columns_gap="35" post_type="liquid-portfolio" posts_per_page="6" enable_item_animation="yes" enable_btn="yes" show_filter="yes" filter_lbl_all="Selected Works" filter_size="size-sm" filter_transformation="text-uppercase ltr-sp-1" filter_mb="75" show_button="yes" ib_style="btn-solid" ib_title="See All work" ib_transformation="text-uppercase" ib_shape="circle" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" filter_style="default" ib_color="#4fda91" ib_color2="#34dbc5" ib_fs="13px" ib_fw="700" ib_hover_color="#ffba83" ib_hover_color2="#ffa5cd" filter_id="1524816390497-270ae223-f967" taxonomies="masonry-classic" filter_cats="branded-ecommerce, digital-experiences, branding-strategy" color_primary="linear-gradient(90deg, rgba(255, 186, 131, 0.9) 0.6369426751592356%, rgba(255, 165, 205, 0.9) 100%)" ib_css=".vc_custom_1538059618689{padding-right: 0.75em !important;padding-left: 0.75em !important;}" btn_text="Discover more" btn_color="#ffffff" pf_init_translate_y="48" pf_duration="1200" pf_delay="150" filter_normal_color="rgb(135, 135, 135)" filter_hover_color="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio 4
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/portfolios/portfolio4.jpg' );
	$data['sort_name'] = 'portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row bg_position="custom" css=".vc_custom_1527859143467{padding-top: 90px !important;background-image: url(http://construction.liquid-themes.com/wp-content/uploads/2018/05/img-min.jpg?id=34) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="50%" bg_pos_v="160%"][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-sm-offset-1" ca_init_translate_y="45" ca_duration="1200" ca_delay="150" ca_init_translate_z="-124" ca_init_rotate_x="-71"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" ls="0.2em"]Our Works[/ld_fancy_heading][vc_empty_space height="10px"][vc_separator color="custom" border_width="2" el_width="10" accent_color="#ffc80b" css=".vc_custom_1527681169193{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(24, 27, 49)" fs="30px" lh="1.6em" fw="300" ls="0"]Our construction and total service offering lets us deliver projects in their entirety. We can lead projects all the way from the initial concept phase to long-term asset management, operations and maintenance.[/ld_fancy_heading][vc_empty_space height="65px"][/vc_column][vc_column][ld_portfolio_listing style="packery" columns_gap="15" post_type="liquid-portfolio" posts_per_page="10" enable_item_animation="yes" show_filter="yes" filter_lbl_all="All Work" filter_decoration="filters-underline" filter_transformation="text-uppercase ltr-sp-1" filter_mb="50" show_button="yes" ib_style="btn-default" ib_title="See more" ib_transformation="text-uppercase" ib_link_type="scroll_to_section" ib_size="btn-sm" ib_border="border-thick" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" filter_id="1527682114006-942bd260-b40a" filter_cats="commercial-office, education, energy, highways-bridges, industrial, public" filter_normal_color="#a7a9b8" filter_hover_color="#181b31" filter_dec_color="#ffc80b" ib_color="rgb(255, 200, 11)" ib_text_color="rgb(24, 27, 49)" ib_fs="12px" ib_css=".vc_custom_1536232084786{padding-right: 1.75em !important;padding-left: 1.75em !important;}" ib_fw="700" color_primary="rgba(255, 200, 11, 0.9)" pf_init_translate_y="55" pf_init_rotate_x="-35" pf_init_rotate_y="0"][/vc_column][vc_column][vc_empty_space height="80px"][ld_carousel columns="lg:6|md:5|sm:3|xs:2|spacing_xs:15px" inactiv_opacity="1" cellalign="left" groupcells="no" wraparound="yes" autoplay="yes" contain="yes"][vc_single_image image="2863" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" image_max_width="130px"][vc_single_image image="2864" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" image_max_width="115px"][vc_single_image image="2865" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" image_max_width="105px"][vc_single_image image="2866" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" image_max_width="92px"][vc_single_image image="2867" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" image_max_width="80px"][vc_single_image image="2868" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" image_max_width="120px"][vc_single_image image="2863" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" image_max_width="130px"][vc_single_image image="2865" img_size="full" alignment="center" enable_opacity="yes" opacity="0.2" image_max_width="105px"][/ld_carousel][vc_empty_space height="60px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio 5
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/portfolios/portfolio5.jpg' );
	$data['sort_name'] = 'portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1542963164785{padding-top: 20px !important;padding-right: 2.5vw !important;padding-bottom: 50px !important;padding-left: 2.5vw !important;}"][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-sm-offset-2" ca_init_translate_y="53" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h2"]We Make Beautiful Things[/ld_fancy_heading][/vc_column][vc_column][ld_portfolio_listing style="metro" columns_gap="6" bottom_gap="10" post_type="liquid-portfolio" posts_per_page="9" enable_item_animation="yes" show_filter="yes" enable_parallax="no" filter_lbl_all="All Work" filter_transformation="text-uppercase ltr-sp-1" filter_mb="50" color_type="ld-pf-light" pf_init_scale_x="0.5" pf_init_scale_y="0.5" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" filter_id="ra1524904729833-81e4b195-e058" taxonomies="metro" filter_cats="branded-ecommerce, digital-experiences, branding-strategy" color_primary="linear-gradient(245deg, rgba(186, 0, 255, 0.9) 0.3184713375796178%, rgba(131, 11, 176, 0.9) 100%)" pf_init_translate_y="1" pf_init_rotate_x="0" pf_duration="1200" pf_delay="150" filter_normal_color="rgb(160, 162, 174)" filter_hover_color="rgb(6, 6, 6)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio 6 
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/portfolios/portfolio6.jpg' );
	$data['sort_name'] = 'portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540459216884{padding-bottom: 100px !important;}"][vc_column align="text-left"][ld_portfolio_listing style="vertical-overlay" post_type="liquid-portfolio" posts_per_page="5" enable_item_animation="yes" show_filter="yes" enable_parallax="no" pagination="ajax" filter_lbl_all="All Work" filter_size="size-custom" filter_align="justify-content-start" filter_mb="35" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_scale_z="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_scale_z="1" pf_an_opacity="1" filter_id="1534238518412-21b33c7f-917a" pf_duration="1200" pf_delay="150" pf_init_translate_y="45" pf_init_translate_z="0" pf_init_rotate_x="0" taxonomies="vertical-overlay" filter_cats="branding, ecommerce, digital-design, custom-print" pf_start_delay="250" custom_filter_size="16px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio 7
	$data = array();
	$data['name'] = esc_html__( 'Portfolio 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/portfolios/portfolio7.jpg' );
	$data['sort_name'] = 'portfolio';
	$data['custom_class'] = 'general portfolio';
	$data['content'] = <<<CONTENT
[vc_row bg_position="right top" css=".vc_custom_1546536033763{padding-top: 50px !important;padding-bottom: 50px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:90px|padding_bottom_medium:100px"][vc_column responsive_css="padding_right_medium:7%25|padding_left_medium:7%25" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h2" alignment="text-center" margin="bottom_small:0.75em"]Total design freedom.[/ld_fancy_heading][ld_fancy_heading tag="h6" alignment="text-center" use_custom_fonts_title="true" margin="bottom_small:0.75em" color="rgb(129, 129, 129)" fs="17px" ls="0.01em" lh="1.7em"]Huge collection of elements, rich customization options, flexible layouts, and instant results![/ld_fancy_heading][ld_spacer height="55px"][/vc_column][vc_column][ld_portfolio_listing style="grid" columns_gap="20" bottom_gap="9" post_type="liquid-portfolio" posts_per_page="6" enable_gallery="listing-lightbox-gallery" enable_parallax="no" orderby="author" filter_id="1539611431482-8a54e91e-9884" color_primary="rgba(71, 97, 230, 0.9)" title_size="19px" title_weight="400"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Pricing
	//Pricing 1
	$data = array();
	$data['name'] = esc_html__( 'Pricing 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/pricings/pricing1.jpg' );
	$data['sort_name'] = 'pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540307021296{padding-top: 105px !important;padding-bottom: 75px !important;}"][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="s2" title="Standard" price="$10" primary_color="#46d664"]</p>
<ul>
<li><strong>05</strong> Users Limit</li>
<li><strong>30GB</strong> Cloud Storage</li>
<li><strong>15</strong> Projects &amp; Tasks</li>
<li><strong>07</strong> File Types Upload</li>
</ul>
<p>[/ld_price_table][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="s2" featured="yes" featured_tag="yes" title="Premium" price="$20" primary_color="#fd623c" featured_label="Best choice"]</p>
<ul>
<li><strong>10</strong> Users Limit</li>
<li><strong>100GB</strong> Cloud Storage</li>
<li><strong>25</strong> Projects &amp; Tasks</li>
<li><strong>10</strong> File Types Upload</li>
</ul>
<p>[/ld_price_table][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="s2" title="Enterprise" price="$30" primary_color="#02a0e5"]</p>
<ul>
<li><strong>Unlimited</strong> Users Limit</li>
<li><strong>500GB</strong> Cloud Storage</li>
<li><strong>50</strong> Projects &amp; Tasks</li>
<li><strong>50</strong> File Types Upload</li>
</ul>
<p>[/ld_price_table][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Pricing 2
	$data = array();
	$data['name'] = esc_html__( 'Pricing 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/pricings/pricing2.jpg' );
	$data['sort_name'] = 'pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540306913589{margin-top: 40px !important;padding-top: 75px !important;padding-bottom: 75px !important;}"][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="default" show_button="yes" pt_style="btn-default" pt_title="Sign up today" pt_transformation="text-uppercase" pt_size="btn-lg" pt_border="border-thick" title="12 Months" price="$299" currency="$" primary_color="#fa7c31" pt_color="rgb(245, 99, 75)" pt_color2="rgb(254, 148, 24)" subtitle="Membership"]</p>
<ul>
<li>Length of Membership <strong>12 Months</strong></li>
<li>Number of People <strong>01 Person</strong></li>
<li>Club Access <strong>Unlimited Club Access</strong></li>
<li>Class Access FREE <strong>Fitness Classes</strong></li>
</ul>
<p>[/ld_price_table][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="default" show_button="yes" pt_style="btn-default" pt_title="Sign up today" pt_transformation="text-uppercase" pt_size="btn-lg" pt_border="border-thick" title="Pay Monthly" price="$29 <sup>/per month</sup>" currency="$" primary_color="#fa7c31" pt_color="rgb(245, 99, 75)" pt_color2="rgb(254, 148, 24)" subtitle="No contract"]</p>
<ul>
<li>Number of People <strong>01 Person</strong></li>
<li>Joining Fee <strong>$30</strong></li>
<li>No Contract <strong>Cancel Anytime</strong></li>
<li>Class Access <strong>FREE Fitness Classes</strong></li>
</ul>
<p>[/ld_price_table][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="default" show_button="yes" pt_style="btn-default" pt_title="Sign up today" pt_transformation="text-uppercase" pt_size="btn-lg" pt_border="border-thick" title="1 day visit" price="$9" currency="$" primary_color="#fa7c31" pt_color="rgb(245, 99, 75)" pt_color2="rgb(254, 148, 24)" subtitle="Pay as you go"]</p>
<ul>
<li>Length of Membership <strong>Try Us For a Day</strong></li>
<li>Number of People <strong>01 Person</strong></li>
<li>Club Access <strong>Gym Club</strong></li>
<li>Class Access <strong>Book a Fitness Class</strong></li>
</ul>
<p>[/ld_price_table][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Pricing 3
	$data = array();
	$data['name'] = esc_html__( 'Pricing 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/pricings/pricing3.jpg' );
	$data['sort_name'] = 'pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540306940589{margin-top: 75px !important;margin-bottom: 75px !important;padding-top: 60px !important;padding-bottom: 60px !important;background-color: #f7f7f7 !important;}"][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="s3" show_button="yes" pt_style="btn-default" pt_title="Sign up today" pt_transformation="text-uppercase" pt_size="btn-lg" pt_border="border-thick" title="12 Months" price="$299" currency="$" primary_color="#fa7c31" pt_color="rgb(245, 99, 75)" pt_color2="rgb(254, 148, 24)"]</p>
<ul>
<li>Membership <strong>12 Months</strong></li>
<li>Number of People <strong>01 Person</strong></li>
<li>Club Access <strong>Unlimited Club Access</strong></li>
<li>Class Access FREE <strong>Fitness Classes</strong></li>
</ul>
<p>[/ld_price_table][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="s3" show_button="yes" pt_style="btn-default" pt_title="Sign up today" pt_transformation="text-uppercase" pt_size="btn-lg" pt_border="border-thick" title="12 Months" price="$29" currency="$" primary_color="#fa7c31" pt_color="rgb(245, 99, 75)" pt_color2="rgb(254, 148, 24)" bg_color="linear-gradient(90deg, #0bccee 0%, #ac1de1 100%)"]</p>
<ul>
<li>Membership <strong>12 Months</strong></li>
<li>Number of People <strong>01 Person</strong></li>
<li>Club Access <strong>Unlimited Club Access</strong></li>
<li>Class Access FREE <strong>Fitness Classes</strong></li>
</ul>
<p>[/ld_price_table][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1"][ld_price_table style="s3" show_button="yes" pt_style="btn-default" pt_title="Sign up today" pt_transformation="text-uppercase" pt_size="btn-lg" pt_border="border-thick" title="1 day visit" price="$9" currency="$" primary_color="#fa7c31" pt_color="rgb(245, 99, 75)" pt_color2="rgb(254, 148, 24)"]</p>
<ul>
<li>Membership <strong>Try Us</strong></li>
<li>Number of People <strong>01 Person</strong></li>
<li>Club Access <strong>Gym Club</strong></li>
<li>Class Access <strong>Book a Fitness Class</strong></li>
</ul>
<p>[/ld_price_table][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Pricing 4
	$data = array();
	$data['name'] = esc_html__( 'Pricing 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/pricings/pricing4.jpg' );
	$data['sort_name'] = 'pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1546252390564{padding-top: 100px !important;padding-bottom: 110px !important;background-color: #f9fafb !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" alignment="text-center"]Buy Ave and get access to premium plugins for free.[/ld_fancy_heading][ld_spacer height="45px"][/vc_column][vc_column][vc_row_inner][vc_column_inner offset="vc_col-md-4"][ld_price_table style="s4" show_button="yes" pt_style="btn-default" pt_title="Join Basic Plan" pt_shape="round" title="Basic Plan" price="`{`ld_span`}`$`{`/ld_span`}`8<small>/mo</small>" primary_color="rgba(115, 116, 127, 0.18)" pt_hover_color="rgb(70, 102, 227)" pt_text_color="rgb(26, 28, 38)" pt_htext_color="rgb(255, 255, 255)" pt_fs="15px" pt_css=".vc_custom_1545649039844{padding-right: 1.25em !important;padding-left: 1.25em !important;}" pt_fw="400" pt_lh="1.25em"]</p>
<ul>
<li><span style="font-size: 15px;">200 Hand-Crafted Templates</span></li>
<li><span style="font-size: 15px;">Exclusive Support</span></li>
<li><span style="font-size: 15px;">50+ PreBuilt Websites</span></li>
<li><span style="font-size: 15px;">Premium Plugins</span></li>
</ul>
<p>[/ld_price_table][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ld_price_table style="s4" show_button="yes" pt_style="btn-solid" pt_title="Join Business Plan" pt_shape="round" title="Business" price="`{`ld_span`}`$`{`/ld_span`}`39<small>/mo</small>" pt_text_color="rgb(255, 255, 255)" pt_fs="15px" pt_css=".vc_custom_1546258064846{padding-right: 1.25em !important;padding-left: 1.25em !important;}" pt_lh="1.25em" pt_fw="400" pt_hover_color="rgb(58, 58, 58)"]</p>
<ul>
<li><span style="font-size: 15px;">200 Hand-crafted Templates</span></li>
<li><span style="font-size: 15px;">Exclusive Support</span></li>
<li><span style="font-size: 15px;">50+ PreBuilt Websites</span></li>
<li><span style="font-size: 15px;">Premium Plugins</span></li>
</ul>
<p>[/ld_price_table][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ld_price_table style="s4" show_button="yes" pt_style="btn-default" pt_title="Join Exclusive Plan" pt_shape="round" title="Exclusive" price="`{`ld_span`}`$`{`/ld_span`}`79<small>/mo</small>" primary_color="rgba(115, 116, 127, 0.18)" pt_hover_color="rgb(70, 102, 227)" pt_text_color="rgb(26, 28, 38)" pt_htext_color="rgb(255, 255, 255)" pt_fs="15px" pt_css=".vc_custom_1545649008180{padding-right: 1.25em !important;padding-left: 1.25em !important;}" pt_fw="400" pt_lh="1.25em"]</p>
<ul>
<li><span style="font-size: 15px;">200 Hand-Crafted Templates</span></li>
<li><span style="font-size: 15px;">Exclusive Support</span></li>
<li><span style="font-size: 15px;">50+ PreBuilt Websites</span></li>
<li><span style="font-size: 15px;">Premium Plugins</span></li>
</ul>
<p>[/ld_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Processes
	//Process 1
	$data = array();
	$data['name'] = esc_html__( 'Process 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/processes/process1.jpg' );
	$data['sort_name'] = 'process';
	$data['custom_class'] = 'general process';
	$data['content'] = <<<CONTENT
[vc_row responsive_css="padding_top_medium:75px|padding_bottom_medium:75px" css=".vc_custom_1539610764764{padding-top: 35px !important;padding-bottom: 35px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1200" ca_delay="120" ca_init_translate_y="35" responsive_css="padding_right_medium:7%25"][ld_fancy_heading tag="h2" use_inheritance="true" color="rgb(245, 99, 75)" margin="bottom_small:10px"]01[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" fs="36px" margin="top_small:0px|bottom_small:28px"]Architecture[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true"]Since the 1980s, as the complexity of buildings began to increase, the field of architecture became multi-disciplinary with specializations for each project type, technological expertise.[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1200" ca_start_delay="300" ca_delay="120" ca_init_translate_y="35" responsive_css="padding_right_medium:3.5%25|padding_left_medium:3.5%25"][ld_fancy_heading tag="h2" use_inheritance="true" color="rgb(245, 99, 75)" margin="bottom_small:10px"]02[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" fs="36px" margin="top_small:0px|bottom_small:28px"]Interior design[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true"]Interior design is the art and science of enhancing the interiors, sometimes including the exterior, of a space or building, to achieve a healthier and more aesthetically pleasing environment.[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1200" ca_start_delay="600" ca_delay="120" ca_init_translate_y="35" responsive_css="padding_left_medium:7%25"][ld_fancy_heading tag="h2" use_inheritance="true" color="rgb(245, 99, 75)" margin="bottom_small:10px"]03[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" fs="36px" margin="top_small:0px|bottom_small:28px"]Urban Design[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" enable_split="true"]Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Process 2
	$data = array();
	$data['name'] = esc_html__( 'Process 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/processes/process2.jpg' );
	$data['sort_name'] = 'process';
	$data['custom_class'] = 'general process';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1531734517011{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column offset="vc_col-md-7 vc_hidden-xs"][ld_images_group_container][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="5331" translate_from_y="185" rotate_from_y="0" translate_to_y="-110" position="left_large:0px|left_medium:20%25|top_small:0px|right_small:-10%25|left_small:10%25"][/ld_images_group_element][/ld_images_group_container][ld_images_group_container][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="5330" translate_from_y="90" translate_to_y="-70" margin="left_large:-23%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1200" ca_delay="150" ca_init_translate_y="40"][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" shadow="iconbox-icon-hover-shadow" i_icon_linea="icon-num-1" title="Register and log-in." shape_hcolor="linear-gradient(65deg, #e78e8e 0.6369426751592356%, rgba(62, 18, 238, 0.651) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1538149620044{padding-bottom: 30px !important;}" icon_size="25px"]We build and activate brands through cultural insight, strategic vision, and the power of emotion.[/ld_icon_box][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" shadow="iconbox-icon-hover-shadow" i_icon_linea="icon-num-2" title="Add your teammates." shape_hcolor="linear-gradient(65deg, #e78e8e 0.6369426751592356%, rgba(62, 18, 238, 0.651) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1538149641681{padding-bottom: 30px !important;}" icon_size="25px"]We build and activate brands through cultural insight, strategic vision, and the power of emotion.[/ld_icon_box][ld_icon_box i_type="linea" heading_size="sm" heading_weight="font-weight-semibold" i_shape="circle" i_size="md" position="iconbox-side" i_border="1" i_linked="iconbox-icon-linked" shadow="iconbox-icon-hover-shadow" i_icon_linea="icon-num-3" title="Manage and share your workspace." shape_hcolor="linear-gradient(65deg, #e78e8e 0.6369426751592356%, rgba(62, 18, 238, 0.651) 100%)" shape_color="rgb(255, 255, 255)" i_color="rgb(51, 51, 51)" h_i_color="rgb(255, 255, 255)" border_shape_color="rgb(233, 233, 233)" css=".vc_custom_1538149648600{padding-bottom: 30px !important;}" icon_size="25px"]We build and activate brands through cultural insight, strategic vision, and the power of emotion.[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Process 3
	$data = array();
	$data['name'] = esc_html__( 'Process 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/processes/process3.jpg' );
	$data['sort_name'] = 'process';
	$data['custom_class'] = 'general process';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540321737186{padding-top: 55px !important;padding-bottom: 100px !important;}"][vc_column offset="vc_col-md-3"][ld_process_box title="Brain Storming" count="1" image="5333"]Produce the highest quality work and services for every client.[/ld_process_box][/vc_column][vc_column offset="vc_col-md-3"][ld_process_box title="Brain Storming" count="2" image="5334"]Produce the highest quality work and services for every client.[/ld_process_box][/vc_column][vc_column offset="vc_col-md-3"][ld_process_box title="Brain Storming" count="3" image="5335"]Produce the highest quality work and services for every client.[/ld_process_box][/vc_column][vc_column offset="vc_col-md-3"][ld_process_box title="Brain Storming" count="4" image="5336"]Produce the highest quality work and services for every client.[/ld_process_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Process 4
	$data = array();
	$data['name'] = esc_html__( 'Process 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/processes/process4.jpg' );
	$data['sort_name'] = 'process';
	$data['custom_class'] = 'general process';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540321766760{padding-top: 55px !important;padding-bottom: 150px !important;}"][vc_column offset="vc_col-md-3"][ld_process_box add_icon="yes" i_type="linea" title="1. Brain Storming" bg_color="rgb(239, 251, 252)" i_icon_linea="icon-ion-ios-color-wand" i_color="rgb(65, 47, 86)"]Produce the highest quality work and services for every client.[/ld_process_box][/vc_column][vc_column offset="vc_col-md-3"][ld_process_box add_icon="yes" i_type="linea" title="2. Brain Storming" bg_color="rgb(255, 248, 244)" i_icon_linea="icon-basic_spread_text_bookmark" i_color="rgb(86, 62, 47)"]Produce the highest quality work and services for every client.[/ld_process_box][/vc_column][vc_column offset="vc_col-md-3"][ld_process_box add_icon="yes" i_type="linea" title="3. Brain Storming" bg_color="rgb(239, 246, 252)" i_icon_linea="icon-basic_webpage_multiple" i_color="rgb(47, 62, 86)"]Produce the highest quality work and services for every client.[/ld_process_box][/vc_column][vc_column offset="vc_col-md-3"][ld_process_box add_icon="yes" i_type="linea" title="4. Brain Storming" bg_color="rgb(246, 246, 255)" i_icon_linea="icon-basic_chronometer" i_color="rgb(86, 62, 47)"]Produce the highest quality work and services for every client.[/ld_process_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Tabs
	//Tabs 1
	$data = array();
	$data['name'] = esc_html__( 'Tabs 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/tabs/tabs1.jpg' );
	$data['sort_name'] = 'tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542962355815{padding-top: 110px !important;padding-bottom: 10px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_init_translate_y="45"][ld_fancy_heading tag="h2" margin="bottom_large:0.2em"]Welcome to Ave Children's Medical[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" color="rgb(255, 142, 50)" fw="700"]For Health. For Life.[/ld_fancy_heading][ld_fancy_heading tag="p"]There's magic in our energy, our spaces, our people and our discoveries. There's even magic in our motivation: our unblinking belief that we can eradicate childhood disease — so that one day, like magic, children will no longer need us.[/ld_fancy_heading][ld_spacer height="60px"][/vc_column][vc_column][ld_tabs style="s2" primary_color="rgba(7, 38, 140, 0.498)" active_color="rgb(7, 38, 140)" secondary_color="rgb(255, 142, 50)"][ld_tab_section title="Here it’s Different" tab_id="1529413792086-ad80d253-9ee0"][vc_row_inner equal_height="yes" css=".vc_custom_1529415301165{margin-top: 70px !important;margin-right: 0px !important;margin-left: 0px !important;background-color: #e7f0f9 !important;}"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1529415585892{padding-top: 55px !important;padding-right: 30px !important;padding-bottom: 110px !important;padding-left: 45px !important;}" ca_init_translate_y="0" ca_init_translate_x="-30"][ld_fancy_heading tag="h2"]A century of caring for children[/ld_fancy_heading][ld_spacer height="5px"][ld_fancy_heading tag="p"]You always know what's best for your kid, so if a time comes when you need help, here's one more thing to know: not all hospitals can deliver the same quality of care.[/ld_fancy_heading][ld_spacer height="25px"][ld_button style="btn-naked" title="Discover why different matters" i_type="fontawesome" i_add_icon="true" fs="18px" fw="700" lh="1.25em" i_icon_fontawesome="fa fa-angle-right" i_margin_left="20px" hover_color="rgb(7, 38, 140)"][/vc_column_inner][vc_column_inner offset="vc_col-md-7" css=".vc_custom_1537775601306{margin-right: -15px !important;margin-left: -15px !important;background-image: url(http://medical.liquid-themes.com/wp-content/uploads/2018/09/tab-1-min.jpg?id=4046) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="4046" img_size="full" invisible="yes" css=".vc_custom_1537775592048{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Our Mission and Values" tab_id="ld-1537776528135-6fbdfa1a-b26a"][vc_row_inner equal_height="yes" css=".vc_custom_1529415301165{margin-top: 70px !important;margin-right: 0px !important;margin-left: 0px !important;background-color: #e7f0f9 !important;}"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1529415585892{padding-top: 55px !important;padding-right: 30px !important;padding-bottom: 110px !important;padding-left: 45px !important;}" ca_init_translate_y="0" ca_init_translate_x="-30"][ld_fancy_heading tag="h2"]A century of caring for children[/ld_fancy_heading][ld_spacer height="5px"][ld_fancy_heading tag="p"]You always know what's best for your kid, so if a time comes when you need help, here's one more thing to know: not all hospitals can deliver the same quality of care.[/ld_fancy_heading][ld_spacer height="25px"][ld_button style="btn-naked" title="Discover why different matters" i_type="fontawesome" i_add_icon="true" fs="18px" fw="700" lh="1.25em" i_icon_fontawesome="fa fa-angle-right" i_margin_left="20px" hover_color="rgb(7, 38, 140)"][/vc_column_inner][vc_column_inner offset="vc_col-md-7" css=".vc_custom_1537775601306{margin-right: -15px !important;margin-left: -15px !important;background-image: url(http://medical.liquid-themes.com/wp-content/uploads/2018/09/tab-1-min.jpg?id=4046) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="4046" img_size="full" invisible="yes" css=".vc_custom_1537775592048{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Leadership Team" tab_id="ld-1537776526603-4bd46a02-e02e"][vc_row_inner equal_height="yes" css=".vc_custom_1529415301165{margin-top: 70px !important;margin-right: 0px !important;margin-left: 0px !important;background-color: #e7f0f9 !important;}"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1529415585892{padding-top: 55px !important;padding-right: 30px !important;padding-bottom: 110px !important;padding-left: 45px !important;}" ca_init_translate_y="0" ca_init_translate_x="-30"][ld_fancy_heading tag="h2"]A century of caring for children[/ld_fancy_heading][ld_spacer height="5px"][ld_fancy_heading tag="p"]You always know what's best for your kid, so if a time comes when you need help, here's one more thing to know: not all hospitals can deliver the same quality of care.[/ld_fancy_heading][ld_spacer height="25px"][ld_button style="btn-naked" title="Discover why different matters" i_type="fontawesome" i_add_icon="true" fs="18px" fw="700" lh="1.25em" i_icon_fontawesome="fa fa-angle-right" i_margin_left="20px" hover_color="rgb(7, 38, 140)"][/vc_column_inner][vc_column_inner offset="vc_col-md-7" css=".vc_custom_1537775601306{margin-right: -15px !important;margin-left: -15px !important;background-image: url(http://medical.liquid-themes.com/wp-content/uploads/2018/09/tab-1-min.jpg?id=4046) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="4046" img_size="full" invisible="yes" css=".vc_custom_1537775592048{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Tabs 2 
	$data = array();
	$data['name'] = esc_html__( 'Tabs 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/tabs/tabs2.jpg' );
	$data['sort_name'] = 'tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1533120656997{padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column][ld_tabs style="s9" transform="uppercase" use_custom_fonts_nav="true" primary_color="rgb(0, 0, 0)" active_color="rgb(255, 255, 255)" border_color="rgb(239, 239, 239)" fs="12px" ls="0.185em" secondary_color="rgb(243, 245, 246)" bg_color="rgb(255, 255, 255)" hover_bg_color="rgb(85, 83, 200)"][ld_tab_section i_type="linea" title="Services 1" tab_id="1533119390972-97f380aa-e3c2" i_icon_linea="icon-ion-ios-folder-open" i_size="40px"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1533123643901{padding-top: 40px !important;padding-right: 7% !important;padding-bottom: 10px !important;padding-left: 5% !important;}" ca_duration="1200" ca_delay="160" ca_init_translate_y="44"][vc_column_inner offset="vc_col-md-4"][vc_round_chart stroke_width="2"][/vc_column_inner][vc_column_inner offset="vc_col-md-8"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="38px"]Unlimited Possibilities[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(105, 110, 111)" fs="18px" lh="1.888em"]With the One wallet you are up and running as soon as it’s installed, no more syncing! And, with 8 second block times you can actually see your transactions occur in real time![/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section i_type="linea" title="Services 2" tab_id="ld-1533123054385-6e991254-d38f" i_icon_linea="icon-ion-ios-list-box" i_size="40px"][vc_row_inner css=".vc_custom_1533121444809{padding-top: 40px !important;padding-right: 7% !important;padding-bottom: 10px !important;padding-left: 5% !important;}"][vc_column_inner offset="vc_col-md-4"][vc_round_chart stroke_width="2"][/vc_column_inner][vc_column_inner offset="vc_col-md-8"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="38px"]Unlimited Possibilities[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(105, 110, 111)" fs="18px" lh="1.888em"]With the One wallet you are up and running as soon as it’s installed, no more syncing! And, with 8 second block times you can actually see your transactions occur in real time![/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section i_type="linea" title="Services 3" tab_id="ld-1533123053857-e9d17f48-03cf" i_icon_linea="icon-ion-ios-briefcase" i_size="40px"][vc_row_inner css=".vc_custom_1533121444809{padding-top: 40px !important;padding-right: 7% !important;padding-bottom: 10px !important;padding-left: 5% !important;}"][vc_column_inner offset="vc_col-md-4"][vc_round_chart stroke_width="2"][/vc_column_inner][vc_column_inner offset="vc_col-md-8"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="38px"]Unique Options[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(105, 110, 111)" fs="18px" lh="1.888em"]With the One wallet you are up and running as soon as it’s installed, no more syncing! And, with 8 second block times you can actually see your transactions occur in real time![/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section i_type="linea" title="Services 4" tab_id="ld-1533123053355-97a3cc6a-3329" i_icon_linea="icon-md-pie" i_size="40px"][vc_row_inner css=".vc_custom_1533121444809{padding-top: 40px !important;padding-right: 7% !important;padding-bottom: 10px !important;padding-left: 5% !important;}"][vc_column_inner offset="vc_col-md-4"][vc_round_chart stroke_width="2"][/vc_column_inner][vc_column_inner offset="vc_col-md-8"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="38px"]Unique Options[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(105, 110, 111)" fs="18px" lh="1.888em"]With the One wallet you are up and running as soon as it’s installed, no more syncing! And, with 8 second block times you can actually see your transactions occur in real time![/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Tabs 3
	$data = array();
	$data['name'] = esc_html__( 'Tabs 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/tabs/tabs3.jpg' );
	$data['sort_name'] = 'tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1533200633779{padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column][ld_tabs style="s6" title="Utilities" active_color="rgb(14, 48, 93)" border_color="rgb(255, 199, 10)"][ld_tab_section title="Business" tab_id="1533200317764-ac74f373-16fd"][vc_row_inner css=".vc_custom_1533201189477{padding-left: 7% !important;}"][vc_column_inner][ld_fancy_heading tag="h2"]Quality and precision that honors architectural vision[/ld_fancy_heading][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-12"][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="Business Consultation" image="4108" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(255, 199, 10)" ib_fs="12px" ib_ls="0.2em" ib_b_color="rgb(255, 199, 10)" ib_color2="rgb(255, 255, 255)" overlay_color="rgba(0, 0, 0, 0.55)" blur_radius="50"]<span style="color: #ffffff; font-size: 16px;">Through a unique combination of engineering, construction and design disciplines and expertise.</span>[/ld_content_box][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-10"][vc_column_text]One Construction employs over 3 000 employees, the majority of whom are based on project sites. We embrace holistic development and support for employees.

<hr />

<ul>
 	<li>Business-Plan Consulting</li>
 	<li>Packing and Unpacking Service</li>
 	<li>Hospital-Bill Auditing</li>
 	<li>Dry-Cleaning Pickup &amp; Delivery</li>
 	<li>Court-Paper Serving</li>
 	<li>Porcelain Repair</li>
 	<li>Cover Letter/Resume Service</li>
 	<li>Tax-Form Preparer</li>
 	<li>Used-Car Inspection</li>
 	<li>Professional Organizer</li>
</ul>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Consultation" tab_id="ld-1540892380633-ac11e805-d3a4"][vc_row_inner css=".vc_custom_1533201189477{padding-left: 7% !important;}"][vc_column_inner][ld_fancy_heading tag="h2"]Quality and precision that honors architectural vision[/ld_fancy_heading][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-12"][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="Business Consultation" image="4108" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(255, 199, 10)" ib_fs="12px" ib_ls="0.2em" ib_b_color="rgb(255, 199, 10)" ib_color2="rgb(255, 255, 255)" overlay_color="rgba(0, 0, 0, 0.55)" blur_radius="50"]<span style="color: #ffffff; font-size: 16px;">Through a unique combination of engineering, construction and design disciplines and expertise.</span>[/ld_content_box][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-10"][vc_column_text]One Construction employs over 3 000 employees, the majority of whom are based on project sites. We embrace holistic development and support for employees.

<hr />

<ul>
 	<li>Business-Plan Consulting</li>
 	<li>Packing and Unpacking Service</li>
 	<li>Hospital-Bill Auditing</li>
 	<li>Dry-Cleaning Pickup &amp; Delivery</li>
 	<li>Court-Paper Serving</li>
 	<li>Porcelain Repair</li>
 	<li>Cover Letter/Resume Service</li>
 	<li>Tax-Form Preparer</li>
 	<li>Used-Car Inspection</li>
 	<li>Professional Organizer</li>
</ul>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Digital" tab_id="ld-1540892380298-e81a8c40-36e8"][vc_row_inner css=".vc_custom_1533201189477{padding-left: 7% !important;}"][vc_column_inner][ld_fancy_heading tag="h2"]Quality and precision that honors architectural vision[/ld_fancy_heading][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-12"][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="Business Consultation" image="4108" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(255, 199, 10)" ib_fs="12px" ib_ls="0.2em" ib_b_color="rgb(255, 199, 10)" ib_color2="rgb(255, 255, 255)" overlay_color="rgba(0, 0, 0, 0.55)" blur_radius="50"]<span style="color: #ffffff; font-size: 16px;">Through a unique combination of engineering, construction and design disciplines and expertise.</span>[/ld_content_box][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-10"][vc_column_text]One Construction employs over 3 000 employees, the majority of whom are based on project sites. We embrace holistic development and support for employees.

<hr />

<ul>
 	<li>Business-Plan Consulting</li>
 	<li>Packing and Unpacking Service</li>
 	<li>Hospital-Bill Auditing</li>
 	<li>Dry-Cleaning Pickup &amp; Delivery</li>
 	<li>Court-Paper Serving</li>
 	<li>Porcelain Repair</li>
 	<li>Cover Letter/Resume Service</li>
 	<li>Tax-Form Preparer</li>
 	<li>Used-Car Inspection</li>
 	<li>Professional Organizer</li>
</ul>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Finance" tab_id="ld-1540892379898-28ba5c67-8a03"][vc_row_inner css=".vc_custom_1533201189477{padding-left: 7% !important;}"][vc_column_inner][ld_fancy_heading tag="h2"]Quality and precision that honors architectural vision[/ld_fancy_heading][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-12"][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="Business Consultation" image="4108" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(255, 199, 10)" ib_fs="12px" ib_ls="0.2em" ib_b_color="rgb(255, 199, 10)" ib_color2="rgb(255, 255, 255)" overlay_color="rgba(0, 0, 0, 0.55)" blur_radius="50"]<span style="color: #ffffff; font-size: 16px;">Through a unique combination of engineering, construction and design disciplines and expertise.</span>[/ld_content_box][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-10"][vc_column_text]One Construction employs over 3 000 employees, the majority of whom are based on project sites. We embrace holistic development and support for employees.

<hr />

<ul>
 	<li>Business-Plan Consulting</li>
 	<li>Packing and Unpacking Service</li>
 	<li>Hospital-Bill Auditing</li>
 	<li>Dry-Cleaning Pickup &amp; Delivery</li>
 	<li>Court-Paper Serving</li>
 	<li>Porcelain Repair</li>
 	<li>Cover Letter/Resume Service</li>
 	<li>Tax-Form Preparer</li>
 	<li>Used-Car Inspection</li>
 	<li>Professional Organizer</li>
</ul>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Construction" tab_id="ld-1540892379165-54c04bb2-500e"][vc_row_inner css=".vc_custom_1533201189477{padding-left: 7% !important;}"][vc_column_inner][ld_fancy_heading tag="h2"]Quality and precision that honors architectural vision[/ld_fancy_heading][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-12"][ld_content_box style="s06" add_shadow="shadowed" show_button="yes" ib_style="btn-underlined" ib_title="Discover One" ib_transformation="text-uppercase" title="Business Consultation" image="4108" ib_color="rgb(255, 255, 255)" ib_hover_color="rgb(255, 199, 10)" ib_fs="12px" ib_ls="0.2em" ib_b_color="rgb(255, 199, 10)" ib_color2="rgb(255, 255, 255)" overlay_color="rgba(0, 0, 0, 0.55)" blur_radius="50"]<span style="color: #ffffff; font-size: 16px;">Through a unique combination of engineering, construction and design disciplines and expertise.</span>[/ld_content_box][ld_spacer][/vc_column_inner][vc_column_inner offset="vc_col-md-10"][vc_column_text]One Construction employs over 3 000 employees, the majority of whom are based on project sites. We embrace holistic development and support for employees.

<hr />

<ul>
 	<li>Business-Plan Consulting</li>
 	<li>Packing and Unpacking Service</li>
 	<li>Hospital-Bill Auditing</li>
 	<li>Dry-Cleaning Pickup &amp; Delivery</li>
 	<li>Court-Paper Serving</li>
 	<li>Porcelain Repair</li>
 	<li>Cover Letter/Resume Service</li>
 	<li>Tax-Form Preparer</li>
 	<li>Used-Car Inspection</li>
 	<li>Professional Organizer</li>
</ul>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Tabs 4 
	$data = array();
	$data['name'] = esc_html__( 'Tabs 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/tabs/tabs4.jpg' );
	$data['sort_name'] = 'tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1545669476180{padding-top: 80px !important;padding-bottom: 70px !important;background-color: #f3f5f8 !important;}"][vc_column][ld_fancy_heading tag="h2" alignment="text-center"]Total Design Freedom[/ld_fancy_heading][ld_fancy_heading tag="h6" alignment="text-center" use_custom_fonts_title="true" fs="16px" lh="25px" color="rgba(24, 27, 49, 0.502)"]Free lifetime updates, and bonus plugins included in the package![/ld_fancy_heading][ld_spacer height="20px"][ld_tabs style="s12" tabs_direction="flex-lg-row-reverse" active_color="rgb(255, 255, 255)" border_color="rgb(255, 199, 10)" primary_color="rgb(0, 0, 0)" secondary_color="rgb(156, 36, 36)"][ld_tab_section title="Digital Marketing" tab_id="ld-1546256381987-d3f844c8-9e75" desc="Being the Ave's business, that is person ignis see pulled."][vc_row_inner][vc_column_inner offset="vc_col-md-12"][ld_content_box style="s05" heading_size="fancy-box-heading-custom" add_icon="yes" i_type="linea" title="Build any kind of layout -visually." image="http://opus-two.liquid-themes.com/wp-content/uploads/2019/01/opus-2-fancy-2.jpg" info="Simple yet effective" custom_heading_size="28px" i_icon_linea="icon-weather_cloud_lightning" cb_height="493px"]<span style="color: #b6bdc4; font-size: 16px;">Duis consectetur feugiat auctor. Morbi nec enim luctus, feugiat arcu id, ultricies ante. Duis vel massa eleifend, porta est non, feugiat metus</span>[/ld_content_box][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="User Interface" tab_id="1533200317764-ac74f373-16fde6e5-93f9" desc="Being the Ave's business, that is person ignis see pulled."][vc_row_inner][vc_column_inner offset="vc_col-md-12"][ld_content_box style="s05" heading_size="fancy-box-heading-custom" add_icon="yes" i_type="linea" title="Build any kind of layout -visually." image="http://opus-two.liquid-themes.com/wp-content/uploads/2018/12/opus-2-tabs-2.jpg" info="Simple yet effective" custom_heading_size="28px" i_icon_linea="icon-weather_cloud_lightning" cb_height="493px"]<span style="color: #b6bdc4; font-size: 16px;">Duis consectetur feugiat auctor. Morbi nec enim luctus, feugiat arcu id, ultricies ante. Duis vel massa eleifend, porta est non, feugiat metus</span>[/ld_content_box][/vc_column_inner][/vc_row_inner][/ld_tab_section][ld_tab_section title="Business Consultation" tab_id="ld-1546256382804-15314e8a-a127" desc="Being the Ave's business, that is person ignis see pulled."][vc_row_inner][vc_column_inner offset="vc_col-md-12"][ld_content_box style="s05" heading_size="fancy-box-heading-custom" add_icon="yes" i_type="linea" title="Build any kind of layout -visually." image="http://opus-two.liquid-themes.com/wp-content/uploads/2019/01/opus-2-fancy-3.jpg" info="Simple yet effective" custom_heading_size="28px" i_icon_linea="icon-weather_cloud_lightning" cb_height="493px"]<span style="color: #b6bdc4; font-size: 16px;">Duis consectetur feugiat auctor. Morbi nec enim luctus, feugiat arcu id, ultricies ante. Duis vel massa eleifend, porta est non, feugiat metus</span>[/ld_content_box][/vc_column_inner][/vc_row_inner][/ld_tab_section][/ld_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Team
	//Team 1
	$data = array();
	$data['name'] = esc_html__( 'Team 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/teams/team1.jpg' );
	$data['sort_name'] = 'team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row gap="5" css=".vc_custom_1533027686454{padding-top: 80px !important;padding-bottom: 40px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" ca_duration="1200" ca_init_translate_y="35" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="13px" fw="500" ls="0.175em" color="rgb(116, 126, 128)"]OUR DESIGNERS[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="45px"]Team members[/ld_fancy_heading][ld_spacer height="35px"][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" gap="3" ca_init_scale_x="0.5" ca_init_scale_y="0.5" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1000" ca_delay="150"][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="737" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="738" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="739" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="740" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="741" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="742" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="743" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="744" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="745" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-1/5"][ld_team_member template="overlay" name="Olive Robertson" position="Designer" image="746" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" primary_color="rgba(255, 255, 255, 0.896)" el_class="mb-2"][/ld_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Team 2
	$data = array();
	$data['name'] = esc_html__( 'Team 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/teams/team2.jpg' );
	$data['sort_name'] = 'team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row gap="5" css=".vc_custom_1532682095764{padding-top: 80px !important;padding-bottom: 40px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" fs="14px" color="rgb(116, 126, 128)" ls="0.175em"]OUR DESIGNERS[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="45px"]Team members[/ld_fancy_heading][ld_spacer][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" ca_duration="1200" ca_delay="150" ca_init_translate_y="40"][ld_images_group_container][ld_images_group_element enable_effects="yes" image="4803" margin="bottom_small:-1em"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h3" use_custom_fonts_title="true" ls="-0.02em" lh="1.2em" fs="20px" margin="bottom_small:0px"]Loretta Dean[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="14px" fw="500" ls="0.01em"]Founder[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" ca_duration="1200" ca_start_delay="200" ca_delay="150" ca_init_translate_y="36"][ld_images_group_container][ld_images_group_element enable_effects="yes" image="4801" margin="bottom_small:-1em"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h3" use_custom_fonts_title="true" ls="-0.02em" lh="1.2em" fs="20px" margin="bottom_small:0px"]Loretta Dean[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="14px" fw="500" ls="0.01em"]Co Founder[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" ca_duration="1200" ca_start_delay="400" ca_delay="150" ca_init_translate_y="35"][ld_images_group_container][ld_images_group_element enable_effects="yes" image="4802" margin="bottom_small:-1em"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h3" use_custom_fonts_title="true" ls="-0.02em" lh="1.2em" fs="20px" margin="bottom_small:0px"]Ralph Walsh[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="14px" fw="500" ls="0.01em"]Director[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" ca_duration="1200" ca_start_delay="600" ca_delay="150" ca_init_translate_y="36"][ld_images_group_container][ld_images_group_element enable_effects="yes" image="4803" margin="bottom_small:-1em"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h3" use_custom_fonts_title="true" ls="-0.02em" lh="1.2em" fs="20px" margin="bottom_small:0px"]Viola Rice[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="14px" fw="500" ls="0.01em"]Manager[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Team 3
	$data = array();
	$data['name'] = esc_html__( 'Team 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/teams/team3.jpg' );
	$data['sort_name'] = 'team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540303449478{padding-top: 90px !important;padding-bottom: 50px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" ca_duration="1200" ca_init_translate_y="47" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(116, 126, 128)" fs="14px" lh="1.222em" fw="500" ls="0.175em"]OUR DESIGNERS[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="45px"]Team members[/ld_fancy_heading][ld_spacer height="30px"][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_duration="1200" ca_delay="180" ca_init_translate_x="144" ca_init_translate_y="0" ca_init_translate_z="0" ca_init_rotate_y="-65"][vc_column_inner width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_team_member template="overlay" color_type="text-light" name="Edna Mason" position="Senior Designer" image="618" socials="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-pinterest-p%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-google%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(24, 27, 49, 0.892)"][/ld_team_member][/vc_column_inner][vc_column_inner width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_team_member template="overlay" color_type="text-light" name="Edna Mason" position="Senior Designer" image="617" socials="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-pinterest-p%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-google%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(24, 27, 49, 0.9)"][/ld_team_member][/vc_column_inner][vc_column_inner width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ld_team_member template="overlay" color_type="text-light" name="Edna Mason" position="Senior Designer" image="616" socials="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-pinterest-p%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-google%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(24, 27, 49, 0.9)"][/ld_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Team 4
	$data = array();
	$data['name'] = esc_html__( 'Team 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/teams/team4.jpg' );
	$data['sort_name'] = 'team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1527686311821{padding-bottom: 120px !important;}"][vc_column responsive_align="text-md-left text-xs-center" offset="vc_col-md-6" css=".vc_custom_1527685444427{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fw="300"]Leadership Team[/ld_fancy_heading][/vc_column][vc_column responsive_align="text-md-right text-xs-center" css=".vc_custom_1527685439914{margin-bottom: 45px !important;}" offset="vc_col-md-6"][ld_button style="btn-default" title="Meet the team" transformation="text-uppercase" size="btn-sm" color="rgb(255, 200, 11)" text_color="rgb(24, 27, 49)" fs="13px" fw="700" css=".vc_custom_1533798890907{padding-right: 1.5em !important;padding-left: 1.5em !important;}"][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-4" ca_init_translate_y="20" ca_duration="1200" ca_delay="150"][vc_single_image image="4088" img_size="full" css=".vc_custom_1537629879004{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h3" margin="bottom_large:0"]Gilbert Hughes[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" fw="400" ls="0.1em"]Chairman[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.6em" margin="right_large:10%25"]Gilbert Hughes joined Ave Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][vc_empty_space height="14px"][ld_social_icons style="branded-text" shape="rectangle bordered" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_empty_space][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-4" ca_init_translate_y="20" ca_start_delay="200" ca_duration="1200" ca_delay="150"][vc_single_image image="4089" img_size="full" css=".vc_custom_1537629885245{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h3" margin="bottom_large:0"]Alan Osborne[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" fw="400" ls="0.1em"]Vice President[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.6em" margin="right_large:10%25"]Gilbert Hughes joined Ave Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][vc_empty_space height="14px"][ld_social_icons style="branded-text" shape="rectangle bordered" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_empty_space][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_init_translate_y="20" ca_start_delay="400" ca_duration="1200" ca_delay="150"][vc_single_image image="4090" img_size="full" css=".vc_custom_1537629892072{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h3" margin="bottom_large:0"]Travis Franklin[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" fw="400" ls="0.1em"]Chief Financial Officer[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.6em" margin="right_large:10%25"]Gilbert Hughes joined Ave Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][vc_empty_space height="14px"][ld_social_icons style="branded-text" shape="rectangle bordered" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_empty_space][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Team 5
	$data = array();
	$data['name'] = esc_html__( 'Team 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/teams/team5.jpg' );
	$data['sort_name'] = 'team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1537547122931{padding-top: 125px !important;padding-bottom: 100px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][ld_fancy_heading tag="h2" transform="text-uppercase" margin="bottom_small:0.15em"]Expert Trainers[/ld_fancy_heading][ld_fancy_heading tag="p"]All classes are suitable for both men and women and all levels of fitness welcome.[/ld_fancy_heading][ld_spacer height="40px"][/vc_column][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1" ca_init_translate_y="40" ca_init_translate_z="-32"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_reveal="yes" reveal_direction="tb" image="4065"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h3"]David Richards[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(250, 124, 49)" fs="12px" fw="600" ls="0.1em"]BootCamp Trainer[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p"]Superstrong former athlete with numerous fitness and health awards with 7 published books on Crossfit lifestyle.[/ld_fancy_heading][ld_spacer height="25px"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#828593" hover_color="#fa7d30" font_size="21px"][ld_spacer][/vc_column][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1" ca_init_translate_y="40" ca_init_translate_z="-32"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_reveal="yes" reveal_direction="tb" image="4066"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h3"]Jesse Willis[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(250, 124, 49)" fs="12px" fw="600" ls="0.1em"]Crossfit Trainer[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p"]Superstrong former athlete with numerous fitness and health awards with 7 published books on Crossfit lifestyle.[/ld_fancy_heading][ld_spacer height="25px"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#828593" hover_color="#fa7d30" font_size="21px"][ld_spacer][/vc_column][vc_column width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-1" ca_init_translate_y="40" ca_init_translate_z="-32"][ld_images_group_container][ld_images_group_element enable_effects="yes" enable_reveal="yes" reveal_direction="tb" image="4067"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h3"]Marion Miller[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(250, 124, 49)" fs="12px" fw="600" ls="0.1em"]Spinning Trainer[/ld_fancy_heading][ld_spacer height="15px"][ld_fancy_heading tag="p"]Superstrong former athlete with numerous fitness and health awards with 7 published books on Crossfit lifestyle.[/ld_fancy_heading][ld_spacer height="25px"][ld_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#828593" hover_color="#fa7d30" font_size="21px"][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Team 6
	$data = array();
	$data['name'] = esc_html__( 'Team 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/teams/team6.jpg' );
	$data['sort_name'] = 'team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1538053722461{padding-top: 20px !important;padding-bottom: 80px !important;}" ca_duration="1200" ca_delay="150" ca_init_translate_y="50" el_id="advisors"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(163, 172, 186)" fs="12px" ls="0.2em" margin="bottom_large:1.5em"]OUR DEDICATED TEAM[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="44px"]Our Advisors[/ld_fancy_heading][ld_spacer height="50px"][/vc_column][vc_column][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1532068851753{padding-right: 15px !important;padding-left: 15px !important;}"][ld_team_member template="classic" name="Logan Benjamin" position="ADVISOR" image="4002" socials="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(2, 55, 83)"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using cryptography.</span>[/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1532069266493{padding-right: 15px !important;padding-left: 15px !important;}"][ld_team_member template="classic" name="Logan Benjamin" position="ADVISOR" image="4003" socials="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(2, 55, 83)"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using cryptography.</span>[/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1532069271914{padding-right: 15px !important;padding-left: 15px !important;}"][ld_team_member template="classic" name="Logan Benjamin" position="ADVISOR" image="4004" socials="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(2, 55, 83)"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using cryptography.</span>[/ld_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1532069276551{padding-right: 15px !important;padding-left: 15px !important;}"][ld_team_member template="classic" name="Logan Benjamin" position="ADVISOR" image="4005" socials="%5B%7B%22network%22%3A%22fa-facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgb(2, 55, 83)"]<span style="color: #6a7c92;">Bitcoin is designed around the idea of using cryptography.</span>[/ld_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testmonials Category
	//Clients 1
	$data = array();
	$data['name'] = esc_html__( 'Clients 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/clients1.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1533128856750{margin-bottom: 20px !important;padding-top: 80px !important;padding-bottom: 90px !important;}"][vc_column][ld_carousel columns="lg:6|md:5|sm:4|xs:3|spacing_sm:15px|spacing_xs:5px" inactiv_opacity="1" wraparound="yes"][vc_single_image image="626" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028798285{margin-bottom: 0px !important;}"][vc_single_image image="624" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028775651{margin-bottom: 0px !important;}"][vc_single_image image="625" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028786728{margin-bottom: 0px !important;}"][vc_single_image image="627" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028855958{margin-bottom: 0px !important;}"][vc_single_image image="627" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028855958{margin-bottom: 0px !important;}"][vc_single_image image="626" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028798285{margin-bottom: 0px !important;}"][vc_single_image image="724" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028891532{margin-bottom: 0px !important;}"][vc_single_image image="628" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028869207{margin-bottom: 0px !important;}"][vc_single_image image="626" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028798285{margin-bottom: 0px !important;}"][vc_single_image image="627" img_size="full" alignment="center" enable_opacity="yes" opacity="0.3" css=".vc_custom_1533028855958{margin-bottom: 0px !important;}"][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 2
	$data = array();
	$data['name'] = esc_html__( 'Clients 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/clients2.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row gap="0" equal_height="yes" css=".vc_custom_1533035237065{padding-top: 55px !important;padding-bottom: 55px !important;}"][vc_column][vc_row_inner equal_height="yes" content_placement="middle" gap="0"][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1533036346730{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 1px !important;padding-top: 76px !important;padding-bottom: 77px !important;border-left-color: #efefef !important;border-left-style: solid !important;border-right-color: #efefef !important;border-right-style: solid !important;border-top-color: #efefef !important;border-top-style: solid !important;}"][vc_single_image image="624" img_size="full" alignment="center" css=".vc_custom_1533035278293{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1533035529705{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-left-color: #efefef !important;border-left-style: solid !important;border-right-color: #efefef !important;border-right-style: solid !important;border-top-color: #efefef !important;border-top-style: solid !important;}"][vc_single_image image="625" img_size="full" alignment="center" css=".vc_custom_1533035290522{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1533035503413{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-left-color: #efefef !important;border-left-style: solid !important;border-right-color: #efefef !important;border-right-style: solid !important;border-top-color: #efefef !important;border-top-style: solid !important;}"][vc_single_image image="626" img_size="full" alignment="center" css=".vc_custom_1533035300670{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1533036333918{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 1px !important;padding-top: 80px !important;padding-bottom: 72px !important;border-left-color: #efefef !important;border-left-style: solid !important;border-right-color: #efefef !important;border-right-style: solid !important;border-top-color: #efefef !important;border-top-style: solid !important;}"][vc_single_image image="627" img_size="full" alignment="center" css=".vc_custom_1533035314462{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1533036259034{margin-top: -10px !important;}"][vc_row_inner equal_height="yes" content_placement="middle" gap="0"][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1533036364258{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 82px !important;padding-bottom: 82px !important;border-left-color: #efefef !important;border-left-style: solid !important;border-right-color: #efefef !important;border-right-style: solid !important;border-top-color: #efefef !important;border-top-style: solid !important;border-bottom-color: #efefef !important;border-bottom-style: solid !important;}"][vc_single_image image="626" img_size="full" alignment="center" css=".vc_custom_1533035742668{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1533035688258{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-left-color: #efefef !important;border-left-style: solid !important;border-right-color: #efefef !important;border-right-style: solid !important;border-top-color: #efefef !important;border-top-style: solid !important;border-bottom-color: #efefef !important;border-bottom-style: solid !important;}"][vc_single_image image="724" img_size="full" alignment="center" css=".vc_custom_1533035722643{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1533036383867{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 78px !important;padding-bottom: 79px !important;border-left-color: #efefef !important;border-left-style: solid !important;border-right-color: #efefef !important;border-right-style: solid !important;border-top-color: #efefef !important;border-top-style: solid !important;border-bottom-color: #efefef !important;border-bottom-style: solid !important;}"][vc_single_image image="624" img_size="full" alignment="center" css=".vc_custom_1533035769913{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1533036403544{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 76px !important;padding-bottom: 76px !important;border-left-color: #efefef !important;border-left-style: solid !important;border-right-color: #efefef !important;border-right-style: solid !important;border-top-color: #efefef !important;border-top-style: solid !important;border-bottom-color: #efefef !important;border-bottom-style: solid !important;}"][vc_single_image image="628" img_size="full" alignment="center" css=".vc_custom_1533035709378{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 1
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 01', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials1.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" ca_init_translate_y="55" ca_init_rotate_x="-1" el_id="testi" ca_duration="1200" ca_delay="150"][vc_column width="5/6" offset="vc_col-md-offset-3 vc_col-md-6 vc_col-sm-offset-1"][ld_fancy_heading tag="h2" alignment="text-center" init_values="translateY:80,opacity:0" margin="bottom_small:0px"]<span style="color: #3ed2a7;">Real </span>Testimonials[/ld_fancy_heading][vc_empty_space height="20px"][ld_fancy_heading tag="p" alignment="text-center" use_custom_fonts_title="true" fs="18px" lh="1.5em"]Don’t just take our words for it. Our clients are our biggest supporters. Would you like to know what they think about us?[/ld_fancy_heading][vc_empty_space height="65px"][/vc_column][vc_column width="5/6" offset="vc_col-lg-offset-0 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1 vc_col-xs-12" css=".vc_custom_1535969157430{padding-right: 2.5% !important;padding-left: 2.5% !important;}"][ld_testimonial style="testi_s08" rating="5" title="Mable Cobb" avatar="4005" star_color="rgb(255, 176, 159)"]<span style="font-size: 18px; line-height: 30px; color: #808291;"><em>“Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia.”</em></span>[/ld_testimonial][/vc_column][vc_column width="5/6" offset="vc_col-lg-offset-0 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1 vc_col-xs-12" css=".vc_custom_1535969165002{padding-right: 2.5% !important;padding-left: 2.5% !important;}"][ld_testimonial style="testi_s08" rating="5" title="Patrick Norris" avatar="4007" star_color="rgb(255, 176, 159)"]<span style="font-size: 18px; line-height: 30px; color: #808291;"><em>“Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia.”</em></span>[/ld_testimonial][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 2
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 02', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials2.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542958968945{padding-top: 50px !important;padding-bottom: 120px !important;}"][vc_column][ld_carousel columns="1" inactiv_opacity="0.2" cellalign="left" prevnextbuttons="yes" fullwidthside="yes" groupcells="no" navarrow="6" navsize="carousel-nav-lg" navfill="carousel-nav-bordered" navshape="carousel-nav-circle" navhalign="carousel-nav-right" navfloated="carousel-nav-floated" navdirection="carousel-nav-vertical" navline="carousel-nav-line-between" navoffset="right: 100px" nav_arrow_color="rgb(139, 140, 179)" nav_arrow_color_hover="rgb(24, 27, 49)" nav_border_color="rgb(139, 140, 179)" nav_bg_hcolor="rgb(237, 187, 12)" nav_border_hcolor="rgb(237, 187, 12)"][vc_row_inner][vc_column_inner offset="vc_col-md-9"][ld_testimonial style="testi_s07" avatar="4026" title="Dylan Gordon" position="Conecom Creative Director" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.545)"]<span style="color: #ff546c;"><strong><span style="text-transform: uppercase; font-size: 14px; letter-spacing: 0.2em;">nice words from nice clients</span></strong></span></p>
<p><span style="color: #ffffff;"><em><span style="font-size: 30px; line-height: 48px;">“Eugenia is very detail-oriented, which is essential in her line of work; she has a keen eye for relevant digital content, and is superb at understanding a brief, communicating her ideas, and delivering standout results on time and in budget.”</span></em></span>[/ld_testimonial][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner offset="vc_col-md-9"][ld_testimonial style="testi_s07" avatar="4025" title="Walter Ferguson" position="ABC Sales &amp; Marketing" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.545)"]<span style="color: #ff546c;"><strong><span style="text-transform: uppercase; font-size: 14px; letter-spacing: 0.2em;">nice words from nice clients</span></strong></span></p>
<p><span style="color: #ffffff;"><em><span style="font-size: 30px; line-height: 48px;">Working with Eugenia is always a pleasure! She is a talented and patient designer who works hard to produce consistent, stellar work every time. I have hired her on a number of occasions and she always deliver!</span></em></span>[/ld_testimonial][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner offset="vc_col-md-9"][ld_testimonial style="testi_s07" avatar="2874" title="Dylan Gordon" position="Conecom Creative Director" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.545)"]<span style="color: #ff546c;"><strong><span style="text-transform: uppercase; font-size: 14px; letter-spacing: 0.2em;">nice words from nice clients</span></strong></span></p>
<p><span style="color: #ffffff;"><em><span style="font-size: 30px; line-height: 48px;">“Eugenia is very detail-oriented, which is essential in her line of work; she has a keen eye for relevant digital content, and is superb at understanding a brief, communicating her ideas, and delivering standout results on time and in budget.”</span></em></span>[/ld_testimonial][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner offset="vc_col-md-9"][ld_testimonial style="testi_s07" avatar="4026" title="Walter Ferguson" position="ABC Sales &amp; Marketing" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.545)"]<span style="color: #ff546c;"><strong><span style="text-transform: uppercase; font-size: 14px; letter-spacing: 0.2em;">nice words from nice clients</span></strong></span></p>
<p><span style="color: #ffffff;"><em><span style="font-size: 30px; line-height: 48px;">Working with Eugenia is always a pleasure! She is a talented and patient designer who works hard to produce consistent, stellar work every time. I have hired her on a number of occasions and she always deliver!</span></em></span>[/ld_testimonial][/vc_column_inner][/vc_row_inner][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 3
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 03', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials3.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" css=".vc_custom_1529665490851{margin-top: 40px !important;margin-bottom: 40px !important;padding-top: 85px !important;padding-bottom: 85px !important;background-color: #0c3e72 !important;}"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" transform="text-uppercase" color="rgb(255, 255, 255)" margin="bottom_large:0"]Customer Reviews[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6" el_id="testi-carousel-nav" responsive_align="text-md-right text-xs-left"][/vc_column][vc_column][ld_spacer height="25px"][vc_separator color="custom" accent_color="rgba(255,255,255,0.1)"][ld_spacer height="15px"][/vc_column][vc_column offset="vc_col-md-3" css=".vc_custom_1536829298763{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 35px !important;padding-bottom: 30px !important;padding-left: 35px !important;background-color: #0a345f !important;}" responsive_css="margin_bottom_medium:0px"][ld_fancy_heading tag="h3" color="rgb(255, 255, 255)"]Excellent[/ld_fancy_heading][ld_spacer height="10px"][vc_single_image image="64" img_size="full" css=".vc_custom_1529664639079{margin-bottom: 0px !important;}"][ld_spacer height="25px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="14px" lh="1.714em" ls="0.05em"]<span style="color: #a7a9b8;">Based on 702 reviews See all reviews here</span>[/ld_fancy_heading][ld_spacer height="25px0"][vc_single_image image="65" img_size="full" css=".vc_custom_1529664619204{margin-bottom: 0px !important;}"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-8"][ld_carousel columns="sm:2|xs:1|spacing_sm:8%25|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" navappend="custom_id" wraparound="yes" navfill="carousel-nav-solid" navshape="carousel-nav-rectangle" navshadow="carousel-nav-shadowed-onhover" navhalign="carousel-nav-right" paddings="8%" navappend_id="#testi-carousel-nav" nav_arrow_color="rgb(255, 255, 255)" nav_arrow_color_hover="rgb(255, 255, 255)" nav_bg_color="rgb(24, 27, 49)" nav_bg_hcolor="rgb(36, 147, 224)"][ld_testimonial style="testi_s02" details_size="testimonial-details-sm" rating="5" title="Dale Briggs" date_time="3 hours ago" title_color="rgb(255, 255, 255)"]</p>
<h6><span style="color: #ffffff;">Great tour director and driver!!!!</span></h6>
<p><span style="font-size: 13px; line-height: 24px; color: #a7a9b8;">We just got back from our best vacation ever and we wanted to thank you and your team for your excellent work...</span>[/ld_testimonial][ld_testimonial style="testi_s02" details_size="testimonial-details-sm" rating="5" title="Nancy Tyler" date_time="3 hours ago" title_color="rgb(255, 255, 255)"]</p>
<h6><span style="color: #ffffff;">Everything was well planned</span></h6>
<p><span style="font-size: 13px; line-height: 24px; color: #a7a9b8;">From the initial contact till the end of the trip, everything was planned out, taken care of, and done with perfection...</span>[/ld_testimonial][ld_testimonial style="testi_s02" details_size="testimonial-details-sm" rating="5" title="Dale Briggs" date_time="3 hours ago" title_color="rgb(255, 255, 255)"]</p>
<h6><span style="color: #ffffff;">Great tour director and driver!!!!</span></h6>
<p><span style="font-size: 13px; line-height: 24px; color: #a7a9b8;">We just got back from our best vacation ever and we wanted to thank you and your team for your excellent work...</span>[/ld_testimonial][ld_testimonial style="testi_s02" details_size="testimonial-details-sm" rating="5" title="Nancy Tyler" date_time="3 hours ago" title_color="rgb(255, 255, 255)"]</p>
<h6><span style="color: #ffffff;">Everything was well planned</span></h6>
<p><span style="font-size: 13px; line-height: 24px; color: #a7a9b8;">From the initial contact till the end of the trip, everything was planned out, taken care of, and done with perfection...</span>[/ld_testimonial][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 4
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 04', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials4.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" enable_overlay="yes" css=".vc_custom_1537621145647{margin-top: 80px !important;margin-bottom: 80px !important;padding-top: 15vw !important;padding-bottom: 15vw !important;background-image: url(http://mobile.liquid-themes.com/wp-content/uploads/2018/09/testimonials-bg-min.jpg?id=115) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="linear-gradient(90deg, #181b31 0%, rgba(255, 255, 255, 0) 100%)"][vc_column offset="vc_col-md-6"][ld_carousel columns="xs:1|spacing_xs:15px" inactiv_opacity="1" pagenationdots="yes" wraparound="yes" align_dots="carousel-dots-left" size_dots="carousel-dots-md" dots_bg_color="rgba(255, 255, 255, 0.502)" dots_bg_hcolor="rgb(255, 255, 255)"][ld_testimonial title="Antonio Jensen" position="Creative Director" avatar="121" title_color="rgb(253, 98, 60)" pos_color="rgba(255, 255, 255, 0.498)"]<span style="font-size: 36px; line-height: 55px; color: #ffffff;">“Ave’s service is absolute awesome, I’ve never used a PM tool so intuitive.”</span>[/ld_testimonial][ld_testimonial title="Antonio Jensen" position="Creative Director" avatar="120" title_color="rgb(253, 98, 60)" pos_color="rgba(255, 255, 255, 0.498)"]<span style="font-size: 36px; line-height: 55px; color: #ffffff;">“Ave’s service is absolute awesome, I’ve never used a PM tool so intuitive.”</span>[/ld_testimonial][ld_testimonial title="Antonio Jensen" position="Creative Director" avatar="121" title_color="rgb(253, 98, 60)" pos_color="rgba(255, 255, 255, 0.498)"]<span style="font-size: 36px; line-height: 55px; color: #ffffff;">“Ave’s service is absolute awesome, I’ve never used a PM tool so intuitive.”</span>[/ld_testimonial][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 5
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 05', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials14.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1543472667895{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column][ld_section_title title="REAL TESTIMONIALS" alignment="text-center" title_top_margin="0" title_bottom_margin="0" add_line="title-underline" subtitle_top_margin="0" subtitle_bottom_margin="10" text_top_margin="0" text_bottom_margin="0" use_custom_fonts_title="true" fs="12px" fw="600" ls="0.2em" color="rgb(68, 50, 39)" css=".vc_custom_1543483939046{margin-left: -148px !important;}"][ld_spacer][/vc_column][vc_column responsive_css="padding_right_medium:7%25|padding_left_medium:7%25"][ld_testi_carousel template="left-nav"][ld_testi author="Ivana Jones" text="Founder" image="56"]<span style="font-size: 18px; line-height: 0.7em; color: #696e6f;">The fastest theme ever built: Don’t compromise the speed and efficiency. Next-generation technologies, on demand loading and adaptive content deliver the maximum performance.</span>[/ld_testi][ld_testi author="Ivana Jones" text="Founder" image="56"]<span style="font-size: 18px; line-height: 0.7em; color: #696e6f;">The fastest theme ever built: Don’t compromise the speed and efficiency. Next-generation technologies, on demand loading and adaptive content deliver the maximum performance.</span>[/ld_testi][ld_testi author="Ivana Jones" text="Founder" image="56"]<span style="font-size: 18px; line-height: 0.7em; color: #696e6f;">The fastest theme ever built: Don’t compromise the speed and efficiency. Next-generation technologies, on demand loading and adaptive content deliver the maximum performance.</span>[/ld_testi][ld_testi author="Ivana Jones" text="Founder" image="56"]<span style="font-size: 18px; line-height: 0.7em; color: #696e6f;">The fastest theme ever built: Don’t compromise the speed and efficiency. Next-generation technologies, on demand loading and adaptive content deliver the maximum performance.</span>[/ld_testi][/ld_testi_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Testimonials 6
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 06', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials5.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1539250487278{padding-top: 30px !important;}" ca_delay="180" ca_init_translate_x="0" ca_duration="1200" ca_init_translate_y="49"][vc_column offset="vc_col-md-6"][ld_testimonial style="testi_s04" align="text-center" enable_shadow="" title="Robert Houston" position="Florida, USA" avatar="4063" title_color="rgb(7, 38, 140)" pos_color="rgba(7, 38, 140, 0.703)" fill_color="rgb(231, 240, 249)"]<span style="font-size: 18px; line-height: 30px;">“Every single person I encountered was kind, friendly and patient enough to explain everything about my child care – and in a way I could understand! I am so thankful I came to Ave Children’s Hospital!”</span>[/ld_testimonial][/vc_column][vc_column offset="vc_col-md-6"][ld_testimonial style="testi_s04" align="text-center" enable_shadow="" title="Eleanor Delgado" position="New Jersey, USA" avatar="4062" title_color="rgb(7, 38, 140)" pos_color="rgba(7, 38, 140, 0.703)" fill_color="rgb(231, 240, 249)"]<span style="font-size: 18px; line-height: 30px;">“Thanks to them, my child can talk, can walk a good distance and my child has some mobility in my arms and legs. My child was in really good hands with all of the staff and all of the doctors.”</span>[/ld_testimonial][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 7
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 07', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials6.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1527686311821{padding-bottom: 120px !important;}"][vc_column responsive_align="text-md-left text-xs-center" offset="vc_col-md-6" css=".vc_custom_1527685444427{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fw="300"]Leadership Team[/ld_fancy_heading][/vc_column][vc_column responsive_align="text-md-right text-xs-center" css=".vc_custom_1527685439914{margin-bottom: 45px !important;}" offset="vc_col-md-6"][ld_button style="btn-default" title="Meet the team" transformation="text-uppercase" size="btn-sm" color="rgb(255, 200, 11)" text_color="rgb(24, 27, 49)" fs="13px" fw="700" css=".vc_custom_1533798890907{padding-right: 1.5em !important;padding-left: 1.5em !important;}"][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-4" ca_init_translate_y="20" ca_duration="1200" ca_delay="150"][vc_single_image image="4088" img_size="full" css=".vc_custom_1537629879004{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h3" margin="bottom_large:0"]Gilbert Hughes[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" fw="400" ls="0.1em"]Chairman[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.6em" margin="right_large:10%25"]Gilbert Hughes joined Ave Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][vc_empty_space height="14px"][ld_social_icons style="branded-text" shape="rectangle bordered" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_empty_space][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-4" ca_init_translate_y="20" ca_start_delay="200" ca_duration="1200" ca_delay="150"][vc_single_image image="4089" img_size="full" css=".vc_custom_1537629885245{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h3" margin="bottom_large:0"]Alan Osborne[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" fw="400" ls="0.1em"]Vice President[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.6em" margin="right_large:10%25"]Gilbert Hughes joined Ave Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][vc_empty_space height="14px"][ld_social_icons style="branded-text" shape="rectangle bordered" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_empty_space][/vc_column][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-4" ca_init_translate_y="20" ca_start_delay="400" ca_duration="1200" ca_delay="150"][vc_single_image image="4090" img_size="full" css=".vc_custom_1537629892072{margin-bottom: 22px !important;}"][ld_fancy_heading tag="h3" margin="bottom_large:0"]Travis Franklin[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(167, 169, 184)" fs="12px" fw="400" ls="0.1em"]Chief Financial Officer[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.6em" margin="right_large:10%25"]Gilbert Hughes joined Ave Constructon in 1955 as an estimator/project manager, after previously working months as a laborer.[/ld_fancy_heading][vc_empty_space height="14px"][ld_social_icons style="branded-text" shape="rectangle bordered" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_empty_space][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 8
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 08', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials7.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1540480654951{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1200" ca_init_translate_y="61"][ld_testi_carousel][ld_testi author="Leon Blake" image="921"]<span style="font-size: 36px; color: #000000;"><strong>“One is the early leader...</strong></span><br />
<span style="font-size: 30px; color: #000000;">They are actually making the entire ecosystem.”a</span>[/ld_testi][ld_testi author="Chris Peter" image="922"]<span style="font-size: 36px; color: #000000;"><strong>“One is the early leader...</strong></span><br />
<span style="font-size: 30px; color: #000000;">They are actually making the entire ecosystem.”</span>[/ld_testi][ld_testi author="Darrell Conner" image="923"]<span style="font-size: 36px; color: #000000;"><strong>“One is the early leader...</strong></span><br />
<span style="font-size: 30px; color: #000000;">They are actually making the entire ecosystem.”</span>[/ld_testi][ld_testi author="Daniel Floyd" image="924"]<span style="font-size: 36px; color: #000000;"><strong>“One is the early leader...</strong></span><br />
<span style="font-size: 30px; color: #000000;">They are actually making the entire ecosystem.”</span>[/ld_testi][ld_testi author="Darrell Conner" image="923"]<span style="font-size: 36px; color: #000000;"><strong>“One is the early leader...</strong></span><br />
<span style="font-size: 30px; color: #000000;">They are actually making the entire ecosystem.”</span>[/ld_testi][ld_testi author="Chris Peter" image="922"]<span style="font-size: 36px; color: #000000;"><strong>“One is the early leader...</strong></span><br />
<span style="font-size: 30px; color: #000000;">They are actually making the entire ecosystem.”</span>[/ld_testi][/ld_testi_carousel][ld_spacer height="85px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 9
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 09', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials8.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" css=".vc_custom_1537449334395{padding-top: 65px !important;padding-bottom: 55px !important;}" ca_init_translate_x="1" ca_init_translate_y="46" ca_duration="1200" ca_delay="150"][vc_column width="5/6" offset="vc_col-md-6"][ld_testimonial style="testi_s03" details_size="testimonial-details-xl" title="Caleb Cruz" position="Apple marketing manager" avatar="4069" date_time="August, 2017" pos_color="rgb(253, 115, 80)"]<em><span style="font-size: 20px; line-height: 1.15em;">“Duis aute irure dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem”</span></em>[/ld_testimonial][/vc_column][vc_column width="5/6" offset="vc_col-md-6"][ld_testimonial style="testi_s03" details_size="testimonial-details-xl" title="Nathaniel Garner" position="Startup Enthusiast" avatar="4070" date_time="August, 2017" pos_color="rgb(253, 115, 80)"]<em><span style="font-size: 20px; line-height: 1.15em;">“Duis aute irure dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem”</span></em>[/ld_testimonial][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 10
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 10', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials9.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1542958369365{padding-top: 50px !important;padding-bottom: 50px !important;}" responsive_css="padding_top_medium:240px|padding_bottom_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-4 vc_col-md-12" ca_init_translate_y="49" responsive_align="text-md-left"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" title="About Ave Agency" color="rgb(249, 184, 81)" fs="12px" fw="600" ls="0.2em"]Testimonials[/ld_fancy_heading][vc_empty_space height="15px"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" title="Ultimate experiences with story, emotion and purpose" color="rgb(24, 27, 49)" fw="700" fs="42px" lh="1.3em"]What they said[/ld_fancy_heading][vc_empty_space height="10px"][ld_fancy_heading tag="p" title="We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing goals, and look fantastic." margin="right_large:25%25"]We’re humbled to be working with such a great variety of clients that range from early stage startups to Fortune 500 companies.[/ld_fancy_heading][vc_empty_space height="100px"][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-7 vc_col-md-12"][ld_spacer height="30px" md_height="0"][ld_carousel_3d][ld_testimonial style="testi_s05" avatar_size="testimonial-avatar-sm" details_size="testimonial-details-sm" title="Suke Tran" position="Sumo Founder" avatar="4043" date_time="December 2017"]<span style="font-size: 16px; line-height: 30px;">“Original, creative and with an innate understanding of their customer’s needs, the team at Ave Agency are always a pleasure to work with.”</span>[/ld_testimonial][ld_testimonial style="testi_s05" avatar_size="testimonial-avatar-sm" details_size="testimonial-details-sm" title="Selena Gomez" position="POP Star" avatar="4044" date_time="December 2017"]<span style="font-size: 16px; line-height: 30px;">“Original, creative and with an innate understanding of their customer’s needs, the team at Ave Agency are always a pleasure to work with.”</span>[/ld_testimonial][ld_testimonial style="testi_s05" avatar_size="testimonial-avatar-sm" details_size="testimonial-details-sm" title="Jenifer Lopez" position="90s Diva" avatar="4042" date_time="December 2017"]<span style="font-size: 16px; line-height: 30px;">“Original, creative and with an innate understanding of their customer’s needs, the team at Ave Agency are always a pleasure to work with.”</span>[/ld_testimonial][/ld_carousel_3d][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 11
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 11', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials10.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row parallax="enable_parallax" css=".vc_custom_1537773101890{margin-top: 60px !important;margin-bottom: 60px !important;border-right-width: 2.5vw !important;border-left-width: 2.5vw !important;padding-top: 130px !important;padding-bottom: 40px !important;background-image: url(http://agency.liquid-themes.com/wp-content/uploads/2018/09/testimonials-bg-min.jpg?id=3923) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;}"][vc_column width="2/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-sm-offset-2" ca_init_translate_y="50" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h2" color="rgb(255, 255, 255)"]Real testimonials[/ld_fancy_heading][vc_empty_space height="60px"][/vc_column][vc_column][ld_carousel columns="xs:1" inactiv_opacity="1" prevnextbuttons="yes" navarrow="4" navsize="carousel-nav-lg" navfill="carousel-nav-bordered" navshape="carousel-nav-circle" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" paddings="0px" nav_arrow_color="rgba(255, 255, 255, 0.3)" nav_arrow_color_hover="rgb(255, 255, 255)" nav_border_color="rgba(255, 255, 255, 0.3)" nav_border_hcolor="rgb(255, 255, 255)" nav_bg_hcolor="rgba(255, 255, 255, 0)" navoffset="right:65,left:65"][vc_row_inner][vc_column_inner width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1" ca_init_translate_y="70" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h4" tag_to_inherite="h3" use_theme_fonts="" text_font="font_family:Amiri%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_fit="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" lh="1.25em" compressor="0.85" minfontsize="38" fw="400"]“Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsume”[/ld_fancy_heading][vc_empty_space height="15px"][ld_fancy_heading tag="h6" tag_to_inherite="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" lh="1.2em" margin="bottom_small:0px"]Antonio Jensen[/ld_fancy_heading][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.5)" fs="14px"]Creative Director[/ld_fancy_heading][vc_empty_space height="15px"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1" ca_init_translate_y="70" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h4" tag_to_inherite="h4" use_theme_fonts="" text_font="font_family:Amiri%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_fit="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" lh="1.25em" compressor="0.85" minfontsize="38" fw="400"]“Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsume”[/ld_fancy_heading][vc_empty_space height="15px"][ld_fancy_heading tag="h6" tag_to_inherite="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" lh="1.2em" margin="bottom_small:0px"]Antonio Jensen[/ld_fancy_heading][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.5)" fs="14px"]Creative Director[/ld_fancy_heading][vc_empty_space height="15px"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="5/6" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1" ca_init_translate_y="70" ca_duration="1200" ca_delay="150"][ld_fancy_heading tag="h4" tag_to_inherite="h4" use_theme_fonts="" text_font="font_family:Amiri%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_fit="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" lh="1.25em" compressor="0.85" minfontsize="38" fw="400"]“Praesent porttitor nunc vitae lacus vehicula, nec mollis eros congue. Vestibulum ante ipsume”[/ld_fancy_heading][vc_empty_space height="15px"][ld_fancy_heading tag="h6" tag_to_inherite="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" lh="1.2em" margin="bottom_small:0px"]Antonio Jensen[/ld_fancy_heading][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.5)" fs="14px"]Creative Director[/ld_fancy_heading][vc_empty_space height="15px"][/vc_column_inner][/vc_row_inner][/ld_carousel][/vc_column][vc_column][vc_empty_space height="110px"][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" equal_height="yes" ca_init_scale_x="0.25" ca_init_scale_y="0.25" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1"][vc_column_inner width="1/4" offset="vc_col-md-2 vc_col-xs-6"][vc_single_image image="29" img_size="full" alignment="center" enable_opacity="yes" opacity="0.5"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-2 vc_col-xs-6"][vc_single_image image="30" img_size="full" alignment="center" enable_opacity="yes" opacity="0.5"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-2 vc_col-xs-6"][vc_single_image image="31" img_size="full" alignment="center" enable_opacity="yes" opacity="0.5"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-2 vc_col-xs-6"][vc_single_image image="32" img_size="full" alignment="center" enable_opacity="yes" opacity="0.5"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-2 vc_col-xs-6"][vc_single_image image="33" img_size="full" alignment="center" enable_opacity="yes" opacity="0.5"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-md-2 vc_col-xs-6"][vc_single_image image="34" img_size="full" alignment="center" enable_opacity="yes" opacity="0.5"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 12
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 12', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials11.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" parallax="enable_parallax" css=".vc_custom_1540206817631{margin-top: 75px !important;margin-bottom: 75px !important;padding-top: 85px !important;padding-bottom: 150px !important;background-color: #f7f7f7 !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" align="text-center" offset="vc_col-md-8" responsive_align="text-md-left"][ld_fancy_heading tag="h2" el_id="booking-heading" margin="bottom_small:0px"]Testimonials[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(63, 65, 71)" fs="12px" ls="0.2em" lh="1em" margin="top_large:-1em"]We get people talking[/ld_fancy_heading][ld_spacer md_hide="vc_hidden-md" lg_hide="vc_hidden-lg"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-4" responsive_align="text-sm-right"][vc_single_image image="872" img_size="full" css=".vc_custom_1536838287022{margin-bottom: 0px !important;}"][/vc_column][vc_column][ld_spacer height="60px"][/vc_column][vc_column enable_column_shadowbox="yes" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.073)%22%7D%5D" css=".vc_custom_1528972407407{padding-right: 8% !important;padding-left: 8% !important;background-color: #ffffff !important;}"][ld_carousel columns="xs:1" inactiv_opacity="1" prevnextbuttons="yes" navarrow="1" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" nav_arrow_color="rgb(142, 145, 150)" nav_arrow_color_hover="rgb(187, 160, 122)" navoffset="top:42%"][vc_row_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1533106982545{padding-top: 60px !important;padding-right: 8% !important;padding-bottom: 60px !important;padding-left: 8% !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="16px" ls="0.1em" lh="1em" margin="bottom_large:0px"]<strong>Story Title</strong>[/ld_fancy_heading][ld_spacer height="25px"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(63, 65, 71)" fs="22px"]Duis aute irure dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit anim id est laborum."[/ld_fancy_heading][ld_spacer height="40px"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="16px" ls="0.1em" lh="1em" margin="bottom_large:0px"]<strong>Don Willis</strong>[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(142, 145, 150)" fs="14px" ls="0.05em"]Sydney, Australia[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1533106982545{padding-top: 60px !important;padding-right: 8% !important;padding-bottom: 60px !important;padding-left: 8% !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="16px" ls="0.1em" lh="1em" margin="bottom_large:0px"]<strong>Story Title</strong>[/ld_fancy_heading][ld_spacer height="25px"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(63, 65, 71)" fs="22px"]Duis aute irure dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit anim id est laborum."[/ld_fancy_heading][ld_spacer height="40px"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="16px" ls="0.1em" lh="1em" margin="bottom_large:0px"]<strong>Don Willis</strong>[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(142, 145, 150)" fs="14px" ls="0.05em"]Sydney, Australia[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1533106982545{padding-top: 60px !important;padding-right: 8% !important;padding-bottom: 60px !important;padding-left: 8% !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="16px" ls="0.1em" lh="1em" margin="bottom_large:0px"]<strong>Story Title</strong>[/ld_fancy_heading][ld_spacer height="25px"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(63, 65, 71)" fs="22px"]Duis aute irure dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit anim id est laborum."[/ld_fancy_heading][ld_spacer height="40px"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(187, 160, 122)" fs="16px" ls="0.1em" lh="1em" margin="bottom_large:0px"]<strong>Don Willis</strong>[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(142, 145, 150)" fs="14px" ls="0.05em"]Sydney, Australia[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel][/vc_column][vc_column align="text-center"][ld_spacer height="50px"][ld_button style="btn-underlined" title="Read 1274 reviews" transformation="text-uppercase" color="rgb(63, 65, 71)" fs="12px" ls="0.1em" hover_color="rgb(0, 0, 0)"][/vc_column][/vc_row][vc_row][vc_column][ld_spacer height="90px"][ld_fancy_heading tag="h3" alignment="text-center"]Unique Testimonials[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 13
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 13', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials12.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row enable_overlay="yes" css=".vc_custom_1540903622454{margin-top: 50px !important;padding-top: 50px !important;padding-bottom: 140px !important;}"][vc_column offset="vc_col-md-4"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="42px"]The biggest  community[/ld_fancy_heading][ld_spacer height="40px"][/vc_column][vc_column offset="vc_col-md-offset-3 vc_col-md-9"][ld_carousel columns="md:2|sm:1.75|xs:1|spacing_xs:15px" inactiv_opacity="1" cellalign="left" pagenationdots="yes" fullwidthside="yes" groupcells="no" dots_style="carousel-dots-style2" contain="yes" paddings="20px" dots_bg_color="rgba(255, 255, 255, 0.45)" dots_bg_hcolor="rgb(255, 255, 255)"][ld_testimonial style="testi_s11" title="Loretta Dean" position="Developer" primary_color_svg="rgb(27, 137, 226)" fill_color="rgb(27, 137, 226)"]<span style="font-size: 18px; line-height: 2em;">“Dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit.”</span>[/ld_testimonial][ld_testimonial style="testi_s11" title="Loretta Dean" position="Developer" primary_color_svg="rgb(27, 137, 226)" fill_color="rgb(27, 137, 226)"]<span style="font-size: 18px; line-height: 2em;">“Dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit.”</span>[/ld_testimonial][ld_testimonial style="testi_s11" title="Loretta Dean" position="Developer" primary_color_svg="rgb(27, 137, 226)" fill_color="rgb(27, 137, 226)"]<span style="font-size: 18px; line-height: 2em;">“Dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit.”</span>[/ld_testimonial][ld_testimonial style="testi_s11" title="Loretta Dean" position="Developer" primary_color_svg="rgb(27, 137, 226)" fill_color="rgb(27, 137, 226)"]<span style="font-size: 18px; line-height: 2em;">“Dolor in reprehenderit in officia voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui deserunt mollit.”</span>[/ld_testimonial][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 14
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 14', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials14.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row bg_attachment="fixed" css=".vc_custom_1538140288705{margin-top: 60px !important;padding-top: 90px !important;padding-bottom: 55px !important;background-image: url(http://original.liquid-themes.com/wp-content/uploads/2018/09/testimonials-bg-min.jpg?id=4123) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="16px" fw="600" ls="0.2em"]Real Stories[/ld_fancy_heading][ld_spacer height="45px"][/vc_column][vc_column width="5/6" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1"][ld_carousel columns="xs:1" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" navarrow="custom" navsize="carousel-nav-xl" navfill="carousel-nav-bordered" navshape="carousel-nav-circle" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" pagedots="yes" nav_arrow_color="rgb(255, 255, 255)" nav_arrow_color_hover="rgb(0, 0, 0)" nav_bg_hcolor="rgb(255, 255, 255)" prev="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1sZWZ0JTVDJTIyJTNFJTNDJTJGaSUzRQ==" next="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1yaWdodCU1QyUyMiUzRSUzQyUyRmklM0U=" nav_border_color="rgba(255, 255, 255, 0.355)" nav_border_hcolor="rgb(255, 255, 255)" prevoffset="-100px" nextoffset="-100px"][vc_row_inner][vc_column_inner align="text-center"][ld_testimonial style="testi_s06" avatar_size="testimonial-avatar-sm" align="text-center" details_size="testimonial-details-sm" title="SUKE ALEX" position="one user" avatar="5445" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.43)"]<span style="font-size: 24px; line-height: 43px; color: #ffffff;">“Original, creative and an innate understanding of their customer’s needs, the team at Ave Agency are a pleasure to work of clients that range from early stage to companies.”</span>[/ld_testimonial][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center"][ld_testimonial style="testi_s06" avatar_size="testimonial-avatar-sm" align="text-center" details_size="testimonial-details-sm" title="SUKE ALEX" position="one user" avatar="3556" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.43)"]<span style="font-size: 24px; line-height: 43px; color: #ffffff;">“Original, creative and an innate understanding of their customer’s needs, the team at Ave Agency are a pleasure to work of clients that range from early stage to companies.”</span>[/ld_testimonial][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center"][ld_testimonial style="testi_s06" avatar_size="testimonial-avatar-sm" align="text-center" details_size="testimonial-details-sm" title="SUKE ALEX" position="one user" avatar="3556" title_color="rgb(255, 255, 255)" pos_color="rgba(255, 255, 255, 0.43)"]<span style="font-size: 24px; line-height: 43px; color: #ffffff;">“Original, creative and an innate understanding of their customer’s needs, the team at Ave Agency are a pleasure to work of clients that range from early stage to companies.”</span>[/ld_testimonial][/vc_column_inner][/vc_row_inner][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Testimonials 15
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 15', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials15.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row content_placement="bottom" bg_position="center center" bg_attachment="fixed" css=".vc_custom_1546938477635{margin-top: 55px !important;padding-top: 140px !important;padding-bottom: 140px !important;background: #f7f7f7 url(http://opus-four.liquid-themes.com/wp-content/uploads/2019/01/opus-bg-testimonial.jpg?id=6940) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_scale_z="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_scale_z="1" ca_an_opacity="1" offset="vc_col-lg-6 vc_col-md-7" ca_duration="1200" ca_delay="180" ca_init_translate_y="40" ca_init_translate_z="-161" ca_init_rotate_x="-80" css=".vc_custom_1546271797759{border-radius: 4px !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" margin="bottom_small:1em" color="rgb(170, 170, 170)" fw="500" ls="1px"]Real Testimonials[/ld_fancy_heading][ld_spacer height="12px"][ld_fancy_heading tag="h5" tag_to_inherite="h4" use_inheritance="true" color="rgb(80, 80, 80)"]<em>This is by far the most beautiful bit of work I have seen in all my years. It's a real joy to develop with. The theme is amazing, and the support is even more amazing!</em>[/ld_fancy_heading][ld_spacer height="22px"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" fs="16px" lh="25px" color="rgb(255, 255, 255)" fh_bg="rgb(248, 96, 116)" padding="top_small:10px|right_small:30px|bottom_small:10px|left_small:30px"]Trevor Anthiss, Envato User[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 16
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 16', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials16.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1546977430535{margin-top: 70px !important;margin-bottom: 70px !important;padding-top: 90px !important;padding-bottom: 110px !important;background-color: #1d1e1f !important;}"][vc_column align="text-center"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="40px" lh="1.1em" margin="bottom_small:1.2em" color="rgb(255, 255, 255)"]Hear from our community[/ld_fancy_heading][/vc_column][vc_column align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8"][ld_carousel columns="xs:1|spacing_xs:15px" inactiv_opacity="1" wraparound="yes" adaptiveheight="yes" controllingcarousels="#testi-avatars"][vc_row_inner][vc_column_inner][vc_column_text]
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes!”</span></p>
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">— Trevor, Envato User</span></p>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][vc_column_text]
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes!”</span></p>
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">— Trevor, Envato User</span></p>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][vc_column_text]
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes!”</span></p>
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">— Trevor, Envato User</span></p>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][vc_column_text]
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes!”</span></p>
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">— Trevor, Envato User</span></p>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][vc_column_text]
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes!”</span></p>
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">— Trevor, Envato User</span></p>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][vc_column_text]
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes!”</span></p>
<p style="text-align: center;"><span style="color: #afb0ba; font-size: 16px; line-height: 25px;">— Trevor, Envato User</span></p>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_carousel][/vc_column][vc_column][ld_spacer height="60px"][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-10"][ld_carousel columns="md:5|xs:3|spacing_xs:15px" inactiv_opacity="0.3" prevnextbuttons="yes" groupcells="no" wraparound="yes" navarrow="custom" navsize="carousel-nav-xl" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" el_id="testi-avatars" prev="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1sZWZ0JTVDJTIyJTNFJTNDJTJGaSUzRQ==" next="#E-8_JTIwJTNDaSUyMGNsYXNzJTNEJTVDJTIyZmElMjBmYS1hbmdsZS1yaWdodCU1QyUyMiUzRSUzQyUyRmklM0U=" nav_arrow_color="rgb(84, 84, 84)" nav_arrow_color_hover="rgb(255, 255, 255)" prevoffset="-10%" nextoffset="-10%"][vc_row_inner][vc_column_inner align="text-center"][vc_single_image image="http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/opus2-img-4.jpg" img_size="full" alignment="center" style="vc_box_circle_2" image_max_width="64px" css=".vc_custom_1546438043875{margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #afb0ba; font-size: 16px;">Trevor Janes</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center"][vc_single_image image="http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/3.jpg" img_size="full" alignment="center" style="vc_box_circle_2" image_max_width="64px" css=".vc_custom_1546877329482{margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #afb0ba; font-size: 16px;">Trevor Janes</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center"][vc_single_image image="http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/4.jpg" img_size="full" alignment="center" style="vc_box_circle_2" image_max_width="64px" css=".vc_custom_1546438473477{margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #afb0ba; font-size: 16px;">Trevor Janes</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center"][vc_single_image image="http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/testimonials-1.jpg" img_size="full" alignment="center" style="vc_box_circle_2" image_max_width="64px" css=".vc_custom_1546438095932{margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #afb0ba; font-size: 16px;">Trevor Janes</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center"][vc_single_image image="http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/t5-1-2.png" img_size="full" alignment="center" style="vc_box_circle_2" image_max_width="64px" css=".vc_custom_1546877338947{margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #afb0ba; font-size: 16px;">Trevor Janes</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner align="text-center"][vc_single_image image="http://opus-three.liquid-themes.com/wp-content/uploads/2019/01/t3-1-2.jpg" img_size="full" alignment="center" style="vc_box_circle_2" image_max_width="64px" css=".vc_custom_1546609858331{margin-bottom: 15px !important;}"][vc_column_text]<span style="color: #afb0ba; font-size: 16px;">Trevor Janes</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/ld_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials 17
	$data = array();
	$data['name'] = esc_html__( 'Testimonials 17', 'ave' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/liquid/assets/img/liquid_templates/testimonials/testimonials17.jpg' );
	$data['sort_name'] = 'testmonials';
	$data['custom_class'] = 'general testimonials';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" content_placement="top" css=".vc_custom_1546275365039{margin-bottom: 50px !important;padding-right: 5% !important;padding-left: 5% !important;}"][vc_column offset="vc_col-md-3" responsive_css="margin_right_medium:-15px" responsive_align="text-md-right"][ld_carousel columns="xs:1|spacing_xs:0px" inactiv_opacity="1" enable_parallax="yes" el_id="img-carousel-1"][vc_single_image image="http://opus-four.liquid-themes.com/wp-content/uploads/2018/12/opus2-img-4.jpg" img_size="full" css=".vc_custom_1546273720235{margin-bottom: 0px !important;}" image_max_width="150px"][vc_single_image image="http://opus-four.liquid-themes.com/wp-content/uploads/2019/01/testimonials.jpg" img_size="full" css=".vc_custom_1546418815439{margin-bottom: 0px !important;}" image_max_width="150px"][/ld_carousel][/vc_column][vc_column offset="vc_col-lg-9" css=".vc_custom_1545131279740{padding-right: 60px !important;padding-left: 60px !important;}"][ld_carousel columns="xs:1|spacing_xs:15px" inactiv_opacity="1" cellalign="left" prevnextbuttons="yes" navarrow="6" navsize="carousel-nav-xl" navfill="carousel-nav-bordered" navshape="carousel-nav-circle" nav_arrow_color="rgb(16, 15, 38)" nav_arrow_color_hover="rgb(0, 0, 0)" nav_border_color="rgba(255, 255, 255, 0)" nav_border_hcolor="rgb(246, 247, 252)" nav_bg_color="rgb(255, 255, 255)" nav_bg_hcolor="rgb(246, 247, 252)" controllingcarousels="#img-carousel-1, #img-carousel-2"][vc_row_inner][vc_column_inner][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(97, 97, 97)" fs="18px" lh="30px" padding="right_large:12%25" fw="400"]“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes!”[/ld_fancy_heading][ld_spacer height="22px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="13px" fw="500" margin="bottom_small:0.2em" color="rgb(0, 0, 0)" ls="2px"]JESSE BOSMAN[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" margin="bottom_small:1em" color="rgb(170, 170, 170)" fw="500" ls="1px"]ThemeForest User[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(97, 97, 97)" fs="18px" lh="30px" padding="right_large:12%25" fw="400"]“The experience with Ave has been nothing short of amazing. So much better than other themes I’ve used – wish I had seen this one first and saved my wasted time and money on other themes!”[/ld_fancy_heading][ld_spacer height="22px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="13px" fw="500" margin="bottom_small:0.2em" color="rgb(0, 0, 0)" ls="2px"]JESSE BOSMAN[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" fs="11px" margin="bottom_small:1em" color="rgb(170, 170, 170)" fw="500" ls="1px"]ThemeForest User[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel][/vc_column][/vc_row][vc_row css=".vc_custom_1546275309274{padding-top: 140px !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1545659316344{padding-right: 7% !important;padding-left: 7% !important;}"][ld_fancy_heading tag="h2"]Hear from our great community[/ld_fancy_heading][ld_spacer height="40px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	return $templates;
}